/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.SQLExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.EvalWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.NodeProcesserFactory;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.WFStatuEnum;
import com.kingdee.eas.hr.perf.client.AbstractEvaluTargetDetailListUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.KDTableUtil;
import com.kingdee.eas.hr.perf.client.NodeProcesserInputUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.PerfSummaryEditUI;
import com.kingdee.eas.hr.perf.client.TargetAttachHelper;
import com.kingdee.eas.hr.perf.client.WorkFlowControlPersonUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EvaluTargetDetailListUI
extends AbstractEvaluTargetDetailListUI {
    private static final long serialVersionUID = -61166L;
    private String resourcePath = "com.kingdee.eas.hr.perf.EvaluSolutionResource";
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private CommonQueryDialog queryDlg;

    public void onLoad() throws Exception {
        super.onLoad();
        PerfClientUtils.checkValidHRO((CoreUI)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.setColumnMoveable(true);
        this.initComboBox();
        this.actionAttachment.setEnabled(true);
        this.actionAttachment.setVisible(true);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().get().getTop();
        String solutionPeriodId = this.tblMain.getRow(rowIndex).getCell("solutionPeriodId").getValue().toString();
        String evaluObjectId = this.tblMain.getRow(rowIndex).getCell("evaluObjectId").getValue().toString();
        String id = TargetAttachHelper.getTargetAttachId(solutionPeriodId, evaluObjectId);
        acm.showAttachmentListUIByBoID(id, (Object)this);
    }

    private void initComboBox() throws Exception {
        this.comboSolutionPeriod.setActionCommand("init");
        EvaluSolutionHelper.initHRSolutionPeriod(this.comboSolutionPeriod, null, SolutionPeriodStatusEnum.ON_EVALU, EvaluSolutionTypeEnum.PERSON);
        this.comboSolutionPeriod.setActionCommand(null);
        if (this.comboSolutionPeriod.getItemCount() > 0) {
            this.comboSolutionPeriod.setSelectedIndex(0);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEvaluForm.setIcon(EASResource.getIcon((String)"imgTbtn_seequestionnaire"));
        this.btnRestartFlow.setIcon(EASResource.getIcon((String)"imgTbtn_startupserve"));
        this.btnStartWorkFlow.setIcon(EASResource.getIcon((String)"imgTbtn_startupserve"));
        this.btnSummary.setIcon(EASResource.getIcon((String)"imgTbtn_performancesumup"));
        this.btnViewFlow.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.btnFlowHasten.setIcon(EASResource.getIcon((String)"imgTbtn_press"));
        this.menuItemEvaluForm.setIcon(EASResource.getIcon((String)"imgTbtn_seequestionnaire"));
        this.menuItemRestartFlow.setIcon(EASResource.getIcon((String)"imgTbtn_startupserve"));
        this.menuItemSummary.setIcon(EASResource.getIcon((String)"imgTbtn_performancesumup"));
        this.menuItemViewFlow.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.menuItemFlowHasten.setIcon(EASResource.getIcon((String)"imgTbtn_press"));
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                rowSet.updateString("assessPeriod", EvaluSolutionHelper.getStartDate2EndDateString(rowSet.getDate("assessPeriod.startDate"), rowSet.getDate("assessPeriod.endDate")));
                if (((BizEnumValueInfo)rowSet.getObject("status")).getInt() != 30) {
                    rowSet.updateString("rank.name", null);
                }
                if (rowSet.getObject("procInst.state") != null) {
                    BizEnumValueDTO wfState = (BizEnumValueDTO)rowSet.getObject("procInst.state");
                    if (!wfState.getString().equals("open.running")) continue;
                    rowSet.updateObject("procInst.state", (Object)WFStatuEnum.ONUSED);
                    continue;
                }
                rowSet.updateObject("procInst.state", rowSet.getObject("status"));
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        super.onGetRowSet(rowSet);
    }

    @Override
    public RequestContext prepareActionEvaluForm(IItemAction itemAction) throws Exception {
        RequestContext req = super.prepareActionEvaluForm(itemAction);
        super.checkSelected();
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        String solutionPeriodId = (String)row.getCell("solutionPeriodId").getValue();
        String evaluObjectId = (String)row.getCell("evaluObjectId").getValue();
        req.put("solutionPeriodId", (Object)solutionPeriodId);
        req.put("evaluObjectId", (Object)evaluObjectId);
        return req;
    }

    @Override
    public void actionEvaluForm_actionPerformed(ActionEvent e) throws Exception {
        super.checkSelected();
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        String solutionPeriodId = (String)row.getCell("solutionPeriodId").getValue();
        String evaluObjectId = (String)row.getCell("evaluObjectId").getValue();
        String personId = (String)row.getCell("personId").getValue();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.evaluObject.id", (Object)evaluObjectId));
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.solutionPeriod.id", (Object)solutionPeriodId));
        if (!NodeProcesserFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noNodeProcesser"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriod", (Object)solutionPeriodId);
        uiContext.put((Object)"evaluObject", (Object)evaluObjectId);
        uiContext.put((Object)"evaluPersonId", (Object)personId);
        uiContext.put((Object)"type", (Object)"nodeProcesser");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(NodeProcesserInputUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionRestartFlow_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("status").getValue();
        if (status.getInt() == 10) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"UNSTARTFLOW"));
            return;
        }
        if (this.confirmRestartFlow()) {
            String evaluSolutionId = (String)row.getCell("evaluSolutionId").getValue();
            if (!EvaluSolutionHelper.isExistFlowInstance(evaluSolutionId)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CanNotRestartOnDirectMode"));
                SysUtil.abort();
            }
            String solutionPeriodId = (String)row.getCell("solutionPeriodId").getValue();
            String evaluObjectId = (String)row.getCell("evaluObjectId").getValue();
            EvaluSolutionHelper.restartEvaluFlow(solutionPeriodId, evaluObjectId);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"RestartFlowSuccess"));
            this.refresh(e);
        }
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        HashSet<Object> idSet = new HashSet<Object>();
        int[] rows = KDTableUtil.getSelectedRows(this.tblMain);
        IRow row = null;
        BizEnumValueInfo status = null;
        for (int i = 0; i < rows.length; ++i) {
            row = this.tblMain.getRow(rows[i]);
            status = (BizEnumValueInfo)row.getCell("status").getValue();
            if (10 != status.getInt()) continue;
            idSet.add(row.getCell("evaluObjectId").getValue());
        }
        if (idSet.size() > 0) {
            String solutionPeriodId = ((SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getId().toString();
            EvalWorkFlowFacadeFactory.getRemoteInstance().batchStartProcess(solutionPeriodId, idSet);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"StartFlowSuccess"));
            this.refresh(e);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"OnEvaluFlow"));
        }
    }

    private boolean confirmRestartFlow() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmRestartFlow")));
    }

    @Override
    public void actionSummary_actionPerformed(ActionEvent e) throws Exception {
        super.actionSummary_actionPerformed(e);
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        String assessPeriodId = (String)row.getCell("assessPeriodId").getValue();
        String personId = (String)row.getCell("personId").getValue();
        String perfSummaryId = EvaluSolutionHelper.getPerfSummaryId(assessPeriodId, personId);
        if (perfSummaryId == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"NoSummary"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)perfSummaryId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(PerfSummaryEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionViewFlow_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        String evaluSolutionId = (String)row.getCell("evaluSolutionId").getValue();
        String solutionPeriodId = (String)row.getCell("solutionPeriodId").getValue();
        String evaluObjectId = (String)row.getCell("evaluObjectId").getValue();
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("status").getValue();
        if (status.getInt() == 10) {
            EvaluSolutionHelper.showWfDiagramOnNoFlowInstance((CoreUIObject)this, solutionPeriodId, evaluObjectId);
        } else if (!EvaluSolutionHelper.isExistFlowInstance(evaluSolutionId)) {
            EvaluSolutionHelper.showWfDiagramOnNoFlowInstance((CoreUIObject)this, solutionPeriodId, evaluObjectId);
        } else {
            EvaluSolutionHelper.showWfDiagram((CoreUIObject)this, solutionPeriodId, evaluObjectId);
        }
    }

    @Override
    public void actionFlowHasten_actionPerformed(ActionEvent e) throws Exception {
        super.actionFlowHasten_actionPerformed(e);
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        this.SelectHasten();
    }

    private void SelectHasten() throws Exception {
        String solutionPeriodId = ((SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getId().toString();
        HashSet<String> evaluObjectSet = new HashSet<String>();
        HashMap<String, String> evaluObjectMap = new HashMap<String, String>();
        HashMap<String, String> evaluOperatorMap = new HashMap<String, String>();
        HashMap<String, String> evaluOperNameMap = new HashMap<String, String>();
        List rowIndexs = PFUtils.getSelectedRows(this.tblMain);
        if (rowIndexs != null && !rowIndexs.isEmpty()) {
            for (int i = 0; i < rowIndexs.size(); ++i) {
                String evaluSolutionId;
                BizEnumValueInfo status;
                Integer rowIndex = (Integer)rowIndexs.get(i);
                IRow row = this.tblMain.getRow(rowIndex.intValue());
                String evaluObjectId = (String)row.getCell("evaluObjectId").getValue();
                String evaluObjectName = (String)row.getCell("evaluObject.name").getValue();
                String procInstID = (String)row.getCell("procInstID").getValue();
                StringBuffer sb = new StringBuffer();
                String operatorID = null;
                String operatorName = null;
                sb.append("Select EVALWFOBJECTS.fprocInstID,ASSIGN.FPERSONEMPID as PERSONEMPID, ASSIGN.FPERSONEMPNAME_l2 as PERSONEMPNAME from T_PF_EvalWFObjects EVALWFOBJECTS");
                sb.append(" Inner join T_WFR_Assign ASSIGN");
                sb.append(" On EVALWFOBJECTS.fprocInstID= ASSIGN.fprocInstID");
                sb.append(" where EVALWFOBJECTS.FEvaluObjectID='");
                sb.append(evaluObjectId);
                sb.append("'");
                sb.append(" and EVALWFOBJECTS.fprocInstID='");
                sb.append(procInstID);
                sb.append("'");
                IRowSet rowSet = SQLExecutorFactory.getRemoteInstance((String)sb.toString()).executeSQL();
                rowSet.beforeFirst();
                if (rowSet.next()) {
                    operatorID = rowSet.getString(2);
                    operatorName = rowSet.getString(3);
                }
                if ((status = (BizEnumValueInfo)row.getCell("status").getValue()).getInt() == 10) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"UnUsedFlow"));
                    SysUtil.abort();
                }
                if (status.getInt() == 30) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ClosedFlow"));
                    SysUtil.abort();
                }
                if (!EvaluSolutionHelper.isExistFlowInstance(evaluSolutionId = (String)row.getCell("evaluSolutionId").getValue())) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CanNotHastenOnDirectMode"));
                    SysUtil.abort();
                }
                evaluObjectSet.add(evaluObjectId);
                evaluObjectMap.put(evaluObjectId, evaluObjectName);
                evaluOperatorMap.put(evaluObjectId, operatorID);
                evaluOperNameMap.put(evaluObjectId, operatorName);
            }
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriodID", (Object)solutionPeriodId);
        uiContext.put((Object)"evaluObjectMap", evaluObjectMap);
        uiContext.put((Object)"evaluObjectIDs", evaluObjectSet);
        uiContext.put((Object)"evaluOperatorMap", evaluOperatorMap);
        uiContext.put((Object)"evaluOperNameMap", evaluOperNameMap);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(WorkFlowControlPersonUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    @Override
    protected void comboSolutionPeriod_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.setTableNumberFormat(this.tblMain, "targetEvaluScore", 5);
        if ("init".equals(this.comboSolutionPeriod.getActionCommand())) {
            return;
        }
        this.mainQuery = super.getEntityViewInfo(new EntityViewInfo());
        this.refreshList();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.queryDlg != null) {
            return this.queryDlg;
        }
        this.queryDlg = new CommonQueryDialog();
        this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
        this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.queryDlg.setQueryObjectPK(this.mainQueryPK);
        this.queryDlg.setShowSorter(false);
        this.queryDlg.setTitle(EASResource.getString((String)RES, (String)"personEvaluTargetDeTitle"));
        this.queryDlg.setUiObject((IUIObject)this);
        return this.queryDlg;
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        this.tblMain_doRequestRowSetForNoQueryPK(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        String solutionPeriodId = null;
        solutionPeriodId = solutionPeriodInfo != null ? solutionPeriodInfo.getId().toString() : "%noeas%";
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        filter.getFilterItems().add(new FilterItemInfo("rsSolutionPeriod.id", (Object)solutionPeriodId));
        filter.getFilterItems().add(PerfUtils.getAdminRangeFilterItemInfo(null, "orgUnit.id"));
        return filter;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor iqec = super.getQueryExecutor(queryPK, viewInfo);
        iqec.option().isAutoIgnoreZero = false;
        return iqec;
    }

    @Override
    public boolean isPrepareActionViewFlow() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("solutionPeriod", this.comboSolutionPeriod.getSelectedItem());
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    public IUIActionPostman prepareQuery(RequestRowSetEvent e) {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("solutionPeriod", this.comboSolutionPeriod.getSelectedItem());
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    @Override
    public RequestContext prepareActionViewFlow(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionFlowHasten(itemAction);
        if (request == null) {
            request = new RequestContext();
        }
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        String evaluSolutionId = (String)row.getCell("evaluSolutionId").getValue();
        request.put("evaluSolutionId", (Object)evaluSolutionId);
        String solutionPeriodId = (String)row.getCell("solutionPeriodId").getValue();
        request.put("solutionPeriodId", (Object)solutionPeriodId);
        String evaluObjectId = (String)row.getCell("evaluObjectId").getValue();
        request.put("evaluObjectId", (Object)evaluObjectId);
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("status").getValue();
        request.put("status", (Object)status);
        return request;
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
        PFUtils.setTableNumberFormat(this.tblMain, "targetEvaluScore", 5);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        this.initPrecision();
    }

    private void initPrecision() {
        try {
            PFUtils.setTableColumnPrecision(this.tblMain, "evaluSolutionId", "targetEvaluScore", 3);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }
}

