/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.data.event.RequestRowSetEvent;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.commonquery.IQuerySolutionFacade;
import com.kingdee.eas.base.commonquery.QuerySolutionFacadeFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.base.commonquery.client.Util;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.EvalWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.NodeProcesserFactory;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.WFStatuEnum;
import com.kingdee.eas.hr.perf.client.AbstractEvaluTargetDetailOrgUnitListUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.KDTableUtil;
import com.kingdee.eas.hr.perf.client.NodeProcesserInputUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.TargetAttachHelper;
import com.kingdee.eas.hr.perf.client.WorkFlowControlOrgUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;

public class EvaluTargetDetailOrgUnitListUI
extends AbstractEvaluTargetDetailOrgUnitListUI {
    private static final long serialVersionUID = -61166L;
    private String resourcePath = "com.kingdee.eas.hr.perf.EvaluSolutionResource";
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private CommonQueryDialog queryDlg;

    public void onLoad() throws Exception {
        this.setDoRequestData(false);
        super.onLoad();
        this.setDoRequestData(true);
        PerfClientUtils.checkValidHRO((CoreUI)this);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        this.tblMain.setColumnMoveable(true);
        this.initComboBox();
        PFUtils.setTableNumberFormat(this.tblMain, "targetEvaluScore", 2);
        this.actionAttachment.setEnabled(true);
        this.actionAttachment.setVisible(true);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        this.checkSelected();
        int rowIndex = this.tblMain.getSelectManager().get().getTop();
        String solutionPeriodId = this.tblMain.getRow(rowIndex).getCell("solutionPeriodId").getValue().toString();
        String evaluObjectId = this.tblMain.getRow(rowIndex).getCell("evaluObjectId").getValue().toString();
        String id = TargetAttachHelper.getTargetAttachId(solutionPeriodId, evaluObjectId);
        acm.showAttachmentListUIByBoID(id, (Object)this);
    }

    private void initComboBox() throws Exception {
        this.comboSolutionPeriod.setActionCommand("init");
        EvaluSolutionHelper.initHRSolutionPeriod(this.comboSolutionPeriod, null, SolutionPeriodStatusEnum.ON_EVALU, EvaluSolutionTypeEnum.ORGUNIT);
        this.comboSolutionPeriod.setActionCommand(null);
        if (this.comboSolutionPeriod.getItemCount() > 0) {
            this.comboSolutionPeriod.setSelectedIndex(0);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEvaluForm.setIcon(EASResource.getIcon((String)"imgTbtn_seequestionnaire"));
        this.btnRestartFlow.setIcon(EASResource.getIcon((String)"imgTbtn_startupserve"));
        this.btnStartWorkFlow.setIcon(EASResource.getIcon((String)"imgTbtn_startupserve"));
        this.btnSummary.setIcon(EASResource.getIcon((String)"imgTbtn_subjectsetting"));
        this.btnViewFlow.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.btnFlowHasten.setIcon(EASResource.getIcon((String)"imgTbtn_press"));
        this.menuItemEvaluForm.setIcon(EASResource.getIcon((String)"imgTbtn_seequestionnaire"));
        this.menuItemRestartFlow.setIcon(EASResource.getIcon((String)"imgTbtn_startupserve"));
        this.menuViewFlow.setIcon(EASResource.getIcon((String)"imgTbtn_flowchart"));
        this.menuItemFlowHasten.setIcon(EASResource.getIcon((String)"imgTbtn_press"));
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                rowSet.updateString("assessPeriod", EvaluSolutionHelper.getStartDate2EndDateString(rowSet.getDate("assessPeriod.startDate"), rowSet.getDate("assessPeriod.endDate")));
                if (((BizEnumValueInfo)rowSet.getObject("status")).getInt() != 30) {
                    rowSet.updateString("rank.name", null);
                }
                if (rowSet.getObject("procInst.state") != null) {
                    BizEnumValueDTO wfState = (BizEnumValueDTO)rowSet.getObject("procInst.state");
                    if (!wfState.getString().equals("open.running")) continue;
                    rowSet.updateObject("procInst.state", (Object)WFStatuEnum.ONUSED);
                    continue;
                }
                rowSet.updateObject("procInst.state", rowSet.getObject("status"));
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        super.onGetRowSet(rowSet);
    }

    @Override
    public void actionEvaluForm_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        String solutionPeriodId = (String)row.getCell("solutionPeriodId").getValue();
        String evaluObjectId = (String)row.getCell("evaluObjectId").getValue();
        String responserId = (String)row.getCell("responserId").getValue();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.evaluObject.id", (Object)evaluObjectId));
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.solutionPeriod.id", (Object)solutionPeriodId));
        if (!NodeProcesserFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noNodeProcesser"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriod", (Object)solutionPeriodId);
        uiContext.put((Object)"evaluObject", (Object)evaluObjectId);
        uiContext.put((Object)"evaluPersonId", (Object)responserId);
        uiContext.put((Object)"type", (Object)"nodeProcesser");
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(NodeProcesserInputUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionRestartFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionRestartFlow_actionPerformed(e);
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("status").getValue();
        if (status.getInt() == 10) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"UNSTARTFLOW"));
            return;
        }
        if (this.confirmRestartFlow()) {
            String evaluSolutionId = (String)row.getCell("evaluSolutionId").getValue();
            if (!EvaluSolutionHelper.isExistFlowInstance(evaluSolutionId)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CanNotRestartOnDirectMode"));
                SysUtil.abort();
            }
            String solutionPeriodId = (String)row.getCell("solutionPeriodId").getValue();
            String evaluObjectId = (String)row.getCell("evaluObjectId").getValue();
            EvaluSolutionHelper.restartEvaluFlow(solutionPeriodId, evaluObjectId);
            this.resourcePath = "com.kingdee.eas.hr.perf.EvaluSolutionResource";
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.EvaluSolutionResource", (String)"RestartFlowSuccess"));
            this.refresh(e);
        }
    }

    public void actionStartWorkFlow_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        HashSet<Object> idSet = new HashSet<Object>();
        int[] rows = KDTableUtil.getSelectedRows(this.tblMain);
        IRow row = null;
        BizEnumValueInfo status = null;
        for (int i = 0; i < rows.length; ++i) {
            row = this.tblMain.getRow(rows[i]);
            status = (BizEnumValueInfo)row.getCell("status").getValue();
            if (10 != status.getInt()) continue;
            idSet.add(row.getCell("evaluObjectId").getValue());
        }
        if (idSet.size() > 0) {
            String solutionPeriodId = ((SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getId().toString();
            EvalWorkFlowFacadeFactory.getRemoteInstance().batchStartProcess(solutionPeriodId, idSet);
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"StartFlowSuccess"));
            this.refresh(e);
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"OnEvaluFlow"));
        }
    }

    private boolean confirmRestartFlow() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmRestartFlow")));
    }

    @Override
    public void actionSummary_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    public void actionViewFlow_actionPerformed(ActionEvent e) throws Exception {
        super.actionViewFlow_actionPerformed(e);
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        String evaluSolutionId = (String)row.getCell("evaluSolutionId").getValue();
        String solutionPeriodId = (String)row.getCell("solutionPeriodId").getValue();
        String evaluObjectId = (String)row.getCell("evaluObjectId").getValue();
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("status").getValue();
        if (status.getInt() == 10) {
            EvaluSolutionHelper.showWfDiagramOnNoFlowInstance((CoreUIObject)this, solutionPeriodId, evaluObjectId);
        } else if (!EvaluSolutionHelper.isExistFlowInstance(evaluSolutionId)) {
            EvaluSolutionHelper.showWfDiagramOnNoFlowInstance((CoreUIObject)this, solutionPeriodId, evaluObjectId);
        } else {
            EvaluSolutionHelper.showWfDiagram((CoreUIObject)this, solutionPeriodId, evaluObjectId);
        }
    }

    @Override
    public RequestContext prepareActionFlowHasten(IItemAction itemAction) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        RequestContext req = super.prepareActionFlowHasten(itemAction);
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("status").getValue();
        if (status.getInt() == 10) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"UnUsedFlow"));
            SysUtil.abort();
        }
        if (status.getInt() == 30) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ClosedFlow"));
            SysUtil.abort();
        }
        String evaluSolutionId = (String)row.getCell("evaluSolutionId").getValue();
        req.put("evaluSolutionId", (Object)evaluSolutionId);
        return req;
    }

    @Override
    public void actionFlowHasten_actionPerformed(ActionEvent e) throws Exception {
        String evaluSolutionId;
        super.actionFlowHasten_actionPerformed(e);
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        IRow row = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain));
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("status").getValue();
        if (status.getInt() == 10) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"UnUsedFlow"));
            SysUtil.abort();
        }
        if (status.getInt() == 30) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ClosedFlow"));
            SysUtil.abort();
        }
        if (!EvaluSolutionHelper.isExistFlowInstance(evaluSolutionId = (String)row.getCell("evaluSolutionId").getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CanNotHastenOnDirectMode"));
            SysUtil.abort();
        }
        String solutionPeriodId = (String)row.getCell("solutionPeriodId").getValue();
        String evaluObjectId = (String)row.getCell("evaluObjectId").getValue();
        String evaluObjectName = (String)row.getCell("orgUnit.name").getValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"solutionPeriodID", (Object)solutionPeriodId);
        uiContext.put((Object)"evaluObjectID", (Object)evaluObjectId);
        uiContext.put((Object)"evaluObjectName", (Object)evaluObjectName);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(WorkFlowControlOrgUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    @Override
    protected void comboSolutionPeriod_actionPerformed(ActionEvent e) throws Exception {
        if ("init".equals(this.comboSolutionPeriod.getActionCommand())) {
            return;
        }
        if (this.comboSolutionPeriod.getSelectedItem() == null) {
            return;
        }
        IQuerySolutionFacade iQuery = QuerySolutionFacadeFactory.getRemoteInstance();
        String cureQueryName = EvaluTargetDetailOrgUnitListUI.getQueryInfo((IMetaDataPK)this.mainQueryPK).getFullName();
        QuerySolutionInfo solution = iQuery.getDefaultSolution(this.getMetaDataPK().getFullName(), cureQueryName);
        EntityViewInfo entityView = new EntityViewInfo();
        if (solution != null && solution.getEntityViewInfo() != null) {
            entityView = Util.getInnerFilterInfo((QuerySolutionInfo)solution);
        }
        this.mainQuery = super.getEntityViewInfo(entityView);
        this.refreshList();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.queryDlg != null) {
            return this.queryDlg;
        }
        this.queryDlg = new CommonQueryDialog();
        this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
        this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
        this.queryDlg.setQueryObjectPK(this.mainQueryPK);
        this.queryDlg.setShowSorter(false);
        this.queryDlg.setTitle(EASResource.getString((String)RES, (String)"evaluTargetDeOrgTitlte"));
        this.queryDlg.setUiObject((IUIObject)this);
        return this.queryDlg;
    }

    protected boolean initDefaultFilter() {
        return false;
    }

    protected void tblMain_doRequestRowSet(RequestRowSetEvent e) {
        if (this.isDoRequestData()) {
            this.tblMain_doRequestRowSetForNoQueryPK(e);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        String solutionPeriodId = null;
        solutionPeriodId = solutionPeriodInfo != null ? solutionPeriodInfo.getId().toString() : "%noeas%";
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        filter.getFilterItems().add(new FilterItemInfo("rsSolutionPeriod.id", (Object)solutionPeriodId));
        filter.getFilterItems().add(PerfUtils.getAdminRangeFilterItemInfo(null, "orgUnit.id"));
        return filter;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor iqec = super.getQueryExecutor(queryPK, viewInfo);
        iqec.option().isAutoIgnoreZero = false;
        return iqec;
    }

    @Override
    public boolean isPrepareActionFlowHasten() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("solutionPeriod", this.comboSolutionPeriod.getSelectedItem());
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }

    public IUIActionPostman prepareQuery(RequestRowSetEvent e) {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("solutionPeriod", this.comboSolutionPeriod.getSelectedItem());
        clientHanlder.setRequestContext((Serializable)request);
        return clientHanlder;
    }
}

