/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.AuditState2Enum;
import com.kingdee.eas.hr.perf.EvaluSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluTargetFactory;
import com.kingdee.eas.hr.perf.EvaluTargetInfo;
import com.kingdee.eas.hr.perf.IEvaluSolutionFacade;
import com.kingdee.eas.hr.perf.IWorkItem;
import com.kingdee.eas.hr.perf.PerformTargetTypeInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.WorkItemFactory;
import com.kingdee.eas.hr.perf.WorkItemInfo;
import com.kingdee.eas.hr.perf.client.AbstractEvaluTargetListUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class EvaluTargetListUI
extends AbstractEvaluTargetListUI {
    private static final Logger logger = CoreUIObject.getLogger(EvaluTargetListUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";

    public void onLoad() throws Exception {
        this.tblMain.checkParsed();
        this.initWorkButton();
        this.initComboSolutionPeriod();
        if (this.comboSolutionPeriod.getItemCount() > 0) {
            this.comboSolutionPeriod.setSelectedIndex(0);
        }
        PFUtils.setTableNumberFormat(this.tblMain, "weight", 2);
        this.btnAttachment.setVisible(false);
    }

    private void initComboSolutionPeriod() throws Exception {
        this.comboSolutionPeriod.setActionCommand("init");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        viewInfo.setFilter(filter);
        String personId = (String)this.getUIContext().get("PERSON_ID");
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.objectID", (Object)personId));
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("solutionPeriod.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("solutionPeriod.name"));
        TargetEvaluStoreCollection coll = TargetEvaluStoreFactory.getRemoteInstance().getTargetEvaluStoreCollection(viewInfo);
        HashSet<SolutionPeriodInfo> collection = new HashSet<SolutionPeriodInfo>();
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            SolutionPeriodInfo info = coll.get(i).getSolutionPeriod();
            if (collection.contains(info)) continue;
            collection.add(info);
        }
        this.comboSolutionPeriod.addItems(collection.toArray());
        this.comboSolutionPeriod.setActionCommand(null);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        if (!OprtState.VIEW.equals(this.getOprtState())) {
            this.btnAssociateWorkPlan.setVisible(true);
        } else {
            this.btnAssociateWorkPlan.setVisible(false);
        }
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            rowSet.beforeFirst();
            IEvaluSolutionFacade evaluSolutionFacade = EvaluSolutionFacadeFactory.getRemoteInstance();
            while (rowSet.next()) {
                String longNumber = rowSet.getString("targetType.longNumber");
                rowSet.updateString("targetType.name", EvaluSolutionHelper.getLongNameByLongNumber(evaluSolutionFacade, new PerformTargetTypeInfo().getBOSType(), longNumber));
                rowSet.updateString("assessPeriod", EvaluSolutionHelper.getStartDate2EndDateString(rowSet.getDate("assessPeriod.startDate"), rowSet.getDate("assessPeriod.endDate")));
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
        super.onGetRowSet(rowSet);
    }

    @Override
    protected void comboSolutionPeriod_actionPerformed(ActionEvent e) throws Exception {
        super.comboSolutionPeriod_actionPerformed(e);
        if ("init".equals(this.comboSolutionPeriod.getActionCommand())) {
            return;
        }
        if (this.comboSolutionPeriod.getSelectedItem() == null) {
            return;
        }
        EntityViewInfo evi = this.getEntityViewInfo();
        this.setDataObject((IObjectValue)evi);
        this.refresh(e);
    }

    private EntityViewInfo getEntityViewInfo() {
        String solutionPeriodId = ((SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getId().toString();
        String personId = (String)this.getUIContext().get("PERSON_ID");
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        evi.setFilter(fi);
        return evi;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    @Override
    protected void btnAssociateWorkPlan_actionPerformed(ActionEvent e) throws Exception {
        Set idSet = (Set)this.getUIContext().get("idSet");
        if (idSet.size() > 0) {
            WorkItemInfo info;
            int i;
            this.checkSelected();
            String targetId = KDTableUtil.getSelectedRow((KDTable)this.tblMain).getCell("targetId").getValue().toString();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            EvaluTargetInfo evaluTargetInfo = EvaluTargetFactory.getRemoteInstance().getEvaluTargetInfo((IObjectPK)new ObjectUuidPK(targetId));
            IWorkItem iWorkItem = WorkItemFactory.getRemoteInstance();
            EntityViewInfo evi = new EntityViewInfo();
            evi.getSelector().add(new SelectorItemInfo("id"));
            evi.getSelector().add(new SelectorItemInfo("evaluTarget"));
            evi.getSelector().add(new SelectorItemInfo("auditState"));
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
            evi.setFilter(fi);
            CoreBaseCollection coll = iWorkItem.getCollection(evi);
            boolean flag = true;
            int size = coll.size();
            for (i = 0; i < size; ++i) {
                info = (WorkItemInfo)coll.get(i);
                if (!AuditState2Enum.AUDITED.equals((Object)info.getAuditState())) continue;
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"auditedWorkItemCanNotBeAssociated"));
                flag = false;
            }
            if (flag) {
                size = coll.size();
                for (i = 0; i < size; ++i) {
                    info = (WorkItemInfo)coll.get(i);
                    info.setEvaluTarget(evaluTargetInfo);
                }
                iWorkItem.submit(coll);
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noSelectedWorkItem"));
        }
        this.actionExitCurrent_actionPerformed(e);
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }
}

