/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDRadioButton;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CustomerParams;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.util.LocaleUtils;
import java.awt.Component;

public class FilterUIUtil {
    private static final String MULTI = "multi";
    private static final String ID = "id";
    private static final String NAME = "name";
    private static final String NUM = "number";
    private static final String CLASSNAME = "class";
    private static final long serialVersionUID = -61166L;

    public static void saveData(CustomerParams params, Component comp) {
        if (params == null || comp == null) {
            return;
        }
        String keyName = comp.getName();
        if (comp instanceof KDTextField) {
            KDTextField ctrl = (KDTextField)comp;
            String text = ctrl.getText();
            if (text == null || "".equals(text.trim())) {
                return;
            }
            params.addCustomerParam(keyName, text.trim());
            return;
        }
        if (comp instanceof KDComboBox) {
            KDComboBox ctrl = (KDComboBox)comp;
            if (ctrl.getSelectedIndex() != -1) {
                params.putInt(keyName, ctrl.getSelectedIndex());
            }
            return;
        }
        if (comp instanceof KDRadioButton) {
            KDRadioButton ctrl = (KDRadioButton)comp;
            if (ctrl.isSelected()) {
                params.addCustomerParam(keyName, "true");
            }
            return;
        }
        if (comp instanceof KDCheckBox) {
            KDCheckBox ctrl = (KDCheckBox)comp;
            if (ctrl.isSelected()) {
                params.addCustomerParam(keyName, "true");
            }
            return;
        }
        if (comp instanceof KDBizPromptBox) {
            KDBizPromptBox ctrl = (KDBizPromptBox)comp;
            Object obj = ctrl.getData();
            if (obj != null) {
                if (obj instanceof Object[]) {
                    Object[] array = (Object[])obj;
                    if (array.length > 0 && array[0] != null && array[0] instanceof DataBaseInfo) {
                        params.addCustomerParam(MULTI + keyName, "" + array.length);
                        DataBaseInfo info = null;
                        for (int i = 0; i < array.length; ++i) {
                            info = (DataBaseInfo)array[i];
                            params.addCustomerParam(ID + i + keyName, info.getId().toString());
                            params.addCustomerParam("namel1" + i + keyName, info.getName(LocaleUtils.getLocale((String)"l1")));
                            params.addCustomerParam("namel2" + i + keyName, info.getName(LocaleUtils.getLocale((String)"l2")));
                            params.addCustomerParam("namel3" + i + keyName, info.getName(LocaleUtils.getLocale((String)"l3")));
                            params.addCustomerParam(NUM + i + keyName, info.getNumber());
                        }
                        params.addCustomerParam(CLASSNAME + keyName, info.getClass().getName());
                    }
                } else if (obj instanceof DataBaseInfo) {
                    DataBaseInfo info = (DataBaseInfo)obj;
                    params.addCustomerParam(ID + keyName, info.getId().toString());
                    params.addCustomerParam("namel1" + keyName, info.getName(LocaleUtils.getLocale((String)"l1")));
                    params.addCustomerParam("namel2" + keyName, info.getName(LocaleUtils.getLocale((String)"l2")));
                    params.addCustomerParam("namel3" + keyName, info.getName(LocaleUtils.getLocale((String)"l3")));
                    params.addCustomerParam(NUM + keyName, info.getNumber());
                    params.addCustomerParam(CLASSNAME + keyName, info.getClass().getName());
                }
            }
            return;
        }
    }

    public static void retriveData(CustomerParams params, Component comp) throws Exception {
        if (comp == null) {
            return;
        }
        String keyName = comp.getName();
        if (comp instanceof KDTextField) {
            KDTextField ctrl = (KDTextField)comp;
            ctrl.setText(params.getCustomerParam(keyName));
            return;
        }
        if (comp instanceof KDComboBox) {
            KDComboBox ctrl = (KDComboBox)comp;
            ctrl.setSelectedIndex(params.getInt(keyName));
            return;
        }
        if (comp instanceof KDRadioButton) {
            KDRadioButton ctrl = (KDRadioButton)comp;
            if (params.getCustomerParam(keyName) != null) {
                ctrl.setSelected(true);
            } else {
                ctrl.setSelected(false);
            }
            return;
        }
        if (comp instanceof KDCheckBox) {
            KDCheckBox ctrl = (KDCheckBox)comp;
            if (params.getCustomerParam(keyName) != null) {
                ctrl.setSelected(true);
            } else {
                ctrl.setSelected(false);
            }
            return;
        }
        if (comp instanceof KDBizPromptBox) {
            KDBizPromptBox ctrl = (KDBizPromptBox)comp;
            String className = params.getCustomerParam(CLASSNAME + keyName);
            if (className == null || "".equals(className.trim())) {
                ctrl.setValue(null);
                return;
            }
            String multi = params.getCustomerParam(MULTI + keyName);
            if (multi == null || "".equals(multi.trim())) {
                DataBaseInfo info = (DataBaseInfo)Class.forName(className).newInstance();
                info.setId(BOSUuid.read((String)params.getCustomerParam(ID + keyName)));
                info.setName(params.getCustomerParam("namel1" + keyName), LocaleUtils.getLocale((String)"l1"));
                info.setName(params.getCustomerParam("namel2" + keyName), LocaleUtils.getLocale((String)"l2"));
                info.setName(params.getCustomerParam("namel3" + keyName), LocaleUtils.getLocale((String)"l3"));
                info.setNumber(params.getCustomerParam(NUM + keyName));
                ctrl.setData((Object)info);
                return;
            }
            int count = Integer.parseInt(multi);
            DataBaseInfo[] array = new DataBaseInfo[count];
            DataBaseInfo info = null;
            for (int i = 0; i < count; ++i) {
                info = (DataBaseInfo)Class.forName(className).newInstance();
                info.setId(BOSUuid.read((String)params.getCustomerParam(ID + i + keyName)));
                info.setName(params.getCustomerParam("namel1" + i + keyName), LocaleUtils.getLocale((String)"l1"));
                info.setName(params.getCustomerParam("namel2" + i + keyName), LocaleUtils.getLocale((String)"l2"));
                info.setName(params.getCustomerParam("namel3" + i + keyName), LocaleUtils.getLocale((String)"l3"));
                info.setNumber(params.getCustomerParam(NUM + i + keyName));
                array[i] = info;
            }
            ctrl.setData((Object)array);
            return;
        }
    }

    public static void saveAllData(CustomerParams params, CustomerQueryPanel queryPanel) {
        Component comp = null;
        int n = queryPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            comp = queryPanel.getComponent(i);
            if (comp instanceof KDLabelContainer) {
                FilterUIUtil.saveData(params, ((KDLabelContainer)comp).getBoundEditor());
                continue;
            }
            FilterUIUtil.saveData(params, queryPanel.getComponent(i));
        }
    }

    public static CustomerParams saveAllData(CustomerQueryPanel queryPanel) {
        CustomerParams params = new CustomerParams();
        Component comp = null;
        int n = queryPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            comp = queryPanel.getComponent(i);
            if (comp instanceof KDLabelContainer) {
                FilterUIUtil.saveData(params, ((KDLabelContainer)comp).getBoundEditor());
                continue;
            }
            FilterUIUtil.saveData(params, queryPanel.getComponent(i));
        }
        return params;
    }

    public static void retriveAllData(CustomerParams params, CustomerQueryPanel queryPanel) {
        queryPanel.clear();
        if (params == null) {
            return;
        }
        try {
            Component comp = null;
            int n = queryPanel.getComponentCount();
            for (int i = 0; i < n; ++i) {
                comp = queryPanel.getComponent(i);
                if (comp instanceof KDLabelContainer) {
                    FilterUIUtil.retriveData(params, ((KDLabelContainer)comp).getBoundEditor());
                    continue;
                }
                FilterUIUtil.retriveData(params, comp);
            }
        }
        catch (Exception ex) {
            queryPanel.handUIException((Throwable)ex);
        }
    }
}

