/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.view.MetaDataBriefInfo;
import com.kingdee.bos.service.formula.api.BuilderResourceUtil;
import com.kingdee.bos.service.formula.api.IVarInfo;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSObj;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSObjEntity;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSObjMember;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSObjMthd;
import com.kingdee.bos.service.formula.builder.bosmeta.BOSObjProp;
import com.kingdee.bos.service.formula.builder.hr.IHRObject;
import com.kingdee.bos.service.formula.engine.FormulaException;
import com.kingdee.eas.hr.perf.client.TableVarInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class FormulaElem {
    private int eleType = -1;
    private static Object selectedEle = null;
    private EntityObjectInfo entyInfo;
    private PropertyInfo propInfo;
    boolean isLeafProp;
    private BOSObjMember objMemberRef;
    private TableVarInfo varInfo;
    private String simpleStr;
    private String constantStr;
    public static final int BAS_MATHOP_TYPE = 11;
    public static final int BAS_COMPOP_TYPE = 12;
    public static final int BAS_LOGICOP_TYPE = 13;
    public static final int BAS_LOGICEXP_TYPE = 14;
    public static final int BAS_ASSIGN_TYPE = 15;
    public static final int BAS_SBRACKET_TYPE = 16;
    public static final int BAS_BBRACKET_TYPE = 17;
    public static final int BAS_CONSTANT_TYPE = 18;
    public static final int BAS_COMMA_TYPE = 19;
    public static final int BAS_NULL_TYPE = 20;
    public static final int FUNC_TYPE = 2;
    public static final int OBJM_TYPE = 3;
    public static final int VAR_TYPE = 4;
    public static final int PropValProp_TYPE = 5;
    public static final int PropValEntity_TYPE = 6;
    private IHRObject hrEnumObject;
    private IHRObject hrObject;
    public static final int HR_ENUMTYPE = 30;
    public static final int HR_HROBJECTTYPE = 31;
    public static final Vector BAS_MATHOP_TYPES_STRS = FormulaElem.convertArrayToVector(new String[]{"+", "-", "*", "/"});
    public static final Vector BAS_COMPOP_TYPES_STRS = FormulaElem.convertArrayToVector(new String[]{"==", "!=", ">", ">=", "<", "<="});
    public static final Vector BAS_LOGICOP_TYPES_STRS = FormulaElem.convertArrayToVector(new String[]{"and", "or", "not"});
    public static final Vector BAS_LOGICOP_TYPES_STRS_2 = FormulaElem.convertArrayToVector(new String[]{"&&", "||", "!"});
    public static final Vector BAS_LOGICEXP_TYPES_STRS = FormulaElem.convertArrayToVector(new String[]{"if", "else if", "else"});
    public static final Vector BAS_ASSIGN_TYPES_STRS = FormulaElem.convertArrayToVector(new String[]{"="});
    public static final Vector BAS_SBRACKET_TYPES_STRS = FormulaElem.convertArrayToVector(new String[]{"(", ")"});
    public static final Vector BAS_BBRACKET_TYPES_STRS = FormulaElem.convertArrayToVector(new String[]{"{", "}"});
    public static final Vector BAS_CONSTANT_TYPES_STRS = FormulaElem.convertArrayToVector(new String[]{BuilderResourceUtil.getString((String)"constant")});
    public static final Vector BAS_COMMA_TYPES_STRS = FormulaElem.convertArrayToVector(new String[]{","});
    public static final Vector BAS_NULL_TYPES_STRS = FormulaElem.convertArrayToVector(new String[]{""});
    private static long groupIdSeed = 1L;
    private long groupId = -1L;
    private boolean needAddGap = true;

    private static Vector convertArrayToVector(Object[] objs) {
        Vector<Object> result = null;
        if (objs != null) {
            result = new Vector<Object>();
            for (int i = 0; i < objs.length; ++i) {
                result.add(objs[i]);
            }
        }
        return result;
    }

    public static FormulaElem createConstantEle(String str) {
        FormulaElem newEle = new FormulaElem();
        newEle.eleType = 18;
        newEle.constantStr = str;
        return newEle;
    }

    public static FormulaElem createPropValEle(EntityObjectInfo entityInfo) {
        FormulaElem newEle = new FormulaElem();
        newEle.eleType = 6;
        newEle.entyInfo = entityInfo;
        return newEle;
    }

    public static FormulaElem createPropValEle(PropertyInfo propInfo) {
        FormulaElem newEle = new FormulaElem();
        newEle.eleType = 5;
        newEle.propInfo = propInfo;
        return newEle;
    }

    public static ArrayList createPropValEles(List objs) {
        int i;
        if (objs == null) {
            return null;
        }
        ArrayList<FormulaElem> objEles = new ArrayList<FormulaElem>();
        long ourGroupId = FormulaElem.genGroupId();
        for (i = 0; i < objs.size(); ++i) {
            if (objs.get(i) instanceof MetaDataBriefInfo) {
                MetaDataBriefInfo userObject = (MetaDataBriefInfo)objs.get(i);
                String clsName = userObject.getFullName();
                String varName = clsName.substring(clsName.lastIndexOf(".") + 1);
                TableVarInfo varInfo = new TableVarInfo(varName, userObject.getAlias(), clsName, "", "in", "", 4);
                FormulaElem newEle = FormulaElem.createVarEle(varInfo);
                newEle.groupId = ourGroupId;
                if (i != objs.size() - 1) {
                    newEle.setNeedAddGap(false);
                }
                objEles.add(newEle);
                continue;
            }
            if (objs.get(i) instanceof PropertyInfo) {
                PropertyInfo propInfo = (PropertyInfo)objs.get(i);
                FormulaElem propEle = new FormulaElem();
                propEle.eleType = 5;
                propEle.propInfo = propInfo;
                propEle.groupId = ourGroupId;
                if (i < objs.size() - 1) {
                    propEle.setNeedAddGap(false);
                }
                objEles.add(propEle);
                continue;
            }
            if (!(objs.get(i) instanceof EntityObjectInfo)) continue;
            EntityObjectInfo entyInfo = (EntityObjectInfo)objs.get(i);
            FormulaElem entyEle = new FormulaElem();
            entyEle.eleType = 6;
            entyEle.entyInfo = entyInfo;
            entyEle.groupId = ourGroupId;
            if (i < objs.size() - 1) {
                entyEle.setNeedAddGap(false);
            }
            objEles.add(entyEle);
        }
        for (i = 0; i < objEles.size(); ++i) {
            FormulaElem eleInfo = (FormulaElem)objEles.get(i);
            eleInfo.isLeafProp = false;
            if (i != objEles.size() - 1) continue;
            eleInfo.isLeafProp = true;
        }
        return objEles;
    }

    public static Vector createObjEles(Vector paths) {
        if (paths == null) {
            return null;
        }
        Vector<FormulaElem> objEles = new Vector<FormulaElem>();
        long ourGroupId = FormulaElem.genGroupId();
        for (int i = 0; i < paths.size(); ++i) {
            FormulaElem newEle;
            if (paths.get(i) instanceof BOSObj) {
                BOSObj bosObj = (BOSObj)paths.get(i);
                String clsName = bosObj.getObjClassName();
                if (i < paths.size() - 1 && paths.get(i + 1) instanceof BOSObjProp) {
                    clsName = ((BOSObjEntity)bosObj).getObjPropClassName();
                }
                String varName = clsName.substring(clsName.lastIndexOf(".") + 1);
                TableVarInfo varInfo = new TableVarInfo(varName, bosObj.getAlias(), clsName, "", "in", "", 4);
                FormulaElem newEle2 = FormulaElem.createVarEle(varInfo);
                newEle2.groupId = ourGroupId;
                if (i != paths.size() - 1) {
                    newEle2.setNeedAddGap(false);
                }
                objEles.add(newEle2);
                continue;
            }
            if (paths.get(i) instanceof BOSObjProp) {
                BOSObjProp bosProp = (BOSObjProp)paths.get(i);
                newEle = new FormulaElem();
                newEle.eleType = 3;
                newEle.objMemberRef = bosProp;
                newEle.groupId = ourGroupId;
                if (i < paths.size() - 1) {
                    newEle.setNeedAddGap(false);
                }
                objEles.add(newEle);
                continue;
            }
            if (!(paths.get(i) instanceof BOSObjMthd)) continue;
            BOSObjMthd bosMthd = (BOSObjMthd)paths.get(i);
            newEle = new FormulaElem();
            newEle.eleType = 3;
            newEle.objMemberRef = bosMthd;
            newEle.groupId = ourGroupId;
            newEle.setNeedAddGap(false);
            objEles.add(newEle);
            newEle = FormulaElem.createBaseEle((String)BAS_SBRACKET_TYPES_STRS.get(0));
            newEle.groupId = ourGroupId;
            objEles.add(newEle);
            newEle = FormulaElem.createBaseEle((String)BAS_SBRACKET_TYPES_STRS.get(1));
            newEle.groupId = ourGroupId;
            if (i < paths.size() - 1) {
                newEle.setNeedAddGap(false);
            }
            objEles.add(newEle);
        }
        if (paths.size() < 2 || paths.get(1) instanceof BOSObjProp) {
            // empty if block
        }
        return objEles;
    }

    public static Vector cloneMultiEles() {
        if (selectedEle == null || !(selectedEle instanceof Vector)) {
            return null;
        }
        Vector<FormulaElem> multiEles = new Vector<FormulaElem>();
        long newGroupId = FormulaElem.genGroupId();
        for (int i = 0; i < ((Vector)selectedEle).size(); ++i) {
            FormulaElem currEle = (FormulaElem)((Vector)selectedEle).get(i);
            FormulaElem newEle = new FormulaElem();
            newEle.groupId = newGroupId;
            newEle.varInfo = currEle.varInfo;
            newEle.eleType = currEle.eleType;
            newEle.needAddGap = currEle.needAddGap;
            newEle.simpleStr = currEle.simpleStr;
            newEle.objMemberRef = currEle.objMemberRef;
            multiEles.add(newEle);
        }
        return multiEles;
    }

    public static FormulaElem createVarEle(TableVarInfo varInfo) {
        FormulaElem newEle = new FormulaElem();
        newEle.eleType = 4;
        newEle.varInfo = varInfo;
        return newEle;
    }

    public static FormulaElem createBaseEle(String str) {
        FormulaElem newEle = new FormulaElem();
        newEle.simpleStr = str;
        if (BAS_MATHOP_TYPES_STRS.contains(str)) {
            newEle.eleType = 11;
        } else if (BAS_COMPOP_TYPES_STRS.contains(str)) {
            newEle.eleType = 12;
        } else if (BAS_LOGICOP_TYPES_STRS_2.contains(str) || BAS_LOGICOP_TYPES_STRS.contains(str)) {
            newEle.eleType = 13;
        } else if (BAS_LOGICEXP_TYPES_STRS.contains(str)) {
            newEle.eleType = 14;
        } else if (BAS_ASSIGN_TYPES_STRS.contains(str)) {
            newEle.eleType = 15;
        } else if (BAS_SBRACKET_TYPES_STRS.contains(str)) {
            newEle.eleType = 16;
        } else if (BAS_BBRACKET_TYPES_STRS.contains(str)) {
            newEle.eleType = 17;
        } else if (BAS_CONSTANT_TYPES_STRS.contains(str)) {
            newEle.eleType = 18;
        } else if (BAS_COMMA_TYPES_STRS.contains(str)) {
            newEle.eleType = 19;
        } else if (BAS_NULL_TYPES_STRS.contains(str)) {
            newEle.eleType = 20;
        }
        return newEle;
    }

    public static Vector createFuncEle(String funcName) {
        Vector<FormulaElem> funcEles = new Vector<FormulaElem>();
        long ourGroupId = FormulaElem.genGroupId();
        FormulaElem funcEle = new FormulaElem();
        funcEle.simpleStr = funcName;
        funcEle.eleType = 2;
        funcEle.setNeedAddGap(false);
        funcEle.setGroupId(ourGroupId);
        funcEles.add(funcEle);
        Vector bracketStrs = BAS_SBRACKET_TYPES_STRS;
        FormulaElem lBracketEle = FormulaElem.createBaseEle((String)bracketStrs.get(0));
        lBracketEle.setGroupId(ourGroupId);
        funcEles.add(lBracketEle);
        FormulaElem rBracketEle = FormulaElem.createBaseEle((String)bracketStrs.get(1));
        rBracketEle.setGroupId(ourGroupId);
        funcEles.add(rBracketEle);
        return funcEles;
    }

    public static FormulaElem createHREnumEle(IHRObject enumObject) {
        FormulaElem hrEnumEle = new FormulaElem();
        hrEnumEle.eleType = 30;
        hrEnumEle.hrEnumObject = enumObject;
        return hrEnumEle;
    }

    public static FormulaElem createHRObjEle(IHRObject hrObj) {
        FormulaElem hrObjEle = new FormulaElem();
        hrObjEle.eleType = 31;
        hrObjEle.hrObject = hrObj;
        return hrObjEle;
    }

    public void setEleType(int type) {
        this.eleType = type;
    }

    public int getEleType() {
        return this.eleType;
    }

    public static void setSelectedEle(Object obj) {
        if (obj == null) {
            selectedEle = null;
        } else if (obj instanceof FormulaElem) {
            selectedEle = obj;
        } else if (obj instanceof Vector) {
            selectedEle = obj;
        } else if (obj instanceof ArrayList) {
            selectedEle = obj;
        }
    }

    public static Object getSelectedEle() {
        return selectedEle;
    }

    public static String getSelectedEleDispStr() {
        if (selectedEle == null) {
            return null;
        }
        if (selectedEle instanceof FormulaElem) {
            return ((FormulaElem)selectedEle).getDispStr();
        }
        if (selectedEle instanceof Vector) {
            String dispStr = "";
            for (int i = 0; i < ((Vector)selectedEle).size(); ++i) {
                dispStr = dispStr + ((FormulaElem)((Vector)selectedEle).get(i)).getDispStr();
            }
            return dispStr;
        }
        if (selectedEle instanceof ArrayList) {
            StringBuffer dispBuff = new StringBuffer();
            dispBuff.append("\"");
            for (int i = 0; i < ((List)selectedEle).size(); ++i) {
                dispBuff.append(((FormulaElem)((List)selectedEle).get(i)).getDispStr());
            }
            dispBuff.append("\"");
            return dispBuff.toString();
        }
        return null;
    }

    public String getDispStr() {
        String dispStr = "";
        if (this.eleType == 3) {
            if (this.objMemberRef != null) {
                return "." + this.objMemberRef.getAlias();
            }
        } else if (this.eleType == 4) {
            dispStr = this.varInfo.getVarAlias();
            if (dispStr == null || dispStr.trim().equals("")) {
                dispStr = this.varInfo.getVarName();
            }
        } else if (this.eleType == 2) {
            dispStr = this.simpleStr;
        } else {
            if (this.getEleType() == 13) {
                if (BAS_LOGICOP_TYPES_STRS.indexOf(this.getSimpleStr()) > -1) {
                    return this.getSimpleStr();
                }
                int idx = BAS_LOGICOP_TYPES_STRS_2.indexOf(this.getSimpleStr());
                return (String)BAS_LOGICOP_TYPES_STRS.get(idx);
            }
            dispStr = this.eleType == 30 ? this.hrEnumObject.getAlias() : (this.eleType == 31 ? this.hrObject.getAlias() : (this.eleType == 5 ? (this.propInfo.getAlias() != null ? "." + this.propInfo.getAlias() : "." + this.propInfo.getName()) : (this.eleType == 6 ? "\"" + this.entyInfo.getAlias() : this.simpleStr)));
        }
        return dispStr;
    }

    public void setVarInfo(TableVarInfo varInfo) {
        this.varInfo = varInfo;
    }

    public TableVarInfo getVarInfo() {
        return this.varInfo;
    }

    public String getSimpleStr() {
        return this.simpleStr;
    }

    public String genFormulaStr() {
        if (this.getEleType() == 11 || this.getEleType() == 12 || this.getEleType() == 14 || this.getEleType() == 15 || this.getEleType() == 16 || this.getEleType() == 17 || this.getEleType() == 19) {
            return this.getSimpleStr();
        }
        if (this.getEleType() == 13) {
            if (BAS_LOGICOP_TYPES_STRS_2.indexOf(this.getSimpleStr()) > -1) {
                return this.getSimpleStr();
            }
            int idx = BAS_LOGICOP_TYPES_STRS.indexOf(this.getSimpleStr());
            return (String)BAS_LOGICOP_TYPES_STRS_2.get(idx);
        }
        if (this.getEleType() == 3) {
            if (this.objMemberRef != null) {
                return "." + this.objMemberRef.getName();
            }
        } else {
            if (this.getEleType() == 4) {
                return this.varInfo.getVarName();
            }
            if (this.getEleType() == 2) {
                return this.simpleStr;
            }
            if (this.getEleType() == 30) {
                if (this.hrEnumObject != null) {
                    return "\"" + this.hrEnumObject.getUuid() + "\"";
                }
            } else if (this.getEleType() == 31) {
                if (this.hrObject != null) {
                    return this.hrObject.getUuid();
                }
            } else {
                if (this.getEleType() == 5) {
                    return "." + this.propInfo.getName();
                }
                if (this.getEleType() == 6) {
                    return "\"#" + this.entyInfo.getPackage() + "#" + this.entyInfo.getName();
                }
                throw new FormulaException("not support eleType " + this.getEleType());
            }
        }
        return this.simpleStr;
    }

    public String getConstantStr() {
        return this.constantStr;
    }

    public void setObjMemberRef(BOSObjMember objMember) {
        this.objMemberRef = objMember;
    }

    public long getGroupId() {
        return this.groupId;
    }

    public void setGroupId(long id) {
        this.groupId = id;
    }

    public static long genGroupId() {
        return groupIdSeed++;
    }

    public void setNeedAddGap(boolean need) {
        this.needAddGap = need;
    }

    public boolean isNeedAddGap() {
        return this.needAddGap;
    }

    public FormulaElem cloneMe() {
        FormulaElem newEle = new FormulaElem();
        newEle.eleType = this.eleType;
        newEle.simpleStr = this.simpleStr;
        newEle.constantStr = this.constantStr;
        newEle.groupId = this.groupId;
        newEle.needAddGap = this.needAddGap;
        newEle.hrEnumObject = this.hrEnumObject;
        newEle.hrObject = this.hrObject;
        newEle.entyInfo = this.entyInfo;
        newEle.propInfo = this.propInfo;
        newEle.isLeafProp = this.isLeafProp;
        if (this.varInfo != null) {
            TableVarInfo newVarInfo = new TableVarInfo((IVarInfo)this.varInfo);
            newVarInfo.setCreatedWay(this.varInfo.getCreatedWay());
            newEle.varInfo = newVarInfo;
        }
        newEle.objMemberRef = this.objMemberRef;
        return newEle;
    }
}

