/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluResultItemEnum;
import com.kingdee.eas.hr.perf.FormulaSystemEntryInfo;
import com.kingdee.eas.hr.perf.MultiDimentionObjectFactory;
import com.kingdee.eas.hr.perf.MultiDimentionObjectInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.PerfModeEnum;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SumPersonFactory;
import com.kingdee.eas.hr.perf.SumPersonInfo;
import com.kingdee.eas.hr.perf.SumSolutionFactory;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.SynEvaluObjectFactory;
import com.kingdee.eas.hr.perf.SynEvaluObjectInfo;
import com.kingdee.eas.hr.perf.SynSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SynSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.AbstractFormulaSysEditUI;
import com.kingdee.eas.hr.perf.client.FormulaEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import org.apache.log4j.Logger;

public class FormulaSysEditUI
extends AbstractFormulaSysEditUI {
    private static final Logger logger = CoreUIObject.getLogger(FormulaSysEditUI.class);
    private boolean isCancel = true;
    private FormulaSystemEntryInfo editData;
    prmtObjectDataChangeListener dcList;
    private String state;

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
        this.initData();
        this.loadFields();
        if (this.prmtSP.getValue() == null) {
            this.prmtObject.setEnabled(false);
        } else {
            this.prmtObject.setEnabled(true);
        }
    }

    private void initUI() {
        this.combDataType.addItems(EvaluResultItemEnum.getEnumList().toArray());
        this.combPerfType.addItems(PerfModeEnum.getEnumList().toArray());
        this.combPerfType.addActionListener((ActionListener)new PerfTypeSelectChangeListener());
        this.combPerfType.setSelectedIndex(0);
        this.prmtSP.setEditable(false);
        this.prmtObject.setEditable(false);
        this.dcList = new prmtObjectDataChangeListener();
        this.prmtObject.addDataChangeListener((DataChangeListener)this.dcList);
    }

    private void initData() throws Exception {
        Map ctx = this.getUIContext();
        this.editData = (FormulaSystemEntryInfo)ctx.get("editData");
        this.state = ctx.get("state").toString();
    }

    @Override
    public void storeFields() {
        CoreBaseInfo obj;
        super.storeFields();
        if (this.editData == null) {
            this.editData = new FormulaSystemEntryInfo();
        }
        String name = this.txtName.getText();
        this.editData.setName(name);
        this.editData.setDataType((EvaluResultItemEnum)((Object)this.combDataType.getSelectedItem()));
        this.editData.setPerfMode((PerfModeEnum)((Object)this.combPerfType.getSelectedItem()));
        CoreBaseInfo spInfo = (CoreBaseInfo)this.prmtSP.getValue();
        if (spInfo != null) {
            this.editData.setSolutionPeriod(spInfo.getId().toString());
        }
        if ((obj = (CoreBaseInfo)this.prmtObject.getValue()) != null) {
            this.editData.setObject(obj.getId().toString());
        } else {
            this.editData.setObject(null);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if ((OprtState.EDIT.equals(this.state) || OprtState.VIEW.equals(this.state)) && this.editData != null) {
            this.txtName.setText(this.editData.getName());
            this.combDataType.setSelectedItem((Object)this.editData.getDataType());
            PerfModeEnum pm = this.editData.getPerfMode();
            this.combPerfType.setSelectedItem((Object)pm);
            String spId = this.editData.getSolutionPeriod();
            String objId = this.editData.getObject();
            try {
                if (PerfModeEnum.personTarget.equals((Object)pm) || PerfModeEnum.orgTarget.equals((Object)pm)) {
                    if (spId != null) {
                        SolutionPeriodInfo spInfo = SolutionPeriodFactory.getRemoteInstance().getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(spId));
                        this.prmtSP.setValue((Object)spInfo);
                    }
                    if (objId != null) {
                        EvaluObjectInfo objInfo = EvaluObjectFactory.getRemoteInstance().getEvaluObjectInfo((IObjectPK)new ObjectUuidPK(objId));
                        this.prmtObject.setDisplayFormat("$name$");
                        this.prmtObject.removeDataChangeListener((DataChangeListener)this.dcList);
                        this.prmtObject.setValue((Object)objInfo);
                        this.prmtObject.addDataChangeListener((DataChangeListener)this.dcList);
                    }
                } else if (PerfModeEnum.personMulti.equals((Object)pm) || PerfModeEnum.orgMulti.equals((Object)pm)) {
                    if (spId != null) {
                        MultiDimentionSolutionPeriodInfo spInfo = MultiDimentionSolutionPeriodFactory.getRemoteInstance().getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(spId));
                        this.prmtSP.setValue((Object)spInfo);
                    }
                    if (objId != null) {
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("id"));
                        sic.add(new SelectorItemInfo("person.id"));
                        sic.add(new SelectorItemInfo("person.name"));
                        sic.add(new SelectorItemInfo("evaluOrg.id"));
                        sic.add(new SelectorItemInfo("evaluOrg.name"));
                        MultiDimentionObjectInfo objInfo = MultiDimentionObjectFactory.getRemoteInstance().getMultiDimentionObjectInfo((IObjectPK)new ObjectUuidPK(objId), sic);
                        if (PerfModeEnum.personMulti.equals((Object)pm)) {
                            this.prmtObject.setDisplayFormat("$person.name$");
                        } else {
                            this.prmtObject.setDisplayFormat("$evaluOrg.name$");
                        }
                        this.prmtObject.removeDataChangeListener((DataChangeListener)this.dcList);
                        this.prmtObject.setValue((Object)objInfo);
                        this.prmtObject.addDataChangeListener((DataChangeListener)this.dcList);
                    }
                } else if (PerfModeEnum.sum.equals((Object)pm)) {
                    if (spId != null) {
                        SumSolutionInfo spInfo = SumSolutionFactory.getRemoteInstance().getSumSolutionInfo((IObjectPK)new ObjectUuidPK(spId));
                        this.prmtSP.setValue((Object)spInfo);
                    }
                    if (objId != null) {
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("id"));
                        sic.add(new SelectorItemInfo("person.id"));
                        sic.add(new SelectorItemInfo("person.name"));
                        SumPersonInfo objInfo = SumPersonFactory.getRemoteInstance().getSumPersonInfo((IObjectPK)new ObjectUuidPK(objId), sic);
                        this.prmtObject.setDisplayFormat("$person.name$");
                        this.prmtObject.removeDataChangeListener((DataChangeListener)this.dcList);
                        this.prmtObject.setValue((Object)objInfo);
                        this.prmtObject.addDataChangeListener((DataChangeListener)this.dcList);
                    }
                } else if (PerfModeEnum.complex.equals((Object)pm)) {
                    if (spId != null) {
                        SynSolutionPeriodInfo spInfo = SynSolutionPeriodFactory.getRemoteInstance().getSynSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(spId));
                        this.prmtSP.setValue((Object)spInfo);
                    }
                    if (objId != null) {
                        SelectorItemCollection sic = new SelectorItemCollection();
                        sic.add(new SelectorItemInfo("id"));
                        sic.add(new SelectorItemInfo("person.id"));
                        sic.add(new SelectorItemInfo("person.name"));
                        SynEvaluObjectInfo objInfo = SynEvaluObjectFactory.getRemoteInstance().getSynEvaluObjectInfo((IObjectPK)new ObjectUuidPK(objId), sic);
                        this.prmtObject.setDisplayFormat("$person.name$");
                        this.prmtObject.removeDataChangeListener((DataChangeListener)this.dcList);
                        this.prmtObject.setValue((Object)objInfo);
                        this.prmtObject.addDataChangeListener((DataChangeListener)this.dcList);
                    }
                }
            }
            catch (Exception e) {
                super.handleException(e);
            }
        }
        if (OprtState.VIEW.equals(this.state)) {
            this.lockUIAndAction();
            this.btnConfirm.setEnabled(true);
            this.btnCancel.setEnabled(true);
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (!OprtState.VIEW.equals(this.state)) {
            this.isCancel = false;
            this.checkInput();
            this.storeFields();
        }
        this.getUIWindow().close();
    }

    private void checkInput() {
        FormulaEditUI ownerUI;
        Object value = this.txtName.getText();
        if (value == null || value.toString().trim().length() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"69_FormulaSysEditUI"));
            this.txtName.requestFocusInWindow();
            SysUtil.abort();
        }
        if ((value = this.prmtSP.getValue()) == null) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"54_FormulaAchEditUI"));
            this.prmtSP.requestFocusInWindow();
            SysUtil.abort();
        }
        if ((ownerUI = (FormulaEditUI)((Object)this.getUIContext().get("ownerUI"))) != null) {
            String oldName = this.editData == null ? null : this.editData.getName();
            boolean exist = ownerUI.existName(this.txtName.getText().trim(), oldName);
            if (exist) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"55_FormulaAchEditUI"));
                this.txtName.requestFocusInWindow();
                SysUtil.abort();
            }
        }
    }

    @Override
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.isCancel = true;
        this.getUIWindow().close();
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    public FormulaSystemEntryInfo getEditData() {
        return this.editData;
    }

    @Override
    protected void prmtSP_dataChanged(DataChangeEvent e) throws Exception {
        CoreBaseInfo value = (CoreBaseInfo)this.prmtSP.getValue();
        if (value == null) {
            this.prmtObject.setEnabled(false);
            this.prmtObject.setEntityViewInfo(null);
            return;
        }
        this.prmtObject.setEnabled(true);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        PerfModeEnum pm = (PerfModeEnum)((Object)this.combPerfType.getSelectedItem());
        if (PerfModeEnum.personTarget.equals((Object)pm)) {
            fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)value.getId().toString()));
        } else if (PerfModeEnum.personMulti.equals((Object)pm)) {
            this.prmtObject.setEntityViewInfo(null);
            fi.getFilterItems().add(new FilterItemInfo("MDSolutionPeriod.id", (Object)value.getId().toString()));
        } else if (PerfModeEnum.orgTarget.equals((Object)pm)) {
            fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)value.getId().toString()));
        } else if (PerfModeEnum.orgMulti.equals((Object)pm)) {
            fi.getFilterItems().add(new FilterItemInfo("MDSolutionPeriod.id", (Object)value.getId().toString()));
        } else if (PerfModeEnum.sum.equals((Object)pm)) {
            fi.getFilterItems().add(new FilterItemInfo("sumSolution.id", (Object)value.getId().toString()));
        } else if (PerfModeEnum.complex.equals((Object)pm)) {
            fi.getFilterItems().add(new FilterItemInfo("synSolutionPeriod.id", (Object)value.getId().toString()));
        } else {
            this.prmtObject.setEnabled(false);
        }
        this.prmtObject.setEntityViewInfo(evi);
    }

    protected void prmtObject_dataChanged(DataChangeEvent e) throws Exception {
        if (this.prmtObject.getValue() == null) {
            return;
        }
        PerfModeEnum pm = (PerfModeEnum)((Object)this.combPerfType.getSelectedItem());
        if (PerfModeEnum.personTarget.equals((Object)pm) || PerfModeEnum.orgTarget.equals((Object)pm)) {
            this.prmtObject.setDisplayFormat("$name$");
        } else if (PerfModeEnum.personMulti.equals((Object)pm) || PerfModeEnum.orgMulti.equals((Object)pm)) {
            MultiDimentionObjectInfo info = (MultiDimentionObjectInfo)this.prmtObject.getValue();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("person.name"));
            sic.add(new SelectorItemInfo("evaluOrg.id"));
            sic.add(new SelectorItemInfo("evaluOrg.name"));
            MultiDimentionObjectInfo objInfo = MultiDimentionObjectFactory.getRemoteInstance().getMultiDimentionObjectInfo((IObjectPK)new ObjectUuidPK(info.getId().toString()), sic);
            if (PerfModeEnum.personMulti.equals((Object)pm)) {
                this.prmtObject.setDisplayFormat("$person.name$");
            } else {
                this.prmtObject.setDisplayFormat("$evaluOrg.name$");
            }
            this.prmtObject.removeDataChangeListener((DataChangeListener)this.dcList);
            this.prmtObject.setValue((Object)objInfo);
            this.prmtObject.addDataChangeListener((DataChangeListener)this.dcList);
        } else if (PerfModeEnum.sum.equals((Object)pm)) {
            SumPersonInfo objInfo = (SumPersonInfo)this.prmtObject.getValue();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("person.name"));
            objInfo = SumPersonFactory.getRemoteInstance().getSumPersonInfo((IObjectPK)new ObjectUuidPK(objInfo.getId().toString()), sic);
            this.prmtObject.setDisplayFormat("$person.name$");
            this.prmtObject.removeDataChangeListener((DataChangeListener)this.dcList);
            this.prmtObject.setValue((Object)objInfo);
            this.prmtObject.addDataChangeListener((DataChangeListener)this.dcList);
        } else if (PerfModeEnum.complex.equals((Object)pm)) {
            SynEvaluObjectInfo objInfo = (SynEvaluObjectInfo)this.prmtObject.getValue();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("person.id"));
            sic.add(new SelectorItemInfo("person.name"));
            objInfo = SynEvaluObjectFactory.getRemoteInstance().getSynEvaluObjectInfo((IObjectPK)new ObjectUuidPK(objInfo.getId().toString()), sic);
            this.prmtObject.setDisplayFormat("$person.name$");
            this.prmtObject.removeDataChangeListener((DataChangeListener)this.dcList);
            this.prmtObject.setValue((Object)objInfo);
            this.prmtObject.addDataChangeListener((DataChangeListener)this.dcList);
        }
    }

    private class prmtObjectDataChangeListener
    implements DataChangeListener {
        private prmtObjectDataChangeListener() {
        }

        public void dataChanged(DataChangeEvent e) {
            try {
                FormulaSysEditUI.this.prmtObject_dataChanged(e);
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
        }
    }

    private class PerfTypeSelectChangeListener
    implements ActionListener {
        private PerfTypeSelectChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterInfo filter;
            FilterInfo fi;
            EntityViewInfo evi;
            PerfModeEnum pm = (PerfModeEnum)((Object)FormulaSysEditUI.this.combPerfType.getSelectedItem());
            if (PerfModeEnum.personTarget.equals((Object)pm)) {
                FormulaSysEditUI.this.prmtSP.setEntityViewInfo(null);
                FormulaSysEditUI.this.prmtSP.setQueryInfo("com.kingdee.eas.hr.perf.app.SolutionPeriodOverForPersonQuery");
                FormulaSysEditUI.this.prmtObject.setQueryInfo("com.kingdee.eas.hr.perf.app.EvaluObjectPersonResultSPQuery");
                FormulaSysEditUI.this.prmtObject.setDisplayFormat("$name$");
            } else if (PerfModeEnum.personMulti.equals((Object)pm)) {
                FormulaSysEditUI.this.prmtObject.setSelector(null);
                FormulaSysEditUI.this.prmtSP.setEntityViewInfo(null);
                FormulaSysEditUI.this.prmtSP.setQueryInfo("com.kingdee.eas.hr.perf.app.MDSolutionPeriodF7Query");
                evi = new EntityViewInfo();
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("SPStatuEnum", (Object)new Integer(102)));
                evi.setFilter(fi);
                FormulaSysEditUI.this.prmtSP.setEntityViewInfo(evi);
                FormulaSysEditUI.this.prmtObject.setQueryInfo("com.kingdee.eas.hr.perf.app.MDObjectSPQuery");
                FormulaSysEditUI.this.prmtObject.setDisplayFormat("$person.name$");
            } else if (PerfModeEnum.orgTarget.equals((Object)pm)) {
                FormulaSysEditUI.this.prmtSP.setEntityViewInfo(null);
                FormulaSysEditUI.this.prmtSP.setQueryInfo("com.kingdee.eas.hr.perf.app.SolutionPeriodOverForOrgQuery");
                FormulaSysEditUI.this.prmtObject.setQueryInfo("com.kingdee.eas.hr.perf.app.EvaluObjectOrgResultSPQuery");
                FormulaSysEditUI.this.prmtObject.setDisplayFormat("$name$");
            } else if (PerfModeEnum.orgMulti.equals((Object)pm)) {
                FormulaSysEditUI.this.prmtSP.setEntityViewInfo(null);
                FormulaSysEditUI.this.prmtSP.setQueryInfo("com.kingdee.eas.hr.perf.app.MDSolutionPeriodF7OrgQuery");
                evi = new EntityViewInfo();
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("SPStatuEnum", (Object)new Integer(102)));
                evi.setFilter(fi);
                FormulaSysEditUI.this.prmtSP.setEntityViewInfo(evi);
                FormulaSysEditUI.this.prmtObject.setQueryInfo("com.kingdee.eas.hr.perf.app.MDObjectSPOrgQuery");
                FormulaSysEditUI.this.prmtObject.setDisplayFormat("$evaluOrg.name$");
            } else if (PerfModeEnum.sum.equals((Object)pm)) {
                FormulaSysEditUI.this.prmtSP.setEntityViewInfo(null);
                FormulaSysEditUI.this.prmtSP.setQueryInfo("com.kingdee.eas.hr.perf.app.SumSolutionF7Query");
                FormulaSysEditUI.this.prmtObject.setQueryInfo("com.kingdee.eas.hr.perf.app.SumPersonQuery");
                FormulaSysEditUI.this.prmtObject.setDisplayFormat("$person.name$");
            } else if (PerfModeEnum.complex.equals((Object)pm)) {
                FormulaSysEditUI.this.prmtSP.setEntityViewInfo(null);
                FormulaSysEditUI.this.prmtSP.setQueryInfo("com.kingdee.eas.hr.perf.app.SynSolutionPeriodF7Query");
                evi = new EntityViewInfo();
                fi = new FilterInfo();
                fi.getFilterItems().add(new FilterItemInfo("status", (Object)new Integer(102)));
                evi.setFilter(fi);
                FormulaSysEditUI.this.prmtSP.setEntityViewInfo(evi);
                FormulaSysEditUI.this.prmtObject.setQueryInfo("com.kingdee.eas.hr.perf.app.SynObjectSPQuery");
                FormulaSysEditUI.this.prmtObject.setDisplayFormat("$person.name$");
            } else {
                FormulaSysEditUI.this.prmtObject.setEnabled(false);
            }
            EntityViewInfo viewInfo = FormulaSysEditUI.this.prmtSP.getEntityViewInfo();
            if (viewInfo == null) {
                viewInfo = new EntityViewInfo();
            }
            if ((filter = viewInfo.getFilter()) == null) {
                filter = new FilterInfo();
                viewInfo.setFilter(filter);
            }
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
            FormulaSysEditUI.this.prmtSP.setEntityViewInfo(viewInfo);
            FormulaSysEditUI.this.prmtSP.setValue(null);
            FormulaSysEditUI.this.prmtObject.setValue(null);
        }
    }
}

