/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.perf.EvaluSolutionFactory;
import com.kingdee.eas.hr.perf.GradeModeEnum;
import com.kingdee.eas.hr.perf.GradeModeFactory;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.IGradeMode;
import com.kingdee.eas.hr.perf.PerformUtil;
import com.kingdee.eas.hr.perf.RankGroupFactory;
import com.kingdee.eas.hr.perf.client.AbstractGradeModeEditUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class GradeModeEditUI
extends AbstractGradeModeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(GradeModeEditUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private static final Float MIN_VALUE = new Float("0.00");
    private static final Float MAX_VALUE = new Float("10000.00");

    public GradeModeEditUI() throws Exception {
        this.txtMaxGrade.setMinimumValue((Comparable)MIN_VALUE);
        this.txtMinGrade.setMinimumValue((Comparable)MIN_VALUE);
        this.txtMaxGrade.setMaximumValue((Comparable)MAX_VALUE);
        this.txtMinGrade.setMaximumValue((Comparable)MAX_VALUE);
        this.txtMinGrade.setRemoveingZeroInDispaly(false);
        this.txtMaxGrade.setRemoveingZeroInDispaly(false);
        this.txtMinGrade.setRemoveingZeroInEdit(false);
        this.txtMaxGrade.setRemoveingZeroInEdit(false);
        this.txtMaxGrade.setRequired(true);
        this.txtMinGrade.setRequired(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtMaxGrade.setSupportedEmpty(true);
        this.txtMinGrade.setSupportedEmpty(true);
        if (super.getUIContext().get("readOnly") != null) {
            this.btnAddNew.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnEdit.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        GradeModeInfo ret = new GradeModeInfo();
        ret.setIsDefault(GradeModeEnum.NO);
        ret.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return ret;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return GradeModeFactory.getRemoteInstance();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        BigDecimal maxGrade;
        FilterInfo filter = null;
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        BigDecimal minGrade = PerformUtil.toBigDecimal(this.txtMinGrade.getNumberValue());
        if (minGrade == null || minGrade.doubleValue() < 0.0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"minGradeIllegal"));
            this.txtMinGrade.requestFocus();
            SysUtil.abort();
        }
        if ((maxGrade = PerformUtil.toBigDecimal(this.txtMaxGrade.getNumberValue())) == null || maxGrade.compareTo(minGrade) < 1) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"maxGradeIllegal"));
            this.txtMaxGrade.requestFocus();
            SysUtil.abort();
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("minGrade", (Object)minGrade, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("maxGrade", (Object)maxGrade, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId(), CompareType.NOTEQUALS));
        FilterInfo newFilterInfo = new FilterInfo();
        newFilterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
        filter.mergeFilter(newFilterInfo, "and");
        IGradeMode iGradeMode = (IGradeMode)this.getBizInterface();
        if (iGradeMode.exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"existSameScope"));
            SysUtil.abort();
        }
        if (this.comboDefault.getSelectedItem().equals((Object)GradeModeEnum.YES)) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)new Integer(0), CompareType.EQUALS));
            if (this.editData != null && this.editData.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
            }
            FilterInfo newFilterInfo1 = new FilterInfo();
            newFilterInfo1.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
            filter.mergeFilter(newFilterInfo1, "and");
            if (iGradeMode.exists(filter) && MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"existDefaultGradeMode")) == 2) {
                this.comboDefault.requestFocus();
                SysUtil.abort();
            }
        }
        super.beforeStoreFields(e);
    }

    private void setUIEnabled(boolean status) {
        this.txtNumber.setEditable(status);
        this.txtName.setEditable(status);
        this.txtMinGrade.setEditable(status);
        this.txtMaxGrade.setEditable(status);
        this.txtDescription.setEditable(status);
        this.comboDefault.setEnabled(status);
        this.btnSubmit.setEnabled(status);
    }

    private boolean isRefered() throws Exception {
        if (this.editData.getId() == null) {
            return false;
        }
        FilterInfo evaluFilter = new FilterInfo();
        evaluFilter.getFilterItems().add(new FilterItemInfo("gradeMode.id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
        evaluFilter.getFilterItems().add(new FilterItemInfo("targetGradeModeLink.id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
        evaluFilter.setMaskString("#0 or #1");
        FilterInfo groupFilter = new FilterInfo();
        groupFilter.getFilterItems().add(new FilterItemInfo("gradeMode.id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
        return RankGroupFactory.getRemoteInstance().exists(groupFilter) || EvaluSolutionFactory.getRemoteInstance().exists(evaluFilter);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            if (OprtState.VIEW.equals(this.getOprtState()) || this.isRefered()) {
                this.setUIEnabled(false);
            } else {
                this.setUIEnabled(true);
            }
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isRefered()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"gradeModeUsed"));
            return;
        }
        this.setUIEnabled(true);
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.isRefered()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"gradeModeUsed"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        return sic;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        RequestContext request = new RequestContext();
        if (this.editData != null && this.editData.getId() != null) {
            FilterInfo evaluFilter = new FilterInfo();
            evaluFilter.getFilterItems().add(new FilterItemInfo("gradeMode.id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
            evaluFilter.getFilterItems().add(new FilterItemInfo("targetGradeModeLink.id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
            evaluFilter.setMaskString("#0 or #1");
            FilterInfo groupFilter = new FilterInfo();
            groupFilter.getFilterItems().add(new FilterItemInfo("gradeMode.id", (Object)this.editData.getId().toString(), CompareType.EQUALS));
            request.put("evaluFilter", (Object)evaluFilter);
            request.put("groupFilter", (Object)groupFilter);
            postman.setRequestContext((Serializable)request);
        }
        return postman;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

