/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.InterviewFactory;
import com.kingdee.eas.hr.perf.InterviewTypeEnum;
import com.kingdee.eas.hr.perf.client.AbstractInterviewListUI;
import com.kingdee.eas.hr.perf.client.InterviewEditUI;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class InterviewListUI
extends AbstractInterviewListUI {
    private static final Logger logger = CoreUIObject.getLogger(InterviewListUI.class);

    public InterviewListUI() throws Exception {
        PerfClientUtils.checkValidPerson((CoreUI)this);
    }

    protected void beforeExcutQuery(EntityViewInfo ev) {
        CacheServiceFactory.getInstance().discardQuery((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "InterviewQuery"));
        super.beforeExcutQuery(ev);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        String subordinate = null;
        try {
            subordinate = this.getSubordinate();
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (subordinate == null) {
            return null;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("HROrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        fi.getFilterItems().add(new FilterItemInfo("employee.id", (Object)subordinate, CompareType.INNER));
        return fi;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InterviewFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return InterviewEditUI.class.getName();
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"type", (Object)InterviewTypeEnum.AddNew);
    }

    private String getSubordinate() throws Exception {
        String subordinate = "";
        MetaDataPK qryPk = new MetaDataPK("com.kingdee.eas.hr.perf.app.InterviewPersonListQuery");
        IQueryExecutor iqryEx = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)qryPk);
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        String empId = SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString();
        fi.getFilterItems().add(new FilterItemInfo("Person2.id", (Object)empId));
        fi.getFilterItems().add(new FilterItemInfo("Hierarchy.id", (Object)"00000000-0000-0000-0000-000000000001396FCAD0"));
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)empId));
        fi.setMaskString("(#0 and #1) or #2");
        ev.setFilter(fi);
        iqryEx.setObjectView(ev);
        IRowSet rows = iqryEx.executeQuery();
        while (rows.next()) {
            if (subordinate.length() == 0) {
                subordinate = subordinate + "'" + rows.getString("id") + "'";
                continue;
            }
            subordinate = subordinate + ",'" + rows.getString("id") + "'";
        }
        rows.close();
        return subordinate;
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"employee.number", "employee.name"};
        return locateNames;
    }
}

