/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.org.client.AllAdminPromptBox;
import com.kingdee.eas.hr.perf.InterviewTemplateEnum;
import com.kingdee.eas.hr.perf.InterviewTemplateFactory;
import com.kingdee.eas.hr.perf.InterviewTemplateInfo;
import com.kingdee.eas.hr.perf.InterviewTemplateRangeFactory;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.client.AbstractInterviewTemplateEditUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class InterviewTemplateEditUI
extends AbstractInterviewTemplateEditUI {
    private static final Logger logger = CoreUIObject.getLogger(InterviewTemplateEditUI.class);
    private static String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private JButton btnAddEntry;
    private JButton btnDelEntry;
    private JButton btnAddOrgUnit;
    private JButton btnDelOrgUnit;
    private boolean isUseNumberRule = false;

    public void onLoad() throws Exception {
        PerfClientUtils.checkValidHRO((CoreUI)this);
        PerfClientUtils.checkValidPerson((CoreUI)this);
        this.tblTemplateEntry.checkParsed();
        this.tblTemplateRange.checkParsed();
        super.onLoad();
        KDTextField txtProperty = new KDTextField();
        txtProperty.setMaxLength(50);
        KDTextArea txtContent = new KDTextArea();
        txtContent.setMaxLength(1000);
        this.tblTemplateEntry.getColumn("property").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)txtProperty));
        this.tblTemplateEntry.getColumn("content").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextArea)txtContent));
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddEntry = this.conTemplateEntry.add((Action)((Object)this.actionAddEntry));
        this.btnDelEntry = this.conTemplateEntry.add((Action)((Object)this.actionDelEntry));
        this.btnAddEntry.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelEntry.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddEntry.setToolTipText(EASResource.getString((String)RES, (String)"addRow"));
        this.btnDelEntry.setToolTipText(EASResource.getString((String)RES, (String)"removeRow"));
        this.btnAddOrgUnit = this.conTemplateRange.add((Action)((Object)this.actionAddOrgUnit));
        this.btnDelOrgUnit = this.conTemplateRange.add((Action)((Object)this.actionDelOrgUnit));
        this.btnAddOrgUnit.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnDelOrgUnit.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnAddOrgUnit.setToolTipText(EASResource.getString((String)RES, (String)"addRow"));
        this.btnDelOrgUnit.setToolTipText(EASResource.getString((String)RES, (String)"removeRow"));
    }

    @Override
    public void loadFields() {
        try {
            this.isUseNumberRule = PerfUtils.setAutoNumberByOrg("ControlUnit", this.createNewData(), (IObjectValue)this.editData, this.txtNumber);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        super.loadFields();
        boolean bool = OprtState.VIEW.equals(this.getOprtState());
        this.btnAddEntry.setEnabled(!bool);
        this.btnDelEntry.setEnabled(!bool);
        this.btnAddOrgUnit.setEnabled(!bool);
        this.btnDelOrgUnit.setEnabled(!bool);
        if (OprtState.EDIT.equals(this.getOprtState()) && InterviewTemplateEnum.INNER_DEFINED.equals((Object)this.editData.getProperty())) {
            this.txtNumber.setEditable(false);
            this.txtName.setEditable(false);
            this.txtDescription.setEditable(false);
            this.btnAddOrgUnit.setEnabled(false);
            this.btnDelOrgUnit.setEnabled(false);
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (this.txtNumber.isEnabled()) {
            PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        }
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InterviewTemplateFactory.getRemoteInstance();
    }

    protected IObjectValue createNewData() {
        InterviewTemplateInfo objectValue = new InterviewTemplateInfo();
        objectValue.setProperty(InterviewTemplateEnum.USER_DEFINED);
        return objectValue;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("property"));
        return sic;
    }

    @Override
    public void actionAddEntry_actionPerformed(ActionEvent e) throws Exception {
        PerfClientUtils.addLine(this.tblTemplateEntry);
    }

    @Override
    public void actionDelEntry_actionPerformed(ActionEvent e) throws Exception {
        PerfClientUtils.removeLine(this.tblTemplateEntry);
    }

    @Override
    public void actionAddOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        AllAdminPromptBox allAdminOrg = new AllAdminPromptBox((IUIObject)this);
        allAdminOrg.setIsSingleSelect(false);
        allAdminOrg.show();
        if (allAdminOrg.isCanceled()) {
            return;
        }
        Object obj = allAdminOrg.getData();
        if (obj instanceof Object[]) {
            Object[] datas = (Object[])obj;
            HashSet<String> orgIdSet = new HashSet<String>();
            AdminOrgUnitInfo adminInfo = null;
            int n = datas.length;
            for (int i = 0; i < n; ++i) {
                adminInfo = (AdminOrgUnitInfo)datas[i];
                if (adminInfo == null || adminInfo.getId() == null) continue;
                orgIdSet.add(adminInfo.getId().toString());
            }
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit", orgIdSet, CompareType.INCLUDE));
            if (InterviewTemplateRangeFactory.getRemoteInstance().exists(filter)) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"interviewTemplate_ExistsOrgUnit"));
                SysUtil.abort();
            }
            Set orgIds = this.getExistsOrgUnitIdFromTable();
            IRow row = null;
            AdminOrgUnitInfo adminOrgUnitInfo = null;
            int size = datas.length;
            for (int i = 0; i < size; ++i) {
                adminOrgUnitInfo = (AdminOrgUnitInfo)datas[i];
                if (orgIds != null && orgIds.contains(adminOrgUnitInfo.getId().toString())) continue;
                row = this.tblTemplateRange.addRow();
                row.getCell("adminOrgUnit").setValue((Object)adminOrgUnitInfo);
                row.getCell("adminOrgUnit.number").setValue((Object)adminOrgUnitInfo.getNumber());
            }
        }
    }

    private Set getExistsOrgUnitIdFromTable() {
        HashSet<String> orgUnitIds = new HashSet<String>();
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        int size = this.tblTemplateRange.getRowCount();
        for (int i = 0; i < size; ++i) {
            adminOrgUnitInfo = (AdminOrgUnitInfo)this.tblTemplateRange.getRow(i).getCell("adminOrgUnit").getValue();
            orgUnitIds.add(adminOrgUnitInfo.getId().toString());
        }
        return orgUnitIds;
    }

    @Override
    public void actionDelOrgUnit_actionPerformed(ActionEvent e) throws Exception {
        PerfClientUtils.removeLine(this.tblTemplateRange);
    }
}

