/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.framework.CUIDGetterFacadeFactory;
import com.kingdee.eas.basedata.framework.client.ClientControlStrategy;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.InterviewTemplateFacadeFactory;
import com.kingdee.eas.hr.perf.InterviewTemplateFactory;
import com.kingdee.eas.hr.perf.client.AbstractInterviewTemplateListUI;
import com.kingdee.eas.hr.perf.client.CopyInterviewTemplateUI;
import com.kingdee.eas.hr.perf.client.InterviewTemplateEditUI;
import com.kingdee.eas.hr.perf.client.KDTableUtil;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Map;
import org.apache.log4j.Logger;

public class InterviewTemplateListUI
extends AbstractInterviewTemplateListUI {
    private static final Logger logger = CoreUIObject.getLogger(InterviewTemplateListUI.class);
    private static String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private ClientControlStrategy cStrategy = null;

    public void onLoad() throws Exception {
        PerfClientUtils.checkValidHRO((CoreUI)this);
        PerfClientUtils.checkValidPerson((CoreUI)this);
        super.onLoad();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return InterviewTemplateFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return InterviewTemplateEditUI.class.getName();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCopyTemplate.setIcon(EASResource.getIcon((String)"imgTbtn_electcopy"));
        this.menuItemCopyTemplate.setIcon(EASResource.getIcon((String)"imgTbtn_electcopy"));
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.changeState(false);
        this.actionRefresh_actionPerformed(e);
    }

    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        this.changeState(true);
        this.actionRefresh_actionPerformed(e);
    }

    private String getCUIDFromBizobject() throws Exception {
        return CUIDGetterFacadeFactory.getRemoteInstance().getCUID(this.getSelectedKeyValue());
    }

    protected ClientControlStrategy getStrategy() {
        if (this.cStrategy != null) {
            return this.cStrategy;
        }
        String controlType = this.getControlType();
        this.cStrategy = ClientControlStrategy.create((String)controlType, null);
        return this.cStrategy;
    }

    protected void checkPermission(String action, String cuID) throws Exception {
        this.getStrategy().checkPermission(action, cuID);
    }

    private void changeState(boolean state) throws Exception {
        this.checkPermission("ACTION_MODIFY", this.getCUIDFromBizobject());
        int[] rows = KDTableUtil.getSelectedRows(this.tblMain);
        ArrayList<String> list = new ArrayList<String>();
        int n = rows.length;
        for (int i = 0; i < n; ++i) {
            IRow row = this.tblMain.getRow(rows[i]);
            Boolean enable = (Boolean)row.getCell("enable").getValue();
            BizEnumValueDTO defaultDefined = (BizEnumValueDTO)row.getCell("property").getValue();
            if (enable == state || row.getCell("id").getValue() == null || 10 == defaultDefined.getInt()) continue;
            list.add(row.getCell("id").getValue().toString());
        }
        if (list.size() > 0) {
            InterviewTemplateFacadeFactory.getRemoteInstance().changeState(list, state ? 1 : 0);
        }
    }

    @Override
    public void actionCopyTemplate_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        ArrayList list = this.getSelectedIdValues();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"templateID", list.get(0));
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CopyInterviewTemplateUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        this.actionRefresh_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        int[] rows = KDTableUtil.getSelectedRows(this.tblMain);
        if (rows != null && rows.length > 0) {
            Boolean enable;
            IRow row = this.tblMain.getRow(rows[0]);
            BizEnumValueDTO defaultDefined = (BizEnumValueDTO)row.getCell("property").getValue();
            if (10 == defaultDefined.getInt()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"interviewTemplate_removeInnerDefined"));
                SysUtil.abort();
            }
            if ((enable = (Boolean)row.getCell("enable").getValue()).booleanValue()) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"interviewTemplate_removeForEnable"));
                SysUtil.abort();
            }
        }
        super.actionRemove_actionPerformed(e);
    }
}

