/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.dao.AbstractObjectValue;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ObjectValueUtil;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.GradeModeEnum;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.IMultiDimentionSolution;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionInfo;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.client.AbstractMDBaseInfoUI;
import com.kingdee.eas.hr.perf.client.IMultiDimentionSolutionUI;
import com.kingdee.eas.hr.perf.client.MDSolutionHelper;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import java.awt.Container;
import java.io.Serializable;

public class MDBaseInfoUI
extends AbstractMDBaseInfoUI
implements IMultiDimentionSolutionUI {
    private static final long serialVersionUID = -61166L;
    MultiDimentionSolutionInfo oldInfo;
    private String evaluSolutionId;
    private Container parentToolBar;
    private boolean isUseNumberRule = false;

    public void onLoad() throws Exception {
        MDSolutionHelper.initOrgUnit((IUIObject)this, this.prmtOrgUnit);
        MDSolutionHelper.initComboGrade(this.comboGrade);
        this.prmtOrgUnit.setRequired(true);
        this.parentToolBar = (Container)this.getUIContext().get("ToolBar");
        super.onLoad();
        this.loadBaseInfo();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.txtNumber.requestFocus(true);
    }

    public void initUIStatus(boolean isExistSolutionPeriodStarted) {
        if (isExistSolutionPeriodStarted) {
            MDSolutionHelper.setEnabled((Container)((Object)this), false);
            this.txtDescription.setEnabled(false);
            String[] workButtons = new String[]{"btnSubmit"};
            MDSolutionHelper.setEnabled(this.parentToolBar, workButtons, false, false);
        } else {
            MDSolutionHelper.setEnabled((Container)((Object)this), true);
            this.txtDescription.setEnabled(true);
            if (!OprtState.VIEW.equals(this.getOprtState())) {
                String[] workButtons = new String[]{"btnSubmit"};
                MDSolutionHelper.setEnabled(this.parentToolBar, workButtons, false, true);
            }
        }
        if (OprtState.VIEW.equals(this.getOprtState())) {
            MDSolutionHelper.setEnabled((Container)((Object)this), new String[]{"btnViewRankGroup"}, true, false);
            this.txtDescription.setEnabled(false);
        }
        this.labelDescription.setEnabled(true);
    }

    public String getEvaluSolutionId() {
        return this.evaluSolutionId;
    }

    private void loadBaseInfo() throws Exception {
        this.evaluSolutionId = (String)this.getUIContext().get("ID");
        if (this.evaluSolutionId == null) {
            this.evaluSolution = this.createNewData();
            GradeModeInfo gradeModeInfo = null;
            int n = this.comboGrade.getItemCount();
            for (int i = 0; i < n; ++i) {
                gradeModeInfo = (GradeModeInfo)this.comboGrade.getItemAt(i);
                if (!gradeModeInfo.getIsDefault().equals((Object)GradeModeEnum.YES)) continue;
                this.evaluSolution.setGradeMode(gradeModeInfo);
                break;
            }
        } else {
            this.evaluSolution = MDSolutionHelper.getMultiDimentionInfo(this.evaluSolutionId);
        }
        this.setDataObject((IObjectValue)this.evaluSolution);
        this.oldInfo = (MultiDimentionSolutionInfo)this.evaluSolution.clone();
        this.loadFields();
        if (this.evaluSolutionId != null) {
            this.initUIStatus(MDSolutionHelper.isExistSolutionPeriodStartedOrEnded(this.evaluSolutionId));
        }
    }

    private MultiDimentionSolutionInfo createNewData() {
        MultiDimentionSolutionInfo evaluSolutionInfo = new MultiDimentionSolutionInfo();
        evaluSolutionInfo.setHrOrgUnit(PFUtils.getCurrentHROrgUnit());
        EvaluSolutionTypeEnum type = (EvaluSolutionTypeEnum)((Object)this.getUIContext().get("EvaluSolutionType"));
        evaluSolutionInfo.setSolutionType(type);
        return evaluSolutionInfo;
    }

    @Override
    public void loadFields() {
        try {
            this.isUseNumberRule = PerfUtils.setAutoNumberByOrg("HRO", (IObjectValue)this.createNewData(), (IObjectValue)this.evaluSolution, this.txtNumber, "solutionType");
        }
        catch (Exception e) {
            this.handleException(e);
        }
        super.loadFields();
        GradeModeInfo info = null;
        if (this.evaluSolution.getGradeMode() == null) {
            return;
        }
        String id = this.evaluSolution.getGradeMode().getId().toString();
        int size = this.comboGrade.getItemCount();
        for (int i = 0; i < size; ++i) {
            info = (GradeModeInfo)this.comboGrade.getItemAt(i);
            if (!id.equals(info.getId().toString())) continue;
            this.comboGrade.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.evaluSolution.getId() == null) {
            this.evaluSolution.setSolutionStatuEn(SolutionStatusEnum.UNUSED);
        }
        if (this.oldInfo.getGradeMode() != null && !this.oldInfo.getGradeMode().getId().equals((Object)this.evaluSolution.getGradeMode().getId())) {
            this.evaluSolution.setRankGroup(null);
        }
    }

    public boolean isDataModified() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            return false;
        }
        this.storeFields();
        return !ObjectValueUtil.objectValueEquals((AbstractObjectValue)this.oldInfo, (AbstractObjectValue)this.evaluSolution);
    }

    @Override
    public void secondLoad() throws Exception {
        if ((OprtState.EDIT.equals(this.getOprtState()) || OprtState.ADDNEW.equals(this.getOprtState())) && !PFVerifyUtils.objectIsNull(this.getUIContext().get("ID"))) {
            MultiDimentionSolutionInfo info = MDSolutionHelper.getMultiDimentionInfo((String)this.getUIContext().get("ID"));
            this.setDataObject((IObjectValue)info);
            this.oldInfo = info;
        }
        if (this.evaluSolutionId != null) {
            this.initUIStatus(MDSolutionHelper.isExistSolutionPeriodStartedOrEnded(this.evaluSolutionId));
        }
    }

    @Override
    public void submit() throws Exception {
        this.verifyInput();
        this.storeFields();
        IMultiDimentionSolution evaluSolution = MultiDimentionSolutionFactory.getRemoteInstance();
        this.evaluSolutionId = evaluSolution.submit((CoreBaseInfo)this.evaluSolution).toString();
        this.evaluSolution = evaluSolution.getMultiDimentionSolutionInfo((IObjectPK)new ObjectUuidPK(this.evaluSolutionId));
        this.txtNumber.setText(this.evaluSolution.getNumber());
    }

    @Override
    public void verifyInput() throws Exception {
        if (this.txtNumber.isEnabled()) {
            PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        }
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.prmtOrgUnit);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.comboGrade);
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    protected void initUserConfig() {
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("evaluSolutionId", this.getUIContext().get("ID"));
        handler.setRequestContext((Serializable)request);
        return handler;
    }
}

