/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.swing.KDTabbedPane;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.perf.EvalPersonFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.IEvalPerson;
import com.kingdee.eas.hr.perf.MDEvaluGroupCheckPersonException;
import com.kingdee.eas.hr.perf.MDEvaluGroupFactory;
import com.kingdee.eas.hr.perf.MDEvaluGroupInfo;
import com.kingdee.eas.hr.perf.MDGroupObjectInfo;
import com.kingdee.eas.hr.perf.MultiDimentionObjectInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.client.AbstractMDEvaluGroupListUI;
import com.kingdee.eas.hr.perf.client.CheckEvaluPersonUI;
import com.kingdee.eas.hr.perf.client.CheckEvalueOrgUI;
import com.kingdee.eas.hr.perf.client.IMultiDimentionSolutionUI;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.perf.client.MDEvaluGroupSelfUI;
import com.kingdee.eas.hr.perf.client.MDEvaluGroupUI;
import com.kingdee.eas.hr.perf.client.MDSolutionHelper;
import com.kingdee.eas.hr.perf.client.MyMsgBox;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.ProgDialog;
import com.kingdee.eas.hr.perf.client.ViewMDGroupObjectOrgUI;
import com.kingdee.eas.hr.perf.client.ViewMDGroupObjectUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MDEvaluGroupListUI
extends AbstractMDEvaluGroupListUI
implements IMultiDimentionSolutionUI {
    private static final long serialVersionUID = -61166L;
    private static final Logger logger = CoreUIObject.getLogger(MDEvaluGroupListUI.class);
    private static final int SOLUTION_PERIOD_INDEX = 3;
    private static final int KDTABINDEX_EVALUOBJECT = 2;
    private String evaluSolutionId;
    private Container parentToolBar;

    public void onLoad() throws Exception {
        this.parentToolBar = (Container)this.getUIContext().get("ToolBar");
        super.onLoad();
        this.initSolutionPeriod();
        this.setUIStatusByView();
    }

    private void initSolutionPeriod() throws Exception {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)this.getUIContext().get("ID").toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("MultiDimntModeE", null, CompareType.NOTEQUALS));
        if (!MultiDimentionSolutionFactory.getRemoteInstance().exists(filterInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.MultiDimentionSolutionResource", (String)"ModeInfoNotSave"));
            KDTabbedPane tbpMain = (KDTabbedPane)this.getUIContext().get("TBPMain");
            tbpMain.setSelectedComponent(tbpMain.getComponentAt(1));
            SysUtil.abort();
        }
        MultiDimentionSolutionPeriodInfo solutionPeriodInfo = null;
        if (this.comboSolutionPeriod.getSelectedItem() != null) {
            solutionPeriodInfo = (MultiDimentionSolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        }
        this.evaluSolutionId = (String)this.getUIContext().get("ID");
        this.comboSolutionPeriod.setActionCommand("INIT");
        MDSolutionHelper.initSolutionPeriod(this.comboSolutionPeriod, this.evaluSolutionId, false);
        if (this.comboSolutionPeriod.getItemCount() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.MultiDimentionSolutionResource", (String)"NotExistSolutionPeriod"));
            KDTabbedPane tbpMain = (KDTabbedPane)this.getUIContext().get("TBPMain");
            tbpMain.setSelectedComponent(tbpMain.getComponentAt(3));
            SysUtil.abort();
        }
        if (solutionPeriodInfo == null) {
            this.comboSolutionPeriod.setActionCommand(null);
            this.comboSolutionPeriod.setSelectedIndex(0);
        } else {
            if (this.isExistInComboBox(solutionPeriodInfo)) {
                this.comboSolutionPeriod.setSelectedItem((Object)solutionPeriodInfo);
                this.comboSolutionPeriod.setActionCommand(null);
            } else {
                this.comboSolutionPeriod.setActionCommand(null);
                this.comboSolutionPeriod.setSelectedIndex(0);
                solutionPeriodInfo = (MultiDimentionSolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
            }
            this.setWorkButtonStatus(solutionPeriodInfo.getId().toString());
        }
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            rowSet.beforeFirst();
            HashSet<String> idSet = new HashSet<String>();
            String mdEvaluGroupID = null;
            while (rowSet.next()) {
                mdEvaluGroupID = rowSet.getString("id");
                idSet.add(mdEvaluGroupID);
            }
            rowSet.beforeFirst();
            if (!idSet.isEmpty()) {
                Map map = MDEvaluGroupFactory.getRemoteInstance().getEvaluGroupAllName(idSet);
                while (rowSet.next()) {
                    rowSet.updateString("description", (String)map.get(rowSet.getString("id")));
                }
                rowSet.beforeFirst();
            }
        }
        catch (Exception ex) {
            this.abort(ex);
        }
    }

    private boolean isExistInComboBox(MultiDimentionSolutionPeriodInfo solutionPeriodInfo) {
        MultiDimentionSolutionPeriodInfo selectedInfo = null;
        int count = this.comboSolutionPeriod.getItemCount();
        for (int i = 0; i < count; ++i) {
            selectedInfo = (MultiDimentionSolutionPeriodInfo)this.comboSolutionPeriod.getItemAt(i);
            if (!solutionPeriodInfo.getId().equals((Object)selectedInfo.getId())) continue;
            return true;
        }
        return false;
    }

    private IObjectValue getEntityViewInfo(String solutionPeriodId) {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodId));
        evi.setFilter(fi);
        return evi;
    }

    protected String getEditUIName() {
        try {
            if (MDSolutionHelper.isSelftMode(this.evaluSolutionId)) {
                return MDEvaluGroupSelfUI.class.getName();
            }
            return MDEvaluGroupUI.class.getName();
        }
        catch (Exception e) {
            this.handUIException(e);
            return MDEvaluGroupUI.class.getName();
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MDEvaluGroupFactory.getRemoteInstance();
    }

    @Override
    protected void comboSolutionPeriod_actionPerformed(ActionEvent e) throws Exception {
        if ("INIT".equals(this.comboSolutionPeriod.getActionCommand())) {
            return;
        }
        if (this.comboSolutionPeriod.getSelectedItem() == null) {
            return;
        }
        String solutionPeriodId = ((MultiDimentionSolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getId().toString();
        this.getUIContext().put("SolutionPeriodID", solutionPeriodId);
        this.setDataObject(this.getEntityViewInfo(solutionPeriodId));
        this.refreshList();
        if (this.tblMain.getRowCount() > 0 && PerfClientUtils.getSelectedRow(this.tblMain) == null) {
            this.tblMain.getSelectManager().select(0, 0);
        }
        this.setWorkButtonStatus(solutionPeriodId);
    }

    private void setWorkButtonStatus(String solutionPeriodId) throws Exception {
        if (MDSolutionHelper.getEvaluSolutionStatus(this.evaluSolutionId).equals((Object)SolutionStatusEnum.CLOSED)) {
            Container toolBar = (Container)this.getUIContext().get("ToolBar");
            MDSolutionHelper.setEnabled(toolBar, new String[]{"btnAddGroup_PerformanceTarget", "btnEditGroup_PerformanceTarget", "btnDelGroup_PerformanceTarget", "btnImportGroup_PerformanceTarget", "btnModifyPaper_PerformanceTarget"}, false, false);
        } else {
            this.changeWorkButtonStatus(solutionPeriodId);
        }
    }

    private void changeWorkButtonStatus(String solutionPeriodId) throws Exception {
        SolutionPeriodStatusEnum solutionStatus = MDSolutionHelper.getSolutionPeriodStatus(solutionPeriodId);
        Container toolBar = (Container)this.getUIContext().get("ToolBar");
        if (solutionStatus.equals((Object)SolutionPeriodStatusEnum.UN_EVALU)) {
            MDSolutionHelper.setEnabled(toolBar, new String[]{"btnViewObject_PerformanceTarget", "btnAddGroup_PerformanceTarget", "btnEditGroup_PerformanceTarget", "btnDelGroup_PerformanceTarget", "btnImportGroup_PerformanceTarget"}, false, true);
            MDSolutionHelper.setEnabled(toolBar, new String[]{"btnAddObjectToGroup_PerformanceTarget", "btnModifyPaper_PerformanceTarget"}, false, false);
        } else if (solutionStatus.equals((Object)SolutionPeriodStatusEnum.ON_EVALU)) {
            MDSolutionHelper.setEnabled(toolBar, new String[]{"btnViewObject_PerformanceTarget", "btnAddObjectToGroup_PerformanceTarget", "btnModifyPaper_PerformanceTarget"}, false, true);
            MDSolutionHelper.setEnabled(toolBar, new String[]{"btnAddGroup_PerformanceTarget", "btnEditGroup_PerformanceTarget", "btnDelGroup_PerformanceTarget", "btnImportGroup_PerformanceTarget"}, false, false);
        } else if (solutionStatus.equals((Object)SolutionPeriodStatusEnum.END_EVALU)) {
            MDSolutionHelper.setEnabled(toolBar, new String[]{"btnViewObject_PerformanceTarget"}, false, true);
            MDSolutionHelper.setEnabled(toolBar, new String[]{"btnAddGroup_PerformanceTarget", "btnEditGroup_PerformanceTarget", "btnDelGroup_PerformanceTarget", "btnAddObjectToGroup_PerformanceTarget", "btnImportGroup_PerformanceTarget", "btnModifyPaper_PerformanceTarget"}, false, false);
        }
        this.setUIStatusByView();
        FilterInfo filter = new FilterInfo();
        String id = this.getUIContext().get("ID").toString();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)id));
        filter.getFilterItems().add(new FilterItemInfo("MultiDimntModeE", (Object)new Integer(101)));
        MultiDimentionSolutionInfo info = new MultiDimentionSolutionInfo();
        CacheServiceFactory.getInstance().discardType(info.getBOSType());
        if (!MultiDimentionSolutionFactory.getRemoteInstance().exists(filter)) {
            MDSolutionHelper.setEnabled(toolBar, new String[]{"btnImportGroup_PerformanceTarget"}, false, false);
        }
        MDSolutionHelper.setEnabled(toolBar, new String[]{"btnCheckEvaluator_PerformanceTarget"}, false, true);
    }

    private void setUIStatusByView() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            MDSolutionHelper.setEnabled(this.parentToolBar, new String[]{"btnAddGroup_PerformanceTarget", "btnEditGroup_PerformanceTarget", "btnDelGroup_PerformanceTarget", "btnImportGroup_PerformanceTarget", "btnAddObjectToGroup_PerformanceTarget"}, false, false);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("mdSolutionID", this.evaluSolutionId);
        uiContext.put("EvaluSolutionType", this.getUIContext().get("EvaluSolutionType"));
        uiContext.put("SolutionPeriodID", ((MultiDimentionSolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getId().toString());
        uiContext.put("ID", null);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (uiWindow != null && this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.dealEditUI(OprtState.VIEW, e);
    }

    private void dealEditUI(String oprtState, ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("mdSolutionID", this.evaluSolutionId);
        uiContext.put("EvaluSolutionType", this.getUIContext().get("EvaluSolutionType"));
        uiContext.put("SolutionPeriodID", ((MultiDimentionSolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem()).getId().toString());
        uiContext.put("ID", this.getSelectedKeyValue());
        if ("MODIFY_PAPER".equals(oprtState)) {
            uiContext.put("MODIFY_PAPER", "MODIFY_PAPER");
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, oprtState);
        uiWindow.show();
        if (uiWindow != null && this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.dealEditUI(OprtState.EDIT, e);
    }

    public void actionImportEvaluGroup_actionPerformed(ActionEvent e) throws Exception {
        MultiDimentionSolutionPeriodInfo info = (MultiDimentionSolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
        ArrayList<DatataskParameter> arrayList = new ArrayList<DatataskParameter>();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.hr.perf.perfMDEvaluGroup";
        param.alias = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"perfMDImportGroup");
        param.putContextParam((Object)"solutionPeriodID", (Object)info.getId().toString());
        param.putContextParam((Object)"solutionID", (Object)info.getMDSolution().getId().toString());
        arrayList.add(param);
        DatataskCaller task = new DatataskCaller();
        task.setParentComponent((Component)((Object)this));
        task.invoke(arrayList, 0);
        this.refresh(e);
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    public void checkEvaluator() throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        MultiDimentionSolutionPeriodInfo info = (MultiDimentionSolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        if (!UIRuleUtil.isNotNull((Object)info)) {
            return;
        }
        uiContext.put("mdSolutionID", info.getId().toString());
        Class uiClass = null;
        EvaluSolutionTypeEnum solutionType = (EvaluSolutionTypeEnum)((Object)this.getUIContext().get("EvaluSolutionType"));
        if (EvaluSolutionTypeEnum.PERSON.equals((Object)solutionType)) {
            uiClass = CheckEvaluPersonUI.class;
        } else if (EvaluSolutionTypeEnum.ORGUNIT.equals((Object)solutionType)) {
            uiClass = CheckEvalueOrgUI.class;
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass.getName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
    }

    public void viewGroupObject() throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("mdEvaluGroupID", this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain)).getCell("id").getValue().toString());
        Class uiClass = null;
        EvaluSolutionTypeEnum solutionType = (EvaluSolutionTypeEnum)((Object)this.getUIContext().get("EvaluSolutionType"));
        if (EvaluSolutionTypeEnum.PERSON.equals((Object)solutionType)) {
            uiClass = ViewMDGroupObjectUI.class;
        } else if (EvaluSolutionTypeEnum.ORGUNIT.equals((Object)solutionType)) {
            uiClass = ViewMDGroupObjectOrgUI.class;
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void modifyPaper() throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        MultiDimentionSolutionPeriodInfo solutionPeriodInfo = null;
        if (this.comboSolutionPeriod.getSelectedItem() != null) {
            solutionPeriodInfo = (MultiDimentionSolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        }
        if (solutionPeriodInfo == null) {
            return;
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evalReDetail.mdEvaluator.solutionPeriod.id", (Object)solutionPeriodInfo.getId()));
        filter.getFilterItems().add(new FilterItemInfo("paperState", (Object)new Integer(0), CompareType.NOTEQUALS));
        IEvalPerson iEvalPerson = EvalPersonFactory.getRemoteInstance();
        if (iEvalPerson.exists(filter)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.MultiDimentionSolutionResource", (String)"Already_Sended"));
            SysUtil.abort();
        }
        this.dealEditUI("MODIFY_PAPER", null);
    }

    public void addObjectToGroup() throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        MultiDimentionSolutionPeriodInfo currentSynSolutionPeriod = (MultiDimentionSolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        if (currentSynSolutionPeriod == null) {
            return;
        }
        KDCommonPromptDialog dlg = new KDCommonPromptDialog();
        EvaluSolutionTypeEnum solutionType = (EvaluSolutionTypeEnum)((Object)this.getUIContext().get("EvaluSolutionType"));
        MetaDataPK pk = null;
        if (EvaluSolutionTypeEnum.PERSON.equals((Object)solutionType)) {
            pk = new MetaDataPK("com.kingdee.eas.hr.perf.app", "MDUnTouchedPersonObjectQuery");
        } else if (EvaluSolutionTypeEnum.ORGUNIT.equals((Object)solutionType)) {
            pk = new MetaDataPK("com.kingdee.eas.hr.perf.app", "MDUnTouchedObjectQuery");
        }
        QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)pk);
        dlg.setQueryInfo(queryInfo);
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        StringBuffer sb = new StringBuffer();
        sb.append("select FMDObjectID from T_PF_MDGroupObject where FMDEvaluGroupID in ( ");
        sb.append(" select fid from T_PF_MDEvaluGroup where FSolutionPeriodID = '");
        sb.append(currentSynSolutionPeriod.getId().toString());
        sb.append("')");
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.NOTINNER));
        filter.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)this.evaluSolutionId));
        filter.getFilterItems().add(new FilterItemInfo("deleted", (Object)Boolean.FALSE));
        dlg.setEntityViewInfo(evi);
        dlg.setEnabledMultiSelection(true);
        dlg.show();
        if (dlg.isCanceled()) {
            return;
        }
        Object[] obj = (Object[])dlg.getData();
        String groupID = this.tblMain.getRow(PFUtils.getSelectedRow(this.tblMain)).getCell("id").getValue().toString();
        final MDEvaluGroupInfo info = new MDEvaluGroupInfo();
        info.setId(BOSUuid.read((String)groupID));
        info.setSolutionPeriod(currentSynSolutionPeriod);
        MDGroupObjectInfo groupObject = null;
        for (int i = 0; i < obj.length; ++i) {
            groupObject = new MDGroupObjectInfo();
            groupObject.setMdEvaluGroup(info);
            groupObject.setMdObject((MultiDimentionObjectInfo)obj[i]);
            info.getGroupObject().add(groupObject);
        }
        info.put("patch", "true");
        IProgTask prog = new IProgTask(){

            @Override
            public Object exec() throws Exception {
                try {
                    MDEvaluGroupFactory.getRemoteInstance().addnew((CoreBaseInfo)info);
                }
                catch (MDEvaluGroupCheckPersonException ex) {
                    MDEvaluGroupListUI.this.showDetailErrorMsg(ex.getMessage());
                }
                catch (Exception ex) {
                    MDEvaluGroupListUI.this.handleException(ex);
                }
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
                MsgBox.showInfo((Component)((Object)MDEvaluGroupListUI.this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.PerfResource", (String)"addOK"));
            }
        };
        ProgDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new ProgDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new ProgDialog((Dialog)win);
        }
        dialog.setLongTimeTask(prog);
        dialog.show();
    }

    private void showDetailErrorMsg(String errMsg) {
        MyMsgBox.showDetailAndOK((Component)((Object)this), PerfClientUtils.getResource("com.kingdee.eas.hr.perf.client.MultiDimentionSolutionResource", "mdEvaluGroupPersonNoNeedNumber"), errMsg, 0);
        this.setCursorOfDefault();
        SysUtil.abort();
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public void secondLoad() throws Exception {
        LoadThread loadThread = new LoadThread();
        loadThread.start();
    }

    @Override
    public void submit() throws Exception {
    }

    @Override
    public void verifyInput() throws Exception {
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    protected void initUserConfig() {
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("solutionId", this.getUIContext().get("ID"));
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    private class LoadThread
    extends Thread {
        private LoadThread() {
        }

        @Override
        public void run() {
            try {
                MDEvaluGroupListUI.this.initSolutionPeriod();
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage());
            }
        }
    }
}

