/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.hr.perf.AppointPersonCollection;
import com.kingdee.eas.hr.perf.AppointPersonInfo;
import com.kingdee.eas.hr.perf.EvaluRelationCollection;
import com.kingdee.eas.hr.perf.EvaluRelationInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.FellowTypeEnum;
import com.kingdee.eas.hr.perf.MDEvaluGroupCheckPersonException;
import com.kingdee.eas.hr.perf.MDEvaluGroupFactory;
import com.kingdee.eas.hr.perf.MDEvaluGroupInfo;
import com.kingdee.eas.hr.perf.MDEvaluTypeEnum;
import com.kingdee.eas.hr.perf.MDGroupObjectCollection;
import com.kingdee.eas.hr.perf.MDGroupObjectInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.TestPaperInfo;
import com.kingdee.eas.hr.perf.client.AbstractMDEvaluGroupUI;
import com.kingdee.eas.hr.perf.client.AppointPersonUI;
import com.kingdee.eas.hr.perf.client.IMDGroupObjectUI;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.perf.client.MDGroupObjectOrgUI;
import com.kingdee.eas.hr.perf.client.MDGroupObjectUI;
import com.kingdee.eas.hr.perf.client.MDSolutionHelper;
import com.kingdee.eas.hr.perf.client.MyMsgBox;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.ProgDialog;
import com.kingdee.eas.hr.perf.client.TestPaperBrowseUI;
import com.kingdee.eas.hr.perf.client.TestPaperPromptBox;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.STConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MDEvaluGroupUI
extends AbstractMDEvaluGroupUI {
    private static final Logger logger = CoreUIObject.getLogger(MDEvaluGroupUI.class);
    private String resourcePath = "com.kingdee.eas.hr.perf.client.MultiDimentionSolutionResource";
    String ID = "id";
    String RELATION = "relation";
    String WEIGHT = "weight";
    String SETPAPER = "testPaper";
    String VIEWPAPER = "viewPaper";
    String SELECTED = "selected";
    String NAME = "name";
    String VALUE = "value";
    String OLDVALUE = "oldValue";
    MDEvaluGroupInfo oldEvaluGroupInfo = null;
    String mdEvaluGroupID = null;
    String mdSolutionPeriodID = null;
    JButton btnAddLine;
    JButton btnDelLine;
    JButton btnAppointer;
    MDGroupObjectCollection mdGroupObjectCollection = null;
    boolean solutionPeriodCanModify = false;
    private boolean isSuccess = false;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSubmit.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSetObject.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
    }

    @Override
    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.fetchUIContext();
        this.initEntryButton();
        this.initLoad();
        this.containerWeightCount.getBoundLabel().setForeground(Color.RED);
    }

    private void initLoad() throws Exception {
        MDEvaluGroupInfo info = this.fetchObject();
        this.initRelationTable();
        this.initAppointTable();
        this.loadData(info);
        this.oldEvaluGroupInfo = info;
        this.mdGroupObjectCollection = (MDGroupObjectCollection)((Object)info.getGroupObject().clone());
        this.updateCountWeight();
        SolutionPeriodStatusEnum status = MDSolutionHelper.getSolutionPeriodStatus(this.mdSolutionPeriodID);
        this.solutionPeriodCanModify = status == null || status.equals((Object)SolutionPeriodStatusEnum.UN_EVALU);
        if (!this.solutionPeriodCanModify) {
            this.setOprtState(OprtState.VIEW);
        }
        this.operateUIStatus();
    }

    private void operateUIStatus() {
        this.operateActionStatus();
        this.operateUIComponentStatus();
    }

    private void operateUIComponentStatus() {
        if (OprtState.ADDNEW.equals(this.getOprtState()) || OprtState.EDIT.equals(this.getOprtState())) {
            this.kdtRelation.getColumn(this.RELATION).getStyleAttributes().setLocked(true);
            this.kdtRelation.getColumn(this.WEIGHT).getStyleAttributes().setLocked(true);
            this.kdtRelation.getColumn(this.SETPAPER).getStyleAttributes().setLocked(true);
            int n = this.kdtRelation.getRowCount();
            for (int i = 0; i < n; ++i) {
                IRow row = this.kdtRelation.getRow(i);
                if (!((Boolean)row.getCell(this.SELECTED).getValue()).booleanValue()) continue;
                row.getCell(this.WEIGHT).getStyleAttributes().setLocked(false);
                row.getCell(this.SETPAPER).getStyleAttributes().setLocked(false);
            }
        } else {
            this.txtNumber.setEnabled(false);
            this.txtName.setEnabled(false);
            this.comboFellowType.setEnabled(false);
            this.kdtRelation.getColumn(this.SELECTED).getStyleAttributes().setLocked(true);
            this.kdtRelation.getColumn(this.RELATION).getStyleAttributes().setLocked(true);
            this.kdtRelation.getColumn(this.WEIGHT).getStyleAttributes().setLocked(true);
            this.kdtRelation.getColumn(this.SETPAPER).getStyleAttributes().setLocked(true);
            this.kdtAppoint.getColumn(this.NAME).getStyleAttributes().setLocked(true);
            this.kdtAppoint.getColumn(this.WEIGHT).getStyleAttributes().setLocked(true);
            this.kdtAppoint.getColumn(this.SETPAPER).getStyleAttributes().setLocked(true);
        }
        this.kdtAppoint.getColumn(this.VIEWPAPER).getStyleAttributes().setLocked(true);
        this.kdtRelation.getColumn(this.VIEWPAPER).getStyleAttributes().setLocked(true);
    }

    private void operateActionStatus() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.btnSubmit.setEnabled(true);
            this.btnSetObject.setEnabled(true);
            this.btnAddLine.setEnabled(true);
            this.btnDelLine.setEnabled(true);
            this.btnAppointer.setEnabled(true);
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.btnSubmit.setEnabled(true);
            this.btnSetObject.setEnabled(true);
            this.btnAddLine.setEnabled(true);
            this.btnDelLine.setEnabled(true);
            this.btnAppointer.setEnabled(true);
        } else {
            this.btnSubmit.setEnabled(false);
            this.btnSetObject.setEnabled(true);
            this.btnAddLine.setEnabled(false);
            this.btnDelLine.setEnabled(false);
            this.btnAppointer.setEnabled(true);
        }
    }

    private void initEntryButton() {
        this.btnAddLine = this.appointContainer.add((Action)((Object)this.actionAddLine));
        this.btnAddLine.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionAddLine), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnDelLine = this.appointContainer.add((Action)((Object)this.actionDelLine));
        this.btnDelLine.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionDelLine), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnAppointer = this.appointContainer.add((Action)((Object)this.actionAppointer));
        this.btnAppointer.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionAppointer), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnAddLine.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        this.btnAddLine.setToolTipText(PerfClientUtils.getResource(this.resourcePath, "addLine"));
        this.btnAddLine.setText(null);
        this.btnAddLine.setSize(19, 19);
        this.btnDelLine.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        this.btnDelLine.setToolTipText(PerfClientUtils.getResource(this.resourcePath, "delLine"));
        this.btnDelLine.setText(null);
        this.btnDelLine.setSize(19, 19);
        this.btnAppointer.setIcon(EASResource.getIcon((String)"imgTbtn_userview"));
        this.btnAppointer.setToolTipText(PerfClientUtils.getResource(this.resourcePath, "appointer"));
        this.btnAppointer.setText(null);
        this.btnAppointer.setSize(19, 19);
    }

    private MDEvaluGroupInfo fetchObject() throws Exception {
        if (this.mdEvaluGroupID == null) {
            return this.createNewData();
        }
        return MDEvaluGroupFactory.getRemoteInstance().getMDEvaluGroupInfo((IObjectPK)new ObjectUuidPK(this.mdEvaluGroupID), this.getMDEvaluGroupSelectors());
    }

    private SelectorItemCollection getMDEvaluGroupSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("fellowType"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("solutionPeriod.id"));
        sic.add(new SelectorItemInfo("relation.id"));
        sic.add(new SelectorItemInfo("relation.name"));
        sic.add(new SelectorItemInfo("relation.personRestrict"));
        sic.add(new SelectorItemInfo("relation.weight"));
        sic.add(new SelectorItemInfo("relation.MDEvaluTypeEnum"));
        sic.add(new SelectorItemInfo("relation.paper.id"));
        sic.add(new SelectorItemInfo("relation.paper.name"));
        sic.add(new SelectorItemInfo("relation.paper.number"));
        sic.add(new SelectorItemInfo("relation.appointPerson.id"));
        sic.add(new SelectorItemInfo("relation.appointPerson.person.id"));
        sic.add(new SelectorItemInfo("relation.appointPerson.person.name"));
        sic.add(new SelectorItemInfo("relation.appointPerson.person.number"));
        sic.add(new SelectorItemInfo("relation.appointPerson.positioin.id"));
        sic.add(new SelectorItemInfo("relation.appointPerson.positioin.name"));
        sic.add(new SelectorItemInfo("relation.appointPerson.positioin.number"));
        sic.add(new SelectorItemInfo("groupObject.id"));
        sic.add(new SelectorItemInfo("groupObject.mdObject.evaluOrg.number"));
        sic.add(new SelectorItemInfo("groupObject.mdObject.evaluOrg.displayName"));
        sic.add(new SelectorItemInfo("groupObject.mdObject.responser.name"));
        sic.add(new SelectorItemInfo("groupObject.mdObject.id"));
        return sic;
    }

    private void fetchUIContext() {
        this.mdEvaluGroupID = (String)this.getUIContext().get("ID");
        this.mdSolutionPeriodID = (String)this.getUIContext().get("SolutionPeriodID");
    }

    private MDEvaluGroupInfo createNewData() {
        MDEvaluGroupInfo info = new MDEvaluGroupInfo();
        MultiDimentionSolutionPeriodInfo spInfo = new MultiDimentionSolutionPeriodInfo();
        spInfo.setId(BOSUuid.read((String)this.mdSolutionPeriodID));
        info.setSolutionPeriod(spInfo);
        info.setFellowType(FellowTypeEnum.SAMEPOSITION_OTHERPERSON);
        return info;
    }

    private void loadData(MDEvaluGroupInfo info) {
        this.txtNumber.setText(info.getNumber());
        UIHelper.loadMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)info, (String)"name");
        this.comboFellowType.setSelectedItem((Object)info.getFellowType());
        this.loadRelationTableFields(info);
        this.loadAppointTableFields(info);
    }

    private void storeData(MDEvaluGroupInfo info) {
        if (this.mdEvaluGroupID != null) {
            info.setId(BOSUuid.read((String)this.mdEvaluGroupID));
        }
        MultiDimentionSolutionPeriodInfo mdspInfo = new MultiDimentionSolutionPeriodInfo();
        mdspInfo.setId(BOSUuid.read((String)this.mdSolutionPeriodID));
        info.setSolutionPeriod(mdspInfo);
        info.setNumber(this.txtNumber.getText());
        info.setFellowType((FellowTypeEnum)((Object)this.comboFellowType.getSelectedItem()));
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)info, (String)"name");
        this.storeRelationTableFields(info);
        this.storeAppointTableFields(info);
        info.put("groupObject", (Object)this.getGroupObject(this.mdGroupObjectCollection, this.oldEvaluGroupInfo.getGroupObject()));
    }

    private MDGroupObjectCollection getGroupObject(MDGroupObjectCollection newValue, MDGroupObjectCollection oldValue) {
        MDGroupObjectCollection objectCollection = new MDGroupObjectCollection();
        int n = newValue.size();
        for (int i = 0; i < n; ++i) {
            MDGroupObjectInfo info = this.getGroupObjectByObjectId(oldValue, newValue.get(i).getMdObject().getId().toString());
            if (info != null) {
                objectCollection.add(info);
                continue;
            }
            objectCollection.add(newValue.get(i));
        }
        return objectCollection;
    }

    private MDGroupObjectInfo getGroupObjectByObjectId(MDGroupObjectCollection oldValue, String objectID) {
        MDGroupObjectInfo info = null;
        int n = oldValue.size();
        for (int i = 0; i < n; ++i) {
            if (!oldValue.get(i).getMdObject().getId().toString().equals(objectID)) continue;
            info = (MDGroupObjectInfo)oldValue.get(i).clone();
            break;
        }
        return info;
    }

    private void verifyInput() throws Exception {
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        if (PerfClientUtils.objectIsNull(this.comboFellowType.getSelectedItem())) {
            PerfClientUtils.showConfirmMessge(this.resourcePath, "fellowTypeNotNull", this);
            this.comboFellowType.requestFocus();
        }
        this.checkRelationTableInput();
        this.checkAppointTableInput();
        BigDecimal weight = this.countWeight();
        if (weight.compareTo(new BigDecimal("100.00")) != 0) {
            PerfClientUtils.showErrorMessage(this.resourcePath, "TotalWeightNotBeHundred", this);
        }
        if (this.mdGroupObjectCollection == null || this.mdGroupObjectCollection.size() == 0) {
            PerfClientUtils.showErrorMessage(this.resourcePath, "groupObjectNotNull", this);
        }
    }

    private BigDecimal countWeight() {
        IRow row;
        int i;
        BigDecimal weight = new BigDecimal("0.00");
        int n = this.kdtRelation.getRowCount();
        for (i = 0; i < n; ++i) {
            row = this.kdtRelation.getRow(i);
            if (!((Boolean)row.getCell(this.SELECTED).getValue()).booleanValue() || PerfClientUtils.objectIsNull(row.getCell(this.WEIGHT).getValue())) continue;
            weight = weight.add((BigDecimal)row.getCell(this.WEIGHT).getValue());
        }
        n = this.kdtAppoint.getRowCount();
        for (i = 0; i < n; ++i) {
            row = this.kdtAppoint.getRow(i);
            if (PerfClientUtils.objectIsNull(row.getCell(this.WEIGHT).getValue())) continue;
            weight = weight.add((BigDecimal)row.getCell(this.WEIGHT).getValue());
        }
        return weight;
    }

    private void updateCountWeight() {
        BigDecimal value = this.countWeight();
        StringBuffer sb = new StringBuffer();
        sb.append(PerfClientUtils.getResource(this.resourcePath, "evaluGroupWeightCount"));
        sb.append(PerfClientUtils.formatBigDecimal(value, 2));
        sb.append("%");
        this.containerWeightCount.setBoundLabelText(sb.toString());
    }

    private void initRelationTable() throws Exception {
        this.kdtRelation.checkParsed();
        this.kdtRelation.setRefresh(false);
        this.kdtRelation.removeRows();
        this.kdtRelation.setRefresh(true);
        this.kdtRelation.getHeadRow(0).getCell(this.SELECTED).setValue(null);
        this.initRelationTableEdit();
        IRow row = this.kdtRelation.addRow();
        row.getCell(this.RELATION).setValue((Object)MDEvaluTypeEnum.SELF);
        row.getCell(this.SELECTED).setValue((Object)Boolean.FALSE);
        row = this.kdtRelation.addRow();
        row.getCell(this.RELATION).setValue((Object)MDEvaluTypeEnum.DIRECT_SUPERIOR);
        row.getCell(this.SELECTED).setValue((Object)Boolean.FALSE);
        row = this.kdtRelation.addRow();
        row.getCell(this.RELATION).setValue((Object)MDEvaluTypeEnum.INDIRECT_SUPERIOR);
        row.getCell(this.SELECTED).setValue((Object)Boolean.FALSE);
        row = this.kdtRelation.addRow();
        row.getCell(this.RELATION).setValue((Object)MDEvaluTypeEnum.ORGRESPONSER);
        row.getCell(this.SELECTED).setValue((Object)Boolean.FALSE);
        row = this.kdtRelation.addRow();
        row.getCell(this.RELATION).setValue((Object)MDEvaluTypeEnum.FELLOW);
        row.getCell(this.SELECTED).setValue((Object)Boolean.FALSE);
        row = this.kdtRelation.addRow();
        row.getCell(this.RELATION).setValue((Object)MDEvaluTypeEnum.DIRECT_SUBORDINATOR);
        row.getCell(this.SELECTED).setValue((Object)Boolean.FALSE);
        row = this.kdtRelation.addRow();
        row.getCell(this.RELATION).setValue((Object)MDEvaluTypeEnum.INDIRECT_SUBORDINATOR);
        row.getCell(this.SELECTED).setValue((Object)Boolean.FALSE);
    }

    private void initAppointTable() throws Exception {
        this.kdtAppoint.checkParsed();
        this.kdtAppoint.setRefresh(false);
        this.kdtAppoint.removeRows();
        this.kdtAppoint.setRefresh(true);
        this.initAppointTableEdit();
        if (!OprtState.VIEW.equals(this.getOprtState())) {
            this.kdtAppoint.getColumn(this.NAME).getStyleAttributes().setBackground(PerfClientUtils.requiredColor);
            this.kdtAppoint.getColumn(this.WEIGHT).getStyleAttributes().setBackground(PerfClientUtils.requiredColor);
            this.kdtAppoint.getColumn(this.SETPAPER).getStyleAttributes().setBackground(PerfClientUtils.requiredColor);
        }
    }

    private void initRelationTableEdit() throws Exception {
        this.kdtRelation.checkParsed();
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setMinimumValue((Comparable)new BigDecimal("0.00"));
        formattedTextField.setMaximumValue((Comparable)new BigDecimal("100.00"));
        PFUtils.setTableCellEditorByFormattedTextField(this.kdtRelation, formattedTextField, this.WEIGHT, 2);
        PFUtils.setTableNumberFormat(this.kdtRelation, this.WEIGHT, 2);
        KDBizPromptBox promptBox = this.getPaperPromptBox();
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)promptBox);
        this.kdtRelation.getColumn(this.SETPAPER).setEditor((ICellEditor)cellEditor);
    }

    private void initAppointTableEdit() throws Exception {
        this.kdtAppoint.checkParsed();
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setMinimumValue((Comparable)new BigDecimal("0.00"));
        formattedTextField.setMaximumValue((Comparable)new BigDecimal("100.00"));
        PFUtils.setTableCellEditorByFormattedTextField(this.kdtAppoint, formattedTextField, this.WEIGHT, 2);
        PFUtils.setTableNumberFormat(this.kdtAppoint, this.WEIGHT, 2);
        KDBizPromptBox promptBox = this.getPaperPromptBox();
        promptBox.setEditable(false);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)promptBox);
        this.kdtAppoint.getColumn(this.SETPAPER).setEditor((ICellEditor)cellEditor);
        KDBizMultiLangBox langBox = new KDBizMultiLangBox();
        langBox.setMaxLength(40);
        langBox.setSelectedIndex("l2".equalsIgnoreCase(LocaleUtils.getDefaultLocale().toString()) ? 0 : ("l3".equalsIgnoreCase(LocaleUtils.getDefaultLocale().toString()) ? 1 : 2));
        KDTDefaultCellEditor langEditor = new KDTDefaultCellEditor((JComboBox)langBox);
        this.kdtAppoint.getColumn(this.NAME).setEditor((ICellEditor)langEditor);
    }

    private KDBizPromptBox getPaperPromptBox() {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setDisplayFormat("$number$");
        promptBox.setEditFormat("$number$");
        promptBox.setCommitFormat("$number$");
        promptBox.setEditable(false);
        promptBox.setSelector((KDPromptSelector)new TestPaperPromptBox());
        return promptBox;
    }

    private void loadRelationTableFields(MDEvaluGroupInfo evaluGroupInfo) {
        EvaluRelationCollection collection = evaluGroupInfo.getRelation();
        int n = this.kdtRelation.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtRelation.getRow(i);
            MDEvaluTypeEnum type = (MDEvaluTypeEnum)((Object)row.getCell(this.RELATION).getValue());
            EvaluRelationInfo info = this.getEvaluRelationByType(collection, type);
            if (info == null) continue;
            row.getCell(this.SELECTED).setValue((Object)Boolean.TRUE);
            row.getCell(this.ID).setValue((Object)info.getId());
            row.getCell(this.WEIGHT).setValue((Object)info.getWeight());
            row.getCell(this.SETPAPER).setValue((Object)info.getPaper());
            this.setRelationTableRowColor(row, PerfClientUtils.requiredColor);
            if (info.getPaper() == null) continue;
            row.getCell(this.VIEWPAPER).setValue((Object)EASResource.getIcon((String)"imgTbtn_affixmanage"));
        }
    }

    private void setRelationTableRowColor(IRow row, Color color) {
        if (!OprtState.VIEW.equals(this.getOprtState())) {
            row.getCell(this.WEIGHT).getStyleAttributes().setBackground(color);
            row.getCell(this.SETPAPER).getStyleAttributes().setBackground(color);
        }
    }

    private void loadAppointTableFields(MDEvaluGroupInfo evaluGroupInfo) {
        EvaluRelationCollection collection = evaluGroupInfo.getRelation();
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            EvaluRelationInfo info = collection.get(i);
            if (!MDEvaluTypeEnum.APPOINT.equals((Object)info.getMDEvaluTypeEnum())) continue;
            IRow row = this.kdtAppoint.addRow();
            row.getCell(this.ID).setValue((Object)info.getId());
            row.getCell(this.WEIGHT).setValue((Object)info.getWeight());
            row.getCell(this.SETPAPER).setValue((Object)info.getPaper());
            row.getCell(this.VALUE).setValue((Object)info.getAppointPerson());
            row.getCell(this.OLDVALUE).setValue(info.getAppointPerson().clone());
            if (info.getPaper() != null) {
                row.getCell(this.VIEWPAPER).setValue((Object)EASResource.getIcon((String)"imgTbtn_affixmanage"));
            }
            row.getCell(this.NAME).setValue((Object)info.getName());
        }
    }

    private EvaluRelationInfo getEvaluRelationByType(EvaluRelationCollection collection, MDEvaluTypeEnum type) {
        if (collection == null || collection.size() == 0 || type == null) {
            return null;
        }
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            EvaluRelationInfo info = collection.get(i);
            if (!info.getMDEvaluTypeEnum().equals((Object)type)) continue;
            return info;
        }
        return null;
    }

    private void storeRelationTableFields(MDEvaluGroupInfo evaluGroupInfo) {
        EvaluRelationCollection collection = evaluGroupInfo.getRelation();
        int n = this.kdtRelation.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtRelation.getRow(i);
            if (!((Boolean)row.getCell(this.SELECTED).getValue()).booleanValue()) continue;
            EvaluRelationInfo info = new EvaluRelationInfo();
            if (!PFVerifyUtils.objectIsNull(row.getCell(this.ID).getValue())) {
                info.setId(BOSUuid.read((String)row.getCell(this.ID).getValue().toString()));
            }
            if (!PFVerifyUtils.objectIsNull(row.getCell(this.RELATION).getValue())) {
                info.setMDEvaluTypeEnum((MDEvaluTypeEnum)((Object)row.getCell(this.RELATION).getValue()));
            }
            if (!PFVerifyUtils.objectIsNull(row.getCell(this.WEIGHT).getValue())) {
                info.setWeight((BigDecimal)row.getCell(this.WEIGHT).getValue());
            }
            if (!PFVerifyUtils.objectIsNull(row.getCell(this.SETPAPER).getValue())) {
                info.setPaper((TestPaperInfo)row.getCell(this.SETPAPER).getValue());
            }
            collection.add(info);
        }
    }

    private void storeAppointTableFields(MDEvaluGroupInfo evaluGroupInfo) {
        EvaluRelationCollection collection = evaluGroupInfo.getRelation();
        int n = this.kdtAppoint.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtAppoint.getRow(i);
            if (PFVerifyUtils.objectIsNull(row.getCell(this.ID).getValue()) && PFVerifyUtils.objectIsNull(row.getCell(this.NAME).getValue()) && PFVerifyUtils.objectIsNull(row.getCell(this.WEIGHT).getValue()) && PFVerifyUtils.objectIsNull(row.getCell(this.SETPAPER).getValue()) && PFVerifyUtils.objectIsNull(row.getCell(this.VALUE).getValue())) continue;
            EvaluRelationInfo info = new EvaluRelationInfo();
            if (!PFVerifyUtils.objectIsNull(row.getCell(this.ID).getValue())) {
                info.setId(BOSUuid.read((String)row.getCell(this.ID).getValue().toString()));
            }
            info.setMDEvaluTypeEnum(MDEvaluTypeEnum.APPOINT);
            if (!PFVerifyUtils.objectIsNull(row.getCell(this.NAME).getValue())) {
                String name = row.getCell(this.NAME).getValue().toString();
                String sname = STConverter.tc2sc((String)name);
                String tname = STConverter.sc2tc((String)name);
                info.setName(sname, new Locale("L2"));
                info.setName(tname, new Locale("L3"));
                info.setName(name, new Locale("L1"));
            }
            if (!PFVerifyUtils.objectIsNull(row.getCell(this.WEIGHT).getValue())) {
                info.setWeight((BigDecimal)row.getCell(this.WEIGHT).getValue());
            }
            if (!PFVerifyUtils.objectIsNull(row.getCell(this.SETPAPER).getValue())) {
                info.setPaper((TestPaperInfo)row.getCell(this.SETPAPER).getValue());
            }
            if (!PFVerifyUtils.objectIsNull(row.getCell(this.VALUE).getValue())) {
                info.put("appointPerson", (Object)this.getAppointer((AppointPersonCollection)((Object)row.getCell(this.VALUE).getValue()), (AppointPersonCollection)((Object)row.getCell(this.OLDVALUE).getValue())));
            }
            collection.add(info);
        }
    }

    private AppointPersonCollection getAppointer(AppointPersonCollection newValue, AppointPersonCollection oldValue) {
        AppointPersonCollection personCollection = new AppointPersonCollection();
        int n = newValue.size();
        for (int i = 0; i < n; ++i) {
            AppointPersonInfo info = this.getAppointPersonByPersonID(oldValue, newValue.get(i).getPerson().getId().toString());
            if (info != null) {
                personCollection.add(info);
                continue;
            }
            personCollection.add(newValue.get(i));
        }
        return personCollection;
    }

    private AppointPersonInfo getAppointPersonByPersonID(AppointPersonCollection oldValue, String personID) {
        AppointPersonInfo info = null;
        if (oldValue == null) {
            return null;
        }
        int n = oldValue.size();
        for (int i = 0; i < n; ++i) {
            if (!oldValue.get(i).getPerson().getId().toString().equals(personID)) continue;
            info = (AppointPersonInfo)oldValue.get(i).clone();
            break;
        }
        return info;
    }

    private void checkRelationTableInput() {
        int count = 0;
        KDTEditManager kdtManager = this.kdtRelation.getEditManager();
        int n = this.kdtRelation.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtRelation.getRow(i);
            if (!((Boolean)row.getCell(this.SELECTED).getValue()).booleanValue()) continue;
            ++count;
            if (PFVerifyUtils.objectIsNull(row.getCell(this.WEIGHT).getValue())) {
                kdtManager.editCellAt(i, this.kdtRelation.getColumnIndex(this.WEIGHT));
                PerfClientUtils.showErrorMessage(this.resourcePath, "weightNotNull", this);
            }
            if (!PFVerifyUtils.objectIsNull(row.getCell(this.SETPAPER).getValue())) continue;
            kdtManager.editCellAt(i, this.kdtRelation.getColumnIndex(this.SETPAPER));
            PerfClientUtils.showErrorMessage(this.resourcePath, "testPaperNotNull", this);
        }
    }

    private void checkAppointTableInput() {
        HashSet<Object> set = new HashSet<Object>();
        KDTEditManager kdtManager = this.kdtAppoint.getEditManager();
        int n = this.kdtAppoint.getRowCount();
        for (int i = 0; i < n; ++i) {
            IRow row = this.kdtAppoint.getRow(i);
            if (PFVerifyUtils.objectIsNull(row.getCell(this.ID).getValue()) && PFVerifyUtils.objectIsNull(row.getCell(this.NAME).getValue()) && PFVerifyUtils.objectIsNull(row.getCell(this.WEIGHT).getValue()) && PFVerifyUtils.objectIsNull(row.getCell(this.SETPAPER).getValue()) && PFVerifyUtils.objectIsNull(row.getCell(this.VALUE).getValue())) continue;
            if (PFVerifyUtils.objectIsNull(row.getCell(this.NAME).getValue())) {
                kdtManager.editCellAt(i, this.kdtAppoint.getColumnIndex(this.NAME));
                PerfClientUtils.showErrorMessage(this.resourcePath, "appointNameNotNull", this);
            } else if (set.contains(row.getCell(this.NAME).getValue())) {
                kdtManager.editCellAt(i, this.kdtAppoint.getColumnIndex(this.NAME));
                PerfClientUtils.showErrorMessage(this.resourcePath, "appointNameNotDup", this);
            } else {
                set.add(row.getCell(this.NAME).getValue());
            }
            if (PFVerifyUtils.objectIsNull(row.getCell(this.WEIGHT).getValue())) {
                kdtManager.editCellAt(i, this.kdtAppoint.getColumnIndex(this.WEIGHT));
                PerfClientUtils.showErrorMessage(this.resourcePath, "weightNotNull", this);
            }
            if (PFVerifyUtils.objectIsNull(row.getCell(this.SETPAPER).getValue())) {
                kdtManager.editCellAt(i, this.kdtAppoint.getColumnIndex(this.SETPAPER));
                PerfClientUtils.showErrorMessage(this.resourcePath, "testPaperNotNull", this);
            }
            if (!PFVerifyUtils.objectIsNull(row.getCell(this.VALUE).getValue())) continue;
            Object[] variables = new Object[]{row.getCell(this.NAME).getValue()};
            PerfClientUtils.showErrorMessage(this.resourcePath, "appointGroupAppointNotNull", variables, this);
        }
    }

    @Override
    public void actionSetObject_actionPerformed(ActionEvent e) throws Exception {
        super.actionSetObject_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("groupObject", this.mdGroupObjectCollection);
        uiContext.put("SolutionPeriodID", this.getUIContext().get("SolutionPeriodID"));
        if (this.oldEvaluGroupInfo != null && this.oldEvaluGroupInfo.getId() != null) {
            uiContext.put("mdEvaluGroupID", this.oldEvaluGroupInfo.getId().toString());
        }
        uiContext.put("mdSolutionID", this.getUIContext().get("mdSolutionID"));
        EvaluSolutionTypeEnum solutionType = (EvaluSolutionTypeEnum)((Object)this.getUIContext().get("EvaluSolutionType"));
        Class uiClass = null;
        if (EvaluSolutionTypeEnum.PERSON.equals((Object)solutionType)) {
            uiClass = MDGroupObjectUI.class;
        } else if (EvaluSolutionTypeEnum.ORGUNIT.equals((Object)solutionType)) {
            uiClass = MDGroupObjectOrgUI.class;
            MDEvaluGroupInfo info = new MDEvaluGroupInfo();
            info.put("groupObject", (Object)this.mdGroupObjectCollection);
            uiContext.put("InitDataObject", info);
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiClass.getName(), (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
        IMDGroupObjectUI objUI = (IMDGroupObjectUI)uiWindow.getUIObject();
        if (!objUI.isCanceled()) {
            this.mdGroupObjectCollection = objUI.getData();
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.verifyInput();
        final MDEvaluGroupInfo newInfo = this.storeMDEvaluGroupValue();
        IProgTask prog = new IProgTask(){

            @Override
            public Object exec() throws Exception {
                MDEvaluGroupUI.this.handle(newInfo);
                return "0";
            }

            @Override
            public void afterExec(Object result) throws Exception {
            }
        };
        ProgDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new ProgDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new ProgDialog((Dialog)win);
        }
        dialog.setLongTimeTask(prog);
        dialog.show();
        if (this.isSuccess) {
            this.showSuccessMessage();
        }
    }

    private void handle(MDEvaluGroupInfo newInfo) {
        try {
            IObjectPK pk = MDEvaluGroupFactory.getRemoteInstance().submit((CoreBaseInfo)newInfo);
            this.mdEvaluGroupID = pk.toString();
            this.setOprtState(OprtState.EDIT);
            this.initLoad();
            this.isSuccess = true;
        }
        catch (Exception e3) {
            if (e3 instanceof MDEvaluGroupCheckPersonException) {
                this.showDetailErrorMsg(e3.getMessage());
            } else {
                this.handUIException(e3);
            }
            this.isSuccess = false;
        }
    }

    private void showDetailErrorMsg(String errMsg) {
        MyMsgBox.showDetailAndOK((Component)((Object)this), PerfClientUtils.getResource(this.resourcePath, "mdEvaluGroupPersonNoNeedNumber"), errMsg, 0);
        this.setCursorOfDefault();
        SysUtil.abort();
    }

    private void showSuccessMessage() {
        this.setMessageText(this.getClassAlise() + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Save_OK"));
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.setNextMessageText(this.getClassAlise() + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_AddNew"));
        } else if (OprtState.EDIT.equals(this.getOprtState())) {
            this.setNextMessageText(this.getClassAlise() + " " + EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Edit"));
        }
        this.setIsShowTextOnly(false);
        this.setShowMessagePolicy(0);
        this.showMessage();
    }

    private String getClassAlise() {
        return PerfClientUtils.getResource(this.resourcePath, "mdEvaluGroup");
    }

    private MDEvaluGroupInfo storeMDEvaluGroupValue() {
        MDEvaluGroupInfo newInfo = new MDEvaluGroupInfo();
        this.storeData(newInfo);
        return newInfo;
    }

    @Override
    protected void kdtAppoint_editStopped(KDTEditEvent e) throws Exception {
        if (e.getRowIndex() >= 0) {
            if (e.getColIndex() == this.kdtAppoint.getColumn(this.WEIGHT).getColumnIndex()) {
                this.updateCountWeight();
            } else if (e.getColIndex() == this.kdtAppoint.getColumn(this.SETPAPER).getColumnIndex()) {
                if (this.kdtAppoint.getRow(e.getRowIndex()).getCell(this.SETPAPER).getValue() != null) {
                    this.kdtAppoint.getRow(e.getRowIndex()).getCell(this.VIEWPAPER).setValue((Object)EASResource.getIcon((String)"imgTbtn_affixmanage"));
                } else {
                    this.kdtAppoint.getRow(e.getRowIndex()).getCell(this.VIEWPAPER).setValue(null);
                }
            }
        }
    }

    @Override
    protected void kdtRelation_editStopped(KDTEditEvent e) throws Exception {
        if (e.getRowIndex() >= 0) {
            if (e.getColIndex() == this.kdtRelation.getColumn(this.SELECTED).getColumnIndex()) {
                IRow row = this.kdtRelation.getRow(e.getRowIndex());
                if (((Boolean)row.getCell(e.getColIndex()).getValue()).booleanValue()) {
                    row.getCell(this.WEIGHT).getStyleAttributes().setLocked(false);
                    row.getCell(this.SETPAPER).getStyleAttributes().setLocked(false);
                    this.setRelationTableRowColor(row, PerfClientUtils.requiredColor);
                } else {
                    row.getCell(this.WEIGHT).setValue(null);
                    row.getCell(this.SETPAPER).setValue(null);
                    row.getCell(this.VIEWPAPER).setValue(null);
                    row.getCell(this.WEIGHT).getStyleAttributes().setLocked(true);
                    row.getCell(this.SETPAPER).getStyleAttributes().setLocked(true);
                    this.setRelationTableRowColor(row, PerfClientUtils.normalColor);
                }
                this.updateCountWeight();
            } else if (e.getColIndex() == this.kdtRelation.getColumn(this.WEIGHT).getColumnIndex()) {
                this.updateCountWeight();
            } else if (e.getColIndex() == this.kdtRelation.getColumn(this.SETPAPER).getColumnIndex()) {
                if (this.kdtRelation.getRow(e.getRowIndex()).getCell(this.SETPAPER).getValue() != null) {
                    this.kdtRelation.getRow(e.getRowIndex()).getCell(this.VIEWPAPER).setValue((Object)EASResource.getIcon((String)"imgTbtn_affixmanage"));
                } else {
                    this.kdtRelation.getRow(e.getRowIndex()).getCell(this.VIEWPAPER).setValue(null);
                }
            }
        }
    }

    @Override
    protected void kdtRelation_editValueChanged(KDTEditEvent e) throws Exception {
    }

    @Override
    public void actionAddLine_actionPerformed(ActionEvent e) throws Exception {
        this.kdtAppoint.addRow();
    }

    @Override
    public void actionDelLine_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.kdtAppoint);
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || this.isTableColumnSelected(table)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            int top = table.getSelectManager().get().getBeginRow();
            int bottom = table.getSelectManager().get().getEndRow();
            for (int i = top; i <= bottom; ++i) {
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                IObjectValue detailData = (IObjectValue)table.getRow(top).getUserObject();
                table.removeRow(top);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                    continue;
                }
                if (detailData == null) continue;
                collection.removeObject(detailData);
            }
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    private boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    @Override
    public void actionAppointer_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.kdtAppoint);
        IRow row = this.kdtAppoint.getRow(PFUtils.getSelectedRow(this.kdtAppoint));
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("appointPerson", row.getCell(this.VALUE).getValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(AppointPersonUI.class.getName(), (Map)uiContext, null, this.getOprtState());
        uiWindow.show();
        AppointPersonUI objUI = (AppointPersonUI)uiWindow.getUIObject();
        if (!objUI.isCancle) {
            row.getCell(this.VALUE).setValue((Object)objUI.getData());
        }
    }

    @Override
    protected void kdtRelation_tableClicked(KDTMouseEvent e) throws Exception {
        IRow row;
        if (e.getClickCount() == 2 && e.getRowIndex() >= 0 && e.getColIndex() == this.kdtRelation.getColumnIndex(this.VIEWPAPER) && (row = this.kdtRelation.getRow(e.getRowIndex())).getCell(this.SETPAPER).getValue() != null) {
            this.viewPaper(((TestPaperInfo)row.getCell(this.SETPAPER).getValue()).getId().toString());
        }
    }

    @Override
    protected void kdtAppoint_tableClicked(KDTMouseEvent e) throws Exception {
        IRow row;
        if (e.getClickCount() == 2 && e.getRowIndex() >= 0 && e.getColIndex() == this.kdtAppoint.getColumnIndex(this.VIEWPAPER) && (row = this.kdtAppoint.getRow(e.getRowIndex())).getCell(this.SETPAPER).getValue() != null) {
            this.viewPaper(((TestPaperInfo)row.getCell(this.SETPAPER).getValue()).getId().toString());
        }
    }

    private void viewPaper(String paperId) throws Exception {
        if (paperId == null) {
            return;
        }
        IUIFactory uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)paperId);
        IUIWindow currPaperStoreTypeUI = uiFactory.create(TestPaperBrowseUI.class.getName(), (Map)uiContext);
        currPaperStoreTypeUI.show();
    }

    @Override
    protected void comboFellowType_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.comboFellowType.getSelectedItem();
        if (obj != null) {
            this.comboFellowType.setToolTipText(obj.toString());
        }
    }
}

