/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.MDEvaluResultFactory;
import com.kingdee.eas.hr.perf.MDEvaluResultInfo;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.RankCollection;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.client.AbstractMDEvaluResultModifyUI;
import com.kingdee.eas.hr.perf.client.MDEvalDetailModifyUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;

public class MDEvaluResultModifyUI
extends AbstractMDEvaluResultModifyUI {
    private static final long serialVersionUID = -65534L;
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private static final String editTitlte = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"mdEvaluResult");
    private static final String unEditTitlte = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"mdEvaluResultNotEdit");
    private static final String viewTitle = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"mdEvaluResultTitle");
    private boolean onlyView = false;

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("mdObject.id"));
        sic.add(new SelectorItemInfo("mdObject.person.id"));
        sic.add(new SelectorItemInfo("mdObject.position.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.MDSolution.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.AssessPeriod.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.MDSolution.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.MDSolution.GradeMode.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.MDSolution.GradeMode.minGrade"));
        sic.add(new SelectorItemInfo("solutionPeriod.MDSolution.GradeMode.maxGrade"));
        sic.add(new SelectorItemInfo("rank.id"));
        sic.add(new SelectorItemInfo("rank.name"));
        sic.add(new SelectorItemInfo("modifyer.id"));
        sic.add(new SelectorItemInfo("isApproved"));
        sic.add(new SelectorItemInfo("solutionPeriod.MDSolution.RankGroup.id"));
        return sic;
    }

    @Override
    public void setDataObject(IObjectValue dataObject) {
        block8: {
            MDEvaluResultInfo data = (MDEvaluResultInfo)dataObject;
            BigDecimal evaluScore = data.getEvaluScore();
            if (evaluScore != null) {
                data.setEvaluScore(evaluScore.setScale(2, 4));
            }
            super.setDataObject(dataObject);
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)this.editData.getSolutionPeriod().getMDSolution().getRankGroup().getId().toString()));
            viewInfo.setFilter(filter);
            SelectorItemCollection sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("id"));
            SorterItemCollection sorter = viewInfo.getSorter();
            sorter.add(new SorterItemInfo("serial"));
            RankInfo rank = this.editData.getRank();
            try {
                RankCollection coll = RankFactory.getRemoteInstance().getRankCollection(viewInfo);
                this.comboRank.removeAllItems();
                if (coll == null || coll.size() <= 0) break block8;
                this.comboRank.addItems(coll.toArray());
                this.comboRank.setSelectedItem(null);
                if (rank == null) break block8;
                int n = coll.size();
                for (int i = 0; i < n; ++i) {
                    if (!coll.get(i).getId().equals((Object)rank.getId())) continue;
                    this.comboRank.setSelectedIndex(i);
                    break;
                }
            }
            catch (Exception ex) {
                super.handleException(ex);
            }
        }
        if (OprtState.EDIT.equals(this.getOprtState())) {
            this.txtModifiedScore.setEditable(true);
            this.comboRank.setEnabled(true);
            this.txtModifyCause.setEditable(true);
            this.kDContainer1.setTitle(editTitlte);
            this.btnTestPaperInput.setEnabled(true);
        } else {
            this.txtModifiedScore.setEditable(false);
            this.comboRank.setEnabled(false);
            if (!this.onlyView) {
                this.kDContainer1.setTitle(unEditTitlte);
            } else {
                this.kDContainer1.setTitle(viewTitle);
            }
            this.txtModifyCause.setEditable(false);
            this.btnTestPaperInput.setEnabled(false);
        }
        this.pickerModifyDate.setValue((Object)new Date());
        this.prmptModifier.setValue((Object)SysContext.getSysContext().getCurrentUserInfo());
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MDEvaluResultFactory.getRemoteInstance();
    }

    public IObjectPK runSubmit() throws Exception {
        this.editData.setModifyDate(new Date());
        Date date = this.editData.getModifyDate();
        if (date != null) {
            date = DateTimeUtils.truncateDate((Date)date);
            this.editData.setModifyDate(date);
        }
        this.editData.setModifyer(SysContext.getSysContext().getCurrentUserInfo());
        this.editData.setIsModify(true);
        return super.runSubmit();
    }

    @Override
    public void actionTestPaperInput_actionPerformed(ActionEvent e) throws Exception {
        String id = this.editData.getMdObject().getId().toString();
        String suid = this.editData.getSolutionPeriod().getId().toString();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("multiDimObject.id", (Object)id));
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)suid));
        filter.getFilterItems().add(new FilterItemInfo("auditState", (Object)new Integer(80)));
        if (!MultiDimEvaluatorFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"testPaperNotSendEdit"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        uiContext.put((Object)"SUID", (Object)suid);
        boolean isOrg = EvaluSolutionTypeEnum.ORGUNIT.equals(this.getUIContext().get("EvaluSolutionType"));
        uiContext.put((Object)"isOrg", (Object)new Boolean(isOrg));
        uiContext.put((Object)"MDEvaluResultID", (Object)this.editData.getId().toString());
        Boolean isHidePaperAndProcessScore = (Boolean)this.getUIContext().get("IsHidePaperAndProcessScore");
        uiContext.put((Object)"IsHidePaperAndProcessScore", (Object)isHidePaperAndProcessScore);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MDEvalDetailModifyUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        MDEvalDetailModifyUI userUI = (MDEvalDetailModifyUI)uiWindow.getUIObject();
        BigDecimal score = userUI.getModifyScore();
        if (score != null) {
            if (this.txtModifiedScore.getBigDecimalValue() == null) {
                this.txtModifiedScore.setValue((Object)score);
            } else {
                int result;
                BigDecimal mScore = this.txtModifiedScore.getBigDecimalValue();
                if (score.compareTo(mScore) != 0 && (result = MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"unCompatibleDeScore"))) == 0) {
                    this.txtModifiedScore.setValue((Object)score);
                }
            }
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnTestPaperInput.setIcon(EASResource.getIcon((String)"imgTbtn_ruleinitialize"));
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        super.beforeStoreFields(e);
        BigDecimal maxGrade = this.editData.getSolutionPeriod().getMDSolution().getGradeMode().getMaxGrade();
        BigDecimal minGrade = this.editData.getSolutionPeriod().getMDSolution().getGradeMode().getMinGrade();
        BigDecimal grade = this.txtModifiedScore.getBigDecimalValue();
        if (grade != null) {
            if (grade.compareTo(maxGrade) > 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)RES, (String)"tooLarger") + ":" + PFVerifyUtils.formatBigDecimal(maxGrade, 2)));
                SysUtil.abort();
            }
            if (grade.compareTo(minGrade) < 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)RES, (String)"tooLess") + ":" + PFVerifyUtils.formatBigDecimal(minGrade, 2)));
                SysUtil.abort();
            }
        }
    }

    public void onLoad() throws Exception {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.onlyView = true;
        }
        super.onLoad();
        this.txtModifiedScore.setRemoveingZeroInDispaly(false);
        this.txtModifiedScore.setRemoveingZeroInEdit(false);
        this.txtEvaluScore.setRemoveingZeroInDispaly(false);
        this.txtEvaluScore.setRemoveingZeroInEdit(false);
        this.txtEvaluScore.setEditable(false);
        String ownerUIName = this.getUIContext().get("Owner").getClass().getName();
        if ("com.kingdee.eas.hr.perf.client.MDEvaluResultReportUI".equals(ownerUIName) || "com.kingdee.eas.hr.perf.client.MDOrgEvaluResultReportUI".equals(ownerUIName)) {
            this.btnTestPaperInput.setVisible(false);
        }
        this.setComponentsVisible();
    }

    private void setComponentsVisible() {
        boolean isOrg = EvaluSolutionTypeEnum.ORGUNIT.equals(this.getUIContext().get("EvaluSolutionType"));
        this.contPersonNumber.setVisible(!isOrg);
        this.contPersonName.setVisible(!isOrg);
        this.contPosition.setVisible(!isOrg);
        this.contOrgNumber.setVisible(isOrg);
        this.contOrgName.setVisible(isOrg);
        this.contResponser.setVisible(isOrg);
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        if (!this.onlyView && !this.editData.isIsApproved()) {
            this.actionEdit_actionPerformed(null);
            this.setSave(false);
        }
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        if (!this.onlyView && !this.editData.isIsApproved()) {
            this.actionEdit_actionPerformed(null);
            this.setSave(false);
        }
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        if (!this.onlyView && !this.editData.isIsApproved()) {
            this.actionEdit_actionPerformed(null);
            this.setSave(false);
        }
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        if (!this.onlyView && !this.editData.isIsApproved()) {
            this.actionEdit_actionPerformed(null);
            this.setSave(false);
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        if (this.editData.getModifyCause() != null && "".equals(this.editData.getModifyCause().trim())) {
            this.editData.setModifyCause(null);
        }
    }

    @Override
    public void loadFields() {
        super.loadFields();
        BigDecimal evaluScore = this.editData.getEvaluScore();
        if (evaluScore != null) {
            this.editData.setEvaluScore(evaluScore.setScale(2, 4));
        }
    }

    public IObjectPK runSave() throws Exception {
        Date date = this.editData.getModifyDate();
        if (date != null) {
            date = DateTimeUtils.truncateDate((Date)date);
            this.editData.setModifyDate(date);
        }
        return super.runSave();
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

