/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.IMDEvaluResultFacade;
import com.kingdee.eas.hr.perf.MDEvaluResultFacadeFactory;
import com.kingdee.eas.hr.perf.MDEvaluResultFactory;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.client.AbstractMDEvaluResultProcBaseUI;
import com.kingdee.eas.hr.perf.client.KDTableUtil;
import com.kingdee.eas.hr.perf.client.MDEvaluResultModifyUI;
import com.kingdee.eas.hr.perf.client.MDRankConvertStartUI;
import com.kingdee.eas.hr.perf.client.MDSolutionHelper;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.TestPaperScoreViewUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class MDEvaluResultProcBaseUI
extends AbstractMDEvaluResultProcBaseUI {
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private boolean isHidePaperAndProcessScore = false;

    public void onLoad() throws Exception {
        PerfClientUtils.checkValidPerson((CoreUI)this);
        PerfClientUtils.checkValidHRO((CoreUI)this);
        super.onLoad();
        this.setSolutionOPeriodF7Filter();
        this.tblMain.setColumnMoveable(true);
        this.prmptSolutionPeriod.setEditable(false);
        this.setQueryPreference(false);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MDEvaluResultFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return MDEvaluResultModifyUI.class.getName();
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        String id = null;
        Object value = this.prmptSolutionPeriod.getValue();
        id = value != null ? ((MultiDimentionSolutionPeriodInfo)value).getId().toString() : "%noeas%";
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)id, CompareType.EQUALS));
        try {
            filter.getFilterItems().add(PerfUtils.getAdminRangeFilterItemInfo(null, "adminOrgUnit.id"));
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        return filter;
    }

    private void setSolutionOPeriodF7Filter() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("SPStatuEnum", (Object)new Integer(102)));
        viewInfo.setFilter(filter);
        this.prmptSolutionPeriod.setEntityViewInfo(viewInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("MDSolution.id"));
        sic.add(new SelectorItemInfo("MDSolution.name"));
        sic.add(new SelectorItemInfo("MDSolution.gradeMode.id"));
        sic.add(new SelectorItemInfo("MDSolution.gradeMode.name"));
        sic.add(new SelectorItemInfo("MDSolution.gradeMode.maxGrade"));
        sic.add(new SelectorItemInfo("MDSolution.gradeMode.minGrade"));
        sic.add(new SelectorItemInfo("AssessPeriod.id"));
        sic.add(new SelectorItemInfo("AssessPeriod.name"));
        sic.add(new SelectorItemInfo("AssessPeriod.startDate"));
        sic.add(new SelectorItemInfo("AssessPeriod.endDate"));
        this.prmptSolutionPeriod.setSelectorCollection(sic);
    }

    @Override
    protected void prmptSolutionPeriod_dataChanged(DataChangeEvent e) throws Exception {
        MultiDimentionSolutionPeriodInfo info = (MultiDimentionSolutionPeriodInfo)this.prmptSolutionPeriod.getValue();
        if (info != null) {
            this.txtGradeMode.setText(info.getMDSolution().getGradeMode().getName());
            this.txtGradeFrom.setText(PFVerifyUtils.formatBigDecimal(info.getMDSolution().getGradeMode().getMinGrade(), 2));
            this.txtGradeTo.setText(PFVerifyUtils.formatBigDecimal(info.getMDSolution().getGradeMode().getMaxGrade(), 2));
            this.txtSolution.setText(info.getMDSolution().getName());
            this.txtAssessPeriod.setText(info.getAssessPeriod().getName());
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            this.txtStartDate.setText(format.format(info.getAssessPeriod().getStartDate()));
            this.txtEndDate.setText(format.format(info.getAssessPeriod().getEndDate()));
            this.prmptSolutionPeriod.setToolTipText(info.getName());
        } else {
            this.txtGradeFrom.setText(null);
            this.txtGradeTo.setText(null);
            this.txtGradeMode.setText(null);
            this.txtSolution.setText(null);
            this.txtAssessPeriod.setText(null);
            this.txtStartDate.setText(null);
            this.txtEndDate.setText(null);
        }
        this.mainQuery = super.getEntityViewInfo(new EntityViewInfo());
        this.execQuery();
        this.initButton();
    }

    protected void wfInit() {
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selected = KDTableUtil.getSelectedRows(this.tblMain);
        if (selected.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noItemForAudit"));
            return;
        }
        IRow row = null;
        Arrays.sort(selected);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = selected.length - 1; i >= 0; --i) {
            row = this.tblMain.getRow(selected[i]);
            if (((Boolean)row.getCell("isApproved").getValue()).booleanValue()) continue;
            list.add(row.getCell("id").getValue().toString());
        }
        if (list.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noItemSuitebaleForAudit"));
            return;
        }
        String[] idList = new String[list.size()];
        for (int i = 0; i < idList.length; ++i) {
            idList[i] = (String)list.get(i);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)RES, (String)"selectedItems"));
        sb.append(idList.length);
        sb.append(EASResource.getString((String)RES, (String)"auditConfirm"));
        if (MsgBox.showConfirm2((String)sb.toString()) != 0) {
            return;
        }
        IMDEvaluResultFacade facade = MDEvaluResultFacadeFactory.getRemoteInstance();
        facade.auditBill(idList);
        this.execQuery();
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"auditSuccess"));
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        int[] selected = KDTableUtil.getSelectedRows(this.tblMain);
        if (selected.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noItemForAntiAudit"));
            return;
        }
        IRow row = null;
        Arrays.sort(selected);
        ArrayList<String> list = new ArrayList<String>();
        for (int i = selected.length - 1; i >= 0; --i) {
            row = this.tblMain.getRow(selected[i]);
            if (!((Boolean)row.getCell("isApproved").getValue()).booleanValue()) continue;
            list.add(row.getCell("id").getValue().toString());
        }
        if (list.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noItemSuitebaleForAntiAudit"));
            return;
        }
        String[] idList = new String[list.size()];
        for (int i = 0; i < idList.length; ++i) {
            idList[i] = (String)list.get(i);
        }
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)RES, (String)"selectedItems"));
        sb.append(idList.length);
        sb.append(EASResource.getString((String)RES, (String)"antiAuditConfirm"));
        if (MsgBox.showConfirm2((String)sb.toString()) != 0) {
            return;
        }
        IMDEvaluResultFacade facade = MDEvaluResultFacadeFactory.getRemoteInstance();
        facade.antiAuditBill(idList);
        this.execQuery();
        MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"antiAuditSuccess"));
    }

    @Override
    public void actionConvert_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String id = this.getSelectedSolutionPeriodID();
        if (id == null) {
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"sp", (Object)id);
        String[] idList = this.getSelectedIDListForConvert();
        if (idList.length == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noEvaluResultSutiableForConvert"));
            return;
        }
        if (!MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)("" + idList.length + EASResource.getString((String)RES, (String)"confirmConvert"))))) {
            return;
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MDRankConvertStartUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        MDRankConvertStartUI userUI = (MDRankConvertStartUI)uiWindow.getUIObject();
        if (!userUI.isCanceled()) {
            IMDEvaluResultFacade facade = MDEvaluResultFacadeFactory.getRemoteInstance();
            if (userUI.getScoreType() == 0) {
                facade.convertTotalScoreToRank(this.getSelectedIDListForConvert(), userUI.getSelectedRule().getId());
            } else {
                facade.convertModfiedSocreToRank(this.getSelectedIDListForConvert(), userUI.getSelectedRule().getId());
            }
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"convertSuccessful"));
            this.execQuery();
        }
    }

    private String getSelectedSolutionPeriodID() {
        MultiDimentionSolutionPeriodInfo info = (MultiDimentionSolutionPeriodInfo)this.prmptSolutionPeriod.getValue();
        if (info != null) {
            return info.getId().toString();
        }
        return null;
    }

    private String[] getSelectedIDListForConvert() {
        int[] selected = KDTableUtil.getSelectedRows(this.tblMain);
        if (selected.length == 0) {
            return null;
        }
        IRow row = null;
        Arrays.sort(selected);
        ArrayList<String> list = new ArrayList<String>();
        Object obj = null;
        for (int i = selected.length - 1; i >= 0; --i) {
            row = this.tblMain.getRow(selected[i]);
            obj = row.getCell("isApproved").getValue();
            if (obj != null && ((Boolean)obj).booleanValue()) continue;
            list.add(row.getCell("id").getValue().toString());
        }
        String[] idList = new String[list.size()];
        for (int i = 0; i < idList.length; ++i) {
            idList[i] = (String)list.get(i);
        }
        return idList;
    }

    @Override
    public void actionViewPaper_actionPerformed(ActionEvent e) throws Exception {
        this.checkSelected();
        String mdObjectID = this.getSelectedMDObjectID();
        String suid = this.getSelectedSolutionPeriodID();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("multiDimObject.id", (Object)mdObjectID));
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)suid));
        filter.getFilterItems().add(new FilterItemInfo("auditState", (Object)new Integer(80)));
        if (!MultiDimEvaluatorFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"testPaperNotSendView"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"evaluObjectID", (Object)mdObjectID);
        uiContext.put((Object)"solutionPeriodID", (Object)suid);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(TestPaperScoreViewUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getSelectedMDObjectID() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            Object keyValue;
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("mdObject.id");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if ((keyValue = cell.getValue()) != null) {
                return keyValue.toString();
            }
        }
        return null;
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAudit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.btnAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.btnConvert.setIcon(EASResource.getIcon((String)"imgTbtn_gradeconversion"));
        this.btnViewPaper.setIcon(EASResource.getIcon((String)"imgTbtn_hiderule"));
        this.btnResultModify.setIcon(EASResource.getIcon((String)"imgTbtn_emend"));
        this.menuItemAduit.setIcon(EASResource.getIcon((String)"imgTbtn_auditing"));
        this.menuItemAntiAudit.setIcon(EASResource.getIcon((String)"imgTbtn_fauditing"));
        this.menuItemConvert.setIcon(EASResource.getIcon((String)"imgTbtn_gradeconversion"));
        this.menuItemViewPaper.setIcon(EASResource.getIcon((String)"imgTbtn_hiderule"));
        this.menuItemResultModify.setIcon(EASResource.getIcon((String)"imgTbtn_emend"));
    }

    protected boolean getSelectedIsApproved() {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            } else {
                return (Boolean)row.getCell("isApproved").getValue();
            }
        }
        return false;
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getSelectedIsApproved()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"NoEditForAudited"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    protected EvaluSolutionTypeEnum getSolutionType() {
        return null;
    }

    protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
        super.prepareUIContext(uiContext, e);
        uiContext.put((Object)"EvaluSolutionType", (Object)this.getSolutionType());
        uiContext.put((Object)"IsHidePaperAndProcessScore", (Object)this.isHidePaperAndProcessScore);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    protected IQueryExecutor getQueryExecutor(IMetaDataPK queryPK, EntityViewInfo viewInfo) {
        IQueryExecutor exec = super.getQueryExecutor(queryPK, viewInfo);
        exec.option().isAutoIgnoreZero = false;
        return exec;
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        super.handlePermissionForItemAction(action);
    }

    protected void initUserConfig() {
    }

    private void initButton() throws Exception {
        if (this.getSelectedSolutionPeriodID() != null && MDSolutionHelper.getMDSolutionInfoByMDSPID(this.getSelectedSolutionPeriodID()) != null) {
            this.isHidePaperAndProcessScore = MDSolutionHelper.getMDSolutionInfoByMDSPID(this.getSelectedSolutionPeriodID()).isHidePaperAndProcessScore();
        }
        if (this.isHidePaperAndProcessScore) {
            this.btnViewPaper.setEnabled(false);
        } else {
            this.btnViewPaper.setEnabled(true);
        }
    }
}

