/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.client.PositionPromptBox2;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.IMultiDimentionObject;
import com.kingdee.eas.hr.perf.MultiDimentionObjectFactory;
import com.kingdee.eas.hr.perf.client.AbstractMDObjectListUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionF7Helper;
import com.kingdee.eas.hr.perf.client.IMDObjectListUI;
import com.kingdee.eas.hr.perf.client.IMultiDimentionSolutionUI;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.perf.client.MDSolutionHelper;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.ProgDialog;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MDObjectListUI
extends AbstractMDObjectListUI
implements IMultiDimentionSolutionUI,
IMDObjectListUI {
    private static final Logger logger = CoreUIObject.getLogger(MDObjectListUI.class);
    private String resourcePath = "com.kingdee.eas.hr.perf.client.MultiDimentionSolutionResource";
    private String evaluSolutionId;
    private IObjectPK[] pk;
    private KDToolBar parentToolBar;

    public void onLoad() throws Exception {
        this.parentToolBar = (KDToolBar)this.getUIContext().get("ToolBar");
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(10);
        this.evaluSolutionId = (String)this.getUIContext().get("ID");
        super.onLoad();
        this.setUIStatusByView();
        this.refreshList();
    }

    private void setUIStatusByView() {
        if (OprtState.VIEW.equals(this.getOprtState())) {
            MDSolutionHelper.setEnabled((Container)this.parentToolBar, new String[]{"btnAddEvaluObject_EvaluObject", "btnAddEvaluObjectByPosition_EvaluObject", "btnDelEvaluObject_EvaluObject"}, false, false);
        }
        String[] workButtons = new String[]{"btnLocate_EvaluObject"};
        MDSolutionHelper.setEnabled((Container)this.parentToolBar, workButtons, false, true);
    }

    public void initUIStatus(boolean isExistSolutionPeriodStarted) {
        this.setUIStatusByView();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            super.tblMain_tableClicked(e);
        }
    }

    @Override
    public void addEvaluObject() throws Exception {
        EmployeeMultiF7PromptBox pmt = (EmployeeMultiF7PromptBox)EvaluSolutionF7Helper.getEmployeeF7((IUIObject)this);
        pmt.show();
        if (!pmt.isCanceled() && pmt.getData() instanceof Object[]) {
            final Object[] obj = (Object[])pmt.getData();
            if (obj.length > 80) {
                IProgTask prog = new IProgTask(){

                    @Override
                    public Object exec() throws Exception {
                        MDObjectListUI.this.dealAddEvaluObject(obj);
                        return "";
                    }

                    @Override
                    public void afterExec(Object result) throws Exception {
                    }
                };
                ProgDialog dialog = null;
                Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
                if (win instanceof Frame) {
                    dialog = new ProgDialog((Frame)win);
                } else if (win instanceof Dialog) {
                    dialog = new ProgDialog((Dialog)win);
                }
                dialog.setLongTimeTask(prog);
                dialog.show();
            } else {
                this.dealAddEvaluObject(obj);
            }
        }
    }

    public void addEvaluObjectByPosition() throws Exception {
        PositionPromptBox2 pmt = (PositionPromptBox2)EvaluSolutionF7Helper.getPositionF7((IUIObject)this);
        pmt.show();
        if (!pmt.isCanceled() && pmt.getData() instanceof Object[]) {
            final Object[] obj = (Object[])pmt.getData();
            if (obj.length > 80) {
                IProgTask prog = new IProgTask(){

                    @Override
                    public Object exec() throws Exception {
                        MDObjectListUI.this.dealAddEvaluObjectByPosition(obj);
                        return "";
                    }

                    @Override
                    public void afterExec(Object result) throws Exception {
                    }
                };
                ProgDialog dialog = null;
                Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
                if (win instanceof Frame) {
                    dialog = new ProgDialog((Frame)win);
                } else if (win instanceof Dialog) {
                    dialog = new ProgDialog((Dialog)win);
                }
                dialog.setLongTimeTask(prog);
                dialog.show();
            } else {
                this.dealAddEvaluObjectByPosition(obj);
            }
        }
    }

    private void dealAddEvaluObjectByPosition(Object[] obj) throws Exception {
        HashSet<String> positionIdSet = new HashSet<String>();
        PositionInfo positionInfo = null;
        for (int i = 0; i < obj.length; ++i) {
            positionInfo = (PositionInfo)obj[i];
            positionIdSet.add(positionInfo.getId().toString());
        }
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("position", positionIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        PositionMemberCollection pmColl = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(viewInfo);
        if (pmColl != null && pmColl.size() > 0) {
            HashSet<String> idSet = new HashSet<String>();
            int n = pmColl.size();
            for (int i = 0; i < n; ++i) {
                idSet.add(pmColl.get(i).getPerson().getId().toString());
            }
            if (idSet.size() != 0) {
                MultiDimentionObjectFactory.getRemoteInstance().addEvaluObjectBatch(this.evaluSolutionId, idSet);
                this.refreshList();
            }
        }
    }

    private void dealAddEvaluObject(Object[] obj) throws Exception {
        HashSet<String> idSet = new HashSet<String>();
        PersonInfo personInfo = null;
        for (int i = 0; i < obj.length; ++i) {
            personInfo = (PersonInfo)obj[i];
            if (personInfo == null) continue;
            idSet.add(personInfo.getId().toString());
        }
        if (idSet.size() != 0) {
            MultiDimentionObjectFactory.getRemoteInstance().addEvaluObjectBatch(this.evaluSolutionId, idSet);
            this.refreshList();
        }
    }

    @Override
    public void delEvaluObject() throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        if (this.confirmRemove()) {
            List rowIndexList = PFUtils.getSelectedRows(this.tblMain);
            Arrays.sort(rowIndexList.toArray());
            IRow row = null;
            final HashSet<String> idSet = new HashSet<String>();
            final ArrayList<Integer> delRowIndex = new ArrayList<Integer>();
            for (int i = rowIndexList.size() - 1; i >= 0; --i) {
                int rowIndex = (Integer)rowIndexList.get(i);
                row = this.tblMain.getRow(rowIndex);
                String id = (String)row.getCell("id").getValue();
                if (id == null) continue;
                delRowIndex.add(new Integer(rowIndex));
                idSet.add(id);
            }
            if (idSet.size() != 0) {
                final IMultiDimentionObject evaluObject = MultiDimentionObjectFactory.getRemoteInstance();
                final StringBuffer names = new StringBuffer();
                if (idSet.size() > 20) {
                    IProgTask prog = new IProgTask(){

                        @Override
                        public Object exec() throws Exception {
                            MDObjectListUI.access$202(MDObjectListUI.this, evaluObject.deleteEvaluObjectBatch(idSet));
                            names.append(MDObjectListUI.this.getReferedObjectNames(MDObjectListUI.this.pk));
                            MDObjectListUI.this.removeRowsFromTable(delRowIndex, MDObjectListUI.this.pk);
                            return "";
                        }

                        @Override
                        public void afterExec(Object result) throws Exception {
                        }
                    };
                    ProgDialog dialog = null;
                    Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
                    if (win instanceof Frame) {
                        dialog = new ProgDialog((Frame)win);
                    } else if (win instanceof Dialog) {
                        dialog = new ProgDialog((Dialog)win);
                    }
                    dialog.setLongTimeTask(prog);
                    dialog.show();
                } else {
                    this.pk = evaluObject.deleteEvaluObjectBatch(idSet);
                    names.append(this.getReferedObjectNames(this.pk));
                    this.removeRowsFromTable(delRowIndex, this.pk);
                }
                if (names == null || names.length() == 0) {
                    return;
                }
                String msg = EASResource.getString((String)this.resourcePath, (String)"CanNotDelEvaluObject");
                msg = msg.replaceAll("#", names.substring(0, names.length() - 1));
                MsgBox.showInfo((Component)((Object)this), (String)msg);
            }
        }
    }

    private void removeRowsFromTable(List delRowIndex, IObjectPK[] cannotDelPK) {
        IRow row = null;
        for (int i = 0; i < delRowIndex.size(); ++i) {
            int rowIndex = (Integer)delRowIndex.get(i);
            row = this.tblMain.getRow(rowIndex);
            String id = (String)row.getCell("id").getValue();
            if (id == null) {
                this.tblMain.removeRow(rowIndex);
                continue;
            }
            boolean isRefered = false;
            if (cannotDelPK != null) {
                for (int j = 0; j < cannotDelPK.length; ++j) {
                    if (!id.equals(cannotDelPK[j].toString())) continue;
                    isRefered = true;
                }
            }
            if (isRefered) continue;
            this.tblMain.removeRow(rowIndex);
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")));
    }

    private String getReferedObjectNames(IObjectPK[] referedPK) {
        if (referedPK == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int size = referedPK.length;
        block0: for (int i = 0; i < size; ++i) {
            String canDelId = referedPK[i].toString();
            int count = this.tblMain.getRowCount();
            for (int j = 0; j < count; ++j) {
                IRow row = this.tblMain.getRow(j);
                String id = (String)row.getCell("id").getValue();
                if (!id.equals(canDelId)) continue;
                sb.append(row.getCell("person.name").getValue());
                sb.append(",");
                continue block0;
            }
        }
        return sb.toString();
    }

    public void refreshList() throws Exception {
        this.mainQuery = this.getEntityViewInfo();
        super.refreshList();
    }

    protected final EntityViewInfo getEntityViewInfo() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)this.evaluSolutionId));
        filterInfo.getFilterItems().add(new FilterItemInfo("deleted", (Object)Boolean.FALSE));
        viewInfo.setFilter(filterInfo);
        return viewInfo;
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    @Override
    public void secondLoad() throws Exception {
    }

    @Override
    public void submit() throws Exception {
    }

    @Override
    public void verifyInput() throws Exception {
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"person.number", "person.name", "position.name", "adminOrgUnit.name"};
        return locateNames;
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("evaluSolutionId", this.getUIContext().get("ID"));
        handler.setRequestContext((Serializable)request);
        return handler;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    static /* synthetic */ IObjectPK[] access$202(MDObjectListUI x0, IObjectPK[] x1) {
        x0.pk = x1;
        return x1;
    }
}

