/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.hr.perf.AuditStateEnum;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.MDEvaluResultCollection;
import com.kingdee.eas.hr.perf.MDEvaluResultFactory;
import com.kingdee.eas.hr.perf.MDEvaluResultInfo;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorCollection;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.WFStatuEnum;
import com.kingdee.eas.hr.perf.client.AbstractMDPersonFormUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;

public class MDPersonFormUI
extends AbstractMDPersonFormUI {
    private static final long serialVersionUID = -61166L;
    private String personID = null;
    private static final String MACHINE = "0";
    private static final String USER = "1";
    private static final String sumTitle = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"sum");

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.personID = (String)this.getUIContext().get("personID");
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("solutionPeriod.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.name"));
        sic.add(new SelectorItemInfo("solutionPeriod.MDSolution.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.MDSolution.hidePaperWeight"));
        sic.add(new SelectorItemInfo("solutionPeriod.MDSolution.GradeMode.id"));
        sic.add(new SelectorItemInfo("solutionPeriod.MDSolution.GradeMode.maxGrade"));
        sic.add(new SelectorItemInfo("solutionPeriod.MDSolution.GradeMode.minGrade"));
        sic.add(new SelectorItemInfo("solutionPeriod.MDSolution.GradeMode.name"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mdObject.person.id", (Object)this.personID));
        viewInfo.setFilter(filter);
        MDEvaluResultCollection coll = MDEvaluResultFactory.getRemoteInstance().getMDEvaluResultCollection(viewInfo);
        if (coll == null || coll.size() == 0) {
            return;
        }
        this.comboSolutionPeriod.setActionCommand(MACHINE);
        this.comboSolutionPeriod.addItem((Object)"");
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            this.comboSolutionPeriod.addItem((Object)coll.get(i).getSolutionPeriod());
        }
        this.comboSolutionPeriod.setSelectedIndex(0);
        this.comboSolutionPeriod.setActionCommand(USER);
    }

    private void clearTable() {
        this.tblMain.removeRows();
        int cols = this.tblMain.getColumnCount();
        if (cols > 3) {
            for (int i = cols - 1; i > 2; --i) {
                this.tblMain.removeColumn(i);
            }
        }
    }

    private void fillTable() throws Exception {
        MultiDimentionSolutionPeriodInfo info = (MultiDimentionSolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        if (info == null) {
            return;
        }
        GradeModeInfo gradeMode = info.getMDSolution().getGradeMode();
        this.txtGradeMode.setText(gradeMode.getName());
        this.comboSolutionPeriod.setToolTipText(info.getName());
        this.clearTable();
        String pack = "com.kingdee.eas.hr.perf.app";
        String query = "GetRelationInfoQuery";
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)info.getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("Person.id", (Object)this.personID));
        viewInfo.setFilter(filter);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(pack, query));
        exec.setObjectView(viewInfo);
        IRowSet rowSet = exec.executeQuery();
        IColumn column = null;
        String key = null;
        String name = null;
        BigDecimal weight = null;
        StringBuffer sb = null;
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        boolean hideWeight = info.getMDSolution().isHidePaperWeight();
        while (rowSet.next()) {
            column = this.tblMain.addColumn();
            key = rowSet.getString("id");
            name = rowSet.getString("name");
            weight = rowSet.getBigDecimal("evalRelation.weight");
            column.setKey(key);
            column.getStyleAttributes().setNumberFormat("0.00");
            column.getStyleAttributes().setLocked(true);
            sb = new StringBuffer();
            sb.append(name);
            if (!hideWeight) {
                sb.append("(");
                sb.append(decimalFormat.format(weight));
                sb.append("%)");
            }
            this.tblMain.getHeadRow(0).getCell(key).setValue((Object)sb.toString());
            this.tblMain.getHeadRow(0).getCell(key).setUserObject((Object)weight);
        }
        column = this.tblMain.addColumn();
        column.getStyleAttributes().setNumberFormat("0.00");
        column.setKey("sum");
        column.getStyleAttributes().setLocked(true);
        this.tblMain.getHeadRow(0).getCell("sum").setValue((Object)sumTitle);
        query = "MDEvalDetailQuery";
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.personID));
        exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK(pack, query));
        exec.setObjectView(viewInfo);
        rowSet = exec.executeQuery();
        IRow row = null;
        String evalID = null;
        HashMap<String, IRow> map = new HashMap<String, IRow>();
        String rel = null;
        Integer obj = null;
        ICell cell = null;
        BigDecimal score = null;
        BigDecimal zero = new BigDecimal("0.000000");
        BigDecimal maxGrade = null;
        BigDecimal minGrade = null;
        BigDecimal temp = null;
        while (rowSet.next()) {
            maxGrade = rowSet.getBigDecimal("gradeMode.maxGrade");
            minGrade = rowSet.getBigDecimal("gradeMode.minGrade");
            evalID = rowSet.getString("mdEval.id");
            row = (IRow)map.get(evalID);
            if (row == null) {
                row = this.tblMain.addRow();
                row.getCell("evalID").setValue((Object)evalID);
                row.getCell("testPaper").setValue((Object)rowSet.getString("testPaper.name"));
                row.getCell("evalItem").setValue((Object)rowSet.getString("mdEval.evaluation"));
                map.put(evalID, row);
            }
            obj = (obj = (Integer)(cell = row.getCell(rel = rowSet.getString("evalReDetail.id"))).getUserObject()) == null ? new Integer(1) : new Integer(obj + 1);
            cell.setUserObject((Object)obj);
            score = (BigDecimal)cell.getValue();
            temp = rowSet.getBigDecimal("score");
            if (temp == null) continue;
            temp = zero.add(temp);
            temp = temp.subtract(minGrade).divide(maxGrade.subtract(minGrade), 4).multiply(gradeMode.getMaxGrade().subtract(gradeMode.getMinGrade()));
            temp = temp.add(gradeMode.getMinGrade());
            if (score == null) {
                score = temp;
            } else {
                score = zero.add(score.multiply(new BigDecimal(String.valueOf(obj - 1))).add(temp));
                score = score.divide(new BigDecimal(String.valueOf(obj)), 4);
            }
            cell.setValue((Object)score);
        }
        BigDecimal sum = null;
        BigDecimal percent = new BigDecimal("0.01");
        int n = this.tblMain.getRowCount();
        for (int i = 0; i < n; ++i) {
            row = this.tblMain.getRow(i);
            sum = new BigDecimal("0.00000");
            int s = this.tblMain.getColumnIndex("sum");
            for (int j = this.tblMain.getColumnIndex("evalItem") + 1; j < s; ++j) {
                score = (BigDecimal)this.tblMain.getRow(i).getCell(j).getValue();
                if (score == null) continue;
                weight = (BigDecimal)this.tblMain.getHeadRow(0).getCell(j).getUserObject();
                sum = sum.add(score.multiply(weight).multiply(percent));
            }
            row.getCell("sum").setValue((Object)sum);
        }
        this.tblMain.getGroupManager().group();
    }

    @Override
    protected void comboSolutionPeriod_actionPerformed(ActionEvent e) throws Exception {
        if (MACHINE.equals(e.getActionCommand())) {
            return;
        }
        Object obj = this.comboSolutionPeriod.getSelectedItem();
        if (obj == null || "".equals(obj)) {
            this.clearTable();
            return;
        }
        MultiDimentionSolutionPeriodInfo info = (MultiDimentionSolutionPeriodInfo)obj;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("multiDimObject.person.id", (Object)this.personID));
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)info.getId().toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("*"));
        MultiDimEvaluatorCollection mdeColl = MultiDimEvaluatorFactory.getRemoteInstance().getMultiDimEvaluatorCollection(viewInfo);
        if (!AuditStateEnum.ALREADY_SEND.equals((Object)mdeColl.get(0).getAuditState())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"testPaperNotSendView"));
            this.clearTable();
            return;
        }
        if (!WFStatuEnum.CLOSED.equals((Object)mdeColl.get(0).getWfStatus())) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"mdEvaluaotrWfNotClosed"));
            this.clearTable();
            return;
        }
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("mdObject.person.id", (Object)this.personID));
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)info.getId().toString()));
        viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaluScore"));
        sic.add(new SelectorItemInfo("modifiedScore"));
        sic.add(new SelectorItemInfo("rank.id"));
        sic.add(new SelectorItemInfo("rank.name"));
        MDEvaluResultCollection coll = MDEvaluResultFactory.getRemoteInstance().getMDEvaluResultCollection(viewInfo);
        MDEvaluResultInfo result = null;
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        if (coll != null && coll.size() > 0) {
            result = coll.get(0);
            if (result.getModifiedScore() != null) {
                this.txtModifiedScore.setText(decimalFormat.format(result.getModifiedScore()));
            } else {
                this.txtModifiedScore.setText(null);
            }
            if (result.getEvaluScore() != null) {
                this.txtScore.setText(decimalFormat.format(result.getEvaluScore()));
            } else {
                this.txtScore.setText(null);
            }
        }
        this.fillTable();
        if (this.tblMain.getRowCount() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"noEvaluItemResult"));
        }
    }
}

