/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDToolBar;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.org.PositionMemberInfo;
import com.kingdee.eas.basedata.org.client.f7.NewAdminByHROF7;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.AssessPeriodCollection;
import com.kingdee.eas.hr.perf.AssessPeriodFactory;
import com.kingdee.eas.hr.perf.EvaluGroupObjectFactory;
import com.kingdee.eas.hr.perf.EvaluGroupTargetCollection;
import com.kingdee.eas.hr.perf.EvaluGroupTargetFactory;
import com.kingdee.eas.hr.perf.EvaluGroupTargetInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.EvaluTargetCollection;
import com.kingdee.eas.hr.perf.GradeModeCollection;
import com.kingdee.eas.hr.perf.GradeModeFactory;
import com.kingdee.eas.hr.perf.IAssessPeriod;
import com.kingdee.eas.hr.perf.IEvaluGroupObject;
import com.kingdee.eas.hr.perf.IEvaluGroupTarget;
import com.kingdee.eas.hr.perf.IGradeMode;
import com.kingdee.eas.hr.perf.IMultiDimentionSolution;
import com.kingdee.eas.hr.perf.IMultiDimentionSolutionPeriod;
import com.kingdee.eas.hr.perf.IRankGroup;
import com.kingdee.eas.hr.perf.MDEvaluResultFactory;
import com.kingdee.eas.hr.perf.MultiDimentionObjectFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodCollection;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.RankGroupCollection;
import com.kingdee.eas.hr.perf.RankGroupFactory;
import com.kingdee.eas.hr.perf.RankGroupInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.client.MDBaseInfoUI;
import com.kingdee.eas.hr.perf.client.MDEvaluGroupListUI;
import com.kingdee.eas.hr.perf.client.MDEvaluModeUI;
import com.kingdee.eas.hr.perf.client.MDObjectListUI;
import com.kingdee.eas.hr.perf.client.MDObjectOrgListUI;
import com.kingdee.eas.hr.perf.client.MDSolutionPeriodListUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.STConverter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class MDSolutionHelper {
    public static final Logger logger = Logger.getLogger(MDSolutionHelper.class);
    public static final int BASEINFO_PANEL_INDEX = 0;
    public static final int TARGET_EVALU_MODE_PANEL_INDEX = 1;
    public static final int PERFORM_TARGET_PANEL_INDEX = 5;
    public static final int TARGETTYPE_PANEL_INDEX = 0;
    public static final int TARGET_PANEL_INDEX = 1;
    public static final String PERFORM_TARGET_PANEL_NAME = "pnlPerformanceTarget";
    public static final Color KDTABLE_TOTAL_BG_COLOR = new Color(0xF6F6B6);
    public static final Color UNENABLE_COLOR = new Color(217, 217, 214);
    public static final Color ENABLE_COLOR = new Color(0xFFFFFF);
    public static final Color KDTABLE_SUBTOTAL_BG_COLOR = new Color(16119270);
    public static final Color PARENT_TYPE_COLOR = new Color(16119270);
    public static final int WEIGHT_PRECISION = 2;
    public static final int SCORE_PRECISION = 2;
    public static final String TABINDEX = "TABINDEX";
    public static final int KDTABINDEX_BASEINFO = 0;
    public static final int KDTABINDEX_EVALUMODE = 1;
    public static final int KDTABINDEX_EVALUOBJECT = 2;
    public static final int KDTABINDEX_ASSESSPERIOD = 3;
    public static final int KDTABINDEX_PERFORMANCETARGET = 4;
    public static final int DEFAULT_UIOBJ_WIDTH = 730;
    public static final int DEFAULT_UIOBJ_HEIGHT = 450;
    public static final String ESID = "EvaluSolutionID";
    public static final String SPID = "SolutionPeriodID";
    public static final String EGID = "EvaluGroupID";
    public static final String TOOLBAR = "ToolBar";
    public static final String GROUPTOOLBAR = "GroupToolBar";
    public static final String TBPMAIN = "TBPMain";
    public static final String TYPE = "EvaluSolutionType";
    public static final String ISOBJECTMODIFIED = "IsObjectModified";
    public static final String ISEVALUMODEMODIFIED = "IsEvaluModeModified";
    public static final String WEIGHT = "Weight";
    public static final String SECONDLOAD = "SecondLoad";
    public static final String TYPE_UI = "TypeUI";
    public static final String RGID = "RankGroupID";
    public static final String CURRENT_INDEX = "CurrentIndex";
    public static final String TBPMAINGROUP = "TBPMainGroup";
    public static final String TOTAL = "Total";
    public static final String MAIN_FRAME = "MainFrame";
    public static final int PANEL_COUNT = 6;
    public static final String SPECIAL_ID = "--------------------------------------------";
    public static final String APPOINTPERSON = "appointPerson";
    public static final String GROUPOBJECT = "groupObject";
    public static final String UISELECTOBJECT = "selectedObject";
    public static final String MDSID = "mdSolutionID";
    public static final String MDGID = "mdEvaluGroupID";

    public static String getUIClassName(int tabIndex, EvaluSolutionTypeEnum type) {
        switch (tabIndex) {
            case 0: {
                return MDBaseInfoUI.class.getName();
            }
            case 1: {
                return MDEvaluModeUI.class.getName();
            }
            case 2: {
                if (EvaluSolutionTypeEnum.PERSON.equals((Object)type)) {
                    return MDObjectListUI.class.getName();
                }
                return MDObjectOrgListUI.class.getName();
            }
            case 3: {
                return MDSolutionPeriodListUI.class.getName();
            }
            case 4: {
                return MDEvaluGroupListUI.class.getName();
            }
        }
        return null;
    }

    public static PositionInfo getPositionInfo(IPositionMember positionMember, String id) throws Exception {
        CoreBaseCollection coll;
        if (id == null) {
            return null;
        }
        PositionInfo positionInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)id));
        fi.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)new Integer(1)));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("position.name"));
        if (positionMember == null) {
            positionMember = MDSolutionHelper.getPositionMember();
        }
        if ((coll = positionMember.getCollection(evi)).size() != 0) {
            positionInfo = ((PositionMemberInfo)coll.get(0)).getPosition();
        }
        return positionInfo;
    }

    public static HashMap getPrimaryPositionMap(HashSet personSet) throws Exception {
        HashMap<String, String> personPositionMap = new HashMap<String, String>();
        if (personSet == null) {
            return personPositionMap;
        }
        Iterator iterator = personSet.iterator();
        while (iterator.hasNext()) {
            personPositionMap.put(iterator.next().toString(), null);
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("person.id", (Object)personSet, CompareType.INCLUDE));
        fi.getFilterItems().add(new FilterItemInfo("isPrimary", (Object)new Integer(1)));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("position.id"));
        evi.getSelector().add(new SelectorItemInfo("person.id"));
        PositionMemberCollection coll = PositionMemberFactory.getRemoteInstance().getPositionMemberCollection(evi);
        if (coll.size() != 0) {
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                personPositionMap.put(coll.get(i).getPerson().getId().toString(), coll.get(i).getPosition().getId().toString());
            }
        }
        return personPositionMap;
    }

    private static IPositionMember getPositionMember() throws BOSException {
        return PositionMemberFactory.getRemoteInstance();
    }

    private static IPerson getPerson() throws BOSException {
        return PersonFactory.getRemoteInstance();
    }

    public static PersonInfo getPersonInfo(String personId) throws Exception {
        return MDSolutionHelper.getPersonInfo(null, personId);
    }

    public static PersonInfo getPersonInfo(IPerson person, String personId) throws Exception {
        if (personId == null) {
            return null;
        }
        if (person == null) {
            person = MDSolutionHelper.getPerson();
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        return person.getPersonInfo((IObjectPK)new ObjectUuidPK(personId), sic);
    }

    public static void initComboGrade(KDComboBox comboGrade) throws Exception {
        IGradeMode gradeMode = MDSolutionHelper.getGradeMode();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(MDSolutionHelper.getDefaultFilterForQuery());
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        evi.getSelector().add(new SelectorItemInfo("isDefault"));
        GradeModeCollection gradeModeCollection = gradeMode.getGradeModeCollection(evi);
        comboGrade.removeAllItems();
        comboGrade.addItems(gradeModeCollection.toArray());
    }

    private static IGradeMode getGradeMode() throws BOSException {
        return GradeModeFactory.getRemoteInstance();
    }

    public static void initComboRank(KDComboBox comboRank) throws Exception {
        IRankGroup rankGroup = MDSolutionHelper.getRankGroup();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(MDSolutionHelper.getDefaultFilterForQuery());
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        RankGroupCollection rankGroupCollection = rankGroup.getRankGroupCollection(evi);
        comboRank.removeAllItems();
        comboRank.addItems(rankGroupCollection.toArray());
    }

    private static IRankGroup getRankGroup() throws BOSException {
        return RankGroupFactory.getRemoteInstance();
    }

    public static void initComboRank(KDComboBox comboRank, String gradeId) throws Exception {
        if (gradeId == null) {
            return;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("gradeMode.id", (Object)gradeId));
        IRowSet rowSet = MDSolutionHelper.getRowSet("RankGroupHasRankQuery", fi);
        RankGroupCollection rankGroupCollection = new RankGroupCollection();
        while (rowSet.next()) {
            RankGroupInfo groupInfo = new RankGroupInfo();
            groupInfo.setId(BOSUuid.read((String)rowSet.getString("id")));
            groupInfo.setName(rowSet.getString("name"));
            groupInfo.setNumber(rowSet.getString("number"));
            rankGroupCollection.add(groupInfo);
        }
        comboRank.removeAllItems();
        comboRank.addItems(rankGroupCollection.toArray());
    }

    public static void initOrgUnit(IUIObject owner, KDBizPromptBox prmtOrgUnit) throws Exception {
        MDSolutionHelper.initOrgUnit(owner, prmtOrgUnit, false);
    }

    public static void initOrgUnit(IUIObject owner, KDBizPromptBox prmtOrgUnit, boolean isMultiSelected) throws Exception {
        NewAdminByHROF7 adminF7 = new NewAdminByHROF7();
        adminF7.setMultiSelect(isMultiSelected);
        prmtOrgUnit.setSelector((KDPromptSelector)adminF7);
        prmtOrgUnit.setEditFormat("$number$");
        prmtOrgUnit.setDisplayFormat("$name$");
        prmtOrgUnit.setEditable(false);
    }

    public static void initPerson(KDBizPromptBox prmtPerson, boolean isMultiSelected, IUIObject owner) throws Exception {
        EmployeeMultiF7PromptBox personF7 = new EmployeeMultiF7PromptBox(owner);
        personF7.setIsSingleSelect(!isMultiSelected);
        prmtPerson.setSelector((KDPromptSelector)personF7);
        prmtPerson.setEnabledMultiSelection(true);
    }

    public static void initAssessPeriod(KDComboBox comboAssessPeriod) throws Exception {
        IAssessPeriod assessPeriod = MDSolutionHelper.getAssessPeriod();
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(MDSolutionHelper.getDefaultFilterForQuery());
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        AssessPeriodCollection coll = assessPeriod.getAssessPeriodCollection(evi);
        comboAssessPeriod.removeAllItems();
        comboAssessPeriod.addItems(coll.toArray());
    }

    private static IAssessPeriod getAssessPeriod() throws BOSException {
        return AssessPeriodFactory.getRemoteInstance();
    }

    public static FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        HROrgUnitInfo info = SysContext.getSysContext().getCurrentHRUnit();
        if (info == null) {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)"%noeas%"));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)info.getId().toString()));
        }
        return filter;
    }

    public static FilterInfo getCurrentHROrgUnitFilter() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentHRUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    public static FilterInfo getHROrgUnitAndOrgRangeFilter(String hrOrgUnit, String adminOrgUnit) throws Exception {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(adminOrgUnit, (Object)sql.toString(), CompareType.INNER);
        filter.getFilterItems().add(item);
        item = new FilterItemInfo(hrOrgUnit, (Object)hrOrgUnitID);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static HROrgUnitInfo getCurrentHROrgUnit() {
        HROrgUnitInfo info = SysContext.getSysContext().getCurrentHRUnit();
        return info;
    }

    private static IMultiDimentionSolutionPeriod getSolutionPeriod() throws BOSException {
        return MultiDimentionSolutionPeriodFactory.getRemoteInstance();
    }

    public static MultiDimentionSolutionInfo getMultiDimentionInfo(String evaluSolutionId) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("canViewEvalor"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("operateDescript"));
        sic.add(new SelectorItemInfo("canViewSelfForm"));
        sic.add(new SelectorItemInfo("hidePaperWeight"));
        sic.add(new SelectorItemInfo("SolutionStatuEn"));
        sic.add(new SelectorItemInfo("MultiDimntModeE"));
        sic.add(new SelectorItemInfo("EvaluModeEnum"));
        sic.add(new SelectorItemInfo("RankGroup.id"));
        sic.add(new SelectorItemInfo("RankGroup.name"));
        sic.add(new SelectorItemInfo("GradeMode.id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("solutionType"));
        sic.add(new SelectorItemInfo("viewQuestionAvgScore"));
        sic.add(new SelectorItemInfo("canComment"));
        sic.add(new SelectorItemInfo("hidePaperAndProcessScore"));
        sic.add(new SelectorItemInfo("MDOptionalEnum"));
        return MDSolutionHelper.getMultiDimentioinSolutionInfo(evaluSolutionId, sic);
    }

    public static MultiDimentionSolutionInfo getMultiDimentioinSolutionInfo(String evaluSolutionId, SelectorItemCollection sic) {
        MultiDimentionSolutionInfo evaluSolutionInfo = null;
        try {
            evaluSolutionInfo = MultiDimentionSolutionFactory.getRemoteInstance().getMultiDimentionSolutionInfo((IObjectPK)new ObjectUuidPK(evaluSolutionId), sic);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return evaluSolutionInfo;
    }

    private static IMultiDimentionSolution getEvaluSolution() throws BOSException {
        return MultiDimentionSolutionFactory.getRemoteInstance();
    }

    public static void setEnabled(Container container, String[] componentNames, boolean expected, boolean isEnabled) {
        int size = -1;
        boolean flag = false;
        if (container instanceof KDToolBar) {
            size = ((KDToolBar)container).getToolBarComponentCount();
            flag = true;
        } else {
            size = container.getComponentCount();
        }
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; componentNames != null && i < componentNames.length; ++i) {
            set.add(componentNames[i]);
        }
        Component c = null;
        for (int i = 1; i < size; ++i) {
            KDWorkButton workButton;
            c = flag ? ((KDToolBar)container).getToolBarComponentAt(i) : container.getComponent(i);
            if (c == null) continue;
            if (expected) {
                if (!set.contains(c.getName())) {
                    if (c instanceof KDWorkButton) {
                        workButton = (KDWorkButton)c;
                        if (workButton.getAction() != null) {
                            workButton.getAction().setEnabled(isEnabled);
                        } else {
                            workButton.setEnabled(isEnabled);
                        }
                    } else {
                        c.setEnabled(isEnabled);
                    }
                }
            } else if (set.contains(c.getName())) {
                if (c instanceof KDWorkButton) {
                    workButton = (KDWorkButton)c;
                    workButton.getAction().setEnabled(isEnabled);
                } else {
                    c.setEnabled(isEnabled);
                }
            }
            if (!(c instanceof KDWorkButton) || c.getName() != null) continue;
            c.setEnabled(true);
        }
    }

    public static void setEnabled(Container container, boolean isEnabled) {
        MDSolutionHelper.setEnabled(container, null, true, isEnabled);
    }

    public static void initSolutionPeriod(KDComboBox comboSolutionPeriod, String evaluSolutionId, SolutionPeriodStatusEnum status, boolean isUsingHROrgUnitAndOrgRangeFilter) throws Exception {
        IMultiDimentionSolutionPeriod solutionPeriod = MDSolutionHelper.getSolutionPeriod();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        if (evaluSolutionId != null) {
            fi.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)evaluSolutionId));
        } else if (isUsingHROrgUnitAndOrgRangeFilter) {
            fi.mergeFilter(MDSolutionHelper.getHROrgUnitAndOrgRangeFilter("MDSolution.hrOrgUnit.id", "MDSolution.orgUnit.id"), "AND");
        }
        if (status != null) {
            fi.getFilterItems().add(new FilterItemInfo("SPStatuEnum", (Object)new Integer(status.getValue())));
        }
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("id"));
        evi.getSelector().add(new SelectorItemInfo("name"));
        SorterItemInfo sorterItemInfo = new SorterItemInfo("createTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorterItemInfo);
        MultiDimentionSolutionPeriodCollection solutionPeriodCollction = solutionPeriod.getMultiDimentionSolutionPeriodCollection(evi);
        comboSolutionPeriod.removeAllItems();
        String name = null;
        Locale locale = PFUtils.getLocale();
        int size = solutionPeriodCollction.size();
        for (int i = 0; i < size; ++i) {
            name = solutionPeriodCollction.get(i).getName(PFUtils.getSLocale());
            if (locale.equals(PFUtils.getSLocale())) {
                solutionPeriodCollction.get(i).setName(name);
                continue;
            }
            if (!locale.equals(PFUtils.getTLocale())) continue;
            solutionPeriodCollction.get(i).setName(STConverter.sc2tc((String)name.toString()));
        }
        comboSolutionPeriod.addItems(solutionPeriodCollction.toArray());
    }

    public static void initSolutionPeriod(KDComboBox comboSolutionPeriod, String evaluSolutionId, boolean isUsingHROrgUnitAndOrgRangeFilter) throws Exception {
        if (evaluSolutionId == null) {
            return;
        }
        MDSolutionHelper.initSolutionPeriod(comboSolutionPeriod, evaluSolutionId, null, isUsingHROrgUnitAndOrgRangeFilter);
    }

    public static MultiDimentionSolutionPeriodInfo getSolutionPeriodInfo(String solutionPeriodId) {
        return MDSolutionHelper.getSolutionPeriodInfo(solutionPeriodId, null);
    }

    public static boolean checkPeriodHasBeenUsed(String assessPeriodId, String evaluSolutionId, String editDataID) throws Exception {
        if (evaluSolutionId == null || assessPeriodId == null) {
            return false;
        }
        IMultiDimentionSolutionPeriod solutionPeriod = MDSolutionHelper.getSolutionPeriod();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("assessPeriod.id", (Object)assessPeriodId));
        fi.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)evaluSolutionId));
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)editDataID, CompareType.NOTEQUALS));
        return solutionPeriod.exists(fi);
    }

    public static BigDecimal percentString2BigDecimal(String s) {
        String value = s.substring(0, s.indexOf("%"));
        return new BigDecimal(value);
    }

    public static String bigDecimal2PercentString(BigDecimal value) {
        if (value == null) {
            value = new BigDecimal("0");
        }
        value = value.setScale(2, 4);
        return value + "%";
    }

    private static IEvaluGroupObject getEvaluGroupObject() throws BOSException {
        return EvaluGroupObjectFactory.getRemoteInstance();
    }

    public static EvaluTargetCollection getEvaluTargetCollection(String evaluGroupId) throws Exception {
        if (evaluGroupId == null) {
            return null;
        }
        EvaluTargetCollection targetColl = new EvaluTargetCollection();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("evaluGroup.id", (Object)evaluGroupId));
        evi.setFilter(fi);
        IEvaluGroupTarget target = MDSolutionHelper.getEvaluGroupTarget();
        EvaluGroupTargetCollection groupTargetColl = target.getEvaluGroupTargetCollection(evi);
        EvaluGroupTargetInfo groupTargetInfo = null;
        for (int i = 0; i < groupTargetColl.size(); ++i) {
            groupTargetInfo = groupTargetColl.get(i);
            targetColl.add(groupTargetInfo.getEvaluTarget());
        }
        return targetColl;
    }

    public static IEvaluGroupTarget getEvaluGroupTarget() throws BOSException {
        return EvaluGroupTargetFactory.getRemoteInstance();
    }

    public static void startSolutionPeriod(String solutionPeriodId) throws Exception {
        if (solutionPeriodId == null) {
            return;
        }
        MultiDimentionSolutionFacadeFactory.getRemoteInstance().startSolutionPeriod(BOSUuid.read((String)solutionPeriodId));
    }

    public static void finishSolutionPeriod(String solutionPeriodId) throws Exception {
        if (solutionPeriodId == null) {
            return;
        }
        MultiDimentionSolutionFacadeFactory.getRemoteInstance().finishSolutionPeriod(BOSUuid.read((String)solutionPeriodId));
    }

    public static void resetSolutionPeriod(String solutionPeriodId) throws Exception {
        if (solutionPeriodId == null) {
            return;
        }
        MultiDimentionSolutionFacadeFactory.getRemoteInstance().resetSolutionPeriod(BOSUuid.read((String)solutionPeriodId));
    }

    public static void closeEvaluSolution(String evaluSolutionId) throws Exception {
        if (evaluSolutionId == null) {
            return;
        }
        IMultiDimentionSolution evaluSolution = MDSolutionHelper.getEvaluSolution();
        evaluSolution.closeEvaluSolution((IObjectPK)new ObjectUuidPK(evaluSolutionId));
    }

    public static boolean checkIfHaveSolutionPeriodOnEvalued(String evaluSolutionId) throws Exception {
        if (evaluSolutionId == null) {
            return false;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)evaluSolutionId));
        fi.getFilterItems().add(new FilterItemInfo("SPStatuEnum", (Object)new Integer(101)));
        return MultiDimentionSolutionPeriodFactory.getRemoteInstance().exists(fi);
    }

    public static boolean checkIfHaveEvaluResultUnChecked(String evaluSolutionId) throws Exception {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.MDSolution.id", (Object)evaluSolutionId));
        fi.getFilterItems().add(new FilterItemInfo("isApproved", (Object)new Integer(0)));
        return MDEvaluResultFactory.getRemoteInstance().exists(fi);
    }

    public static boolean checkIfHaveSolutionPeriod(String evaluSolutionId) throws Exception {
        if (evaluSolutionId == null) {
            return false;
        }
        IMultiDimentionSolutionPeriod solutionPeriod = MDSolutionHelper.getSolutionPeriod();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)evaluSolutionId));
        return solutionPeriod.exists(fi);
    }

    public static void startEvaluSolution(String evaluSolutionId) throws Exception {
        if (evaluSolutionId == null) {
            return;
        }
        IMultiDimentionSolution evaluSolution = MDSolutionHelper.getEvaluSolution();
        evaluSolution.startEvaluSolution(BOSUuid.read((String)evaluSolutionId));
    }

    public static void unStartEvaluSolution(String evaluSolutionId) throws Exception {
        if (evaluSolutionId == null) {
            return;
        }
        IMultiDimentionSolution evaluSolution = MDSolutionHelper.getEvaluSolution();
        evaluSolution.unStartEvaluSolution(BOSUuid.read((String)evaluSolutionId));
    }

    public static boolean isExistSolutionPeriodStartedOrEnded(String mdSolutionId) throws Exception {
        return MultiDimentionSolutionFacadeFactory.getRemoteInstance().existUseOrEndSolutionPeriod(mdSolutionId);
    }

    public static boolean isExistSolutionPeriodStarted(String evaluSolutionId) throws Exception {
        if (evaluSolutionId == null) {
            return false;
        }
        IMultiDimentionSolutionPeriod solutionPeriod = MDSolutionHelper.getSolutionPeriod();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)evaluSolutionId));
        fi.getFilterItems().add(new FilterItemInfo("SPStatuEnum", (Object)new Integer(101)));
        return solutionPeriod.exists(fi);
    }

    public static boolean isExistSolutionPeriodEnded(String evaluSolutionId) throws Exception {
        if (evaluSolutionId == null) {
            return false;
        }
        IMultiDimentionSolutionPeriod solutionPeriod = MDSolutionHelper.getSolutionPeriod();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)evaluSolutionId));
        fi.getFilterItems().add(new FilterItemInfo("SPStatuEnum", (Object)new Integer(102)));
        return solutionPeriod.exists(fi);
    }

    public static boolean isExistSolutionPeriodObject(String evaluSolutionId) throws Exception {
        if (evaluSolutionId == null) {
            return false;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)evaluSolutionId));
        return MultiDimentionObjectFactory.getRemoteInstance().exists(fi);
    }

    public static SolutionPeriodStatusEnum getSolutionPeriodStatus(String solutionPeriodId) throws Exception {
        if (solutionPeriodId == null) {
            return SolutionPeriodStatusEnum.UN_EVALU;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("SPStatuEnum"));
        MultiDimentionSolutionPeriodInfo solutionPeriodInfo = MDSolutionHelper.getSolutionPeriodInfo(solutionPeriodId, sic);
        return solutionPeriodInfo.getSPStatuEnum();
    }

    public static MultiDimentionSolutionPeriodInfo getSolutionPeriod(String solutionPeriodId) throws Exception {
        if (solutionPeriodId == null) {
            return null;
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("SPStatuEnum"));
        sic.add(new SelectorItemInfo("MDSolution.MultiDimntModeE"));
        MultiDimentionSolutionPeriodInfo solutionPeriodInfo = MDSolutionHelper.getSolutionPeriodInfo(solutionPeriodId, sic);
        return solutionPeriodInfo;
    }

    public static boolean isSolutionPeriodNeedASynchronize(String solutionPeriodId) throws Exception {
        if (solutionPeriodId == null) {
            return false;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("id", (Object)solutionPeriodId));
        fi.getFilterItems().add(new FilterItemInfo("MDSolution.MultiDimntModeE", (Object)new Integer(100), CompareType.NOTEQUALS));
        return MultiDimentionSolutionPeriodFactory.getRemoteInstance().exists(fi);
    }

    private static MultiDimentionSolutionPeriodInfo getSolutionPeriodInfo(String solutionPeriodId, SelectorItemCollection sic) {
        if (solutionPeriodId == null) {
            return null;
        }
        MultiDimentionSolutionPeriodInfo solutionPeriodInfo = null;
        try {
            solutionPeriodInfo = sic == null ? MDSolutionHelper.getSolutionPeriod().getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodId)) : MDSolutionHelper.getSolutionPeriod().getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodId), sic);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return solutionPeriodInfo;
    }

    private static IAdminOrgUnit getAdminOrgUnit() throws BOSException {
        return AdminOrgUnitFactory.getRemoteInstance();
    }

    private static AdminOrgUnitInfo getAdminOrgUnitInfo(BOSUuid id) throws Exception {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.name"));
        return AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
    }

    public static MultiDimentionSolutionPeriodCollection getSolutionPeriodCollection(String evaluSolutionId) throws Exception {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)evaluSolutionId));
        evi.setFilter(fi);
        evi.getSelector().add(new SelectorItemInfo("assessPeriod.name"));
        return MultiDimentionSolutionPeriodFactory.getRemoteInstance().getMultiDimentionSolutionPeriodCollection(evi);
    }

    public static Map getMainUIContext(CoreUIObject ui) {
        CoreUIObject uiObject = (CoreUIObject)ui.getUIContext().get(MAIN_FRAME);
        return uiObject.getUIContext();
    }

    public static boolean isContainPerson(PersonCollection personColl, PersonInfo personInfo) {
        if (personColl == null || personInfo == null) {
            return false;
        }
        int size = personColl.size();
        for (int i = 0; i < size; ++i) {
            if (!personColl.get(i).getId().equals((Object)personInfo.getId())) continue;
            return true;
        }
        return false;
    }

    public static String getStartDate2EndDateString(Date startDate, Date endDate) {
        StringBuffer sb = new StringBuffer();
        sb.append(startDate);
        sb.append("----");
        sb.append(endDate);
        return sb.toString();
    }

    public static SolutionStatusEnum getEvaluSolutionStatus(String evaluSolutionId) {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("SolutionStatuEn"));
        return MDSolutionHelper.getMultiDimentioinSolutionInfo(evaluSolutionId, sic).getSolutionStatuEn();
    }

    public static IRowSet getRowSet(String queryName, FilterInfo fi) throws Exception {
        MetaDataPK queryPK = new MetaDataPK("com.kingdee.eas.hr.perf.app", queryName);
        CacheServiceFactory.getInstance().discardQuery((IMetaDataPK)queryPK);
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPK);
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        exec.setObjectView(evi);
        IRowSet rowSet = exec.executeQuery();
        return rowSet;
    }

    public static PersonCollection getPersonCollection(String orgUnitId) {
        return null;
    }

    public static boolean isSolutionExistEvaluGroup(String mdSolutionId) throws Exception {
        return MultiDimentionSolutionFacadeFactory.getRemoteInstance().existEvaluGroup(mdSolutionId);
    }

    public static boolean isSelftMode(String solutionId) throws Exception {
        return MultiDimentionSolutionFactory.getRemoteInstance().isSelfMode(solutionId);
    }

    public static MultiDimentionSolutionInfo getMDSolutionInfoByMDSPID(String MDSolutionPeriodID) throws Exception {
        MultiDimentionSolutionInfo mDSolutionInfo = new MultiDimentionSolutionInfo();
        MultiDimentionSolutionPeriodInfo mDSolutionPeriodInfo = new MultiDimentionSolutionPeriodInfo();
        SelectorItemCollection sicCollection = new SelectorItemCollection();
        sicCollection.add(new SelectorItemInfo("id"));
        sicCollection.add(new SelectorItemInfo("MDSolution.hidePaperAndProcessScore"));
        mDSolutionPeriodInfo = MultiDimentionSolutionPeriodFactory.getRemoteInstance().getMultiDimentionSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(MDSolutionPeriodID), sicCollection);
        if (mDSolutionPeriodInfo != null) {
            mDSolutionInfo = mDSolutionPeriodInfo.getMDSolution();
        }
        return mDSolutionInfo;
    }
}

