/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.EditUI;
import com.kingdee.eas.hr.perf.MDOptionalMethodEnum;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionInfo;
import com.kingdee.eas.hr.perf.MultiDimntModeEnum;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.client.AbstractMDSolutionListUI;
import com.kingdee.eas.hr.perf.client.MDCopySolutionUI;
import com.kingdee.eas.hr.perf.client.MDSolutionFilterUI;
import com.kingdee.eas.hr.perf.client.MDSolutionHelper;
import com.kingdee.eas.hr.perf.client.MDSolutionUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MDSolutionListUI
extends AbstractMDSolutionListUI {
    private static final Logger logger = CoreUIObject.getLogger(MDSolutionListUI.class);
    private String resourcePath = "com.kingdee.eas.hr.perf.client.MultiDimentionSolutionResource";
    private CommonQueryDialog queryDlg;
    private MDSolutionFilterUI filterUI;
    private WindowListener listenerForEditWindow = null;

    public void onLoad() throws Exception {
        PerfClientUtils.checkValidPerson((CoreUI)this);
        PerfClientUtils.checkValidHRO((CoreUI)this);
        super.onLoad();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCloseEvaluSolution.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.menuItemCloseEvaluSolution.setIcon(EASResource.getIcon((String)"imgTbtn_close"));
        this.btnCopySolution.setIcon(EASResource.getIcon((String)"imgTbtn_copy"));
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected String getEditUIName() {
        return MDSolutionUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MultiDimentionSolutionFactory.getRemoteInstance();
    }

    public void onGetRowSet(IRowSet rowSet) {
        try {
            LinkedHashSet<String> idSet = new LinkedHashSet<String>();
            while (rowSet.next()) {
                idSet.add(rowSet.getString("id"));
            }
            rowSet.beforeFirst();
            Map map = MultiDimentionSolutionFacadeFactory.getRemoteInstance().getAssessPeriodNames(idSet);
            while (rowSet.next()) {
                rowSet.updateString("assessPeriod", (String)map.get(rowSet.getString("id")));
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            this.abort(ex);
        }
        super.onGetRowSet(rowSet);
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        try {
            if (this.queryDlg != null) {
                return this.queryDlg;
            }
            this.queryDlg = new CommonQueryDialog();
            this.queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
            this.queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
            this.queryDlg.setQueryObjectPK(this.mainQueryPK);
            this.queryDlg.setHeight(350);
            this.queryDlg.setWidth(450);
            this.queryDlg.addUserPanel((KDPanel)this.getFilterUI());
            this.queryDlg.setTitle(EASResource.getString((String)this.resourcePath, (String)"MultiDimentionSolutionResource"));
            this.queryDlg.setShowSorter(false);
            this.queryDlg.setUiObject((IUIObject)this);
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return this.queryDlg;
    }

    @Override
    public void actionCloseEvaluSolution_actionPerformed(ActionEvent e) throws Exception {
        if (this.confirmCloseEvaluSolution()) {
            super.actionCloseEvaluSolution_actionPerformed(e);
            PFUtils.checkSelected((Component)((Object)this), this.tblMain);
            int selectedRow = PFUtils.getSelectedRow(this.tblMain);
            BizEnumValueInfo status = (BizEnumValueInfo)this.tblMain.getRow(selectedRow).getCell("solutionStatus").getValue();
            if (status.getInt() == 100 || status.getInt() == 102) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotCloseSolution"));
                SysUtil.abort();
            }
            if (this.checkIfHaveSolutionPeriodOnEvalued()) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"HaveSolutionPeriodOnEvalued"));
                SysUtil.abort();
            }
            if (MDSolutionHelper.checkIfHaveEvaluResultUnChecked(this.tblMain.getRow(selectedRow).getCell("id").getValue().toString())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"HaveEvaluResultUnChecked"));
                SysUtil.abort();
            }
            MDSolutionHelper.closeEvaluSolution(this.getSelectedKeyValue());
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CloseSuccess"));
            this.refresh(e);
        }
    }

    private boolean confirmCloseEvaluSolution() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmCloseEvaluSolution")));
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        IRow row = this.tblMain.getRow(selectedRow);
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("solutionStatus").getValue();
        if (status.getInt() == 102) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotEditSolution"));
            SysUtil.abort();
        }
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)this.getSelectedKeyValue());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.EDIT);
        uiWindow.show();
        this.prepareRefresh(null).callHandler();
        this.refresh(e);
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        IRow row = this.tblMain.getRow(selectedRow);
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("solutionStatus").getValue();
        if (status.getInt() != 100) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotDelSolution"));
            SysUtil.abort();
        }
        super.actionRemove_actionPerformed(e);
    }

    private boolean checkIfHaveSolutionPeriodOnEvalued() throws Exception {
        String evaluSolutionId = this.getSelectedKeyValue();
        return MDSolutionHelper.checkIfHaveSolutionPeriodOnEvalued(evaluSolutionId);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        this.prepareUIContext(uiContext, e);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (this.isRefresh(uiWindow)) {
            this.prepareRefresh(null).callHandler();
            this.refresh(e);
        }
    }

    protected final boolean isRefresh(IUIWindow uiWindow) {
        if (this.getEditUIModal().equals("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory")) {
            return !(uiWindow.getUIObject() instanceof EditUI) || ((EditUI)uiWindow.getUIObject()).isSave();
        }
        Window window = SwingUtilities.getWindowAncestor((JComponent)uiWindow.getUIObject());
        if (this.listenerForEditWindow == null) {
            this.listenerForEditWindow = new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent event) {
                    try {
                        if (SysContext.getSysContext().getSessionID() != null) {
                            MDSolutionListUI.this.refresh(null);
                        }
                    }
                    catch (Exception e) {
                        MDSolutionListUI.this.handleException(e);
                    }
                }
            };
        }
        window.removeWindowListener(this.listenerForEditWindow);
        window.addWindowListener(this.listenerForEditWindow);
        return false;
    }

    public MDSolutionFilterUI getFilterUI() throws Exception {
        if (this.filterUI == null) {
            this.filterUI = new MDSolutionFilterUI();
        }
        return this.filterUI;
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionType", (Object)new Integer(100)));
        try {
            filterInfo.mergeFilter(PFUtils.getHRAndAdminRangeFilterInfo("hrOrgUnit.id", "orgUnit.id"), "AND");
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        return filterInfo;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    @Override
    public void actionCopySolution_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        String id = this.getSelectedKeyValue();
        if (id == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"noSelected"));
            return;
        }
        MultiDimentionSolutionInfo solution = MultiDimentionSolutionFactory.getRemoteInstance().getMultiDimentionSolutionInfo((IObjectPK)new ObjectUuidPK(id));
        if (!solution.getSolutionStatuEn().equals((Object)SolutionStatusEnum.ONUSED) && !solution.getSolutionStatuEn().equals((Object)SolutionStatusEnum.UNUSED)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"noOnusedConntCopy"));
            return;
        }
        uiContext.put((Object)"copyedSolutionStatusEnum", (Object)solution.getSolutionStatuEn());
        uiContext.put((Object)"ID", (Object)id);
        if (MultiDimntModeEnum.WORKFLOW_OPTIONAL.equals((Object)solution.getMultiDimntModeE()) && (MDOptionalMethodEnum.EVALUATOR_OPTIONAL.equals((Object)solution.getMDOptionalEnum()) || MDOptionalMethodEnum.UPPER_OPTIONAL.equals((Object)solution.getMDOptionalEnum()))) {
            uiContext.put((Object)"iSMDOptional", (Object)"true");
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MDCopySolutionUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.refreshList();
    }

    @Override
    public IUIActionPostman prepareInit() {
        PerfClientUtils.checkValidPerson((CoreUI)this);
        PerfClientUtils.checkValidHRO((CoreUI)this);
        return super.prepareInit();
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionQuery() {
        return true;
    }

    public boolean isPrepareActionRefresh() {
        return true;
    }

    public boolean isPrepareActionView() {
        return true;
    }
}

