/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.MultiDimEvaluatorFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.MultiDimntModeEnum;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.SolutionStatusEnum;
import com.kingdee.eas.hr.perf.client.AbstractMDSolutionPeriodListUI;
import com.kingdee.eas.hr.perf.client.ESBaseInfoUI;
import com.kingdee.eas.hr.perf.client.ESEvaluObjectOrgUnitUI;
import com.kingdee.eas.hr.perf.client.ESEvaluObjectUI;
import com.kingdee.eas.hr.perf.client.ESTargetEvaluModeUI;
import com.kingdee.eas.hr.perf.client.IMultiDimentionSolutionUI;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.perf.client.MDSolutionHelper;
import com.kingdee.eas.hr.perf.client.MDSolutionPeriodEditUI;
import com.kingdee.eas.hr.perf.client.MDSolutionPeriodResetUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.ProgDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class MDSolutionPeriodListUI
extends AbstractMDSolutionPeriodListUI
implements IMultiDimentionSolutionUI {
    private static final Logger logger = CoreUIObject.getLogger(MDSolutionPeriodListUI.class);
    private String resourcePath = "com.kingdee.eas.hr.perf.client.MultiDimentionSolutionResource";
    private String evaluSolutionId;
    private Container parentToolBar;

    public void onLoad() throws Exception {
        this.parentToolBar = (Container)this.getUIContext().get("ToolBar");
        super.onLoad();
        this.evaluSolutionId = (String)this.getUIContext().get("ID");
        this.setDataObject(this.getEntityViewInfo());
        this.setUIStatusByView();
    }

    private void setUIStatusByView() {
        if (this.getOprtState().equals(OprtState.VIEW)) {
            String[] workButtons = new String[]{"btnAddAssessPeriod_AssessPeriod", "btnEditAssessPeriod_AssessPeriod", "btnDelAssessPeriod_AssessPeriod", "btnResetAssessPeriod_AssessPeriod", "btnFinishAssessPeriod_AssessPeriod", "btnStartAssessPeriod_AssessPeriod"};
            MDSolutionHelper.setEnabled(this.parentToolBar, workButtons, false, false);
        }
    }

    private IObjectValue getEntityViewInfo() {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)this.evaluSolutionId));
        evi.setFilter(fi);
        SorterItemInfo sorterItemInfo = new SorterItemInfo("createTime");
        sorterItemInfo.setSortType(SortType.DESCEND);
        evi.getSorter().add(sorterItemInfo);
        return evi;
    }

    protected String getEditUIName() {
        return MDSolutionPeriodEditUI.class.getName();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return MultiDimentionSolutionPeriodFactory.getRemoteInstance();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put("EvaluSolutionID", this.evaluSolutionId);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (uiWindow != null && this.isDoRefresh(uiWindow)) {
            this.refreshList();
        }
    }

    protected boolean confirmRemove() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmDelSolutionPeriod")));
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
        this.dealEditUI(OprtState.VIEW, e);
    }

    private void dealEditUI(String oprtState, ActionEvent e) throws Exception {
        this.checkSelected();
        this.checkObjectExists();
        UIContext uiContext = new UIContext();
        uiContext.put("EvaluSolutionID", this.evaluSolutionId);
        uiContext.put("ID", this.getSelectedKeyValue());
        uiContext.put("superOprtState", this.getOprtState());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(this.getEditUIName(), (Map)uiContext, null, oprtState);
        uiWindow.show();
        if (uiWindow != null && this.isDoRefresh(uiWindow)) {
            this.refresh(e);
        }
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        this.dealEditUI(OprtState.EDIT, e);
    }

    private void checkObjectExists() throws BOSException, EASBizException, Exception {
        if (this.getSelectedKeyValue() == null) {
            return;
        }
        if (!this.getBizInterface().exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)this.getSelectedKeyValue())))) {
            this.refreshList();
            throw new EASBizException(EASBizException.CHECKEXIST);
        }
    }

    @Override
    protected void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        super.tblMain_tableSelectChanged(e);
        if (MDSolutionHelper.getEvaluSolutionStatus(this.evaluSolutionId).equals((Object)SolutionStatusEnum.CLOSED)) {
            Container toolBar = (Container)this.getUIContext().get("ToolBar");
            String[] workButtons = new String[]{"btnAddAssessPeriod_AssessPeriod", "btnEditAssessPeriod_AssessPeriod", "btnDelAssessPeriod_AssessPeriod", "btnResetAssessPeriod_AssessPeriod", "btnFinishAssessPeriod_AssessPeriod", "btnStartAssessPeriod_AssessPeriod"};
            MDSolutionHelper.setEnabled(toolBar, workButtons, false, false);
        } else {
            this.changeWorkButtonStatus();
        }
    }

    private void changeWorkButtonStatus() {
        String[] workButtonsEnabled;
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        if (selectedRow < 0) {
            return;
        }
        IRow row = this.tblMain.getRow(selectedRow);
        if (row.getCell("status").getValue() == null) {
            return;
        }
        BizEnumValueInfo status = (BizEnumValueInfo)row.getCell("status").getValue();
        Container toolBar = (Container)this.getUIContext().get("ToolBar");
        if (status.getInt() == 100) {
            String[] workButtonsUnEnabled = new String[]{"btnResetAssessPeriod_AssessPeriod", "btnFinishAssessPeriod_AssessPeriod"};
            MDSolutionHelper.setEnabled(toolBar, workButtonsUnEnabled, false, false);
            String[] workButtonsEnabled2 = new String[]{"btnAddAssessPeriod_AssessPeriod", "btnEditAssessPeriod_AssessPeriod", "btnDelAssessPeriod_AssessPeriod", "btnStartAssessPeriod_AssessPeriod"};
            MDSolutionHelper.setEnabled(toolBar, workButtonsEnabled2, false, true);
        }
        if (status.getInt() == 102) {
            workButtonsEnabled = new String[]{"btnAddAssessPeriod_AssessPeriod"};
            MDSolutionHelper.setEnabled(toolBar, workButtonsEnabled, false, true);
            String[] workButtonsUnEnable = new String[]{"btnResetAssessPeriod_AssessPeriod", "btnEditAssessPeriod_AssessPeriod", "btnDelAssessPeriod_AssessPeriod", "btnFinishAssessPeriod_AssessPeriod", "btnStartAssessPeriod_AssessPeriod"};
            MDSolutionHelper.setEnabled(toolBar, workButtonsUnEnable, false, false);
        }
        if (status.getInt() == 101) {
            workButtonsEnabled = new String[]{"btnAddAssessPeriod_AssessPeriod", "btnResetAssessPeriod_AssessPeriod", "btnFinishAssessPeriod_AssessPeriod"};
            MDSolutionHelper.setEnabled(toolBar, workButtonsEnabled, false, true);
            String[] workButtonsUnEnabled = new String[]{"btnEditAssessPeriod_AssessPeriod", "btnDelAssessPeriod_AssessPeriod", "btnStartAssessPeriod_AssessPeriod"};
            MDSolutionHelper.setEnabled(toolBar, workButtonsUnEnabled, false, false);
        }
        this.setUIStatusByView();
    }

    private void setUIStatus(boolean isSolutionPeriodStarted, boolean isSolutionPeriodEnded) {
        ESEvaluObjectOrgUnitUI evaluObjectOrgUnitUI;
        ESEvaluObjectUI evaluObjectUI;
        ESTargetEvaluModeUI evaluModeUI;
        ESBaseInfoUI baseInfoUI = (ESBaseInfoUI)this.getUIContext().get(ESBaseInfoUI.class.getName());
        Map uiContext = ((CoreUIObject)this.getUIContext().get("MainFrame")).getUIContext();
        if (baseInfoUI != null) {
            baseInfoUI.initUIStatus(isSolutionPeriodStarted || isSolutionPeriodEnded);
        }
        if ((evaluModeUI = (ESTargetEvaluModeUI)uiContext.get(ESTargetEvaluModeUI.class.getName())) != null) {
            evaluModeUI.initUIStatus(isSolutionPeriodStarted || isSolutionPeriodEnded);
        }
        if ((evaluObjectUI = (ESEvaluObjectUI)uiContext.get(ESEvaluObjectUI.class.getName())) != null) {
            evaluObjectUI.initUIStatus(isSolutionPeriodStarted);
        }
        if ((evaluObjectOrgUnitUI = (ESEvaluObjectOrgUnitUI)uiContext.get(ESEvaluObjectOrgUnitUI.class.getName())) != null) {
            evaluObjectOrgUnitUI.initUIStatus(isSolutionPeriodStarted);
        }
    }

    public void finishSolutionPeriod() throws Exception {
        boolean isExistNotSubmit;
        SolutionPeriodStatusEnum status;
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        MultiDimentionSolutionPeriodInfo info = MDSolutionHelper.getSolutionPeriod(this.tblMain.getRow(selectedRow).getCell("id").getValue().toString());
        if (PerfUtils.objectIsNull(info)) {
            this.refreshList();
            PerfClientUtils.showErrorMessage(this.resourcePath, "recordNotExist", (CoreUI)this);
        }
        if (SolutionPeriodStatusEnum.END_EVALU.equals((Object)(status = info.getSPStatuEnum())) || SolutionPeriodStatusEnum.UN_EVALU.equals((Object)status)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotFinishSolutionPeriod"));
            SysUtil.abort();
        }
        boolean isExistUnSelected = false;
        boolean isExistUnSend = false;
        if (MultiDimntModeEnum.WORKFLOW_OPTIONAL.equals((Object)info.getMDSolution().getMultiDimntModeE())) {
            isExistUnSelected = this.checkIfAllSelfSelected(this.tblMain.getRow(selectedRow).getCell("id").getValue().toString());
            isExistUnSend = this.checkIfAllSelfSend(this.tblMain.getRow(selectedRow).getCell("id").getValue().toString());
        }
        if ((isExistNotSubmit = this.checkIfAllObjectHaveFinishFlow(this.tblMain.getRow(selectedRow).getCell("id").getValue().toString())) || isExistUnSelected || isExistUnSend) {
            if (this.confirmFinishSolutionPeriod(isExistNotSubmit, isExistUnSelected, isExistUnSend)) {
                this.finish();
            }
        } else {
            this.finish();
        }
    }

    private boolean checkIfAllSelfSend(String mdSolutionPeriod) throws Exception {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriod));
        fi.getFilterItems().add(new FilterItemInfo("auditState", (Object)new Integer(40)));
        return MultiDimEvaluatorFactory.getRemoteInstance().exists(fi);
    }

    private boolean checkIfAllSelfSelected(String mdSolutionPeriod) throws Exception {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)mdSolutionPeriod));
        fi.getFilterItems().add(new FilterItemInfo("auditState", (Object)new Integer(80), CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("auditState", (Object)new Integer(80), CompareType.NOTEQUALS));
        return MultiDimEvaluatorFactory.getRemoteInstance().exists(fi);
    }

    private void finish() {
        IProgTask prog = new IProgTask(){

            @Override
            public Object exec() throws Exception {
                MDSolutionHelper.finishSolutionPeriod(MDSolutionPeriodListUI.this.getSelectedKeyValue());
                MDSolutionPeriodListUI.this.refreshList();
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
                MsgBox.showInfo((Component)((Object)MDSolutionPeriodListUI.this), (String)EASResource.getString((String)MDSolutionPeriodListUI.this.resourcePath, (String)"FinishSuccess"));
            }
        };
        ProgDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new ProgDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new ProgDialog((Dialog)win);
        }
        dialog.setLongTimeTask(prog);
        dialog.show();
    }

    private boolean checkIfAllObjectHaveFinishFlow(String solutionPeriodID) throws Exception {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)solutionPeriodID));
        fi.getFilterItems().add(new FilterItemInfo("wfStatus", (Object)new Integer(30), CompareType.NOTEQUALS));
        fi.getFilterItems().add(new FilterItemInfo("auditState", (Object)new Integer(80)));
        fi.getFilterItems().add(new FilterItemInfo("solutionPeriod.MDSolution.MultiDimntModeE", (Object)new Integer(100), CompareType.NOTEQUALS));
        return MultiDimEvaluatorFactory.getRemoteInstance().exists(fi);
    }

    public void resetSolutionPeriod() throws Exception {
        Date endDate;
        Date startDate;
        boolean isReset;
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        SolutionPeriodStatusEnum status = MDSolutionHelper.getSolutionPeriodStatus(this.tblMain.getRow(selectedRow).getCell("id").getValue().toString());
        if (status.getValue() == 102 || status.getValue() == 100) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotResetSolutionPeriod"));
            SysUtil.abort();
        }
        if (this.confirmResetSolutionPeriod() && (isReset = MDSolutionPeriodResetUI.showDialogWindows((IUIObject)this, startDate = (Date)this.tblMain.getRow(selectedRow).getCell("assessPeriod.startDate").getValue(), endDate = (Date)this.tblMain.getRow(selectedRow).getCell("assessPeriod.endDate").getValue()))) {
            this.reset();
        }
    }

    private void reset() {
        IProgTask prog = new IProgTask(){

            @Override
            public Object exec() throws Exception {
                MDSolutionHelper.resetSolutionPeriod(MDSolutionPeriodListUI.this.getSelectedKeyValue());
                MDSolutionPeriodListUI.this.refreshList();
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
                MsgBox.showInfo((Component)((Object)MDSolutionPeriodListUI.this), (String)EASResource.getString((String)MDSolutionPeriodListUI.this.resourcePath, (String)"ResetSuccess"));
            }
        };
        ProgDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new ProgDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new ProgDialog((Dialog)win);
        }
        dialog.setLongTimeTask(prog);
        dialog.show();
    }

    public void startSolutionPeriod() throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int selectedRow = PFUtils.getSelectedRow(this.tblMain);
        SolutionPeriodStatusEnum status = MDSolutionHelper.getSolutionPeriodStatus(this.tblMain.getRow(selectedRow).getCell("id").getValue().toString());
        if (status.getValue() == 102 || status.getValue() == 101) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"CannotStartSolutionPeriod"));
            this.secondLoad();
            SysUtil.abort();
        }
        this.start();
    }

    private void start() {
        IProgTask prog = new IProgTask(){

            @Override
            public Object exec() throws Exception {
                MDSolutionHelper.startSolutionPeriod(MDSolutionPeriodListUI.this.getSelectedKeyValue());
                MDSolutionPeriodListUI.this.refreshList();
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
                MsgBox.showInfo((Component)((Object)MDSolutionPeriodListUI.this), (String)EASResource.getString((String)MDSolutionPeriodListUI.this.resourcePath, (String)"StartSuccess"));
            }
        };
        ProgDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new ProgDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new ProgDialog((Dialog)win);
        }
        dialog.setLongTimeTask(prog);
        dialog.show();
    }

    private boolean confirmResetSolutionPeriod() {
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)"ConfirmResetSolutionPeriod")));
    }

    private boolean confirmFinishSolutionPeriod(boolean isExistNotSubmit, boolean isExistUnSelected, boolean isExistUnSend) {
        String msgKey = "ConfirmFinishSolutionPeriod";
        if (isExistNotSubmit && isExistUnSelected && isExistUnSend) {
            msgKey = "ConfirmFinishSolutionPeriodSelectedSendSubmit";
        } else if (isExistNotSubmit && isExistUnSelected) {
            msgKey = "ConfirmFinishSolutionPeriodSelectedSubmit";
        } else if (isExistNotSubmit && isExistUnSend) {
            msgKey = "ConfirmFinishSolutionPeriodSendSubmit";
        } else if (isExistUnSend && isExistUnSelected) {
            msgKey = "ConfirmFinishSolutionPeriodSelectedSend";
        } else if (isExistNotSubmit) {
            msgKey = "ConfirmFinishSolutionPeriodSubmit";
        } else if (isExistUnSelected) {
            msgKey = "ConfirmFinishSolutionPeriodSelected";
        } else if (isExistUnSend) {
            msgKey = "ConfirmFinishSolutionPeriodSend";
        }
        return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)this.resourcePath, (String)msgKey)));
    }

    private boolean checkIfExistSolutionPeriodOnUsed() throws Exception {
        return MDSolutionHelper.isExistSolutionPeriodStarted(this.evaluSolutionId);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
        this.refreshList();
    }

    @Override
    public void secondLoad() throws Exception {
        this.refreshList();
    }

    @Override
    public void submit() throws Exception {
    }

    @Override
    public void verifyInput() throws Exception {
    }

    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UIModelDialogFactory";
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    protected void initUserConfig() {
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
    }

    protected void checkQueryPK() {
        this.setHasQyeryPK(false);
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman handler = super.prepareInit();
        RequestContext request = new RequestContext();
        request.put("evaluSolutionId", this.getUIContext().get("ID"));
        handler.setRequestContext((Serializable)request);
        return handler;
    }
}

