/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.foot.KDTFootManager;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.base.client.GetDataDialog;
import com.kingdee.eas.hr.base.client.GetDataTaskAdapter;
import com.kingdee.eas.hr.perf.MDEvaluAverageScoreFacadeFactory;
import com.kingdee.eas.hr.perf.MDEvaluResultFactory;
import com.kingdee.eas.hr.perf.MDEvaluResultInfo;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodCollection;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodFactory;
import com.kingdee.eas.hr.perf.MultiDimentionSolutionPeriodInfo;
import com.kingdee.eas.hr.perf.PaperQuestionsCollection;
import com.kingdee.eas.hr.perf.PaperQuestionsFactory;
import com.kingdee.eas.hr.perf.TestQuestionInfo;
import com.kingdee.eas.hr.perf.client.AbstractMyMDEvaluAverageScoreReportUI;
import com.kingdee.eas.hr.perf.client.MyMDEvaluAverageScoreQueryPanel;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.SwingUtilities;

public class MyMDEvaluAverageScoreReportUI
extends AbstractMyMDEvaluAverageScoreReportUI {
    protected Set columnKeySet = new HashSet();

    public void onLoad() throws Exception {
        PerfClientUtils.checkValidHRO((CoreUI)this);
        super.onLoad();
        this.actionQuery_actionPerformed(null);
        this.initTable();
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        CommonQueryDialog queryDlg = super.initCommonQueryDialog();
        MyMDEvaluAverageScoreQueryPanel userPanel = null;
        String solutionId = null;
        String assPeriodId = null;
        solutionId = (String)this.getUIContext().get("solutionId");
        assPeriodId = (String)this.getUIContext().get("assPeriodId");
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("MDSolution.id", (Object)solutionId, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("AssessPeriod.id", (Object)assPeriodId, CompareType.EQUALS));
        filter.setMaskString("#0 and #1");
        viewInfo.setFilter(filter);
        MultiDimentionSolutionPeriodInfo info = null;
        try {
            MultiDimentionSolutionPeriodCollection mdSoluPeriodCollection = MultiDimentionSolutionPeriodFactory.getRemoteInstance().getMultiDimentionSolutionPeriodCollection(viewInfo);
            info = mdSoluPeriodCollection.get(0);
        }
        catch (Exception e1) {
            super.handleException(e1);
        }
        try {
            if (info != null) {
                userPanel = new MyMDEvaluAverageScoreQueryPanel(info);
            }
        }
        catch (Exception e) {
            super.handleException(e);
        }
        if (userPanel != null) {
            queryDlg.addUserPanel((KDPanel)userPanel);
        }
        queryDlg.setShowSorter(false);
        queryDlg.setShowFilter(false);
        queryDlg.setOwner((Component)this.getUIContext().get("Owner"));
        queryDlg.setParentUIClassName(this.getMetaDataPK().getFullName());
        queryDlg.setUiObject((IUIObject)this);
        return queryDlg;
    }

    public void actionQuery_actionPerformed(ActionEvent e) throws Exception {
        super.actionQuery_actionPerformed(e);
        this.doQuery();
    }

    protected void doQuery() throws Exception {
        if (this.mainQuery.getFilter() == null || this.mainQuery.getFilter().getFilterItems().size() == 0) {
            return;
        }
        String solutionId = null;
        String assPeriodId = null;
        HashSet<String> orgIds = new HashSet<String>();
        HashSet personIds = new HashSet();
        String paperId = null;
        FilterItemCollection coll = this.mainQuery.getFilter().getFilterItems();
        int j = coll.size();
        for (int i = 0; i < j; ++i) {
            FilterItemInfo info = coll.get(i);
            String propName = info.getPropertyName();
            if (!"TestPaper.id".equals(propName)) continue;
            paperId = info.getCompareValue().toString();
        }
        solutionId = (String)this.getUIContext().get("solutionId");
        assPeriodId = (String)this.getUIContext().get("assPeriodId");
        personIds.add(this.getUIContext().get("personId"));
        String evalResultId = (String)this.getUIContext().get("evalResultId");
        MDEvaluResultInfo mdEvaluResultInfo = MDEvaluResultFactory.getRemoteInstance().getMDEvaluResultInfo((IObjectPK)new ObjectUuidPK(evalResultId));
        if (mdEvaluResultInfo != null && mdEvaluResultInfo.getAdminOrgUnit() != null) {
            orgIds.add(mdEvaluResultInfo.getAdminOrgUnit().getId().toString());
        }
        this.clearTable();
        this.createTableColumn(paperId);
        this.fillData(solutionId, assPeriodId, paperId, orgIds, personIds);
    }

    protected void fillData(String solutionId, String assPeriodId, String paperId, Set orgIds, Set personIds) throws Exception {
        IRowSet rowSet = MDEvaluAverageScoreFacadeFactory.getRemoteInstance().getResult(solutionId, assPeriodId, paperId, orgIds, personIds);
        if (rowSet == null) {
            return;
        }
        while (rowSet.next()) {
            IRow row;
            if ("avgData".equals(rowSet.getString("personNum"))) {
                IRow footRow;
                KDTFootManager footRowManager = this.tblMain.getFootManager();
                if (footRowManager == null) {
                    String total = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_Total");
                    footRowManager = new KDTFootManager(this.tblMain);
                    footRowManager.addFootView();
                    this.tblMain.setFootManager(footRowManager);
                    footRow = footRowManager.addFootRow(0);
                    footRow.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
                    this.tblMain.getIndexColumn().setWidthAdjustMode((short)1);
                    this.tblMain.getIndexColumn().setWidth(30);
                    footRowManager.addIndexText(0, total);
                } else {
                    footRow = footRowManager.getFootRow(0);
                }
                footRow.getStyleAttributes().setBackground(new Color(255, 255, 179));
                footRow.getStyleAttributes().setLocked(true);
                footRow.getCell("personNum").setValue((Object)EASResource.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"75_MDEvaluAverageScoreReportUI"));
                footRow.getStyleAttributes().setBackground(new Color(255, 255, 179));
                footRow.getStyleAttributes().setLocked(true);
                footRow.getCell("paperAverScore").getStyleAttributes().setNumberFormat("0.00");
                footRow.getCell("personNum").getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"center"));
                row = footRow;
            } else {
                row = this.tblMain.addRow();
                row.getCell("personNum").setValue((Object)rowSet.getString("personNum"));
                row.getCell("personName").setValue((Object)rowSet.getString("personName"));
                row.getCell("adminDisplayName").setValue((Object)rowSet.getString("adminDisplayName"));
                row.getCell("position").setValue((Object)rowSet.getString("position"));
                row.getCell("job").setValue((Object)rowSet.getString("job"));
                row.getCell("solutionPeriodName").setValue((Object)rowSet.getString("solutionPeriodName"));
                row.getCell("paperType").setValue((Object)rowSet.getString("paperType"));
                row.getCell("paperName").setValue((Object)rowSet.getString("paperName"));
            }
            row.getCell("paperAverScore").setValue((Object)rowSet.getString("paperAverScore"));
            Iterator it = this.columnKeySet.iterator();
            while (it.hasNext()) {
                String key = it.next().toString();
                row.getCell(key).setValue(rowSet.getObject(key));
            }
        }
    }

    protected void initTable() {
        this.tblMain.getDataRequestManager().setDataRequestMode(0);
        KDTSortManager sm = new KDTSortManager(this.tblMain);
        int count = this.tblMain.getColumnCount();
        for (int i = 0; i < count; ++i) {
            this.tblMain.getColumn(i).setSortable(true);
        }
        sm.setSortAuto(true);
        this.tblMain.setColumnMoveable(false);
    }

    protected void createTableColumn(String paperId) throws Exception {
        if (paperId == null) {
            return;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("testPaper.id", (Object)paperId));
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("testQuestion.id"));
        sic.add(new SelectorItemInfo("testQuestion.name"));
        sic.add(new SelectorItemInfo("testQuestion.Number"));
        sic.add(new SelectorItemInfo("testQuestion.content"));
        PaperQuestionsCollection paperQuestColl = PaperQuestionsFactory.getRemoteInstance().getPaperQuestionsCollection(evi);
        IRow head = this.tblMain.getHeadRow(0);
        this.columnKeySet.clear();
        int j = paperQuestColl.size();
        for (int i = 0; i < j; ++i) {
            TestQuestionInfo testQuestInfo = paperQuestColl.get(i).getTestQuestion();
            IColumn col = this.tblMain.addColumn();
            col.getStyleAttributes().setNumberFormat("0.00");
            String key = "F" + i;
            this.columnKeySet.add(key);
            col.setKey(key);
            if (testQuestInfo.getName() != null && testQuestInfo.getName().trim().length() > 0) {
                head.getCell(key).setValue((Object)testQuestInfo.getName());
            } else {
                head.getCell(key).setValue((Object)testQuestInfo.getContent());
            }
            col.getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.getAlignment((String)"right"));
        }
        this.tblMain.getSelectManager().setSelectMode(10);
        this.tblMain.setColumnMoveable(false);
        this.tblMain.getHeadRow(0).getStyleAttributes().setWrapText(true);
    }

    protected void clearTable() {
        int colCount = this.tblMain.getColumnCount();
        if (colCount > 9) {
            for (int i = colCount - 1; i >= 9; --i) {
                this.tblMain.removeColumn(i);
            }
            this.tblMain.removeRows();
            this.tblMain.setRefresh(true);
            this.tblMain.repaint();
        }
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        GetDataDialog dlg = new GetDataDialog((Frame)SwingUtilities.getWindowAncestor((Component)((Object)this)));
        dlg.setGetDataTask(new GetDataTaskAdapter(){

            public Object exec() throws Exception {
                MyMDEvaluAverageScoreReportUI.this.doQuery();
                return null;
            }
        });
        dlg.show();
    }

    protected String getKeyFieldName() {
        return "personNum";
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }
}

