/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.FetchTypeEnum;
import com.kingdee.eas.hr.perf.NDRuleFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.client.AbstractNDBaseUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.PercentRender;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;

public class NDBaseUI
extends AbstractNDBaseUI {
    public static final String SOLUTION_PERIOD = "solutionPeriod";
    public static final String TOTAL_AMOUNT = "totalAmount";
    public static final String QUERY_PK = "queryPk";
    public static final String CONDITION = "condition";
    protected static final int SCALE = 2;
    protected static final int ROUND_MODE = 4;
    protected static final String RESOURCE = "com.kingdee.eas.hr.perf.client.PerfResource";
    private static final String TOTAL_STRING = EASResource.getString((String)"com.kingdee.eas.hr.perf.EvaluSolutionResource", (String)"Total");
    protected SelectorItemCollection selector = super.getSelectors();
    protected boolean canceled = true;
    protected int type;

    public NDBaseUI() throws Exception {
        this.selector.add(new SelectorItemInfo("fetchType"));
    }

    public void onLoad() throws Exception {
        this.kdtItems.checkParsed();
        this.type = (Integer)this.getUIContext().get("type");
        this.initUI();
        super.onLoad();
        this.setDefaultValues();
        this.handleTable();
    }

    private void initUI() {
        IRow row = this.kdtItems.getHeadRow(0);
        switch (this.type) {
            case 0: {
                this.contTotal.setBoundLabelText(EASResource.getString((String)RESOURCE, (String)"personTotal"));
                row.getCell("refAmount").setValue((Object)EASResource.getString((String)RESOURCE, (String)"refPersonAmount"));
                row.getCell("realAmount").setValue((Object)EASResource.getString((String)RESOURCE, (String)"realPersonAmount"));
                break;
            }
            case 1: {
                this.contTotal.setBoundLabelText(EASResource.getString((String)RESOURCE, (String)"orgUnitTotal"));
                row.getCell("refAmount").setValue((Object)EASResource.getString((String)RESOURCE, (String)"refOrgUnitAmount"));
                row.getCell("realAmount").setValue((Object)EASResource.getString((String)RESOURCE, (String)"realOrgUnitAmount"));
                break;
            }
        }
    }

    private void setDefaultValues() {
        FetchTypeEnum fetchType = this.editData.getFetchType();
        if (FetchTypeEnum.EVALU_SCORE.equals((Object)fetchType) || fetchType == null) {
            this.rdEvaluScore.setSelected(true);
        } else if (FetchTypeEnum.MODIFY_SCORE.equals((Object)fetchType)) {
            this.rdModifyScore.setSelected(true);
        } else if (FetchTypeEnum.MODIFY_SCORE_NULL.equals((Object)fetchType)) {
            this.rdModifyScoreNull.setSelected(true);
        }
        switch (this.type) {
            case 2: {
                SumSolutionInfo sumSolutionInfo = (SumSolutionInfo)this.getUIContext().get(SOLUTION_PERIOD);
                if (sumSolutionInfo == null) break;
                this.txtSolution.setText(sumSolutionInfo.getName());
                this.txtPeriod.setText(sumSolutionInfo.getAssessPeriod().getName());
                break;
            }
            default: {
                SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)this.getUIContext().get(SOLUTION_PERIOD);
                if (solutionPeriodInfo == null) break;
                this.txtSolution.setText(solutionPeriodInfo.getEvaluSolution().getName());
                this.txtPeriod.setText(solutionPeriodInfo.getAssessPeriod().getName());
            }
        }
        this.txtTotalAmount.setValue(this.getUIContext().get(TOTAL_AMOUNT));
    }

    protected void handleTable() {
        BigDecimal totalAmount = this.getTotalAmount();
        BigDecimal weight = null;
        BigDecimal amount = null;
        BigDecimal rate = new BigDecimal("100.00");
        IRow row = null;
        int size = this.kdtItems.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtItems.getRow(i);
            weight = (BigDecimal)row.getCell("refWeight").getValue();
            amount = totalAmount.multiply(weight).divide(rate, 2, 4);
            row.getCell("refAmount").setValue((Object)amount);
        }
        this.handleRealColumn();
        this.addTotalLine();
        this.calculateTotal();
        PercentRender render = new PercentRender();
        this.kdtItems.getColumn("refWeight").setRenderer((IBasicRender)render);
        this.kdtItems.getColumn("realWeight").setRenderer((IBasicRender)render);
    }

    protected BigDecimal getTotalAmount() {
        return new BigDecimal(this.txtTotalAmount.getNumberValue().toString());
    }

    protected void handleRealColumn() {
    }

    private int addTotalLine() {
        IRow row = this.kdtItems.addRow();
        row.getStyleAttributes().setLocked(true);
        row.getCell("rank").setValue((Object)TOTAL_STRING);
        row.getStyleAttributes().setBackground(EvaluSolutionHelper.KDTABLE_TOTAL_BG_COLOR);
        return row.getRowIndex();
    }

    protected int getTotalRowIndex() {
        int count = this.kdtItems.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (!TOTAL_STRING.equals(this.kdtItems.getRow(i).getCell("rank").getValue().toString())) continue;
            return i;
        }
        return -1;
    }

    private void calculateTotal() {
        int rankIndex = this.kdtItems.getColumnIndex("rank");
        int count = this.kdtItems.getColumnCount();
        for (int i = 0; i < count; ++i) {
            if (i == rankIndex) continue;
            this.calculateTotal(i);
        }
    }

    private void calculateTotal(int columnIndex) {
        int totalRowIndex = this.getTotalRowIndex();
        if (totalRowIndex == -1) {
            return;
        }
        BigDecimal total = new BigDecimal("0.00");
        IRow row = null;
        int count = this.kdtItems.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (i == totalRowIndex || (row = this.kdtItems.getRow(i)).getCell(columnIndex).getValue() == null) continue;
            total = total.add((BigDecimal)row.getCell(columnIndex).getValue());
        }
        this.kdtItems.getRow(totalRowIndex).getCell(columnIndex).setValue((Object)total.setScale(2, 4));
    }

    protected void calculateRealWeigth() {
        IRow row = null;
        BigDecimal amount = null;
        BigDecimal newRate = null;
        BigDecimal totalAmount = this.getTotalAmount();
        int columnIndex = this.kdtItems.getColumnIndex("realAmount");
        int size = this.kdtItems.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtItems.getRow(i);
            amount = (BigDecimal)row.getCell(columnIndex).getValue();
            if (amount == null) {
                amount = new BigDecimal("0");
            }
            newRate = amount.multiply(new BigDecimal("100.00")).divide(totalAmount, 2, 4);
            row.getCell("realWeight").setValue((Object)newRate);
        }
        this.calculateTotal(this.kdtItems.getColumnIndex("realWeight"));
        this.calculateTotal(columnIndex);
    }

    @Override
    public void actionCancelOP_actionPerformed(ActionEvent e) throws Exception {
        this.canceled = true;
        this.getUIWindow().close();
    }

    public boolean isModify() {
        return false;
    }

    protected IObjectValue createNewData() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return NDRuleFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return this.selector;
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

