/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.common.util.ControlUtilities;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.hr.perf.NDFacadeFactory;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.client.AbstractNDCalculatorUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.swing.JTextField;

public class NDCalculatorUI
extends AbstractNDCalculatorUI {
    private static final Color DISABLE_COLOR = new Color(217, 217, 214);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setRoundingMode(4);
        formattedTextField.setPrecision(0);
        this.kdtItems.getColumn("realAmount").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        this.setDisableColor();
    }

    private void setDisableColor() {
        IRow row = null;
        ICell cell = null;
        int totalRowIndex = this.getTotalRowIndex();
        int rowCount = this.kdtItems.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            if (i == totalRowIndex) continue;
            row = this.kdtItems.getRow(i);
            int colCount = this.kdtItems.getColumnCount();
            for (int j = 0; j < colCount; ++j) {
                cell = row.getCell(j);
                if (!cell.getStyleAttributes().isLocked()) continue;
                cell.getStyleAttributes().setBackground(DISABLE_COLOR);
            }
        }
    }

    @Override
    protected void handleRealColumn() {
        BigDecimal amount = null;
        IRow row = null;
        int size = this.kdtItems.getRowCount();
        for (int i = 0; i < size; ++i) {
            row = this.kdtItems.getRow(i);
            row.getCell("realWeight").setValue(row.getCell("refWeight").getValue());
            amount = (BigDecimal)row.getCell("refAmount").getValue();
            row.getCell("realAmount").setValue((Object)amount.setScale(0, 4));
        }
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        ControlUtilities.checkFocusAndCommit();
        BigDecimal totalAmount = this.getTotalAmount();
        int totalRowIndex = this.getTotalRowIndex();
        BigDecimal realTotalAmount = (BigDecimal)this.kdtItems.getRow(totalRowIndex).getCell("realAmount").getValue();
        if (totalAmount.intValue() != realTotalAmount.intValue()) {
            String message = null;
            switch (this.type) {
                case 0: {
                    message = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"personalAmountNotEquals");
                    break;
                }
                case 1: {
                    message = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"orgUnitAmountNotEquals");
                    break;
                }
                case 2: {
                    message = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"personalAmountNotEquals");
                }
            }
            MsgBox.showWarning((Component)((Object)this), message);
            this.kdtItems.getEditManager().editCellAt(0, this.kdtItems.getColumnIndex("realAmount"));
            return;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"ndCalculateConfirm")) != 0) {
            return;
        }
        ArrayList<String[]> realRule = new ArrayList<String[]>();
        IRow row = null;
        String[] item = null;
        RankInfo rank = null;
        int count = this.kdtItems.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (i == totalRowIndex || (rank = (RankInfo)(row = this.kdtItems.getRow(i)).getCell("rank").getValue()) == null || rank.getId() == null) continue;
            item = new String[]{rank.getId().toString(), row.getCell("realAmount").getValue().toString()};
            realRule.add(item);
        }
        switch (this.type) {
            case 2: {
                SumSolutionInfo sumSolutionInfo = (SumSolutionInfo)this.getUIContext().get("solutionPeriod");
                NDFacadeFactory.getRemoteInstance().calculate((IObjectValue)sumSolutionInfo, (IMetaDataPK)this.getUIContext().get("queryPk"), (FilterInfo)this.getUIContext().get("condition"), this.editData.getFetchType(), realRule);
                break;
            }
            default: {
                SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)this.getUIContext().get("solutionPeriod");
                NDFacadeFactory.getRemoteInstance().calculate((IObjectValue)solutionPeriodInfo, (IMetaDataPK)this.getUIContext().get("queryPk"), (FilterInfo)this.getUIContext().get("condition"), this.editData.getFetchType(), realRule);
            }
        }
        this.canceled = false;
        this.getUIWindow().close();
    }

    @Override
    protected void kdtItems_editStopped(KDTEditEvent e) throws Exception {
        if (e.getColIndex() == this.kdtItems.getColumnIndex("realAmount")) {
            this.calculateRealWeigth();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        return this.selector;
    }
}

