/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.extendcontrols.KDCommonPromptDialog;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.QueryInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.FetchTypeEnum;
import com.kingdee.eas.hr.perf.NDRuleFactory;
import com.kingdee.eas.hr.perf.NDRuleInfo;
import com.kingdee.eas.hr.perf.NDRuleItemCollection;
import com.kingdee.eas.hr.perf.NDRuleItemInfo;
import com.kingdee.eas.hr.perf.RankCollection;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankGroupInfo;
import com.kingdee.eas.hr.perf.client.AbstractNDRuleEditUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PercentRender;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.HashSet;
import javax.swing.Action;
import javax.swing.JButton;
import org.apache.log4j.Logger;

public class NDRuleEditUI
extends AbstractNDRuleEditUI {
    private static final Logger logger = CoreUIObject.getLogger(NDRuleEditUI.class);
    private static final String RESOURCE = "com.kingdee.eas.hr.perf.client.PerfResource";
    private static final String TOTAL_STRING = EASResource.getString((String)"com.kingdee.eas.hr.perf.EvaluSolutionResource", (String)"Total");
    private boolean isLoadField = false;

    public void onLoad() throws Exception {
        this.init();
        super.onLoad();
    }

    private void init() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(PFUtils.getHRFilter());
        this.prmtRankGroup.setEntityViewInfo(viewInfo);
        this.kdtItems.checkParsed();
        this.kdtSolutionPeriods.checkParsed();
        this.kdtSolutionPeriods.getStyleAttributes().setLocked(true);
        this.kdtSolutionPeriods.getSelectManager().setSelectMode(10);
        JButton button = this.contSolutionPeriods.add((Action)((Object)this.actionAddSolution));
        button.setIcon(EASResource.getIcon((String)"imgTbtn_addline"));
        button.setText(null);
        button = this.contSolutionPeriods.add((Action)((Object)this.actionRemoveLine));
        button.setIcon(EASResource.getIcon((String)"imgTbtn_deleteline"));
        button.setText(null);
        TrainUtils.setTableCellEditorByFormattedTextField((KDTable)this.kdtItems, (String)"weight", (int)2);
        this.kdtItems.getColumn("weight").setRenderer((IBasicRender)new PercentRender());
    }

    @Override
    public void loadFields() {
        this.isLoadField = true;
        super.loadFields();
        FetchTypeEnum type = this.editData.getFetchType();
        if (FetchTypeEnum.EVALU_SCORE.equals((Object)type) || type == null) {
            this.rdEvaluScore.setSelected(true);
        } else if (FetchTypeEnum.MODIFY_SCORE.equals((Object)type)) {
            this.rdModifyScore.setSelected(true);
        } else if (FetchTypeEnum.MODIFY_SCORE_NULL.equals((Object)type)) {
            this.rdModifyScoreNull.setSelected(true);
        }
        this.calculateTotalWeight();
        this.setActionStatus(!OprtState.VIEW.equals(this.getOprtState()));
        this.isLoadField = false;
    }

    private void setActionStatus(boolean enable) {
        this.actionAddSolution.setEnabled(enable);
        this.actionRemoveLine.setEnabled(enable);
        this.kdtItems.getStyleAttributes().setLocked(!enable);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        FetchTypeEnum type = null;
        if (this.rdEvaluScore.isSelected()) {
            type = FetchTypeEnum.EVALU_SCORE;
        } else if (this.rdModifyScore.isSelected()) {
            type = FetchTypeEnum.MODIFY_SCORE;
        } else if (this.rdModifyScoreNull.isSelected()) {
            type = FetchTypeEnum.MODIFY_SCORE_NULL;
        }
        if (type == null) {
            type = FetchTypeEnum.EVALU_SCORE;
        }
        this.editData.setFetchType(type);
        this.removeTotalData();
    }

    private void removeTotalData() {
        NDRuleItemCollection items = this.editData.getItems();
        NDRuleItemInfo itemInfo = null;
        for (int i = items.size() - 1; i >= 0; --i) {
            itemInfo = items.get(i);
            if (itemInfo == null || itemInfo.getRank() != null && itemInfo.getRank().getId() != null) continue;
            items.remove(itemInfo);
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("fetchType"));
        return sic;
    }

    @Override
    protected void prmtRankGroup_dataChanged(DataChangeEvent e) throws Exception {
        if (e.getNewValue() != null && e.getNewValue().equals(e.getOldValue()) || this.isLoadField) {
            return;
        }
        this.removeTableRows(this.kdtItems);
        this.removeTableRows(this.kdtSolutionPeriods);
        if (e.getNewValue() != null) {
            RankGroupInfo rankGroupInfo = (RankGroupInfo)e.getNewValue();
            EntityViewInfo viewInfo = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("group.id", (Object)rankGroupInfo.getId().toString()));
            viewInfo.setFilter(filterInfo);
            SorterItemInfo sorterItemInfo = new SorterItemInfo("serial");
            sorterItemInfo.setSortType(SortType.ASCEND);
            viewInfo.getSorter().add(sorterItemInfo);
            viewInfo.getSelector().add(new SelectorItemInfo("id"));
            viewInfo.getSelector().add(new SelectorItemInfo("name"));
            viewInfo.getSelector().add(new SelectorItemInfo("number"));
            viewInfo.getSelector().add(new SelectorItemInfo("group.id"));
            RankCollection ranks = RankFactory.getRemoteInstance().getRankCollection(viewInfo);
            if (ranks != null && ranks.size() > 0) {
                IRow row = null;
                int size = ranks.size();
                for (int i = 0; i < size; ++i) {
                    row = this.kdtItems.addRow();
                    row.getCell("rank").setValue((Object)ranks.get(i));
                }
            }
        }
        this.calculateTotalWeight();
    }

    private int addTotalLine() {
        IRow row = this.kdtItems.addRow();
        row.getCell("rank").setValue((Object)TOTAL_STRING);
        row.getCell("weight").setValue((Object)"0.00");
        row.getCell("weight").getStyleAttributes().setLocked(true);
        row.getStyleAttributes().setBackground(EvaluSolutionHelper.KDTABLE_TOTAL_BG_COLOR);
        return row.getRowIndex();
    }

    private void calculateTotalWeight() {
        if (this.kdtItems.getRowCount() > 0) {
            BigDecimal totalWeight = new BigDecimal("0.00");
            int totalRowIndex = this.getTotalRowIndex();
            if (totalRowIndex == -1) {
                totalRowIndex = this.addTotalLine();
            }
            IRow row = null;
            int count = this.kdtItems.getRowCount();
            for (int i = 0; i < count; ++i) {
                if (i == totalRowIndex || (row = this.kdtItems.getRow(i)).getCell("weight").getValue() == null) continue;
                totalWeight = totalWeight.add((BigDecimal)row.getCell("weight").getValue());
            }
            this.kdtItems.getRow(totalRowIndex).getCell("weight").setValue((Object)totalWeight);
        }
    }

    private int getTotalRowIndex() {
        int count = this.kdtItems.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (!TOTAL_STRING.equals(this.kdtItems.getRow(i).getCell("rank").getValue().toString())) continue;
            return i;
        }
        return -1;
    }

    private void removeTableRows(KDTable table) {
        table.removeRows();
        IObjectCollection collection = (IObjectCollection)table.getUserObject();
        collection.clear();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        Object value;
        super.beforeStoreFields(e);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtName);
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, (KDBizPromptBox)this.prmtRankGroup);
        TrainVerifyUtils.verifyInput((CoreUIObject)this, (KDTable)this.kdtItems, (String)"weight");
        int totalRowIndex = this.getTotalRowIndex();
        if (totalRowIndex != -1 && (value = this.kdtItems.getRow(totalRowIndex).getCell("weight").getValue()) != null) {
            BigDecimal weightValue = null;
            weightValue = value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(value.toString());
            if (new BigDecimal("100.00").compareTo(weightValue) != 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"ruleSumWeight"));
                SysUtil.abort();
            }
        }
    }

    @Override
    protected void kdtItems_editStopped(KDTEditEvent e) throws Exception {
        if (e.getColIndex() == this.kdtItems.getColumnIndex("weight")) {
            this.calculateTotalWeight();
        }
    }

    @Override
    public void actionAddSolution_actionPerformed(ActionEvent e) throws Exception {
        if (this.prmtRankGroup.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RESOURCE, (String)"selectRankGroup"));
            this.prmtRankGroup.requestFocus(true);
            return;
        }
        MetaDataPK queryPk = new MetaDataPK("com.kingdee.eas.hr.perf.app", "SolutionPeriodForRuleUnionQuery");
        Object[] objs = this.getSolutionPeriod(queryPk);
        if (objs != null && objs.length > 0) {
            HashSet<Object> ids = new HashSet<Object>();
            int length = objs.length;
            for (int i = 0; i < length; ++i) {
                ids.add(objs[i]);
            }
            IQueryExecutor queryExecutor = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)queryPk);
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
            EntityViewInfo viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filterInfo);
            queryExecutor.setObjectView(viewInfo);
            IRowSet rowSet = queryExecutor.executeQuery();
            IRow row = null;
            while (rowSet.next()) {
                row = this.kdtSolutionPeriods.addRow();
                row.getCell("solutionPeriodId").setValue((Object)rowSet.getString("id"));
                row.getCell("solutionNumber").setValue((Object)rowSet.getString("solution.number"));
                row.getCell("solutionName").setValue((Object)rowSet.getString("solution.name"));
                row.getCell("assessPeriodName").setValue((Object)rowSet.getString("assessPeriod.name"));
            }
        }
    }

    private Object[] getSolutionPeriod(MetaDataPK queryPk) throws BOSException {
        KDCommonPromptDialog dialog = new KDCommonPromptDialog();
        QueryInfo queryInfo = MetaDataLoaderFactory.getRemoteMetaDataLoader().getQuery((IMetaDataPK)queryPk);
        dialog.setQueryInfo(queryInfo);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("rankGroup.id", (Object)((RankGroupInfo)this.prmtRankGroup.getValue()).getId().toString()));
        StringBuffer sql = new StringBuffer();
        sql.append("select sp.FSolutionPeriodId from T_PF_NDSolutionPeriod as sp");
        if (this.editData.getId() != null) {
            sql.append(" inner join T_PF_NDRule as ndRule on ndRule.FID = sp.FParentID");
            sql.append(" where ndRule.FID != ");
            sql.append("'");
            sql.append(this.editData.getId().toString());
            sql.append("'");
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)sql.toString(), CompareType.NOTINNER));
        HashSet<Object> ids = new HashSet<Object>();
        int size = this.kdtSolutionPeriods.getRowCount();
        for (int i = 0; i < size; ++i) {
            ids.add(this.kdtSolutionPeriods.getRow(i).getCell("solutionPeriodId").getValue());
        }
        if (!ids.isEmpty()) {
            filterInfo.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.NOTINCLUDE));
        }
        filterInfo.mergeFilter(PFUtils.getHRAndAdminRangeFilterInfo("hrOrgUnit.id", "adminOrgUnit.id"), "AND");
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filterInfo);
        dialog.setEntityViewInfo(viewInfo);
        dialog.setEnabledMultiSelection(true);
        dialog.setReturnValueType(1);
        dialog.show();
        if (dialog.isCanceled()) {
            return null;
        }
        return (Object[])dialog.getData();
    }

    @Override
    public void actionRemoveLine_actionPerformed(ActionEvent e) throws Exception {
        TrainUtils.removeLine((KDTable)this.kdtSolutionPeriods);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setActionStatus(true);
    }

    @Override
    protected IObjectValue createNewData() {
        NDRuleInfo info = new NDRuleInfo();
        info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        info.setHrOrgUnit(PFUtils.getCurrentHROrgUnit());
        info.setFetchType(FetchTypeEnum.EVALU_SCORE);
        info.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return info;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return NDRuleFactory.getRemoteInstance();
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
        super.setAutoNumberByOrg(orgType);
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            String orgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
            boolean isModifiable = true;
            try {
                ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
                boolean result = codingRuleManager.isExist((IObjectValue)this.editData, orgUnitId);
                if (result) {
                    isModifiable = codingRuleManager.isModifiable((IObjectValue)this.editData, orgUnitId);
                    this.txtNumber.setEnabled(isModifiable);
                    this.txtNumber.setEditable(isModifiable);
                }
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
            catch (EASBizException e1) {
                ExceptionHandler.handle((Throwable)e1);
            }
        } else {
            this.txtNumber.setEnabled(false);
        }
    }
}

