/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.perf.AchieveDataCollection;
import com.kingdee.eas.hr.perf.AchieveDataFactory;
import com.kingdee.eas.hr.perf.AchieveDataInfo;
import com.kingdee.eas.hr.perf.DataTypeEnum;
import com.kingdee.eas.hr.perf.EvalWFObjectsCollection;
import com.kingdee.eas.hr.perf.EvalWFObjectsFactory;
import com.kingdee.eas.hr.perf.EvaluFormSolutionFacadeFactory;
import com.kingdee.eas.hr.perf.EvaluFormSolutionMultiTableInfo;
import com.kingdee.eas.hr.perf.EvaluNodeCollection;
import com.kingdee.eas.hr.perf.EvaluNodeFactory;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.EvaluTargetInfo;
import com.kingdee.eas.hr.perf.IAchieveData;
import com.kingdee.eas.hr.perf.INodeProcesserHandler;
import com.kingdee.eas.hr.perf.KindEnum;
import com.kingdee.eas.hr.perf.NodeProcesserCollection;
import com.kingdee.eas.hr.perf.NodeProcesserFactory;
import com.kingdee.eas.hr.perf.NodeProcesserInfo;
import com.kingdee.eas.hr.perf.NodeProcesserParam;
import com.kingdee.eas.hr.perf.PrecisionTypeEnum;
import com.kingdee.eas.hr.perf.RankConvertRuleFactory;
import com.kingdee.eas.hr.perf.RankConvertRuleInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TargetEvaluStoreCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreInfo;
import com.kingdee.eas.hr.perf.client.ClearRender;
import com.kingdee.eas.hr.perf.client.NodeProcesserHelper;
import com.kingdee.eas.hr.perf.client.PercentRender;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.PerfContractTemplateDrawTableHelper;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class NodeProcesserHandler
implements INodeProcesserHandler {
    @Override
    public NodeProcesserParam initParameters(Map uiContext) throws Exception {
        NodeProcesserParam parameter = new NodeProcesserParam();
        parameter.setEvaluObjectId((String)uiContext.get("evaluObject"));
        parameter.setEvaluPersonId((String)uiContext.get("evaluPersonId"));
        String solutionPeriodId = (String)uiContext.get("solutionPeriod");
        if (!StringUtils.isEmpty((String)solutionPeriodId)) {
            SolutionPeriodInfo solutionPeriodInfo = this.getSolutionPeriodInfo(solutionPeriodId);
            parameter.setSolutionPeriodInfo(solutionPeriodInfo);
            parameter.setFormSolutionId(solutionPeriodInfo.getFormSolution().getId().toString());
            parameter.setEvaluSolutionType(solutionPeriodInfo.getEvaluSolution().getSolutionType());
            if (EvaluSolutionTypeEnum.PERSON.equals((Object)parameter.getEvaluSolutionType())) {
                parameter.setEvaluObjectType(EvaluObjectTypeEnum.PERSON);
            } else if (EvaluSolutionTypeEnum.ORGUNIT.equals((Object)parameter.getEvaluSolutionType())) {
                parameter.setEvaluObjectType(EvaluObjectTypeEnum.ORGUNIT);
            }
            parameter.setNodeProeceeserInfos(this.getNodeProcesserInfos(parameter));
        }
        return parameter;
    }

    private SolutionPeriodInfo getSolutionPeriodInfo(String solutionPeriodId) throws EASBizException, BOSException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("formTitle"));
        sic.add(new SelectorItemInfo("evaluFormDesc"));
        sic.add(new SelectorItemInfo("evaluSolution.id"));
        sic.add(new SelectorItemInfo("evaluSolution.inputMode"));
        sic.add(new SelectorItemInfo("evaluSolution.modifyScore"));
        sic.add(new SelectorItemInfo("evaluSolution.targetRankGroup.id"));
        sic.add(new SelectorItemInfo("evaluSolution.targetRankGroup.name"));
        sic.add(new SelectorItemInfo("evaluSolution.rankGroup.id"));
        sic.add(new SelectorItemInfo("evaluSolution.rankGroup.id"));
        sic.add(new SelectorItemInfo("evaluSolution.targetGradeModeLink.id"));
        sic.add(new SelectorItemInfo("evaluSolution.targetGradeModeLink.maxGrade"));
        sic.add(new SelectorItemInfo("evaluSolution.targetGradeModeLink.minGrade"));
        sic.add(new SelectorItemInfo("evaluSolution.targetGradeModeLink.name"));
        sic.add(new SelectorItemInfo("evaluSolution.gradeMode.id"));
        sic.add(new SelectorItemInfo("evaluSolution.gradeMode.maxGrade"));
        sic.add(new SelectorItemInfo("evaluSolution.gradeMode.minGrade"));
        sic.add(new SelectorItemInfo("evaluSolution.gradeMode.name"));
        sic.add(new SelectorItemInfo("evaluSolution.rankConvertRule.id"));
        sic.add(new SelectorItemInfo("evaluSolution.viewSelfForm"));
        sic.add(new SelectorItemInfo("evaluSolution.viewOtherResult"));
        sic.add(new SelectorItemInfo("evaluSolution.outGradeMode"));
        sic.add(new SelectorItemInfo("evaluSolution.viewWeight"));
        sic.add(new SelectorItemInfo("evaluSolution.allocateTarget"));
        sic.add(new SelectorItemInfo("evaluSolution.deliverMode"));
        sic.add(new SelectorItemInfo("evaluSolution.targetGradeMode"));
        sic.add(new SelectorItemInfo("evaluSolution.canComment"));
        sic.add(new SelectorItemInfo("evaluSolution.solutionType"));
        sic.add(new SelectorItemInfo("evaluSolution.parallelDisplay"));
        sic.add(new SelectorItemInfo("evaluSolution.scoreToNextNode"));
        sic.add(new SelectorItemInfo("evaluSolution.deduction"));
        sic.add(new SelectorItemInfo("evaluSolution.totalScore"));
        sic.add(new SelectorItemInfo("evaluSolution.nodeVisibleMode"));
        sic.add(new SelectorItemInfo("evaluSolution.evaluRule.EvaluRuleToolClassName"));
        sic.add(new SelectorItemInfo("evaluSolution.evaluRule.ruleMode"));
        sic.add(new SelectorItemInfo("assessPeriod.id"));
        sic.add(new SelectorItemInfo("formSolution.id"));
        SolutionPeriodInfo solutionPeriodInfo = SolutionPeriodFactory.getRemoteInstance().getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(solutionPeriodId), sic);
        if (solutionPeriodInfo.getEvaluSolution().getRankConvertRule() != null) {
            sic.clear();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("entries.id"));
            sic.add(new SelectorItemInfo("entries.minScore"));
            sic.add(new SelectorItemInfo("entries.maxScore"));
            sic.add(new SelectorItemInfo("entries.maxScoreCondition"));
            sic.add(new SelectorItemInfo("entries.minScoreCondition"));
            sic.add(new SelectorItemInfo("entries.rank.id"));
            sic.add(new SelectorItemInfo("entries.rank.name"));
            sic.add(new SelectorItemInfo("entries.rank.grade"));
            RankConvertRuleInfo rankConvertRuleInfo = RankConvertRuleFactory.getRemoteInstance().getRankConvertRuleInfo((IObjectPK)new ObjectUuidPK(solutionPeriodInfo.getEvaluSolution().getRankConvertRule().getId().toString()), sic);
            solutionPeriodInfo.getEvaluSolution().setRankConvertRule(rankConvertRuleInfo);
        }
        return solutionPeriodInfo;
    }

    private NodeProcesserCollection getNodeProcesserInfos(NodeProcesserParam parameter) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.solutionPeriod", (Object)parameter.getSolutionPeriodInfo().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.evaluObject.id", (Object)parameter.getEvaluObjectId()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("evaluNode.*"));
        sic.add(new SelectorItemInfo("evaluNode.nodes.*"));
        sic.add(new SelectorItemInfo("evaluNode.evalWorkFlow.id"));
        sic.add(new SelectorItemInfo("evaluNode.evalWorkFlow.wfLevels"));
        sic.add(new SelectorItemInfo("evaluDetails.*"));
        sic.add(new SelectorItemInfo("evaluDetails.rank.*"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.id"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.values"));
        sic.add(new SelectorItemInfo("evaluer.id"));
        sic.add(new SelectorItemInfo("evaluer.name"));
        sic.add(new SelectorItemInfo("rank.*"));
        sic.add(new SelectorItemInfo("evaluResult.id"));
        sic.add(new SelectorItemInfo("evaluResult.id"));
        sic.add(new SelectorItemInfo("evaluResult.targetEvaluScore"));
        sic.add(new SelectorItemInfo("evaluResult.evaluateSum"));
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("evaluNode.seqNumber"));
        sorter.add(new SorterItemInfo("evaluDetails.targetEvaluStore.evaluTarget.seqNumber"));
        NodeProcesserCollection collection = NodeProcesserFactory.getRemoteInstance().getNodeProcesserCollection(viewInfo);
        if (collection == null || collection.size() == 0) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evaluObject", (Object)parameter.getEvaluObjectId()));
            filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)parameter.getSolutionPeriodInfo().getId().toString()));
            viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("evalWorkFlow.id"));
            EvalWFObjectsCollection objColl = EvalWFObjectsFactory.getRemoteInstance().getEvalWFObjectsCollection(viewInfo);
            if (objColl.size() > 0) {
                String id = objColl.get(0).getEvalWorkFlow().getId().toString();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.id", (Object)id));
                viewInfo = new EntityViewInfo();
                viewInfo.setFilter(filter);
                sic = viewInfo.getSelector();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("seqNumber"));
                EvaluNodeCollection nodeColl = EvaluNodeFactory.getRemoteInstance().getEvaluNodeCollection(viewInfo);
                if (nodeColl != null && nodeColl.size() > 0) {
                    String[] nodeSeqs = new String[nodeColl.size()];
                    int n = nodeColl.size();
                    for (int i = 0; i < n; ++i) {
                        nodeSeqs[i] = String.valueOf(nodeColl.get(i).getSeqNumber());
                    }
                    Map map = NodeProcesserFactory.getRemoteInstance().getNodeProcesserInfoOfTheNode(nodeSeqs, parameter.getEvaluObjectId(), parameter.getSolutionPeriodInfo().getId().toString());
                    NodeProcesserInfo info = null;
                    collection = new NodeProcesserCollection();
                    int size = map.size();
                    for (int i = 1; i <= size; ++i) {
                        info = (NodeProcesserInfo)map.get(String.valueOf(i));
                        if (info == null) continue;
                        collection.add(info);
                    }
                }
            }
        }
        return collection;
    }

    @Override
    public Map getHeadData(NodeProcesserParam parameters) throws EASBizException, BOSException {
        return EvaluFormSolutionFacadeFactory.getRemoteInstance().getHeadEntrys(parameters.getSolutionPeriodInfo().getId().toString(), parameters.getEvaluObjectId(), parameters.getEvaluObjectType().getValue());
    }

    @Override
    public AbstractObjectCollection getTargetData(NodeProcesserParam parameters) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)parameters.getSolutionPeriodInfo().getId().toString()));
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluObject.id", (Object)parameters.getEvaluObjectId()));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("weight"));
        sic.add(new SelectorItemInfo("values"));
        sic.add(new SelectorItemInfo("thresholdValue"));
        sic.add(new SelectorItemInfo("standardValue"));
        sic.add(new SelectorItemInfo("challengeValue"));
        sic.add(new SelectorItemInfo("realValue"));
        sic.add(new SelectorItemInfo("multiTable.id"));
        sic.add(new SelectorItemInfo("evaluTarget.id"));
        sic.add(new SelectorItemInfo("evaluTarget.targetID"));
        sic.add(new SelectorItemInfo("evaluTarget.number"));
        sic.add(new SelectorItemInfo("evaluTarget.content"));
        sic.add(new SelectorItemInfo("evaluTarget.standard"));
        sic.add(new SelectorItemInfo("evaluTarget.description"));
        sic.add(new SelectorItemInfo("evaluTarget.kind"));
        sic.add(new SelectorItemInfo("evaluTarget.thresholdValue"));
        sic.add(new SelectorItemInfo("evaluTarget.standardValue"));
        sic.add(new SelectorItemInfo("evaluTarget.challengeValue"));
        sic.add(new SelectorItemInfo("evaluTarget.unit"));
        sic.add(new SelectorItemInfo("evaluTarget.reportFrequency"));
        sic.add(new SelectorItemInfo("evaluTarget.scoringMethod"));
        sic.add(new SelectorItemInfo("evaluTarget.evaluationSide"));
        sic.add(new SelectorItemInfo("evaluTarget.reservedField1"));
        sic.add(new SelectorItemInfo("evaluTarget.reservedField2"));
        sic.add(new SelectorItemInfo("evaluTarget.type.id"));
        sic.add(new SelectorItemInfo("evaluTarget.type.name"));
        sic.add(new SelectorItemInfo("evaluTarget.type.longNumber"));
        sic.add(new SelectorItemInfo("evaluTarget.formula.id"));
        sic.add(new SelectorItemInfo("evaluTarget.formula.name"));
        sic.add(new SelectorItemInfo("evaluTarget.formula.achieveItem.dataType"));
        sic.add(new SelectorItemInfo("evaluTarget.formula.achieveItem.dataPrecision"));
        sic.add(new SelectorItemInfo("evaluTarget.formula.achieveItem.precisionType"));
        sic.add(new SelectorItemInfo("evaluTarget.dataPrecision"));
        sic.add(new SelectorItemInfo("evaluTarget.precisionType"));
        sic.add(new SelectorItemInfo("evaluTarget.seqNumber"));
        sic.add(new SelectorItemInfo("evaluTarget.reservedField3"));
        sic.add(new SelectorItemInfo("evaluTarget.reservedField4"));
        sic.add(new SelectorItemInfo("evaluTarget.reservedField5"));
        sic.add(new SelectorItemInfo("evaluTarget.reservedField6"));
        sic.add(new SelectorItemInfo("evaluTarget.reservedField2text"));
        sic.add(new SelectorItemInfo("evaluTarget.firstTypeWeight"));
        sic.add(new SelectorItemInfo("evaluTarget.firstTypeScore"));
        sic.add(new SelectorItemInfo("evaluTarget.secondTypeWeight"));
        sic.add(new SelectorItemInfo("evaluTarget.secondTypeScore"));
        sic.add(new SelectorItemInfo("evaluTarget.secondType.id"));
        sic.add(new SelectorItemInfo("evaluTarget.secondType.name"));
        sic.add(new SelectorItemInfo("solutionPeriod.evaluSolution.solutionType"));
        sic.add(new SelectorItemInfo("evaluObject.objectID"));
        viewInfo.setSelector(sic);
        SorterItemInfo sortItemInfo = new SorterItemInfo("multiTable.id");
        sortItemInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sortItemInfo);
        sortItemInfo = new SorterItemInfo("seqNumber");
        sortItemInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sortItemInfo);
        sortItemInfo = new SorterItemInfo("evaluTarget.type.id");
        sortItemInfo.setSortType(SortType.ASCEND);
        viewInfo.getSorter().add(sortItemInfo);
        return TargetEvaluStoreFactory.getRemoteInstance().getTargetEvaluStoreCollection(viewInfo);
    }

    @Override
    public Map assembleMultiTableTargetDataMap(AbstractObjectCollection objectCollection) {
        HashMap<String, TargetEvaluStoreCollection> map = new HashMap<String, TargetEvaluStoreCollection>();
        TargetEvaluStoreInfo info = null;
        TargetEvaluStoreCollection targets = null;
        TargetEvaluStoreCollection collection = (TargetEvaluStoreCollection)objectCollection;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            info = collection.get(i);
            String multiTableId = info.getMultiTable().getId().toString();
            targets = (TargetEvaluStoreCollection)((Object)map.get(multiTableId));
            if (targets == null) {
                targets = new TargetEvaluStoreCollection();
                map.put(multiTableId, targets);
            }
            targets.add(info);
        }
        return map;
    }

    @Override
    public void fillTable(KDTable table, AbstractObjectCollection collection) {
        if (collection == null || collection.size() <= 0) {
            return;
        }
        this.fillTargetData(table, collection);
    }

    private void fillTargetData(KDTable table, AbstractObjectCollection collection) {
        TargetEvaluStoreCollection targetEvaluStoreCollection = (TargetEvaluStoreCollection)collection;
        TargetEvaluStoreInfo targetEvaluStoreInfo = null;
        EvaluTargetInfo evaluTargetInfo = null;
        KindEnum targetKind = null;
        IRow row = null;
        AchieveDataInfo achieveDataInfo = null;
        IAchieveData iAchieveData = null;
        try {
            iAchieveData = AchieveDataFactory.getRemoteInstance();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
        int scaleForBigdecimal = 2;
        int scaleForReservedFieldNumber = 4;
        for (int i = 0; i < targetEvaluStoreCollection.size(); ++i) {
            targetEvaluStoreInfo = targetEvaluStoreCollection.get(i);
            evaluTargetInfo = targetEvaluStoreInfo.getEvaluTarget();
            row = table.addRow();
            if (row.getCell("id") != null) {
                row.getCell("id").setValue((Object)targetEvaluStoreInfo.getId().toString());
            }
            if (row.getCell("seq") != null) {
                row.getCell("seq").setValue((Object)new Integer(evaluTargetInfo.getSeqNumber()));
            }
            if (row.getCell("content") != null) {
                row.getCell("content").setValue((Object)evaluTargetInfo.getContent());
            }
            if (row.getCell("number") != null) {
                row.getCell("number").setValue((Object)evaluTargetInfo.getNumber());
            }
            if (row.getCell("description") != null) {
                row.getCell("description").setValue((Object)evaluTargetInfo.getDescription());
            }
            if (row.getCell("firstLevelTargetTypeWeight") != null && evaluTargetInfo.getFirstTypeWeight() != null) {
                row.getCell("firstLevelTargetTypeWeight").setValue((Object)evaluTargetInfo.getFirstTypeWeight().setScale(scaleForBigdecimal, 4));
            }
            if (row.getCell("firstLevelTargetTypeScore") != null && evaluTargetInfo.getFirstTypeScore() != null) {
                row.getCell("firstLevelTargetTypeScore").setValue((Object)evaluTargetInfo.getFirstTypeScore().setScale(0, 4));
            }
            if (row.getCell("secondLevelTargetTypeWeight") != null && evaluTargetInfo.getSecondTypeWeight() != null) {
                row.getCell("secondLevelTargetTypeWeight").setValue((Object)evaluTargetInfo.getSecondTypeWeight().setScale(scaleForBigdecimal, 4));
            }
            if (row.getCell("secondLevelTargetTypeScore") != null && evaluTargetInfo.getSecondTypeScore() != null) {
                row.getCell("secondLevelTargetTypeScore").setValue((Object)evaluTargetInfo.getSecondTypeScore().setScale(0, 4));
            }
            if (row.getCell("standard") != null) {
                row.getCell("standard").setValue((Object)evaluTargetInfo.getStandard());
            }
            if (row.getCell("weight") != null && targetEvaluStoreInfo.getWeight() != null) {
                row.getCell("weight").setValue((Object)targetEvaluStoreInfo.getWeight().setScale(scaleForBigdecimal, 4));
            }
            if (row.getCell("values") != null && targetEvaluStoreInfo.getValues() != null) {
                row.getCell("values").setValue((Object)targetEvaluStoreInfo.getValues().setScale(scaleForBigdecimal, 4));
            }
            if (row.getCell("kind") != null) {
                row.getCell("kind").setValue((Object)evaluTargetInfo.getKind());
                targetKind = evaluTargetInfo.getKind();
            }
            if (row.getCell("thresholdValue") != null && targetEvaluStoreInfo.getThresholdValue() != null) {
                this.setKindTypeCellValue(row.getCell("thresholdValue"), targetEvaluStoreInfo.getThresholdValue(), evaluTargetInfo);
            }
            if (row.getCell("standardValue") != null && targetEvaluStoreInfo.getStandardValue() != null) {
                this.setKindTypeCellValue(row.getCell("standardValue"), targetEvaluStoreInfo.getStandardValue(), evaluTargetInfo);
            }
            if (row.getCell("challengeValue") != null && targetEvaluStoreInfo.getChallengeValue() != null) {
                this.setKindTypeCellValue(row.getCell("challengeValue"), targetEvaluStoreInfo.getChallengeValue(), evaluTargetInfo);
            }
            if (evaluTargetInfo.getFormula() != null) {
                achieveDataInfo = this.getAchieveData(targetEvaluStoreInfo, iAchieveData);
                if (row.getCell("realValue") != null && achieveDataInfo != null && achieveDataInfo.getRealValue() != null) {
                    this.setKindTypeCellRealValue(row.getCell("realValue"), new BigDecimal(achieveDataInfo.getRealValue()), evaluTargetInfo);
                }
            } else if (row.getCell("realValue") != null && targetEvaluStoreInfo.getRealValue() != null) {
                this.setKindTypeCellRealValue(row.getCell("realValue"), new BigDecimal(targetEvaluStoreInfo.getRealValue()), evaluTargetInfo);
            }
            if (row.getCell("unit") != null) {
                row.getCell("unit").setValue((Object)evaluTargetInfo.getUnit());
            }
            if (row.getCell("reportFrequency") != null) {
                row.getCell("reportFrequency").setValue((Object)evaluTargetInfo.getReportFrequency());
            }
            if (row.getCell("scoringMethod") != null) {
                row.getCell("scoringMethod").setValue((Object)evaluTargetInfo.getScoringMethod());
            }
            if (row.getCell("evaluationSide") != null) {
                row.getCell("evaluationSide").setValue((Object)evaluTargetInfo.getEvaluationSide());
            }
            if (row.getCell("reservedField1") != null) {
                row.getCell("reservedField1").setValue((Object)evaluTargetInfo.getReservedField1());
            }
            if (row.getCell("reservedField2") != null) {
                row.getCell("reservedField2").setValue((Object)evaluTargetInfo.getReservedField2text());
            }
            if (row.getCell("reservedField3") != null) {
                row.getCell("reservedField3").setValue((Object)evaluTargetInfo.getReservedField3());
            }
            if (row.getCell("reservedField4") != null) {
                row.getCell("reservedField4").setValue((Object)evaluTargetInfo.getReservedField4());
            }
            if (row.getCell("reservedField5") != null) {
                row.getCell("reservedField5").setValue((Object)evaluTargetInfo.getReservedField5());
            }
            if (row.getCell("reservedField6") != null) {
                row.getCell("reservedField6").setValue((Object)evaluTargetInfo.getReservedField6());
            }
            if (row.getCell("reservedFieldNumber") != null && evaluTargetInfo.getReservedField2() != null) {
                int roundForThresholdValue = PerfContractTemplateDrawTableHelper.getRoundStyle(evaluTargetInfo.getPrecisionType() != null ? evaluTargetInfo.getPrecisionType() : PrecisionTypeEnum.ROUND);
                row.getCell("reservedFieldNumber").setValue((Object)evaluTargetInfo.getReservedField2().setScale(evaluTargetInfo.getDataPrecision(), roundForThresholdValue));
            }
            if (row.getCell("calFormula") != null) {
                row.getCell("calFormula").setValue((Object)evaluTargetInfo.getFormula());
            }
            if (row.getCell("type") != null) {
                row.getCell("type").setValue((Object)evaluTargetInfo.getType());
            }
            if (row.getCell("secondLevelTargetType") == null) continue;
            row.getCell("secondLevelTargetType").setValue((Object)evaluTargetInfo.getSecondType());
        }
        table.getStyleAttributes().setWrapText(true);
        EvaluFormSolutionMultiTableInfo tableInfo = (EvaluFormSolutionMultiTableInfo)table.getUserObject();
        if (tableInfo.isCalSumScore() && NodeProcesserHelper.containScoreColumn(table)) {
            row = table.addRow();
            row.getCell("id").setValue((Object)"scoreRow");
            row.getStyleAttributes().setLocked(true);
            row.getStyleAttributes().setBackground(PerfClientUtils.normalColor);
            int firstColumn = -1;
            int currentColumn = -1;
            IColumn column = null;
            int count = table.getColumnCount();
            for (int i = 0; i < count; ++i) {
                column = table.getColumn(i);
                if (column.getStyleAttributes().isHided()) continue;
                if (firstColumn == -1) {
                    firstColumn = column.getColumnIndex();
                    row.getCell(firstColumn).setValue((Object)"\u5c0f\u8ba1");
                }
                if (column.getKey().indexOf("score") != -1 || column.getKey().indexOf("rank") != -1 || column.getKey().indexOf("comment") != -1) break;
                currentColumn = i;
            }
            table.getMergeManager().mergeBlock(row.getRowIndex(), firstColumn, row.getRowIndex(), currentColumn);
        }
    }

    private void setKindTypeCellValue(ICell cell, BigDecimal value, EvaluTargetInfo evaluTargetInfo) {
        if (cell == null || value == null) {
            return;
        }
        KindEnum targetKind = evaluTargetInfo.getKind();
        int curRowdataPrecisionForthresholdValue = evaluTargetInfo.getDataPrecision();
        int roundForThresholdValue = PerfContractTemplateDrawTableHelper.getRoundStyle(evaluTargetInfo.getPrecisionType() != null ? evaluTargetInfo.getPrecisionType() : PrecisionTypeEnum.ROUND);
        if (KindEnum.QUANTITATIVE2.equals((Object)targetKind)) {
            value = value.multiply(new BigDecimal("100.00"));
            value = value.setScale(curRowdataPrecisionForthresholdValue, roundForThresholdValue);
        } else {
            value = value.setScale(curRowdataPrecisionForthresholdValue, roundForThresholdValue);
        }
        cell.setValue((Object)value);
    }

    private void setKindTypeCellRealValue(ICell cell, BigDecimal value, EvaluTargetInfo evaluTargetInfo) {
        if (cell == null || value == null) {
            return;
        }
        DataTypeEnum dataTypeEnum = evaluTargetInfo.getFormula().getAchieveItem().getDataType();
        int realValue = 2;
        if (evaluTargetInfo.getFormula() != null && evaluTargetInfo.getFormula().getAchieveItem() != null) {
            realValue = evaluTargetInfo.getFormula().getAchieveItem().getDataPrecision();
        }
        int roundForRealValue = PerfContractTemplateDrawTableHelper.getRoundStyle(evaluTargetInfo.getFormula() != null && evaluTargetInfo.getFormula().getAchieveItem() != null ? evaluTargetInfo.getFormula().getAchieveItem().getPrecisionType() : PrecisionTypeEnum.ROUND);
        if (DataTypeEnum.PERCENT.equals((Object)dataTypeEnum)) {
            value = value.multiply(new BigDecimal("100.00"));
            value = value.setScale(realValue, roundForRealValue);
            cell.setRenderer((IBasicRender)new PercentRender());
        } else {
            value = value.setScale(realValue, roundForRealValue);
            cell.setRenderer((IBasicRender)new ClearRender());
        }
        cell.setValue((Object)value);
    }

    @Override
    public Collection getWickedlyColumns() {
        return null;
    }

    private AchieveDataInfo getAchieveData(TargetEvaluStoreInfo targetEvaluStoreInfo, IAchieveData iAchieveData) {
        AchieveDataInfo info = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("target.id", (Object)targetEvaluStoreInfo.getEvaluTarget().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod", (Object)targetEvaluStoreInfo.getSolutionPeriod().getId().toString()));
        if (EvaluSolutionTypeEnum.ORGUNIT.equals((Object)targetEvaluStoreInfo.getSolutionPeriod().getEvaluSolution().getSolutionType())) {
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)targetEvaluStoreInfo.getEvaluObject().getObjectID()));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)targetEvaluStoreInfo.getEvaluObject().getObjectID()));
        }
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("realValue"));
        sic.add(new SelectorItemInfo("achieveItem.id"));
        sic.add(new SelectorItemInfo("achieveItem.dataType"));
        try {
            AchieveDataCollection coll = iAchieveData.getAchieveDataCollection(viewInfo);
            info = coll.get(0);
        }
        catch (BOSException e) {
            Logger.error((Throwable)e);
        }
        return info;
    }
}

