/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDScrollPane;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.Result;
import com.kingdee.eas.hr.perf.BatchEvaluProcessHelper;
import com.kingdee.eas.hr.perf.CommentEnum;
import com.kingdee.eas.hr.perf.EvaluDetailCollection;
import com.kingdee.eas.hr.perf.EvaluDetailInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryCollection;
import com.kingdee.eas.hr.perf.EvaluFormSolutionEntryInfo;
import com.kingdee.eas.hr.perf.EvaluFormSolutionMultiTableInfo;
import com.kingdee.eas.hr.perf.EvaluNodeInfo;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluObjectTypeEnum;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluResultInfo;
import com.kingdee.eas.hr.perf.EvaluRuleModeEnum;
import com.kingdee.eas.hr.perf.EvaluRuleTool;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.NodeProcesserCollection;
import com.kingdee.eas.hr.perf.NodeProcesserFactory;
import com.kingdee.eas.hr.perf.NodeProcesserInfo;
import com.kingdee.eas.hr.perf.NodeProcesserUtils;
import com.kingdee.eas.hr.perf.PerfSummaryFactory;
import com.kingdee.eas.hr.perf.PerfSummaryInfo;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.PrecisionMaintainInfo;
import com.kingdee.eas.hr.perf.PrecisionTypeEnum;
import com.kingdee.eas.hr.perf.ProcesserWorkedStateEnum;
import com.kingdee.eas.hr.perf.RankCollection;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.TargetData;
import com.kingdee.eas.hr.perf.TargetGradeModeEnum;
import com.kingdee.eas.hr.perf.client.EvalCommUI;
import com.kingdee.eas.hr.perf.client.EvaluFormSolutionView;
import com.kingdee.eas.hr.perf.client.EvaluViewSynResultUI;
import com.kingdee.eas.hr.perf.client.KDFormattedTextField1;
import com.kingdee.eas.hr.perf.client.MDEvalorResultReportUI;
import com.kingdee.eas.hr.perf.client.MDPersonFormUI;
import com.kingdee.eas.hr.perf.client.OrgEvaluResultReportUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.PerfDialogHelper;
import com.kingdee.eas.hr.perf.client.PerfSummaryEditUI;
import com.kingdee.eas.hr.perf.client.PersonalEvaluResultHistoryListUI;
import com.kingdee.eas.hr.perf.client.TargetAttachHelper;
import com.kingdee.eas.hr.perf.client.WorkPlanEditUI;
import com.kingdee.eas.hr.time.client.PerfViewAttendDataUI;
import com.kingdee.eas.hr.train.client.TrainUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;

public class NodeProcesserInputUI
extends EvaluFormSolutionView {
    private static final BigDecimal PERCENT = new BigDecimal("0.01");
    private static final String SCORE = "score";
    private static final String MAX = "max";
    private static final String MIN = "min";
    private static final String TARGETSCOREPRECISION = "grade";
    private static final String NODESCOREPRECISION = "node";
    private static final String TOTALSCOREPRECISION = "total";
    private KDTable totalTable = null;
    private KDFormattedTextField1 txtTotalScore = null;
    private Map txtComments = null;
    private KDTDefaultCellEditor targetRankEditor = null;
    private KDTDefaultCellEditor solutionRankEditor = null;
    private KDTDefaultCellEditor scoreEditor = null;
    private PrecisionMaintainInfo precisionMaintainInfo = null;
    private boolean refreshParent = false;
    private boolean isOnLoad = true;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.btnSetWidth.setVisible(false);
        this.setActionStatus();
        this.initData();
        this.isOnLoad = false;
    }

    private void setActionStatus() {
        boolean isOrg = EvaluSolutionTypeEnum.ORGUNIT.equals((Object)this.parameter.getEvaluSolutionType());
        this.actionSaveData.setVisible(true);
        this.menuItemSave.setVisible(true);
        this.actionSaveData.setEnabled(!OprtState.VIEW.equals(this.getOprtState()));
        this.actionAttachment.setVisible(true);
        this.actionTargetResult.setVisible(true);
        this.action360AuditResult.setVisible(true);
        this.action360Result.setVisible(true);
        this.actionSynResult.setVisible(true);
        this.actionWorkPlan.setVisible(true);
        this.actionPerfSummary.setVisible(true);
        this.actionAttendData.setVisible(!isOrg);
        this.actionViewReward.setVisible(!isOrg);
        this.actionViewKeyEvent.setVisible(!isOrg);
        if (isOrg) {
            this.btnWorkPlan.setText(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"viewOrgWorkPlan"));
            this.btnWorkPlan.setToolTipText(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"viewOrgWorkPlan"));
        }
    }

    private void initData() {
        EvaluRuleTool evaluRuleTool = this.getEvaluRuleTool();
        NodeProcesserCollection nodeProcesserCollection = this.parameter.getNodeProeceeserInfos();
        EvaluNodeInfo evaluNodeInfo = null;
        String columnKey = null;
        KDTable table = null;
        IRow row = null;
        int size = this.tables.size();
        for (int i = 0; i < size; ++i) {
            int j;
            table = (KDTable)this.tables.get(i);
            int count = table.getRowCount();
            for (j = 0; j < count; ++j) {
                row = table.getRow(j);
                if (this.isScoreRow(row)) continue;
                this.setTargetScore(table, j, evaluRuleTool);
            }
            count = nodeProcesserCollection.size();
            for (j = 0; j < count; ++j) {
                evaluNodeInfo = nodeProcesserCollection.get(j).getEvaluNode();
                columnKey = SCORE + evaluNodeInfo.getSeqNumber();
                this.setSubTotalScore(table, columnKey, evaluRuleTool);
                if (nodeProcesserCollection.get(j).getId() != null) continue;
                BigDecimal nodeScore = this.setNodeScore(columnKey, evaluRuleTool);
                this.setNodeRank(columnKey, nodeScore);
            }
        }
        this.setTotalScore();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        super.setButtonDefaultStyl(this.btnSaveData);
        this.btnSaveData.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btn360Result.setIcon(EASResource.getIcon((String)"imgTbtn_newdialog"));
        this.btn360AuditResult.setIcon(EASResource.getIcon((String)"imgTbtn_newdialog"));
        this.btnTargetResult.setIcon(EASResource.getIcon((String)"imgTbtn_distributelog"));
        this.btnSynResult.setIcon(EASResource.getIcon((String)"imgTbtn_newdialog"));
        this.btnViewReward.setIcon(EASResource.getIcon((String)"imgTbtn_hortationamerce"));
        this.btnViewKeyEvent.setIcon(EASResource.getIcon((String)"imgTbtn_hortationamerce"));
        this.btnViewAttendData.setIcon(EASResource.getIcon((String)"imgTbtn_newdialog"));
        this.btnPerfSummary.setIcon(EASResource.getIcon((String)"imgTbtn_subjectsetting"));
        this.menuItemSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
    }

    @Override
    protected void initParameters() throws Exception {
        super.initParameters();
        this.precisionMaintainInfo = PFUtils.getPrecisionMaintainInfo(this.parameter.getSolutionPeriodInfo().getEvaluSolution());
        if (this.precisionMaintainInfo == null) {
            this.precisionMaintainInfo = PFUtils.getDefaultPrecisionMaintainInfo();
        }
    }

    @Override
    protected Component addSubScoreComponent(int seq, int y) {
        return null;
    }

    @Override
    protected List createPanels() throws BOSException, EASBizException, Exception {
        List panels = super.createPanels();
        panels.add(this.initTotalPanel(this.parameter.getNodeProeceeserInfos()));
        panels.add(this.initCommentPanel(this.parameter.getNodeProeceeserInfos()));
        return panels;
    }

    private KDPanel initTotalPanel(NodeProcesserCollection nodeProcesserInfos) throws BOSException {
        if (nodeProcesserInfos == null || nodeProcesserInfos.isEmpty()) {
            return null;
        }
        KDPanel pnlTotalPanel = new KDPanel();
        pnlTotalPanel.setName("pnlTotalPanel");
        this.totalTable = this.createTotalTable();
        this.totalTable.getStyleAttributes().setLocked(OprtState.VIEW.equals(this.getOprtState()));
        int x = 10;
        int y = 0;
        int width = this.getBounds().width - 20;
        int height = 75;
        this.totalTable.setBounds(new Rectangle(x, y, width, height));
        KDLayout.Constraints cons = new KDLayout.Constraints();
        cons.originalBounds = new Rectangle(x, y, width, height);
        cons.anchor = 31;
        this.totalTable.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
        pnlTotalPanel.add((Component)this.totalTable);
        y += this.totalTable.getBounds().height + 3;
        TargetGradeModeEnum gradeMode = this.parameter.getSolutionPeriodInfo().getEvaluSolution().getTargetGradeMode();
        if (TargetGradeModeEnum.MANUAL_ENTER.equals((Object)gradeMode)) {
            KDLabelContainer cont = new KDLabelContainer();
            cont.setName("contTotalScore");
            cont.setBoundLabelLength(100);
            cont.setBoundLabelUnderline(true);
            cont.setBoundLabelText("\u8bc4\u4f30\u603b\u5206");
            cont.setToolTipText("\u8bc4\u4f30\u603b\u5206");
            width = 270;
            height = 19;
            x = 10;
            cons = new KDLayout.Constraints();
            cons.originalBounds = new Rectangle(x, y, width, height);
            cons.anchor = 5;
            cont.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
            this.txtTotalScore = new KDFormattedTextField1();
            this.txtTotalScore.setRemoveingZeroInDispaly(false);
            this.txtTotalScore.setPrecision(2);
            this.txtTotalScore.setDataType(1);
            this.txtTotalScore.setEnabled(false);
            cont.setBoundEditor((JComponent)((Object)this.txtTotalScore));
            pnlTotalPanel.add((Component)cont);
            y += height;
        }
        pnlTotalPanel.setBounds(new Rectangle(0, 0, this.getBounds().width, y));
        this.totalTable.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                NodeProcesserInputUI.this.table_editStarting(e);
            }
        });
        return pnlTotalPanel;
    }

    private KDTable createTotalTable() throws BOSException {
        KDTable table = new KDTable();
        IColumn column = table.addColumn();
        column.setKey("id");
        column.setWidth(50);
        column.getStyleAttributes().setHided(true);
        column = table.addColumn();
        column.setKey("name");
        column.setWidth(100);
        column.getStyleAttributes().setLocked(true);
        NodeProcesserCollection nodeProcesserInfos = this.parameter.getNodeProeceeserInfos();
        if (nodeProcesserInfos != null && !nodeProcesserInfos.isEmpty()) {
            String key = null;
            IRow headRow = table.addHeadRow();
            NodeProcesserInfo nodeProcesserInfo = null;
            int size = nodeProcesserInfos.size();
            for (int i = 0; i < size; ++i) {
                nodeProcesserInfo = nodeProcesserInfos.get(i);
                column = table.addColumn();
                key = SCORE + nodeProcesserInfo.getEvaluNode().getSeqNumber();
                column.setKey(key);
                column.setWidth(150);
                column.setEditor((ICellEditor)this.getSolutionRankEditor());
                column.getStyleAttributes().setNumberFormat(this.getScoreFormatString(TARGETSCOREPRECISION));
                headRow.getCell(key).setValue((Object)this.getSimpleNodeName(nodeProcesserInfo));
            }
        }
        return table;
    }

    private void table_editStarting(KDTEditEvent e) {
        KDTable table = (KDTable)e.getSource();
        Component component = table.getEditManager().getEditor().getComponent();
        if (component instanceof KDComboBox) {
            TrainUtils.setComboBoxSelected((KDComboBox)((KDComboBox)component), (KDTable)table, (int)e.getRowIndex(), (int)e.getColIndex());
        }
    }

    private KDPanel initCommentPanel(NodeProcesserCollection nodeProcesserInfos) {
        if (nodeProcesserInfos == null || nodeProcesserInfos.isEmpty()) {
            return null;
        }
        KDPanel pnlTotalPanel = new KDPanel();
        pnlTotalPanel.setName("pnlCommentPanel");
        int x = 10;
        int y = 0;
        int width = 30;
        int height = 19;
        KDLabel iconLabel = null;
        KDLabelContainer contNode = null;
        KDTextArea txtComment = null;
        KDScrollPane scrollPane = null;
        KDLayout.Constraints cons = null;
        NodeProcesserInfo nodeProcesserInfo = null;
        EvaluNodeInfo evaluNodeInfo = null;
        int size = nodeProcesserInfos.size();
        for (int i = 0; i < size; ++i) {
            nodeProcesserInfo = nodeProcesserInfos.get(i);
            evaluNodeInfo = nodeProcesserInfo.getEvaluNode();
            if (CommentEnum.noComment.equals((Object)evaluNodeInfo.getCanComment())) continue;
            x = 10;
            width = 30;
            height = 19;
            iconLabel = new KDLabel();
            iconLabel.setIcon(EASResource.getIcon((String)"imgTbtn_ymyjbj"));
            iconLabel.setBounds(new Rectangle(x, y, width, height));
            pnlTotalPanel.add((Component)iconLabel, (Object)new KDLayout.Constraints(x, y, width, height, 13));
            x = 30;
            width = 500;
            contNode = new KDLabelContainer();
            contNode.setBoundLabelText(this.getNodeName(nodeProcesserInfo));
            contNode.setBounds(new Rectangle(x, y, width, height));
            pnlTotalPanel.add((Component)contNode, (Object)new KDLayout.Constraints(x, y, width, height, 13));
            x = 10;
            width = this.getBounds().width - 20;
            height = 100;
            scrollPane = new KDScrollPane();
            scrollPane.setBounds(new Rectangle(x, y += contNode.getBounds().height + 3, width, height));
            cons = new KDLayout.Constraints();
            cons.originalBounds = new Rectangle(x, y, width, height);
            cons.anchor = 31;
            scrollPane.putClientProperty((Object)"KDLayoutConstraints", (Object)cons);
            pnlTotalPanel.add((Component)scrollPane);
            txtComment = new KDTextArea();
            txtComment.setName("txtComment" + i);
            txtComment.setText(nodeProcesserInfo.getComment());
            txtComment.setMaxLength(1000);
            boolean required = false;
            if (CommentEnum.mandatoryComment.equals((Object)evaluNodeInfo.getCanComment())) {
                required = true;
            } else if (CommentEnum.optionalComment.equals((Object)evaluNodeInfo.getCanComment())) {
                required = false;
            }
            txtComment.setRequired(required);
            txtComment.setEnabled(!OprtState.VIEW.equals(this.getOprtState()));
            if (this.txtComments == null) {
                this.txtComments = new HashMap();
            }
            this.txtComments.put(String.valueOf(evaluNodeInfo.getSeqNumber()), txtComment);
            scrollPane.getViewport().add((Component)txtComment, null);
            y += scrollPane.getBounds().height + 3;
        }
        pnlTotalPanel.setBounds(new Rectangle(0, 0, this.getBounds().width, y));
        return pnlTotalPanel;
    }

    private String getSimpleNodeName(NodeProcesserInfo info) {
        EvaluNodeInfo nodeInfo = info.getEvaluNode();
        StringBuffer name = new StringBuffer();
        name.append("[");
        name.append(nodeInfo.getNodeName());
        name.append("] ");
        if (info.getEvalRank() != null || info.getNodeScore() != null || info.getEvaluResult().getTargetEvaluScore() != null || info.getEvaluResult().getPerfRank() != null) {
            name.append(info.getEvaluer());
        }
        if (nodeInfo.isNodeVisible() && nodeInfo.getWeight() != null) {
            name.append(" ");
            name.append(new DecimalFormat("0.00").format(nodeInfo.getWeight()));
            name.append("%");
        }
        return name.toString();
    }

    private String getNodeName(NodeProcesserInfo nodeProcesserInfo) {
        EvaluNodeInfo node = nodeProcesserInfo.getEvaluNode();
        StringBuffer sb = new StringBuffer();
        sb.append("[");
        sb.append(node.getNodeName());
        sb.append("]");
        sb.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)NODESCOREPRECISION));
        sb.append("  ");
        if (nodeProcesserInfo.getEvalRank() != null || nodeProcesserInfo.getNodeScore() != null || nodeProcesserInfo.getEvaluResult().getTargetEvaluScore() != null || nodeProcesserInfo.getEvaluResult().getPerfRank() != null) {
            sb.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"opratePerson"));
            sb.append(":");
            sb.append(nodeProcesserInfo.getEvaluer());
        }
        if (node != null && node.isNodeVisible() && node.getWeight() != null) {
            sb.append("(");
            sb.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"weight"));
            sb.append(":");
            sb.append(new DecimalFormat("0.00").format(node.getWeight()));
            sb.append("%");
            sb.append(")");
        }
        return sb.toString();
    }

    @Override
    protected void afterCreateTable(KDTable table) {
        super.afterCreateTable(table);
        try {
            this.appendScoreColumn(table);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        table.addKDTEditListener((KDTEditListener)new KDTEditAdapter(){

            public void editStarting(KDTEditEvent e) {
                NodeProcesserInputUI.this.table_editStarting(e);
            }
        });
        table.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent e) {
                NodeProcesserInputUI.this.table_propertyChange(e);
            }
        });
        table.addKDTMouseListener(new KDTMouseListener(){

            public void tableClicked(KDTMouseEvent e) {
                NodeProcesserInputUI.this.table_mouseClick(e);
            }
        });
    }

    private void appendScoreColumn(KDTable table) throws Exception {
        NodeProcesserCollection nodeProcesserInfos = this.parameter.getNodeProeceeserInfos();
        if (nodeProcesserInfos == null || nodeProcesserInfos.isEmpty()) {
            return;
        }
        IRow firstHeadRow = table.getHeadRow(0);
        IRow secondHeadRow = table.addHeadRow();
        KDTMergeManager mergeManager = table.getHeadMergeManager();
        int count = table.getColumnCount();
        for (int i = 0; i < count; ++i) {
            secondHeadRow.getCell(i).setValue(firstHeadRow.getCell(i).getValue());
            mergeManager.mergeBlock(0, i, 1, i);
        }
        String headName = null;
        String columnName = null;
        NodeProcesserInfo nodeProcesserInfo = null;
        int size = nodeProcesserInfos.size();
        for (int i = 0; i < size; ++i) {
            nodeProcesserInfo = nodeProcesserInfos.get(i);
            EvaluNodeInfo evaluNodeInfo = nodeProcesserInfo.getEvaluNode();
            headName = this.getSimpleNodeName(nodeProcesserInfo);
            EvaluFormSolutionEntryCollection entryCollection = this.getEvaluFormSolutionEntryCollection(table);
            columnName = this.getFirstColumnName(entryCollection);
            if (SCORE.equals(columnName)) {
                this.appendScoreColumn(table, evaluNodeInfo, headName);
                this.appendTargetCommentColumn(table, evaluNodeInfo, headName, entryCollection);
                continue;
            }
            this.appendTargetCommentColumn(table, evaluNodeInfo, headName, entryCollection);
            this.appendScoreColumn(table, evaluNodeInfo, headName);
        }
    }

    private String getFirstColumnName(EvaluFormSolutionEntryCollection entryCollection) {
        EvaluFormSolutionEntryInfo entryInfo = null;
        String code = null;
        int size = entryCollection.size();
        for (int i = 0; i < size && !"targetComm".equalsIgnoreCase(code = (entryInfo = entryCollection.get(i)).getCode()) && !SCORE.equalsIgnoreCase(code); ++i) {
        }
        return code;
    }

    private void appendScoreColumn(KDTable table, EvaluNodeInfo evaluNodeInfo, String headName) throws Exception {
        EvaluFormSolutionMultiTableInfo tableInfo = (EvaluFormSolutionMultiTableInfo)table.getUserObject();
        if (!tableInfo.isCompute()) {
            return;
        }
        int width = 150;
        if (evaluNodeInfo.isCanTargetComment()) {
            width = 80;
        }
        IColumn column = null;
        String key = null;
        TargetGradeModeEnum gradeMode = this.parameter.getSolutionPeriodInfo().getEvaluSolution().getTargetGradeMode();
        IRow firstHeadRow = table.getHeadRow(0);
        IRow secondHeadRow = table.getHeadRow(1);
        if (TargetGradeModeEnum.MANUAL_ENTER.equals((Object)gradeMode)) {
            column = table.addColumn();
            key = SCORE + evaluNodeInfo.getSeqNumber();
            column.setKey(key);
            column.setWidth(width);
            column.setEditor((ICellEditor)this.getScoreEditor());
            column.getStyleAttributes().setNumberFormat(this.getScoreFormatString(TARGETSCOREPRECISION));
            firstHeadRow.getCell(key).setValue((Object)headName);
            secondHeadRow.getCell(key).setValue((Object)"\u8bc4\u5206");
        } else if (TargetGradeModeEnum.RANK_GROUP.equals((Object)gradeMode)) {
            column = table.addColumn();
            key = "rank" + evaluNodeInfo.getSeqNumber();
            column.setKey(key);
            column.setWidth(width);
            column.setEditor((ICellEditor)this.getTargetRankEditor());
            firstHeadRow.getCell(key).setValue((Object)headName);
            secondHeadRow.getCell(key).setValue((Object)"\u7b49\u7ea7");
        }
        if (!evaluNodeInfo.isCanGrade()) {
            column.getStyleAttributes().setLocked(true);
            column.getStyleAttributes().setBackground(Color.LIGHT_GRAY);
        } else {
            column.setRequired(true);
        }
    }

    private void appendTargetCommentColumn(KDTable table, EvaluNodeInfo evaluNodeInfo, String headName, EvaluFormSolutionEntryCollection entryCollection) {
        if (!evaluNodeInfo.isCanTargetComment()) {
            return;
        }
        IColumn column = table.addColumn();
        String key = "comment" + evaluNodeInfo.getSeqNumber();
        column.setKey(key);
        column.setWidth(100);
        column.getStyleAttributes().setLocked(true);
        column.setRequired(true);
        table.getHeadRow(0).getCell(key).setValue((Object)headName);
        table.getHeadRow(1).getCell(key).setValue((Object)this.getCommentName(entryCollection));
    }

    private EvaluFormSolutionEntryCollection getEvaluFormSolutionEntryCollection(KDTable table) {
        EvaluFormSolutionMultiTableInfo multiTableInfo = (EvaluFormSolutionMultiTableInfo)table.getUserObject();
        Map multiTableSettingMap = this.parameter.getMultiTableSettingMap();
        return (EvaluFormSolutionEntryCollection)((Object)multiTableSettingMap.get(multiTableInfo.getId().toString()));
    }

    private String getCommentName(EvaluFormSolutionEntryCollection entryCollection) {
        EvaluFormSolutionEntryInfo entryInfo = null;
        String name = null;
        int size = entryCollection.size();
        for (int i = 0; i < size; ++i) {
            entryInfo = entryCollection.get(i);
            if (!"targetComm".equalsIgnoreCase(entryInfo.getCode())) continue;
            name = !StringUtils.isEmpty((String)entryInfo.getAlias()) ? entryInfo.getAlias() : entryInfo.getName();
            break;
        }
        if (StringUtils.isEmpty(name)) {
            name = "\u6307\u6807\u8bc4\u8bed";
        }
        return name;
    }

    private KDTDefaultCellEditor getScoreEditor() throws Exception {
        if (this.scoreEditor == null) {
            KDFormattedTextField1 scoreTextField = new KDFormattedTextField1();
            scoreTextField.setDataType(1);
            if (this.precisionMaintainInfo != null) {
                scoreTextField.setPrecision(this.precisionMaintainInfo.getIndexGradePrecision());
                if (PrecisionTypeEnum.ROUND.equals((Object)this.precisionMaintainInfo.getIndexGradePrecisionType())) {
                    scoreTextField.setRoundingMode(4);
                } else if (PrecisionTypeEnum.CARRY.equals((Object)this.precisionMaintainInfo.getIndexGradePrecisionType())) {
                    scoreTextField.setRoundingMode(0);
                } else if (PrecisionTypeEnum.TRUNCATE.equals((Object)this.precisionMaintainInfo.getIndexGradePrecisionType())) {
                    scoreTextField.setRoundingMode(1);
                }
            } else {
                scoreTextField.setPrecision(2);
                scoreTextField.setRoundingMode(4);
            }
            scoreTextField.setRemoveingZeroInDispaly(false);
            scoreTextField.setRemoveingZeroInEdit(false);
            this.scoreEditor = new KDTDefaultCellEditor((JTextField)((Object)scoreTextField));
        }
        return this.scoreEditor;
    }

    private KDTDefaultCellEditor getTargetRankEditor() throws BOSException {
        if (this.targetRankEditor == null) {
            KDComboBox comboBox = new KDComboBox();
            RankCollection targetRanks = this.getRankCollection(this.parameter.getSolutionPeriodInfo().getEvaluSolution().getTargetRankGroup().getId().toString());
            comboBox.addItems(targetRanks.toArray());
            this.targetRankEditor = new KDTDefaultCellEditor((JComboBox)comboBox);
        }
        return this.targetRankEditor;
    }

    private KDTDefaultCellEditor getSolutionRankEditor() throws BOSException {
        if (this.solutionRankEditor == null) {
            KDComboBox comboBox = new KDComboBox();
            RankCollection targetRanks = this.getRankCollection(this.parameter.getSolutionPeriodInfo().getEvaluSolution().getRankGroup().getId().toString());
            comboBox.addItems(targetRanks.toArray());
            this.solutionRankEditor = new KDTDefaultCellEditor((JComboBox)comboBox);
        }
        return this.solutionRankEditor;
    }

    private RankCollection getRankCollection(String rankGroupId) throws BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo(TARGETSCOREPRECISION));
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("serial"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)rankGroupId));
        viewInfo.setFilter(filter);
        RankCollection targetRanks = RankFactory.getRemoteInstance().getRankCollection(viewInfo);
        return targetRanks;
    }

    private void table_propertyChange(KDTPropertyChangeEvent e) {
        if (this.isOnLoad) {
            return;
        }
        KDTable table = (KDTable)e.getSource();
        int colIndex = e.getColIndex();
        String columnKey = table.getColumn(colIndex).getKey();
        String id = (String)table.getRow(e.getRowIndex()).getCell("id").getValue();
        if (!StringUtils.isEmpty((String)id) && id.indexOf("scoreRow") != -1) {
            return;
        }
        if (columnKey.indexOf(SCORE) != -1) {
            EvaluRuleTool evaluRuleTool = this.getEvaluRuleTool();
            this.setTargetScore(table, e.getRowIndex(), evaluRuleTool);
            this.setSubTotalScore(table, columnKey, evaluRuleTool);
            BigDecimal nodeScore = this.setNodeScore(columnKey, evaluRuleTool);
            this.setNodeRank(columnKey, nodeScore);
            this.setTotalScore();
        }
    }

    private BigDecimal setSubTotalScore(KDTable table, String columnKey, EvaluRuleTool evaluRuleTool) {
        List targetDatas = this.assembleTargetDatas(table, columnKey);
        BigDecimal nodeScore = evaluRuleTool.countTotalScore(targetDatas);
        nodeScore = this.setScorePrecision(nodeScore, this.precisionMaintainInfo, TARGETSCOREPRECISION);
        IRow scoreRow = this.getSubScoreRow(table);
        if (scoreRow != null) {
            scoreRow.getCell(columnKey).setValue((Object)nodeScore);
        }
        return nodeScore;
    }

    private BigDecimal setNodeScore(String columnKey, EvaluRuleTool evaluRuleTool) {
        BigDecimal nodeScore = null;
        IRow scoreRow = this.getSubScoreRow(this.totalTable);
        if (scoreRow != null && scoreRow.getCell(columnKey) != null) {
            List targetDatas = this.getTargetDatas(columnKey);
            nodeScore = evaluRuleTool.countTotalScore(targetDatas);
            nodeScore = this.setScorePrecision(nodeScore, this.precisionMaintainInfo, TARGETSCOREPRECISION);
            scoreRow.getCell(columnKey).setValue((Object)nodeScore);
        }
        return nodeScore;
    }

    private IRow getSubScoreRow(KDTable table) {
        return this.getRowById(table, "scoreRow");
    }

    private IRow getRowById(KDTable table, String value) {
        IRow row = null;
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = table.getRow(i);
            if (!value.equalsIgnoreCase((String)row.getCell("id").getValue())) continue;
            return row;
        }
        return null;
    }

    private RankInfo setNodeRank(String columnKey, BigDecimal nodeScore) {
        RankInfo rankInfo = null;
        IRow rankRow = this.getSubRankRow(this.totalTable);
        if (rankRow != null && rankRow.getCell(columnKey) != null) {
            EvaluSolutionInfo evaluSolutionInfo = this.parameter.getSolutionPeriodInfo().getEvaluSolution();
            GradeModeInfo gradeModeInfo = this.getTargetGrade(evaluSolutionInfo);
            rankInfo = BatchEvaluProcessHelper.convertTotalScoreToRank(evaluSolutionInfo.getGradeMode(), gradeModeInfo, nodeScore, evaluSolutionInfo.getRankConvertRule());
            if (rankInfo != null) {
                rankRow.getCell(columnKey).setValue((Object)rankInfo);
            }
        }
        return rankInfo;
    }

    private IRow getSubRankRow(KDTable table) {
        return this.getRowById(table, "rankRow");
    }

    private GradeModeInfo getTargetGrade(EvaluSolutionInfo evaluSolutionInfo) {
        GradeModeInfo gradeModeInfo = evaluSolutionInfo.getTargetGradeModeLink();
        if (gradeModeInfo == null) {
            gradeModeInfo = new GradeModeInfo();
            BigDecimal max = evaluSolutionInfo.getTotalScore();
            if (max == null) {
                max = new BigDecimal("100");
            }
            gradeModeInfo.setMaxGrade(max);
            gradeModeInfo.setMinGrade(PerfUtils.ZERO);
        }
        return gradeModeInfo;
    }

    private void setTotalScore() {
        if (this.txtTotalScore != null) {
            BigDecimal totalScore = this.setScorePrecision(this.getTotalScore(), this.precisionMaintainInfo, TOTALSCOREPRECISION);
            this.txtTotalScore.setValue(totalScore);
        }
    }

    private void setTargetScore(KDTable table, int rowIndex, EvaluRuleTool evaluRuleTool) {
        if (table.getColumn("evalutargetScore") == null && table.getColumn("targetWeightedScore") == null) {
            return;
        }
        IRow row = table.getRow(rowIndex);
        BigDecimal score = this.computeScore(row, this.parameter.getSolutionPeriodInfo().getEvaluSolution().isDeduction());
        score = this.setScorePrecision(score, this.precisionMaintainInfo, TARGETSCOREPRECISION);
        int columnIndex = table.getColumnIndex("evalutargetScore");
        if (columnIndex != -1) {
            row.getCell(columnIndex).setValue((Object)score);
        }
        if ((columnIndex = table.getColumnIndex("targetWeightedScore")) != -1) {
            TargetData targetData = this.assembleTagetData(row, null);
            targetData.setScore(score);
            score = evaluRuleTool.countWeightedScore(targetData);
            if ("com.kingdee.eas.hr.perf.EvaluRuleToolConcreteThree".equals(evaluRuleTool.getClass().getName()) || "com.kingdee.eas.hr.perf.EvaluRuleToolConcreteFour".equals(evaluRuleTool.getClass().getName())) {
                score = null;
            }
            row.getCell(columnIndex).setValue((Object)this.setScorePrecision(score, this.precisionMaintainInfo, TARGETSCOREPRECISION));
        }
    }

    private String showEvalCommUI(KDTable table, String oprtState, String value) {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"0", (Object)value);
        try {
            IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EvalCommUI.class.getName(), (Map)uiContext, null, oprtState);
            uiWindow.show();
            EvalCommUI ui = (EvalCommUI)uiWindow.getUIObject();
            value = ui.getComment();
        }
        catch (UIException e) {
            this.handleException((Exception)((Object)e));
        }
        return value;
    }

    private int getTargetCommentHeight(String targetComment, int columnWidth) {
        int rowCharSize;
        byte[] bytes = targetComment.getBytes();
        int rowSize = bytes.length / (2 * (rowCharSize = columnWidth / 18)) + 1;
        if (rowSize < 10) {
            return 18 * rowSize;
        }
        return 180;
    }

    private void table_mouseClick(KDTMouseEvent e) {
        if (e.getType() != 1) {
            return;
        }
        KDTable table = (KDTable)e.getSource();
        int colIndex = e.getColIndex();
        String columnKey = table.getColumn(colIndex).getKey();
        IRow row = table.getRow(e.getRowIndex());
        String id = (String)row.getCell("id").getValue();
        if (!"scoreRow".equalsIgnoreCase(id) && columnKey.indexOf("comment") != -1) {
            String oprtState = table.isEditable() ? OprtState.EDIT : OprtState.VIEW;
            String comment = (String)table.getRow(e.getRowIndex()).getCell(colIndex).getValue();
            comment = this.showEvalCommUI(table, oprtState, comment);
            if (OprtState.VIEW.equals(oprtState)) {
                return;
            }
            table.getRow(e.getRowIndex()).getCell(e.getColIndex()).setValue((Object)comment);
            int columnWidth = table.getColumn(e.getColIndex()).getWidth();
            if (columnWidth > 0) {
                int height = 20;
                if (!StringUtils.isEmpty((String)comment)) {
                    int tableHeight;
                    int commentHeight = this.getTargetCommentHeight(comment, columnWidth);
                    if (commentHeight < (tableHeight = table.getHeight() - table.getHead().getHeight() * 2)) {
                        table.getRow(e.getRowIndex()).setHeight(commentHeight);
                        height = commentHeight;
                    } else {
                        height = tableHeight;
                    }
                }
                table.getRow(e.getRowIndex()).setHeight(height);
            }
        }
    }

    private BigDecimal setScorePrecision(BigDecimal score, PrecisionMaintainInfo precisionInfo, String type) {
        if (score == null) {
            return null;
        }
        int precision = 0;
        PrecisionTypeEnum PrecisionType = null;
        if (TARGETSCOREPRECISION.equals(type)) {
            precision = this.precisionMaintainInfo.getIndexGradePrecision();
            PrecisionType = this.precisionMaintainInfo.getIndexGradePrecisionType();
        } else if (NODESCOREPRECISION.equals(type)) {
            precision = this.precisionMaintainInfo.getNodeScorePrecision();
            PrecisionType = this.precisionMaintainInfo.getNodeScorePrecisionType();
        } else {
            precision = this.precisionMaintainInfo.getTotalPrecision();
            PrecisionType = this.precisionMaintainInfo.getTotalPrecisionType();
        }
        if (precisionInfo != null) {
            if (PrecisionTypeEnum.ROUND.equals((Object)PrecisionType)) {
                score = score.setScale(precision, 4);
            } else if (PrecisionTypeEnum.CARRY.equals((Object)PrecisionType)) {
                score = score.setScale(precision, 0);
            } else if (PrecisionTypeEnum.TRUNCATE.equals((Object)PrecisionType)) {
                score = score.setScale(precision, 1);
            }
        } else {
            score = score.setScale(2, 4);
        }
        return score;
    }

    private String getScoreFormatString(String type) {
        int precision = 0;
        String formatString = null;
        if (this.precisionMaintainInfo != null) {
            precision = TARGETSCOREPRECISION.equals(type) ? this.precisionMaintainInfo.getIndexGradePrecision() : (NODESCOREPRECISION.equals(type) ? this.precisionMaintainInfo.getNodeScorePrecision() : this.precisionMaintainInfo.getTotalPrecision());
            StringBuffer sb = new StringBuffer();
            sb.append("0.");
            for (int i = 0; i < precision; ++i) {
                sb.append("0");
            }
            formatString = sb.toString();
        } else {
            formatString = "0.00";
        }
        return formatString;
    }

    private EvaluRuleTool getEvaluRuleTool() {
        try {
            return NodeProcesserUtils.getEvaluRuleTool(this.parameter.getSolutionPeriodInfo().getEvaluSolution());
        }
        catch (Exception e) {
            this.handleException(e);
            return null;
        }
    }

    private List getTargetDatas(String columnKey) {
        ArrayList targetDatas = new ArrayList();
        List items = null;
        int size = this.tables.size();
        for (int i = 0; i < size; ++i) {
            items = this.assembleTargetDatas((KDTable)this.tables.get(i), columnKey);
            if (items == null) continue;
            targetDatas.addAll(items);
        }
        return targetDatas;
    }

    private List assembleTargetDatas(KDTable table, String columnKey) {
        EvaluFormSolutionMultiTableInfo tableInfo = (EvaluFormSolutionMultiTableInfo)table.getUserObject();
        if (!tableInfo.isCompute()) {
            return null;
        }
        ArrayList<TargetData> targetDatas = new ArrayList<TargetData>();
        IRow row = null;
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = table.getRow(i);
            if (((String)row.getCell("id").getValue()).indexOf("scoreRow") != -1) continue;
            targetDatas.add(this.assembleTagetData(table.getRow(i), columnKey));
        }
        return targetDatas;
    }

    private TargetData assembleTagetData(IRow row, String scoreColumnName) {
        TargetData targetData = new TargetData();
        if (row.getCell("firstLevelTargetTypeWeight") != null && row.getCell("firstLevelTargetTypeWeight").getValue() != null) {
            targetData.setTypeWeight(PERCENT.multiply((BigDecimal)row.getCell("firstLevelTargetTypeWeight").getValue()));
        }
        if (row.getCell("weight") != null && row.getCell("weight").getValue() != null) {
            targetData.setWeight(PERCENT.multiply((BigDecimal)row.getCell("weight").getValue()));
        }
        if (row.getCell(scoreColumnName) != null) {
            BigDecimal score = this.getTargetScore(row, scoreColumnName);
            targetData.setScore(score);
        }
        return targetData;
    }

    private BigDecimal getTargetScore(IRow row, String scoreColumnName) {
        BigDecimal score = null;
        if (row.getCell(scoreColumnName) != null) {
            score = (BigDecimal)row.getCell(scoreColumnName).getValue();
        }
        if (score == null) {
            score = PerfClientUtils.ZERO;
        }
        if (this.isScoreRow(row)) {
            return score;
        }
        EvaluSolutionInfo evaluSolutionInfo = this.parameter.getSolutionPeriodInfo().getEvaluSolution();
        if (evaluSolutionInfo.isDeduction()) {
            BigDecimal values = null;
            if (EvaluRuleModeEnum.WEIGHT_MODE.equals((Object)evaluSolutionInfo.getEvaluRule().getRuleMode())) {
                values = evaluSolutionInfo.getTargetGradeModeLink().getMaxGrade();
            } else if (row.getCell("values") != null) {
                values = (BigDecimal)row.getCell("values").getValue();
            }
            if (values != null) {
                score = values.add(score);
            }
        }
        return score;
    }

    private BigDecimal getTotalScore() {
        IRow scoreRow = this.getSubScoreRow(this.totalTable);
        if (scoreRow == null) {
            return null;
        }
        return this.computeScore(scoreRow, false);
    }

    private BigDecimal computeScore(IRow scoreRow, boolean deduction) {
        BigDecimal totalScore = PerfClientUtils.ZERO;
        BigDecimal score = null;
        BigDecimal weight = null;
        EvaluNodeInfo evaluNodeInfo = null;
        String columnKey = null;
        NodeProcesserCollection nodeProcesserCollection = this.parameter.getNodeProeceeserInfos();
        int size = nodeProcesserCollection.size();
        for (int i = 0; i < size; ++i) {
            evaluNodeInfo = nodeProcesserCollection.get(i).getEvaluNode();
            columnKey = SCORE + evaluNodeInfo.getSeqNumber();
            weight = evaluNodeInfo.getWeight().multiply(PERCENT);
            score = this.getTargetScore(scoreRow, columnKey);
            totalScore = this.parameter.getSolutionPeriodInfo().getEvaluSolution().getAllocateTarget() == 2 ? totalScore.add(score) : totalScore.add(score.multiply(weight));
        }
        return totalScore;
    }

    @Override
    protected void afterFillTable(KDTable table) {
        super.afterFillTable(table);
        Map evaluNodeMap = this.getEvaluNodeMap(this.parameter.getNodeProeceeserInfos());
        this.fillNodeData(table, evaluNodeMap);
    }

    private Map getEvaluNodeMap(NodeProcesserCollection nodeProcesserInfos) {
        if (nodeProcesserInfos == null || nodeProcesserInfos.isEmpty()) {
            return null;
        }
        HashMap<String, Map> evaluNodeMap = new HashMap<String, Map>();
        Map evaluDetailMap = null;
        NodeProcesserInfo info = null;
        int size = nodeProcesserInfos.size();
        for (int i = 0; i < size; ++i) {
            info = nodeProcesserInfos.get(i);
            evaluDetailMap = this.getEvaluDetailMap(info.getEvaluDetails());
            evaluNodeMap.put(String.valueOf(info.getEvaluNode().getSeqNumber()), evaluDetailMap);
        }
        return evaluNodeMap;
    }

    private Map getEvaluDetailMap(EvaluDetailCollection evaluDetails) {
        HashMap<String, EvaluDetailInfo> evaluDetailMap = new HashMap<String, EvaluDetailInfo>();
        EvaluDetailInfo evaluDetailInfo = null;
        String targetEvaluStoreId = null;
        int size = evaluDetails.size();
        for (int i = 0; i < size; ++i) {
            evaluDetailInfo = evaluDetails.get(i);
            targetEvaluStoreId = evaluDetailInfo.getTargetEvaluStore().getId().toString();
            evaluDetailMap.put(targetEvaluStoreId, evaluDetailInfo);
        }
        return evaluDetailMap;
    }

    private void fillNodeData(KDTable table, Map evaluNodeMap) {
        IRow row = null;
        String targetEvaluStoreId = null;
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = table.getRow(i);
            if (this.isScoreRow(row)) continue;
            targetEvaluStoreId = (String)row.getCell("id").getValue();
            this.fillRow(row, targetEvaluStoreId, evaluNodeMap);
        }
    }

    private boolean isScoreRow(IRow row) {
        String id = (String)row.getCell("id").getValue();
        return "scoreRow".equalsIgnoreCase(id);
    }

    private void fillRow(IRow row, String targetEvaluStoreId, Map evaluNodeMap) {
        ICell cell = null;
        String nodeSeq2 = null;
        Map evaluDetailMap = null;
        EvaluDetailInfo evaluDetailInfo = null;
        for (String nodeSeq2 : evaluNodeMap.keySet()) {
            evaluDetailMap = (Map)evaluNodeMap.get(nodeSeq2);
            evaluDetailInfo = (EvaluDetailInfo)evaluDetailMap.get(targetEvaluStoreId);
            if (evaluDetailInfo == null) continue;
            cell = row.getCell(SCORE + nodeSeq2);
            if (cell != null && !Color.LIGHT_GRAY.equals(cell.getStyleAttributes().getBackground())) {
                cell.setValue((Object)evaluDetailInfo.getTargetScore());
            }
            if ((cell = row.getCell("rank" + nodeSeq2)) != null && !Color.LIGHT_GRAY.equals(cell.getStyleAttributes().getBackground())) {
                cell.setValue((Object)evaluDetailInfo.getRank());
            }
            if ((cell = row.getCell("comment" + nodeSeq2)) == null || Color.LIGHT_GRAY.equals(cell.getStyleAttributes().getBackground())) continue;
            cell.setValue((Object)evaluDetailInfo.getComment());
        }
    }

    private Map getNodeProcesserMap(NodeProcesserCollection nodeProcesserInfos) {
        if (nodeProcesserInfos == null || nodeProcesserInfos.isEmpty()) {
            return null;
        }
        HashMap<String, NodeProcesserInfo> nodeProcesserMap = new HashMap<String, NodeProcesserInfo>();
        NodeProcesserInfo info = null;
        int size = nodeProcesserInfos.size();
        for (int i = 0; i < size; ++i) {
            info = nodeProcesserInfos.get(i);
            nodeProcesserMap.put(String.valueOf(info.getEvaluNode().getSeqNumber()), info);
        }
        return nodeProcesserMap;
    }

    @Override
    protected void fillDataToUI() {
        super.fillDataToUI();
        this.lblTitle.setText(this.parameter.getSolutionPeriodInfo().getFormTitle());
        this.fillTotalAndCommentData(this.parameter.getNodeProeceeserInfos());
        this.setTotalScore();
    }

    private void fillTotalAndCommentData(NodeProcesserCollection nodeProcesserInfos) {
        Map nodeProcesserMap;
        boolean hasScore = false;
        if (TargetGradeModeEnum.MANUAL_ENTER.equals((Object)this.parameter.getSolutionPeriodInfo().getEvaluSolution().getTargetGradeMode())) {
            int size = nodeProcesserInfos.size();
            for (int i = 0; i < size; ++i) {
                if (!nodeProcesserInfos.get(i).getEvaluNode().isCanGrade()) continue;
                hasScore = true;
                break;
            }
        }
        IRow scoreRow = null;
        if (hasScore) {
            scoreRow = this.totalTable.addRow();
            scoreRow.getStyleAttributes().setLocked(true);
            scoreRow.getCell("id").setValue((Object)"scoreRow");
            scoreRow.getCell("name").setValue((Object)"\u5408\u8ba1");
        }
        boolean hasRank = false;
        int size = nodeProcesserInfos.size();
        for (int i = 0; i < size; ++i) {
            if (!nodeProcesserInfos.get(i).getEvaluNode().isCanEvaluateLevel()) continue;
            hasRank = true;
            break;
        }
        IRow rankRow = null;
        if (hasRank) {
            rankRow = this.totalTable.addRow();
            rankRow.getCell("id").setValue((Object)"rankRow");
            rankRow.getCell("name").setValue((Object)"\u7ee9\u6548\u7b49\u7ea7");
        }
        if ((nodeProcesserMap = this.getNodeProcesserMap(nodeProcesserInfos)) == null) {
            return;
        }
        int columnIndex = -1;
        String nodeSeq2 = null;
        KDTextArea txtComment = null;
        NodeProcesserInfo nodeProcesserInfo = null;
        for (String nodeSeq2 : nodeProcesserMap.keySet()) {
            nodeProcesserInfo = (NodeProcesserInfo)nodeProcesserMap.get(nodeSeq2);
            columnIndex = this.totalTable.getColumnIndex(SCORE + nodeSeq2);
            this.totalTable.getColumn(columnIndex).getStyleAttributes().setNumberFormat(this.getScoreFormatString(NODESCOREPRECISION));
            if (columnIndex < 0) continue;
            if (scoreRow != null) {
                scoreRow.getCell(columnIndex).setValue((Object)this.setScorePrecision(nodeProcesserInfo.getNodeScore(), this.precisionMaintainInfo, NODESCOREPRECISION));
            }
            if (rankRow != null) {
                rankRow.getCell(columnIndex).setValue((Object)nodeProcesserInfo.getRank());
            }
            if (this.txtComments == null) {
                this.txtComments = new HashMap();
            }
            if ((txtComment = (KDTextArea)this.txtComments.get(nodeSeq2)) == null) continue;
            txtComment.setText(nodeProcesserInfo.getComment());
        }
    }

    @Override
    public void actionSaveData_actionPerformed(ActionEvent e) throws Exception {
        this.storeFields();
        this.verifyInput();
        this.saveNodeProcesser();
        this.saveEvaluResultData();
        MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"saveDataOK"));
        this.setRefreshParent(true);
    }

    @Override
    public void storeFields() {
        super.storeFields();
        KDTable table2 = null;
        Map evaluNodeMap = this.getEvaluNodeMap(this.parameter.getNodeProeceeserInfos());
        for (KDTable table2 : this.tables) {
            this.storeTableField(table2, evaluNodeMap);
        }
        this.storeTotalAndCommentField(this.parameter.getNodeProeceeserInfos());
    }

    private void storeTableField(KDTable table, Map evaluNodeMap) {
        IRow row = null;
        String targetEvaluStoreId = null;
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            row = table.getRow(i);
            if (this.isScoreRow(row)) continue;
            targetEvaluStoreId = (String)row.getCell("id").getValue();
            this.storeRowField(row, targetEvaluStoreId, evaluNodeMap);
        }
    }

    private void storeRowField(IRow row, String targetEvaluStoreId, Map evaluNodeMap) {
        ICell cell = null;
        String nodeSeq2 = null;
        Map evaluDetailMap = null;
        EvaluDetailInfo evaluDetailInfo = null;
        for (String nodeSeq2 : evaluNodeMap.keySet()) {
            evaluDetailMap = (Map)evaluNodeMap.get(nodeSeq2);
            evaluDetailInfo = (EvaluDetailInfo)evaluDetailMap.get(targetEvaluStoreId);
            cell = row.getCell(SCORE + nodeSeq2);
            if (cell != null) {
                evaluDetailInfo.setTargetScore((BigDecimal)cell.getValue());
            }
            if ((cell = row.getCell("rank" + nodeSeq2)) != null) {
                evaluDetailInfo.setRank((RankInfo)cell.getValue());
            }
            if ((cell = row.getCell("comment" + nodeSeq2)) == null) continue;
            evaluDetailInfo.setComment((String)cell.getValue());
        }
    }

    private void storeTotalAndCommentField(NodeProcesserCollection nodeProcesserInfos) {
        Map nodeProcesserMap = this.getNodeProcesserMap(nodeProcesserInfos);
        if (nodeProcesserMap == null) {
            return;
        }
        IRow scoreRow = this.getSubScoreRow(this.totalTable);
        IRow rankRow = this.getSubRankRow(this.totalTable);
        int columnIndex = -1;
        String nodeSeq2 = null;
        KDTextArea txtComment = null;
        NodeProcesserInfo nodeProcesserInfo = null;
        for (String nodeSeq2 : nodeProcesserMap.keySet()) {
            nodeProcesserInfo = (NodeProcesserInfo)nodeProcesserMap.get(nodeSeq2);
            columnIndex = this.totalTable.getColumnIndex(SCORE + nodeSeq2);
            if (columnIndex < 0) continue;
            if (scoreRow != null) {
                nodeProcesserInfo.setNodeScore((BigDecimal)scoreRow.getCell(columnIndex).getValue());
            }
            if (rankRow != null) {
                nodeProcesserInfo.setRank((RankInfo)rankRow.getCell(columnIndex).getValue());
            }
            if ((txtComment = (KDTextArea)this.txtComments.get(nodeSeq2)) == null) continue;
            nodeProcesserInfo.setComment(txtComment.getText());
        }
    }

    private void verifyInput() {
        this.checkScore();
    }

    private void checkScore() {
        EvaluSolutionInfo evaluSolutionInfo = this.parameter.getSolutionPeriodInfo().getEvaluSolution();
        if (TargetGradeModeEnum.RANK_GROUP.equals((Object)evaluSolutionInfo.getTargetCreateMode())) {
            return;
        }
        boolean isOutGradeMode = false;
        isOutGradeMode = evaluSolutionInfo.isOutGradeMode();
        ArrayList datas = new ArrayList();
        NodeProcesserCollection nodeProcesserCollection = this.parameter.getNodeProeceeserInfos();
        NodeProcesserInfo nodeProcesserInfo = null;
        int size = nodeProcesserCollection.size();
        for (int i = 0; i < size; ++i) {
            nodeProcesserInfo = nodeProcesserCollection.get(i);
            datas.addAll(this.getEvaluDetailData(nodeProcesserInfo.getEvaluDetails(), evaluSolutionInfo));
        }
        BigDecimal score = null;
        Map item = null;
        int size2 = datas.size();
        for (int i = 0; i < size2; ++i) {
            item = (Map)datas.get(i);
            score = (BigDecimal)item.get(SCORE);
            if (score == null) continue;
            if (!isOutGradeMode && score.compareTo((BigDecimal)item.get(MAX)) > 0) {
                MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"gradeUPIllegal") + PFVerifyUtils.formatBigDecimal((BigDecimal)item.get(MAX), 2)));
                SysUtil.abort();
                continue;
            }
            if (isOutGradeMode || score.compareTo((BigDecimal)item.get(MIN)) >= 0) continue;
            MsgBox.showInfo((String)(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"gradeDownIllegal") + PFVerifyUtils.formatBigDecimal((BigDecimal)item.get(MIN), 2)));
            SysUtil.abort();
        }
    }

    private List getEvaluDetailData(EvaluDetailCollection collection, EvaluSolutionInfo evaluSolutionInfo) {
        ArrayList datas = new ArrayList();
        HashMap<String, BigDecimal> data = null;
        EvaluDetailInfo detailInfo = null;
        BigDecimal values = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            detailInfo = collection.get(i);
            data = new HashMap<String, BigDecimal>();
            data.put(SCORE, detailInfo.getTargetScore());
            if (EvaluRuleModeEnum.WEIGHT_MODE.equals((Object)evaluSolutionInfo.getEvaluRule().getRuleMode())) {
                BigDecimal max = evaluSolutionInfo.getTargetGradeModeLink().getMaxGrade();
                BigDecimal min = evaluSolutionInfo.getTargetGradeModeLink().getMinGrade();
                data.put(MAX, max);
                if (!evaluSolutionInfo.isDeduction()) {
                    data.put(MIN, min);
                } else {
                    data.put(MIN, PerfClientUtils.ZERO.subtract(max));
                }
            } else if (EvaluRuleModeEnum.SCORE_MODE.equals((Object)evaluSolutionInfo.getEvaluRule().getRuleMode())) {
                values = detailInfo.getTargetEvaluStore().getValues();
                if (values == null) {
                    values = PerfClientUtils.ZERO;
                    continue;
                }
                data.put(MAX, values);
                if (!evaluSolutionInfo.isDeduction()) {
                    data.put(MIN, PerfClientUtils.ZERO);
                } else {
                    data.put(MIN, PerfClientUtils.ZERO.subtract(values));
                }
            }
            datas.add(data);
        }
        return datas;
    }

    private void saveNodeProcesser() throws BOSException, EASBizException {
        CoreBaseCollection collection = this.handleNodeProcesser(this.parameter.getNodeProeceeserInfos());
        Result result = NodeProcesserFactory.getRemoteInstance().save(collection);
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            collection.get(i).setId(BOSUuid.read((String)result.getLineResult(i).getPk().toString()));
        }
    }

    private CoreBaseCollection handleNodeProcesser(NodeProcesserCollection nodeProeceeserInfos) {
        CoreBaseCollection collection = new CoreBaseCollection();
        NodeProcesserInfo info = null;
        int size = nodeProeceeserInfos.size();
        for (int i = 0; i < size; ++i) {
            info = nodeProeceeserInfos.get(i);
            if (info.getWorkedState() == null) {
                info.setWorkedState(ProcesserWorkedStateEnum.NOTSUBMIT);
            }
            collection.add((CoreBaseInfo)info);
        }
        return collection;
    }

    private void saveEvaluResultData() throws EASBizException, BOSException {
        int seq = -1;
        NodeProcesserInfo info = null;
        EvaluResultInfo evaluResultInfo = null;
        NodeProcesserCollection nodeProeceeserInfos = this.parameter.getNodeProeceeserInfos();
        int size = nodeProeceeserInfos.size();
        for (int i = 0; i < size; ++i) {
            info = nodeProeceeserInfos.get(i);
            if (info.getEvaluNode().getSeqNumber() <= seq) continue;
            seq = info.getEvaluNode().getSeqNumber();
            if (evaluResultInfo == null) {
                evaluResultInfo = info.getEvaluResult();
            }
            evaluResultInfo.setPerfRank(info.getRank());
        }
        BigDecimal totalScore = null;
        if (this.txtTotalScore != null) {
            totalScore = this.txtTotalScore.getBigDecimalValue();
        }
        if (totalScore != null && evaluResultInfo != null) {
            EvaluSolutionInfo evaluSolutionInfo = this.parameter.getSolutionPeriodInfo().getEvaluSolution();
            GradeModeInfo gradeModeInfo = this.getTargetGrade(evaluSolutionInfo);
            evaluResultInfo.setEvaluateSum(BatchEvaluProcessHelper.convertTotalScore(evaluSolutionInfo.getGradeMode(), gradeModeInfo, totalScore));
            evaluResultInfo.setTargetEvaluScore(evaluResultInfo.getEvaluateSum());
        }
        if (evaluResultInfo != null) {
            EvaluResultFactory.getRemoteInstance().update((IObjectPK)new ObjectUuidPK(evaluResultInfo.getId().toString()), (CoreBaseInfo)evaluResultInfo);
        }
    }

    private void setRefreshParent(boolean refreshParent) {
        this.refreshParent = refreshParent;
    }

    public boolean isRefreshParent() {
        return this.refreshParent;
    }

    @Override
    public void action360Result_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"personID", (Object)this.parameter.getEvaluPersonId());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MDPersonFormUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void action360AuditResult_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"personID", (Object)this.parameter.getEvaluPersonId());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MDEvalorResultReportUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionSynResult_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"personID", (Object)this.parameter.getEvaluPersonId());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(EvaluViewSynResultUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionTargetResult_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        String uiName = null;
        if (EvaluSolutionTypeEnum.ORGUNIT.equals((Object)this.parameter.getEvaluSolutionType())) {
            Map values = (Map)this.parameter.getHeadData().get("values");
            uiContext.put((Object)"orgUnitID", values.get("orgId"));
            uiName = OrgEvaluResultReportUI.class.getName();
        } else {
            uiContext.put((Object)"evalor", (Object)this.parameter.getEvaluPersonId());
            uiContext.put((Object)"evaluObjectType", (Object)EvaluObjectTypeEnum.PERSON);
            uiName = PersonalEvaluResultHistoryListUI.class.getName();
        }
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(uiName, (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionViewReward_actionPerformed(ActionEvent e) throws Exception {
        PerfDialogHelper.viewReward((IUIObject)this, this.parameter.getEvaluPersonId());
    }

    @Override
    public void actionViewKeyEvent_actionPerformed(ActionEvent e) throws Exception {
        PerfDialogHelper.viewKeyEvent((IUIObject)this, this.parameter.getEvaluPersonId());
    }

    @Override
    public void actionWorkPlan_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext();
        SelectorItemCollection coll = new SelectorItemCollection();
        PersonInfo person = new PersonInfo();
        if (EvaluSolutionTypeEnum.ORGUNIT.equals((Object)this.parameter.getEvaluSolutionType())) {
            coll.add(new SelectorItemInfo("responser.id"));
            coll.add(new SelectorItemInfo("responser.name"));
            coll.add(new SelectorItemInfo("responser.number"));
            EvaluObjectInfo info = EvaluObjectFactory.getRemoteInstance().getEvaluObjectInfo((IObjectPK)new ObjectUuidPK(this.parameter.getEvaluObjectId()), coll);
            person = info.getResponser();
        } else {
            coll.add(new SelectorItemInfo("id"));
            coll.add(new SelectorItemInfo("name"));
            coll.add(new SelectorItemInfo("number"));
            person = PersonFactory.getRemoteInstance().getPersonInfo((IObjectPK)new ObjectUuidPK(this.parameter.getEvaluPersonId()), coll);
        }
        uiContext.put((Object)"person", (Object)person);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(WorkPlanEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionAttendData_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"personId", (Object)this.parameter.getEvaluPersonId());
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PerfViewAttendDataUI.class.getName(), (Map)uiContext);
        uiWindow.show();
    }

    @Override
    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
        String solutionPeriodID = this.parameter.getSolutionPeriodInfo().getId().toString();
        String evaluObjectID = this.parameter.getEvaluObjectId();
        String id = TargetAttachHelper.getTargetAttachId(solutionPeriodID, evaluObjectID);
        boolean flag = !OprtState.VIEW.equals(this.getOprtState());
        acm.showAttachmentListUIByBoID(id, (Object)this, flag);
    }

    @Override
    public void actionPerfSummary_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getPefSummaryID();
        if (StringUtils.isEmpty((String)id)) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"noPerfSummary"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(PerfSummaryEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    private String getPefSummaryID() throws BOSException {
        PerfSummaryInfo perfSummaryInfo = null;
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("assessPeriod.id", (Object)this.parameter.getSolutionPeriodInfo().getAssessPeriod().getId().toString(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.parameter.getEvaluPersonId(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        CoreBaseCollection psColl = PerfSummaryFactory.getRemoteInstance().getCollection(viewInfo);
        if (psColl != null && psColl.size() > 0) {
            perfSummaryInfo = (PerfSummaryInfo)psColl.get(0);
            return perfSummaryInfo.getId().toString();
        }
        return null;
    }

    @Override
    protected Set getWickedlyColumnSet() {
        HashSet<String> wickedlyColumnSet_temp = new HashSet<String>();
        wickedlyColumnSet_temp.add("creator");
        wickedlyColumnSet_temp.add("creatorPosition");
        wickedlyColumnSet_temp.add("calFormula");
        wickedlyColumnSet_temp.add(SCORE);
        wickedlyColumnSet_temp.add("targetComm");
        return wickedlyColumnSet_temp;
    }
}

