/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.common.util.StringUtil;
import com.kingdee.bos.ctrl.swing.CtrlPlainDocument;
import com.kingdee.bos.ctrl.swing.DecimalFormatEx;
import com.kingdee.bos.ctrl.swing.KDInvalidValueException;
import com.kingdee.eas.hr.perf.client.KDFormattedTextField1;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.text.Document;
import javax.swing.text.NumberFormatter;

public class NumberFormatterEx1
extends NumberFormatter {
    private static final long serialVersionUID = 1626491247126121564L;
    private boolean isRemoveingZero = false;
    private int precision = 0;
    private int roundingMode = 4;
    private boolean isSupportedEmpty = false;
    private KDFormattedTextField1 ftf = null;

    public NumberFormatterEx1() {
    }

    public NumberFormatterEx1(NumberFormat format) {
        super(format);
    }

    @Override
    public void install(JFormattedTextField ftf) {
        Document document;
        if (ftf != null && ftf instanceof KDFormattedTextField1) {
            this.ftf = (KDFormattedTextField1)((Object)ftf);
        }
        if (ftf.hasFocus() && (document = ftf.getDocument()) != null && document instanceof CtrlPlainDocument) {
            ((CtrlPlainDocument)document).setFocusing(true);
            Format format = this.getFormat();
            if (format instanceof DecimalFormat) {
                String patter = ((DecimalFormat)format).toPattern();
                patter = patter.replaceAll("#", "");
                String valStr = ((CtrlPlainDocument)document).getCtrTextDocumentFilter().getValidateStr();
                ((CtrlPlainDocument)document).getCtrTextDocumentFilter().setValidateStr(patter + valStr);
            }
        }
        super.install(ftf);
    }

    @Override
    public void uninstall() {
        super.uninstall();
    }

    @Override
    public String valueToString(Object obj) throws ParseException {
        String val = "";
        val = this.valueToString2(obj);
        if (!this.isRemoveingZero()) {
            val = this.repairingStrByPrecision(val, this.getDecimalPrecision());
        }
        return val;
    }

    public String valueToString2(Object value) throws ParseException {
        if (value == null) {
            return "";
        }
        Format f = this.getFormat();
        if (f == null) {
            return value.toString();
        }
        if (this.ftf != null && this.ftf instanceof KDFormattedTextField1 && this.ftf.getDataType() == 1) {
            return ((DecimalFormatEx)f).formatBigDecimal(new BigDecimal(value.toString()).setScale(this.ftf.getPrecision(), this.ftf.getRoundingMode()));
        }
        return f.format(value);
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        ParseException pEx = null;
        try {
            String newValue = text;
            char decimalSeparator = ((DecimalFormatEx)this.getFormat()).getDecimalFormatSymbols().getDecimalSeparator();
            if (this.isRemoveingZero() && text != null && text.length() > 0 && text.indexOf(String.valueOf(decimalSeparator)) != -1) {
                newValue = new String(this.removeTrailZero(new StringBuffer(text)));
            }
            if (this.ftf != null && this.ftf instanceof KDFormattedTextField1 && this.ftf.getDataVerifierType() == 12) {
                newValue = this.repairingStrByPrecision(newValue, this.getDecimalPrecision());
            }
            Object obj = this.stringToValue2(newValue);
            try {
                return new BigDecimal(obj.toString()).setScale(this.getDecimalPrecision(), this.ftf.getRoundingMode());
            }
            catch (Exception e) {
                throw new ParseException("can not new a BigDecimal", 0);
            }
        }
        catch (ParseException ex) {
            pEx = ex;
            if (this.isSupportedEmpty() && text != null && text.trim().length() == 0) {
                return null;
            }
            throw pEx;
        }
    }

    public Object stringToValue2(String text) throws ParseException {
        Format f = this.getFormat();
        if (f == null) {
            return text;
        }
        Object value = null;
        value = this.ftf != null && this.ftf instanceof KDFormattedTextField1 && this.ftf.getDataType() == 1 ? ((DecimalFormatEx)f).parseBigDecimal(text) : f.parseObject(text);
        try {
            if (!this.isValidValue(value)) {
                throw new KDInvalidValueException("Value not within min/max range", 0);
            }
        }
        catch (ClassCastException cce) {
            throw new ParseException("Class cast exception comparing values: " + cce, 0);
        }
        this.convertValueToValueClass2(value, this.getValueClass());
        return value;
    }

    private String repairingStrByPrecision(String str, int precision) {
        char decimalSeparator = ((DecimalFormatEx)this.getFormat()).getDecimalFormatSymbols().getDecimalSeparator();
        char zero = ((DecimalFormatEx)this.getFormat()).getDecimalFormatSymbols().getZeroDigit();
        if (str != null && str.length() > 0 && str.indexOf(String.valueOf(decimalSeparator)) != -1 && !StringUtil.isPercentStr((String)str)) {
            StringBuffer sb = new StringBuffer(20);
            precision = precision < 0 ? 0 : precision;
            int dotIndex = str.lastIndexOf(String.valueOf(decimalSeparator));
            String preStr = str.substring(0, dotIndex);
            String nextStr = str.substring(dotIndex + 1);
            int nextStrLen = nextStr.length();
            if (nextStrLen == precision) {
                return str;
            }
            if (nextStrLen > precision) {
                str = (nextStr = nextStr.substring(0, precision)).length() > 0 ? sb.append(preStr).append(decimalSeparator).append(nextStr).toString() : sb.append(preStr).toString();
            } else {
                int interval = precision - nextStrLen;
                sb.append(str);
                for (int i = 0; i < interval; ++i) {
                    sb.append(zero);
                }
                str = sb.toString();
            }
        }
        return str;
    }

    private Object convertValueToValueClass2(Object value, Class valueClass) {
        if (valueClass != null && value instanceof Number) {
            if (valueClass == Integer.class) {
                return new Integer(((Number)value).intValue());
            }
            if (valueClass == Long.class) {
                return new Long(((Number)value).longValue());
            }
            if (valueClass == Float.class) {
                return new Float(((Number)value).floatValue());
            }
            if (valueClass == Double.class) {
                return new Double(((Number)value).doubleValue());
            }
            if (valueClass == Byte.class) {
                return new Byte(((Number)value).byteValue());
            }
            if (valueClass == Short.class) {
                return new Short(((Number)value).shortValue());
            }
        }
        return value;
    }

    boolean isValidValue(Object value) {
        Comparable<?> min = this.getMinimum();
        Comparable<?> max = this.getMaximum();
        boolean isNegatived = true;
        if (this.ftf != null && this.ftf instanceof KDFormattedTextField1) {
            isNegatived = this.ftf.isNegatived();
        }
        if (value == null) {
            return true;
        }
        if (min instanceof BigDecimal && max instanceof BigDecimal && value instanceof BigDecimal) {
            BigDecimal zero;
            BigDecimal nmin = (BigDecimal)min;
            BigDecimal nmax = (BigDecimal)max;
            BigDecimal v = (BigDecimal)value;
            if (!isNegatived && v.compareTo(zero = new BigDecimal(BigInteger.valueOf(0L))) < 0) {
                return false;
            }
            return v.compareTo(nmax) <= 0 && v.compareTo(nmin) >= 0;
        }
        if (min instanceof Number && max instanceof Number && value instanceof Number) {
            Number nmin = (Number)((Object)min);
            Number v = (Number)value;
            Number nmax = (Number)((Object)max);
            if (!isNegatived && v.doubleValue() < 0.0) {
                return false;
            }
            return !(v.doubleValue() > nmax.doubleValue()) && !(v.doubleValue() < nmin.doubleValue());
        }
        return this.isValidValue2(value, true);
    }

    boolean isValidValue2(Object value, boolean wantsCCE) {
        Comparable<?> min = this.getMinimum();
        try {
            if (min != null && min.compareTo(value) > 0) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            if (wantsCCE) {
                throw cce;
            }
            return false;
        }
        Comparable<?> max = this.getMaximum();
        try {
            if (max != null && max.compareTo(value) < 0) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            if (wantsCCE) {
                throw cce;
            }
            return false;
        }
        return true;
    }

    @Override
    protected void invalidEdit() {
        super.invalidEdit();
    }

    public boolean isRemoveingZero() {
        return this.isRemoveingZero;
    }

    public void setRemoveingZero(boolean newValue) {
        this.isRemoveingZero = newValue;
    }

    public void setDecimalPrecision(int newValue) {
        this.precision = newValue;
    }

    public int getDecimalPrecision() {
        return this.precision;
    }

    public void setRoundingMode(int newValue) {
        this.roundingMode = newValue;
    }

    public int getRoundingMode() {
        return this.roundingMode;
    }

    public void setSupportedEmpty(boolean newValue) {
        this.isSupportedEmpty = newValue;
    }

    public boolean isSupportedEmpty() {
        return this.isSupportedEmpty;
    }

    private StringBuffer removeTrailZero(String s) {
        StringBuffer sb = new StringBuffer(s);
        return this.removeTrailZero(sb);
    }

    StringBuffer removeTrailZero(StringBuffer sb) {
        int dotIndex = sb.indexOf(".");
        if (dotIndex != -1) {
            int index = this.findNotZeroDigitLastIndex(sb, dotIndex);
            sb = index != -1 ? sb.delete(index + 1, sb.length()) : sb.delete(dotIndex, sb.length());
        }
        return sb;
    }

    private int findNotZeroDigitLastIndex(StringBuffer sb, int dotIndex) {
        int lastIndex = -1;
        for (int i = dotIndex + 1; i < sb.length(); ++i) {
            if (!this.isNotZeroDigits(sb.charAt(i))) continue;
            lastIndex = i;
        }
        return lastIndex;
    }

    private boolean isNotZeroDigits(char c) {
        return c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9';
    }
}

