/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.AchieveStatisticsPeriodInfo;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.OrgKeyEventCollection;
import com.kingdee.eas.hr.perf.OrgKeyEventFactory;
import com.kingdee.eas.hr.perf.OrgKeyEventInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.AbstractOrgEvaluResultListUI;
import com.kingdee.eas.hr.perf.client.EvaluResultOrgModifyEditUI;
import com.kingdee.eas.hr.perf.client.HistoryOrgKeyEventListUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgEvaluResultListUI
extends AbstractOrgEvaluResultListUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgEvaluResultListUI.class);

    @Override
    public void actionPerfSummary_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EvaluResultFactory.getRemoteInstance();
    }

    @Override
    protected String getEditUIName() {
        return EvaluResultOrgModifyEditUI.class.getName();
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        PerfClientUtils.checkValidHRO((CoreUI)this);
        this.actionPerfSummary.setEnabled(false);
        this.menuItemPerfSummary.setVisible(false);
        this.tblMain.getColumn("cmpPeriod.name").getStyleAttributes().setHided(true);
        this.btnVerdictAllCmpPeriod.setVisible(false);
        this.btnVerdictAllCmpPeriod.setEnabled(false);
        this.btnCountTotalKeyEventGrade.setEnabled(false);
        this.btnViewKeyEvents.setEnabled(false);
        this.tblMain.getColumn("modifyCause").getStyleAttributes().setWrapText(true);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    @Override
    protected Map getResourceMap() {
        HashMap<String, String> resourceMap = new HashMap<String, String>();
        resourceMap.put("resultIsLittle", EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"orgUnitlResultIsLittle"));
        return resourceMap;
    }

    @Override
    protected EvaluSolutionTypeEnum getSolutionType() {
        return EvaluSolutionTypeEnum.ORGUNIT;
    }

    @Override
    public boolean isPrepareActionConvert() {
        return true;
    }

    @Override
    public boolean isPrepareActionEdit() {
        return true;
    }

    public boolean isPrepareActionView() {
        return true;
    }

    @Override
    public boolean isPrepareActionViewNodeProcess() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public boolean isPrepareActionQuery() {
        return true;
    }

    @Override
    protected int getNDType() {
        return 1;
    }

    @Override
    protected void prmptSolutionPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmptSolutionPeriod_dataChanged(e);
        SolutionPeriodInfo info = (SolutionPeriodInfo)this.prmptSolutionPeriod.getValue();
        if (info != null) {
            this.btnCountTotalKeyEventGrade.setEnabled(info.getEvaluSolution().isKeyEvent());
            this.btnViewKeyEvents.setEnabled(info.getEvaluSolution().isKeyEvent());
        }
    }

    @Override
    public void actionCalKeyEventScore_actionPerformed(ActionEvent e) throws Exception {
        SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)this.prmptSolutionPeriod.getValue();
        AchieveStatisticsPeriodInfo keyEventPeriod = solutionPeriodInfo.getKeyEventPeriod();
        if (keyEventPeriod == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"notDate"));
            return;
        }
        Date startTime = keyEventPeriod.getStartDate();
        Date endTime = keyEventPeriod.getEndDate();
        IRow row = null;
        HashMap<String, String> unitResult = new HashMap<String, String>();
        String unitId = null;
        String evaluResultId = null;
        boolean isAudit = false;
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int count = rows.length;
        for (int j = 0; j < count; ++j) {
            row = this.tblMain.getRow(rows[j]);
            unitId = row.getCell("AdminOrgUnit.id").getValue().toString();
            evaluResultId = row.getCell("id").getValue().toString();
            isAudit = (Boolean)row.getCell("isApproved").getValue();
            if (isAudit) continue;
            unitResult.put(unitId, evaluResultId);
        }
        HashSet unitIdSet = new HashSet();
        unitIdSet.addAll(unitResult.keySet());
        if (unitIdSet.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"auditedNotkey"));
            SysUtil.abort();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("eventStartDate", (Object)startTime, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("eventEndDate", (Object)endTime, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("adminOrgUnit", unitIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("adminOrgUnit"));
        viewInfo.getSelector().add(new SelectorItemInfo("grade"));
        OrgKeyEventCollection coll = OrgKeyEventFactory.getRemoteInstance().getOrgKeyEventCollection(viewInfo);
        if (coll == null || coll.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"noKeyEvent"));
            SysUtil.abort();
        }
        OrgKeyEventInfo info = null;
        HashMap mapcoll = new HashMap();
        HashMap<String, Object> entry = null;
        HashSet<String> keyEventSet = null;
        BigDecimal sumScore = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            unitId = info.getAdminOrgUnit().getId().toString();
            entry = (HashMap<String, Object>)mapcoll.get(unitId);
            if (entry == null) {
                entry = new HashMap<String, Object>();
                mapcoll.put(unitId, entry);
            }
            if ((sumScore = (BigDecimal)entry.get("sumScore")) == null) {
                sumScore = new BigDecimal("0.00000000");
            }
            if (info.getGrade() != null) {
                sumScore = sumScore.add(info.getGrade());
            }
            entry.put("sumScore", sumScore);
            keyEventSet = (HashSet<String>)entry.get("keyEvent");
            if (keyEventSet == null) {
                keyEventSet = new HashSet<String>();
                entry.put("keyEvent", keyEventSet);
            }
            keyEventSet.add(info.getId().toString());
            evaluResultId = (String)entry.get("evaluResult");
            if (evaluResultId != null) continue;
            evaluResultId = (String)unitResult.get(unitId);
            entry.put("evaluResult", evaluResultId);
        }
        if (mapcoll.size() > 0) {
            this.handleSumScorePrecesion(mapcoll);
            EvaluResultFactory.getRemoteInstance().updateKeyEventScore(mapcoll, 1);
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"keyScoreAssers"));
            this.refreshList();
        }
    }

    @Override
    public void actionKeyEventHistory_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int[] index = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(index[0]);
        String id = (String)row.getCell("id").getValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(HistoryOrgKeyEventListUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    public void onGetRowSet(IRowSet rowSet) {
        SolutionPeriodInfo info = (SolutionPeriodInfo)this.prmptSolutionPeriod.getValue();
        super.onGetRowSet(rowSet);
        if (info != null && info.getEvaluSolution() != null && info.getEvaluSolution().getTargetGradeMode() != null && info.getEvaluSolution().getTargetGradeMode().getValue() == 101) {
            try {
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    rowSet.updateString("evaluateSum", "");
                    rowSet.updateString("targetEvaluScore", "");
                    rowSet.updateString("modifiedScore", "");
                }
                rowSet.beforeFirst();
            }
            catch (Exception ex) {
                super.handleException(ex);
            }
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        if (rows.length > 0) {
            IRow row = this.tblMain.getRow(rows[0]);
            String isApproved = row.getCell("isApproved").getValue().toString();
            if (!"true".equals(isApproved)) {
                this.actionAudit.setEnabled(true);
                this.actionAntiAudit.setEnabled(false);
            } else {
                this.actionAudit.setEnabled(false);
                this.actionAntiAudit.setEnabled(true);
            }
        }
        super.tblMain_tableClicked(e);
    }
}

