/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.client.f7.AdminByCurrentHROF7WithOrgRangeFilter;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.KeyEventTypeEnum;
import com.kingdee.eas.hr.perf.OrgKeyEventFactory;
import com.kingdee.eas.hr.perf.OrgKeyEventInfo;
import com.kingdee.eas.hr.perf.PlanFreqTypeException;
import com.kingdee.eas.hr.perf.client.AbstractOrgKeyEventEditUI;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Date;
import org.apache.log4j.Logger;

public class OrgKeyEventEditUI
extends AbstractOrgKeyEventEditUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgKeyEventEditUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (this.prmtAdminOrgUnit.getData() == null) {
            throw new PlanFreqTypeException(PlanFreqTypeException.ORG_KEYEVENT_NOT_ORG);
        }
        if (this.pkEventStartDate.getValue() == null) {
            throw new PlanFreqTypeException(PlanFreqTypeException.PERSON_KEYEVENT_NO_STARTDATE);
        }
        if (this.pkEventEndDate.getValue() == null) {
            throw new PlanFreqTypeException(PlanFreqTypeException.PERSON_KEYEVENT_NO_ENDDATE);
        }
        if (this.pkEventStartDate.getValue() != null && this.pkEventEndDate.getValue() != null && DateTimeUtils.dayAfter((Date)((Date)this.pkEventStartDate.getValue()), (Date)((Date)this.pkEventEndDate.getValue()))) {
            this.pkEventStartDate.requestFocusInWindow();
            throw new PlanFreqTypeException(PlanFreqTypeException.PERSON_KEYEVENT_NO_ERROR_DATE);
        }
        this.verifyGrade();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.prmtAdminOrgUnit.setQueryInfo("com.kingdee.eas.basedata.org.app.AdminOrgUnitQuery");
        this.prmtAdminOrgUnit.setCommitFormat("$number$");
        this.prmtAdminOrgUnit.setEditFormat("$number$");
        this.prmtAdminOrgUnit.setDisplayFormat("$name$");
        this.prmtAdminOrgUnit.setHasCUDefaultFilter(false);
        this.prmtAdminOrgUnit.setEditable(false);
        this.prmtAdminOrgUnit.setSelector((KDPromptSelector)new AdminByCurrentHROF7WithOrgRangeFilter());
        if (this.getUIContext().get("STATUES") != null) {
            this.btnAddNew.setEnabled(false);
            this.btnCopy.setEnabled(false);
            this.btnSubmit.setEnabled(false);
            this.btnRemove.setEnabled(false);
            this.btnEdit.setEnabled(false);
        }
    }

    protected IObjectValue createNewData() {
        OrgKeyEventInfo keyInfo = new OrgKeyEventInfo();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        keyInfo.setFounder(userInfo.getPerson());
        keyInfo.setRecordDate(DateTimeUtils.truncateDate((Date)new Date()));
        keyInfo.setKeyEventType(KeyEventTypeEnum.PROMOTIVE);
        return keyInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OrgKeyEventFactory.getRemoteInstance();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("adminOrgUnit.*"));
        return sic;
    }

    private void verifyGrade() {
        KeyEventTypeEnum selectItem = (KeyEventTypeEnum)((Object)this.comboKeyEventType.getSelectedItem());
        BigDecimal value = (BigDecimal)this.txtGrade.getValue(BigDecimal.class);
        if (selectItem != null && value != null) {
            int eventType = selectItem.getValue();
            String eventTypeName = selectItem.toString();
            String message = "";
            if (0 == eventType && value.compareTo(PerfClientUtils.ZERO) < 0) {
                message = EASResource.getString((String)RES, (String)"greaterThanZero");
                MsgBox.showWarning((String)(eventTypeName + message));
                SysUtil.abort();
            } else if (1 == eventType && value.compareTo(PerfClientUtils.ZERO) > 0) {
                message = EASResource.getString((String)RES, (String)"lessThanZero");
                MsgBox.showWarning((String)(eventTypeName + message));
                SysUtil.abort();
            }
        }
    }
}

