/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.perf.EvalWFObjectsInfo;
import com.kingdee.eas.hr.perf.EvaluObjectCollection;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.client.AbstractOrgTargetEvaluStoreEditUI;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OrgTargetEvaluStoreEditUI
extends AbstractOrgTargetEvaluStoreEditUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgTargetEvaluStoreEditUI.class);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("number").setRequired(false);
        this.btnReferDiathesis.setVisible(false);
        this.btnReferWorkResponse.setVisible(false);
    }

    @Override
    protected void initBaseInfo() throws Exception {
        IRowSet rowSet = this.getBaseInfo();
        if (rowSet != null && rowSet.size() > 0) {
            try {
                while (rowSet.next()) {
                    String evaluObject = rowSet.getString("adminOrgUnit.name");
                    this.txtEvaluObject.setText(evaluObject);
                    String responser = rowSet.getString("responser.name");
                    this.txtPositionOrResponser.setText(responser);
                    String evaluSolution = rowSet.getString("evaluSolution.name");
                    this.txtEvaluSolution.setText(evaluSolution);
                    String assessPeriod = rowSet.getString("assessPeriod.name");
                    this.txtAccessPeriod.setText(assessPeriod);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e);
            }
        } else {
            EvalWFObjectsInfo adminOrg;
            PersonInfo responser;
            Object org = this.getUIContext().get("PF_EvaluObject");
            String evaluObject = org.toString();
            this.txtEvaluObject.setText(evaluObject);
            String evaluSolution = this.getUIContext().get("PF_EvaluSolution").toString();
            this.txtEvaluSolution.setText(evaluSolution);
            String EvaluSolutionId = "";
            if (this.getUIContext().get("PF_EvaluSolution") != null) {
                EvaluSolutionId = ((EvaluSolutionInfo)this.getUIContext().get("PF_EvaluSolution")).getId().toString();
            }
            if ((responser = this.getResponserByAdminOrgUnit((adminOrg = (EvalWFObjectsInfo)org).getEvaluObject().getObjectID(), EvaluSolutionId)) != null) {
                this.txtPositionOrResponser.setText(responser.getName());
            }
            String assessPeriod = this.getUIContext().get("PF_AssessPeriod").toString();
            this.txtAccessPeriod.setText(assessPeriod);
        }
    }

    @Override
    public boolean isPrepareInit() {
        return false;
    }

    @Override
    protected String getEvaluStoreType() {
        return "orgUnit";
    }

    @Override
    protected String getCurrentEvaluObjectId() {
        EvalWFObjectsInfo info = (EvalWFObjectsInfo)this.getUIContext().get("PF_EvaluObject");
        String objcetID = info.getEvaluObject().getObjectID();
        return objcetID;
    }

    private PersonInfo getResponserByAdminOrgUnit(String adminOrgId, String evaluSolutionId) throws BOSException {
        if (StringUtils.isEmpty((String)adminOrgId)) {
            return null;
        }
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("objectID", (Object)adminOrgId, CompareType.EQUALS));
        if (!"".equals(evaluSolutionId)) {
            fi.getFilterItems().add(new FilterItemInfo("evaluSolution", (Object)evaluSolutionId, CompareType.EQUALS));
        }
        EntityViewInfo evi = new EntityViewInfo();
        evi.setFilter(fi);
        SelectorItemCollection sic = evi.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("responser"));
        sic.add(new SelectorItemInfo("responser.name"));
        EvaluObjectCollection coll = EvaluObjectFactory.getRemoteInstance().getEvaluObjectCollection(evi);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        EvaluObjectInfo evaluObjInfo = coll.get(0);
        PersonInfo responser = evaluObjInfo.getResponser();
        return responser;
    }
}

