/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.perf.DeliverModeEnum;
import com.kingdee.eas.hr.perf.EvaluObjectCollection;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.IEvaluObject;
import com.kingdee.eas.hr.perf.ITargetDeliverer;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.TargetCreateModeEnum;
import com.kingdee.eas.hr.perf.TargetDelivererCollection;
import com.kingdee.eas.hr.perf.TargetDelivererFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreWeightFacadeFactory;
import com.kingdee.eas.hr.perf.client.AbstractOrgTargetStoreCopyUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class OrgTargetStoreCopyUI
extends AbstractOrgTargetStoreCopyUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgTargetStoreCopyUI.class);
    private HashMap orgMap = new HashMap();
    private HashMap directEvaluObject = new HashMap();
    private HashMap unDirectEvaluObject = new HashMap();
    private final PersonInfo self = SysContext.getSysContext().getCurrentUserInfo().getPerson();
    private static final String MACHINE = "0";
    private static final String USER = "1";
    private int selectedIndex = -1;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        StringBuffer sb = new StringBuffer();
        sb.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"reasonalWeightOrgUnit"));
        sb.append(PFVerifyUtils.formatBigDecimal(this.totalWeight, 2));
        sb.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"orgUnit"));
        sb.append("\uff09");
        this.contSrc.setTitle(sb.toString());
    }

    @Override
    protected void comboSoultionPeriod_actionPerformed(ActionEvent e) throws Exception {
        if (MACHINE.equals(e.getActionCommand())) {
            return;
        }
        if (this.comboSoultionPeriod.getSelectedItem() == null) {
            return;
        }
        if (this.comboSoultionPeriod.getSelectedIndex() == this.selectedIndex) {
            return;
        }
        this.selectedIndex = this.comboSoultionPeriod.getSelectedIndex();
        this.listSource.removeAllElements();
        this.listDest.removeAllElements();
        SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)this.comboSoultionPeriod.getSelectedItem();
        EvaluSolutionInfo evaluSolutionInfo = solutionPeriodInfo.getEvaluSolution();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        HashSet allOrgUnitSet = new HashSet();
        HashSet subUnitSet = new HashSet();
        allOrgUnitSet.addAll(this.orgMap.keySet());
        subUnitSet.addAll(this.unDirectEvaluObject.keySet());
        if (allOrgUnitSet.size() == 0) {
            return;
        }
        if (evaluSolutionInfo.getTargetCreateMode().equals((Object)TargetCreateModeEnum.LEADER_SELF)) {
            filterInfo.getFilterItems().add(new FilterItemInfo("objectID", allOrgUnitSet, CompareType.INCLUDE));
        } else {
            if (subUnitSet.size() == 0) {
                return;
            }
            filterInfo.getFilterItems().add(new FilterItemInfo("objectID", subUnitSet, CompareType.INCLUDE));
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)solutionPeriodInfo.getEvaluSolution().getId()));
        viewInfo.setFilter(filterInfo);
        SelectorItemCollection selector = viewInfo.getSelector();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("ObjectID"));
        IEvaluObject ieo = EvaluObjectFactory.getRemoteInstance();
        EvaluObjectCollection coll = ieo.getEvaluObjectCollection(viewInfo);
        ArrayList<String> idList = new ArrayList<String>();
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            idList.add(coll.get(i).getId().toString());
        }
        HashMap weightMap = TargetEvaluStoreWeightFacadeFactory.getRemoteInstance().getTotalWeight(idList, solutionPeriodInfo.getId());
        HashSet<String> selectedOrgSet = new HashSet<String>();
        HashSet<String> selectedObjectSet = new HashSet<String>();
        BigDecimal weight = null;
        int n2 = coll.size();
        for (int i = 0; i < n2; ++i) {
            weight = (BigDecimal)weightMap.get(coll.get(i).getId().toString());
            if (weight == null) {
                weight = new BigDecimal("0.00");
            }
            if (!evaluSolutionInfo.isIsControlWeight() && this.totalWeight.add(weight).compareTo(HUNDRE) > 0) continue;
            this.listSource.addElement((Object)coll.get(i));
            selectedOrgSet.add(coll.get(i).getObjectID());
            selectedObjectSet.add(coll.get(i).getId().toString());
        }
    }

    private boolean containsAny(Set src, Set sub) {
        boolean ret = false;
        Iterator iter = sub.iterator();
        while (iter.hasNext()) {
            if (!src.contains(iter.next())) continue;
            return true;
        }
        return ret;
    }

    @Override
    protected void initSolutionPeriod() throws Exception {
        this.initOrgUnit();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        HashSet selfSet = new HashSet();
        selfSet.addAll(this.directEvaluObject.keySet());
        if (selfSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("objectID", selfSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("evaluSolution.targetCreateMode", (Object)new Integer(TargetCreateModeEnum.LEADER_SELF.getValue())));
        }
        HashSet subSet = new HashSet();
        subSet.addAll(this.unDirectEvaluObject.keySet());
        if (subSet.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("objectID", subSet, CompareType.INCLUDE));
        }
        if (selfSet.size() == 0 && subSet.size() == 0) {
            return;
        }
        String maskString = null;
        if (selfSet.size() > 0 && subSet.size() > 0) {
            maskString = "((#0 and #1) or #2)";
        } else if (selfSet.size() > 0) {
            maskString = "#0 and #1";
        }
        if (maskString != null) {
            filter.setMaskString(maskString);
        }
        FilterInfo condFilter = new FilterInfo();
        condFilter.getFilterItems().add(new FilterItemInfo("SolutionPeriod.status", (Object)new Integer(100)));
        condFilter.getFilterItems().add(new FilterItemInfo("evaluSolution.deliverMode", (Object)new Integer(101)));
        condFilter.getFilterItems().add(new FilterItemInfo("evaluSolution.deliverMode", (Object)new Integer(103)));
        condFilter.setMaskString("#0 and (#1 or #2)");
        filter.mergeFilter(condFilter, "and");
        viewInfo.setFilter(filter);
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "EvaluObjectReferToSolutionPeriodQuery"));
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        EvaluSolutionInfo solutionInfo = null;
        SolutionPeriodInfo solutionPeriod = null;
        this.comboSoultionPeriod.setActionCommand(MACHINE);
        while (rowSet.next()) {
            solutionInfo = new EvaluSolutionInfo();
            solutionInfo.setId(BOSUuid.read((String)rowSet.getString("evaluSolution.id")));
            solutionInfo.setTargetCreateMode(TargetCreateModeEnum.getEnum(rowSet.getInt("evaluSolution.targetCreateMode")));
            solutionInfo.setDeliverMode(DeliverModeEnum.getEnum(rowSet.getInt("evaluSolution.deliverMode")));
            solutionInfo.setIsControlWeight(rowSet.getBoolean("evaluSolution.isControlWeight"));
            solutionPeriod = new SolutionPeriodInfo();
            solutionPeriod.setEvaluSolution(solutionInfo);
            solutionPeriod.setId(BOSUuid.read((String)rowSet.getString("SolutionPeriod.id")));
            solutionPeriod.setName(rowSet.getString("SolutionPeriod.name"));
            this.comboSoultionPeriod.addItem((Object)solutionPeriod);
        }
        this.comboSoultionPeriod.setSelectedItem(null);
        this.comboSoultionPeriod.setActionCommand(USER);
    }

    private void initOrgUnit() throws Exception {
        this.initInChargedAdminOrgUnit();
        this.initOwnDirectSubAdiminOrgUnit();
        this.initTempResponserAdminOrgUnit();
        this.initSubTempResponserAdminOrgUnit();
        this.initDelivererObjectOrg();
    }

    private void initInChargedAdminOrgUnit() throws Exception {
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "InChargedAdminOrgUnitQuery"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.self.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        AdminOrgUnitInfo orgUnit = null;
        String id = null;
        while (rowSet.next()) {
            orgUnit = new AdminOrgUnitInfo();
            id = rowSet.getString("AdminOrgUnit.id");
            orgUnit.setId(BOSUuid.read((String)id));
            orgUnit.setName(rowSet.getString("AdminOrgUnit.name"));
            this.directEvaluObject.put(id, orgUnit);
            this.orgMap.put(id, orgUnit);
        }
    }

    private void initOwnDirectSubAdiminOrgUnit() throws Exception {
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "SubAdminOrgUnitByPositionQuery"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Person.id", (Object)this.self.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        AdminOrgUnitInfo orgUnit = null;
        String id = null;
        while (rowSet.next()) {
            id = rowSet.getString("id");
            orgUnit = new AdminOrgUnitInfo();
            orgUnit.setId(BOSUuid.read((String)id));
            orgUnit.setName(rowSet.getString("name"));
            this.orgMap.put(id, orgUnit);
            this.unDirectEvaluObject.put(id, orgUnit);
        }
    }

    private void initSubTempResponserAdminOrgUnit() throws Exception {
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "SubTempResponseAdminOrgUnitQuery"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Person.id", (Object)this.self.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        AdminOrgUnitInfo orgUnit = null;
        String id = null;
        while (rowSet.next()) {
            id = rowSet.getString("adminOrgUnit.id");
            orgUnit = new AdminOrgUnitInfo();
            orgUnit.setId(BOSUuid.read((String)id));
            orgUnit.setName(rowSet.getString("adminOrgUnit.name"));
            this.orgMap.put(id, orgUnit);
            this.unDirectEvaluObject.put(id, orgUnit);
        }
    }

    private void initTempResponserAdminOrgUnit() throws Exception {
        IQueryExecutor iqec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.hr.perf.app", "TempResponseAdminOrgUnitQuery"));
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("responser.id", (Object)this.self.getId().toString(), CompareType.EQUALS));
        viewInfo.setFilter(filter);
        iqec.setObjectView(viewInfo);
        IRowSet rowSet = iqec.executeQuery();
        AdminOrgUnitInfo orgUnit = null;
        while (rowSet.next()) {
            orgUnit = new AdminOrgUnitInfo();
            String id = rowSet.getString("adminOrgUnit.id");
            orgUnit.setId(BOSUuid.read((String)id));
            orgUnit.setName(rowSet.getString("adminOrgUnit.name"));
            this.directEvaluObject.put(id, orgUnit);
            this.orgMap.put(id, orgUnit);
        }
    }

    @Override
    protected void setEvaluObjectIcon() {
        this.evaluObjectIcon = EASResource.getIcon((String)"imgTree_adminorg");
    }

    @Override
    protected boolean canDeliver() throws Exception {
        EvaluObjectInfo info = null;
        HashSet<String> selectedOrgSet = new HashSet<String>();
        HashSet<String> selectedObjectSet = new HashSet<String>();
        for (int i = 0; i < this.listDest.getElementCount(); ++i) {
            info = (EvaluObjectInfo)this.listDest.getElement(i);
            selectedOrgSet.add(info.getObjectID());
            selectedObjectSet.add(info.getId().toString());
        }
        if (this.containsAny(selectedOrgSet, this.directEvaluObject.keySet())) {
            return false;
        }
        ITargetDeliverer iTargetDeliver = TargetDelivererFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.objectID", selectedOrgSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.id", selectedObjectSet, CompareType.INCLUDE));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("person.id"));
        TargetDelivererCollection coll = iTargetDeliver.getTargetDelivererCollection(viewInfo);
        if (coll == null || coll.size() == 0) {
            return true;
        }
        PersonInfo person = null;
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            person = coll.get(i).getPerson();
            if (person == null || !person.getId().equals((Object)this.self.getId())) continue;
            return true;
        }
        return false;
    }

    private void initDelivererObjectOrg() throws Exception {
        ITargetDeliverer iTargetDeliverer = TargetDelivererFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluObject.evaluObjectType", (Object)new Integer(101), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)this.self.getId().toString(), CompareType.EQUALS));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaluObject.objectID"));
        sic.add(new SelectorItemInfo("evaluObject.name"));
        TargetDelivererCollection coll = iTargetDeliverer.getTargetDelivererCollection(viewInfo);
        AdminOrgUnitInfo admin = null;
        if (coll != null) {
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                admin = new AdminOrgUnitInfo();
                admin.setId(BOSUuid.read((String)coll.get(i).getEvaluObject().getObjectID()));
                admin.setName(coll.get(i).getEvaluObject().getName());
                this.orgMap.put(admin.getId().toString(), admin);
                this.unDirectEvaluObject.put(admin.getId().toString(), admin);
            }
        }
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

