/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTPropertyChangeListener;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.TextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.client.CommonQueryDialog;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.KindEnum;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.TargetEvaluStoreCollection;
import com.kingdee.eas.hr.perf.TargetEvaluStoreFactory;
import com.kingdee.eas.hr.perf.TargetEvaluStoreInfo;
import com.kingdee.eas.hr.perf.client.AbstractOrgTargetValueEntryListUI;
import com.kingdee.eas.hr.perf.client.OrgTargetValueEntrytQueryPanelUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PerformItemHelper;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class OrgTargetValueEntryListUI
extends AbstractOrgTargetValueEntryListUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgTargetValueEntryListUI.class);
    private Map changedValue = new HashMap();
    private static String path = "com.kingdee.eas.hr.perf.TargetValueEntryResource";
    private CommonQueryDialog cqDialog = null;
    private Map tempMap = new HashMap();
    private KDPanel userPanel = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getSelectManager().setSelectMode(15);
        this.merge();
        this.btnSave.setEnabled(false);
        this.tHelper.getDisabledTables().add(this.tblMain);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        int rowCount = this.tblMain.getRowCount();
        if (rowCount < 1) {
            return;
        }
        int precision = 2;
        IRow row = null;
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            precision = Integer.parseInt(row.getCell("evaluTarget.dataPrecision").getValue().toString());
            KDFormattedTextField formattedTextField = new KDFormattedTextField();
            formattedTextField.setDataType(1);
            formattedTextField.setPrecision(precision);
            row.getCell("thresholdValue").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
            row.getCell("standardValue").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
            row.getCell("challengeValue").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
        }
        this.tblMain.getColumn("thresholdValue").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("standardValue").getStyleAttributes().setLocked(false);
        this.tblMain.getColumn("challengeValue").getStyleAttributes().setLocked(false);
        this.btnSave.setEnabled(true);
        this.btnEdit.setEnabled(false);
        this.tblMain.addKDTPropertyChangeListener(new KDTPropertyChangeListener(){

            public void propertyChange(KDTPropertyChangeEvent evt) {
                OrgTargetValueEntryListUI.this.tblMain_propertyChange(evt);
            }
        });
    }

    private void tblMain_propertyChange(KDTPropertyChangeEvent evt) {
        int row_idx = evt.getRowIndex();
        int col_idx = evt.getColIndex();
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if (oldValue == null && newValue == null) {
            return;
        }
        if (oldValue != null && newValue != null && newValue.equals(oldValue)) {
            return;
        }
        if (this.tblMain.getCell(row_idx, "id").getValue() == null) {
            return;
        }
        IColumn col = this.tblMain.getColumn(col_idx);
        Object value = evt.getNewValue();
        if (this.isEq(value, evt.getOldValue())) {
            return;
        }
        String id = this.tblMain.getCell(row_idx, "id").getValue().toString();
        TargetEvaluStoreInfo info = null;
        info = (TargetEvaluStoreInfo)this.changedValue.get(id);
        IRow row = this.tblMain.getRow(row_idx);
        if (info == null) {
            info = new TargetEvaluStoreInfo();
            info.setId(BOSUuid.read((String)id));
            this.saveRow(info, row);
            this.changedValue.put(id, info);
        }
        this.saveRow(info, row);
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            rowSet.beforeFirst();
            while (rowSet.next()) {
                if (rowSet.getBigDecimal("thresholdValue") == null) {
                    rowSet.updateString("thresholdValue", "0.00");
                }
                if (rowSet.getBigDecimal("standardValue") == null) {
                    rowSet.updateString("standardValue", "0.00");
                }
                if (rowSet.getBigDecimal("challengeValue") != null) continue;
                rowSet.updateString("challengeValue", "0.00");
            }
            rowSet.beforeFirst();
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
    }

    private void saveRow(TargetEvaluStoreInfo info, IRow row) {
        if (row.getCell("evaluTarget.kind").getValue() != null) {
            int kind = ((BizEnumValueDTO)row.getCell("evaluTarget.kind").getValue()).getInt();
            BigDecimal per = new BigDecimal("0.01");
            if (row.getCell("thresholdValue").getValue() != null) {
                if (KindEnum.QUANTITATIVE2.getValue() == kind) {
                    info.setThresholdValue(new BigDecimal(row.getCell("thresholdValue").getValue().toString()).multiply(per));
                } else {
                    info.setThresholdValue(new BigDecimal(row.getCell("thresholdValue").getValue().toString()));
                }
            }
            if (row.getCell("standardValue").getValue() != null) {
                if (KindEnum.QUANTITATIVE2.getValue() == kind) {
                    info.setStandardValue(new BigDecimal(row.getCell("standardValue").getValue().toString()).multiply(per));
                } else {
                    info.setStandardValue(new BigDecimal(row.getCell("standardValue").getValue().toString()));
                }
            }
            if (row.getCell("challengeValue").getValue() != null) {
                if (KindEnum.QUANTITATIVE2.getValue() == kind) {
                    info.setChallengeValue(new BigDecimal(row.getCell("challengeValue").getValue().toString()).multiply(per));
                } else {
                    info.setChallengeValue(new BigDecimal(row.getCell("challengeValue").getValue().toString()));
                }
            }
        }
    }

    protected boolean initDefaultFilter() {
        return true;
    }

    protected CommonQueryDialog initCommonQueryDialog() {
        if (this.cqDialog != null) {
            return this.cqDialog;
        }
        this.cqDialog = super.initCommonQueryDialog();
        KDPanel userPanel = this.getUserPanel();
        if (userPanel != null) {
            this.cqDialog.addUserPanel(userPanel);
        }
        this.cqDialog.setShowSorter(true);
        this.cqDialog.setUiObject(null);
        this.cqDialog.setShowDefaultSolution(false);
        return this.cqDialog;
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo fi = new FilterInfo();
        try {
            fi.getFilterItems().add(new FilterItemInfo("adminOrgUnit.id", (Object)PerfUtils.getAdminRangeSql(null), CompareType.INNER));
            fi.getFilterItems().add(new FilterItemInfo("isDelivered", (Object)Boolean.TRUE));
            fi.getFilterItems().add(new FilterItemInfo("uniteTarget", (Object)Boolean.TRUE));
            fi.getFilterItems().add(new FilterItemInfo("evaluTarget.kind", (Object)new Integer(10), CompareType.NOTEQUALS));
        }
        catch (Exception e) {
            super.handleException(e);
        }
        return fi;
    }

    private KDPanel getUserPanel() {
        if (this.userPanel == null) {
            try {
                this.userPanel = new OrgTargetValueEntrytQueryPanelUI();
            }
            catch (Exception e) {
                super.handleException(e);
            }
        }
        return this.userPanel;
    }

    private void merge() {
        this.tblMain.getGroupManager().setGroup(true);
        this.tblMain.getMergeManager().setMergeMode(5);
        this.tblMain.getGroupManager().group();
    }

    @Override
    protected void btnSave_actionPerformed(ActionEvent e) throws Exception {
        if (!this.submit()) {
            return;
        }
        this.btnSave.setEnabled(false);
        this.btnEdit.setEnabled(true);
        this.tblMain.getColumn("thresholdValue").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("standardValue").getStyleAttributes().setLocked(true);
        this.tblMain.getColumn("challengeValue").getStyleAttributes().setLocked(true);
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)path, (String)"Modify_SUCCESS"));
    }

    private boolean submit() throws Exception {
        TargetEvaluStoreCollection coll = new TargetEvaluStoreCollection();
        Iterator iter = this.changedValue.values().iterator();
        while (iter.hasNext()) {
            coll.add((TargetEvaluStoreInfo)iter.next());
        }
        if (coll.size() > 0) {
            TargetEvaluStoreFactory.getRemoteInstance().updateAchieveDataValue(coll, this.getEvaluStoreType());
        }
        this.changedValue.clear();
        return true;
    }

    protected String getEvaluStoreType() {
        return "orgunit";
    }

    protected ICoreBase getBizInterface() throws Exception {
        return TargetEvaluStoreFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return null;
    }

    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    @Override
    protected void btnSelectCopy_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblMain.getRowCount() == 0) {
            return;
        }
        int size = this.tblMain.getSelectManager().size();
        if (size > 0) {
            KDTSelectBlock sb = this.tblMain.getSelectManager().get(0);
            int row = sb.getTop();
            int column = sb.getLeft();
            IColumn iColumn = this.tblMain.getColumn(column);
            if (iColumn == null) {
                return;
            }
            if (iColumn.getStyleAttributes().isLocked() || this.tblMain.getCell(row, column).getStyleAttributes().isLocked()) {
                return;
            }
            Object value = this.tblMain.getCell(row, column).getValue();
            for (int i = 0; i < size; ++i) {
                sb = this.tblMain.getSelectManager().get(i);
                for (int j = sb.getBeginRow(); j <= sb.getEndRow(); ++j) {
                    if (this.tblMain.getCell(j, column).getStyleAttributes().isLocked()) continue;
                    this.tblMain.getCell(j, column).setValue(value);
                }
            }
        }
    }

    private boolean isEq(Object o1, Object o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null && o2 != null) {
            return false;
        }
        if (o1 != null && o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public void actionLocate_actionPerformed(ActionEvent e) throws Exception {
        super.actionLocate_actionPerformed(e);
    }

    protected String[] getLocateNames() {
        String[] locateNames = new String[]{"adminOrgUnit.number", "adminOrgUnit.name"};
        return locateNames;
    }

    protected boolean checkBeforeWindowClosing() {
        this.editorStopEditing();
        if (this.changedValue != null && this.changedValue.size() > 0) {
            String message = EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Save_Exit");
            int result = MsgBox.showConfirm3((Component)((Object)this), (String)message);
            if (result == 0) {
                try {
                    this.submit();
                }
                catch (Exception e) {
                    super.handUIException((Throwable)e);
                }
            } else if (result == 2) {
                return false;
            }
        }
        return super.checkBeforeWindowClosing();
    }

    private void editorStopEditing() {
        ICellEditor editor = this.tblMain.getColumn("thresholdValue").getEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        if ((editor = this.tblMain.getColumn("standardValue").getEditor()) != null) {
            editor.stopCellEditing();
        }
        if ((editor = this.tblMain.getColumn("challengeValue").getEditor()) != null) {
            editor.stopCellEditing();
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0 && (e.getColIndex() == this.tblMain.getColumnIndex("evaluTarget.content") || e.getColIndex() == this.tblMain.getColumnIndex("evaluTarget.standard"))) {
            return;
        }
        int row_idx = e.getRowIndex();
        if (row_idx <= 0) {
            return;
        }
        if (this.tblMain.getCell(row_idx, "solutionPeriod.status") != null && this.tblMain.getCell(row_idx, "solutionPeriod.status").getValue() != null) {
            if (102 == ((BizEnumValueDTO)this.tblMain.getCell(row_idx, "solutionPeriod.status").getValue()).getInt()) {
                this.tblMain.getCell(row_idx, "thresholdValue").getStyleAttributes().setLocked(true);
                this.tblMain.getCell(row_idx, "standardValue").getStyleAttributes().setLocked(true);
                this.tblMain.getCell(row_idx, "challengeValue").getStyleAttributes().setLocked(true);
            } else {
                this.tblMain.getCell(row_idx, "thresholdValue").getStyleAttributes().setLocked(false);
                this.tblMain.getCell(row_idx, "standardValue").getStyleAttributes().setLocked(false);
                this.tblMain.getCell(row_idx, "challengeValue").getStyleAttributes().setLocked(false);
            }
        }
        super.tblMain_tableClicked(e);
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
        this.tempMap = new HashMap();
        if (rowSet != null) {
            try {
                rowSet.beforeFirst();
                while (rowSet.next()) {
                    TargetEvaluStoreInfo tmp = new TargetEvaluStoreInfo();
                    tmp.setThresholdValue(rowSet.getBigDecimal("thresholdValue"));
                    tmp.setStandardValue(rowSet.getBigDecimal("standardValue"));
                    tmp.setChallengeValue(rowSet.getBigDecimal("challengeValue"));
                    this.tempMap.put(rowSet.getString("id"), tmp);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        try {
            this.setRowNumberRender();
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
    }

    private void setRowNumberRender() {
        if (this.tempMap == null || this.tempMap.size() == 0) {
            return;
        }
        int rowCount = this.tblMain.getRowCount();
        if (rowCount < 1) {
            return;
        }
        IRow row = null;
        int kind = 0;
        BigDecimal per = new BigDecimal("100.00");
        String[] columnName = new String[]{"thresholdValue", "standardValue", "challengeValue"};
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            Object dataPrecision = row.getCell("evaluTarget.dataPrecision").getValue();
            String precision = PFUtils.getNumberFormat(Integer.parseInt(dataPrecision.toString()));
            if (row.getCell("evaluTarget.kind").getValue() != null) {
                kind = ((BizEnumValueDTO)row.getCell("evaluTarget.kind").getValue()).getInt();
            }
            DecimalFormat df = new DecimalFormat(precision);
            TargetEvaluStoreInfo storeInfo = (TargetEvaluStoreInfo)this.tempMap.get(row.getCell("id").getValue());
            if (storeInfo == null) continue;
            if (KindEnum.QUANTITATIVE2.getValue() == kind) {
                if (storeInfo.getThresholdValue() != null) {
                    row.getCell("thresholdValue").setValue((Object)df.format(storeInfo.getThresholdValue().multiply(per)));
                }
                if (storeInfo.getStandardValue() != null) {
                    row.getCell("standardValue").setValue((Object)df.format(storeInfo.getStandardValue().multiply(per)));
                }
                if (storeInfo.getChallengeValue() != null) {
                    row.getCell("challengeValue").setValue((Object)df.format(storeInfo.getChallengeValue().multiply(per)));
                }
                PerformItemHelper.setRender(row, columnName, new PercentRender(df, per));
                continue;
            }
            if (storeInfo.getThresholdValue() != null) {
                row.getCell("thresholdValue").setValue((Object)df.format(storeInfo.getThresholdValue()));
            }
            if (storeInfo.getStandardValue() != null) {
                row.getCell("standardValue").setValue((Object)df.format(storeInfo.getStandardValue()));
            }
            if (storeInfo.getChallengeValue() != null) {
                row.getCell("challengeValue").setValue((Object)df.format(storeInfo.getChallengeValue()));
            }
            PerformItemHelper.setRender(row, columnName, new NumberRender(df));
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
        this.setRowNumberRender();
    }

    class NumberRender
    implements IBasicRender {
        private TextRender render = new TextRender();
        DecimalFormat df;

        public NumberRender(DecimalFormat df) {
            this.df = df;
        }

        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            if (object == null || this.df == null) {
                return;
            }
            this.render.draw(graphics, clip, this.df.format(new BigDecimal(object.toString())), cellStyle);
        }
    }

    class PercentRender
    implements IBasicRender {
        private TextRender render = new TextRender();
        DecimalFormat df;
        BigDecimal per;

        public PercentRender(DecimalFormat df, BigDecimal per) {
            this.df = df;
            this.per = per;
        }

        public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
            if (object == null || this.df == null || this.per == null) {
                return;
            }
            this.render.draw(graphics, clip, this.df.format(new BigDecimal(object.toString())) + "%", cellStyle);
        }
    }
}

