/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.perf.client.AbstractOrgUnitResponserUI;
import com.kingdee.eas.hr.perf.client.EvaluSolutionHelper;
import com.kingdee.eas.hr.perf.client.PFUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class OrgUnitResponserUI
extends AbstractOrgUnitResponserUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgUnitResponserUI.class);
    private PersonInfo personInfo;

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblResponser.checkParsed();
        PersonCollection personColl = (PersonCollection)this.getUIContext().get("PersonCollection");
        this.fillTable(personColl.toArray());
    }

    protected void initWorkButton() {
        super.initWorkButton();
    }

    public void fillTable(Object[] obj) throws Exception {
        PersonInfo personInfo = null;
        IPositionMember positionMember = null;
        int length = obj.length;
        for (int i = 0; i < length; ++i) {
            PositionInfo positionInfo;
            personInfo = (PersonInfo)obj[i];
            if (personInfo == null || this.checkIfRefered(personInfo)) continue;
            IRow row = this.tblResponser.addRow();
            row.getCell("id").setValue((Object)personInfo.getId().toString());
            row.getCell("number").setValue((Object)personInfo.getNumber());
            row.getCell("name").setValue((Object)personInfo.getName());
            if (positionMember == null) {
                positionMember = PositionMemberFactory.getRemoteInstance();
            }
            if ((positionInfo = EvaluSolutionHelper.getPositionInfo(positionMember, personInfo.getId().toString())) == null) continue;
            row.getCell("position").setValue((Object)positionInfo.getName());
        }
    }

    private boolean checkIfRefered(PersonInfo personInfo) {
        IRow row = null;
        for (int i = 0; i < this.tblResponser.getRowCount(); ++i) {
            row = this.tblResponser.getRow(i);
            String personId = (String)row.getCell("id").getValue();
            if (!personInfo.getId().toString().equals(personId)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.disposeUIWindow();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.btnConfirm_actionPerformed(e);
        PFUtils.checkSelected((Component)((Object)this), this.tblResponser);
        PersonInfo info = new PersonInfo();
        IRow row = this.tblResponser.getRow(PFUtils.getSelectedRow(this.tblResponser));
        if (row.getCell("id").getValue() == null) {
            return;
        }
        info.setId(BOSUuid.read((String)((String)row.getCell("id").getValue())));
        if (row.getCell("number").getValue() != null) {
            info.setNumber(row.getCell("number").getValue().toString());
        }
        if (row.getCell("name").getValue() != null) {
            info.setName(row.getCell("name").getValue().toString());
        }
        this.personInfo = info;
        this.disposeUIWindow();
    }

    @Override
    protected void tblResponser_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getType() == 0) {
            return;
        }
        if (e.getClickCount() == 2) {
            this.btnConfirm_actionPerformed(null);
        }
    }

    public static PersonInfo showDialogWindows(IUIObject ui, PersonCollection personColl) throws UIException {
        UIContext uiContext = new UIContext((Object)ui);
        uiContext.put((Object)"PersonCollection", (Object)personColl);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(OrgUnitResponserUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        OrgUnitResponserUI responserUI = (OrgUnitResponserUI)uiWindow.getUIObject();
        return responserUI.personInfo;
    }
}

