/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.basedata.org.HierarchyCollection;
import com.kingdee.eas.basedata.org.HierarchyFactory;
import com.kingdee.eas.basedata.org.IHierarchy;
import com.kingdee.eas.basedata.org.IPositionMember;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.org.PositionMemberCollection;
import com.kingdee.eas.basedata.org.PositionMemberFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.PerfUtils;
import com.kingdee.eas.hr.perf.PrecisionMaintainCollection;
import com.kingdee.eas.hr.perf.PrecisionMaintainFactory;
import com.kingdee.eas.hr.perf.PrecisionMaintainInfo;
import com.kingdee.eas.hr.perf.PrecisionTypeEnum;
import com.kingdee.eas.hr.perf.client.VOComparator;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.TypeConversionUtils;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public class PFUtils {
    public static final int precision = 2;
    public static final int precisionType = 10;

    public static void checkSelected(Component ui, KDTable table) {
        if (table.getRowCount() == 0 || table.getSelectManager().getActiveRowIndex() == -1) {
            MsgBox.showInfo((Component)ui, (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
    }

    public static int getSelectedRow(KDTable table) {
        KDTSelectBlock selectBlock = table.getSelectManager().get();
        if (selectBlock == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        return selectBlock.getTop();
    }

    public static List getSelectedRows(KDTable table) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int[] selectRowsIndex = KDTableUtil.getSelectedRows((KDTable)table);
        Arrays.sort(selectRowsIndex);
        for (int i = 0; i < selectRowsIndex.length; ++i) {
            if (list.contains(new Integer(selectRowsIndex[i]))) continue;
            list.add(new Integer(selectRowsIndex[i]));
        }
        return list;
    }

    public static UserInfo getCurrentUser() {
        return SysContext.getSysContext().getCurrentUserInfo();
    }

    public static Locale getLocale() {
        return SysContext.getSysContext().getLocale();
    }

    public static Locale getSLocale() {
        return new Locale("L2");
    }

    public static Locale getTLocale() {
        return new Locale("L3");
    }

    public static CompanyOrgUnitInfo getCurrentCompany() {
        CompanyOrgUnitInfo companyOrgUnitInfo = SysContext.getSysContext().getCurrentFIUnit();
        return companyOrgUnitInfo;
    }

    public static HROrgUnitInfo getCurrentHROrgUnit() {
        HROrgUnitInfo info = SysContext.getSysContext().getCurrentHRUnit();
        return info;
    }

    private static void setTableCellEditorByComboBox(KDTable tblMain, KDComboBox comboBox, IObjectCollection coll, String property) throws Exception {
        if (comboBox == null) {
            comboBox = new KDComboBox();
        }
        if (coll != null) {
            DefaultComboBoxModel<IObjectValue> model = new DefaultComboBoxModel<IObjectValue>();
            for (int j = 0; j < coll.size(); ++j) {
                model.addElement(coll.getObject(j));
            }
            comboBox.setModel(model);
        }
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBox));
    }

    public static void setTableCellEditorByComboBox(KDTable tblMain, IObjectCollection coll, String property) throws Exception {
        PFUtils.setTableCellEditorByComboBox(tblMain, null, coll, property);
    }

    public static void setTableCellEditorByComboBox(KDTable tblMain, KDComboBox comboBox, String property) throws Exception {
        PFUtils.setTableCellEditorByComboBox(tblMain, comboBox, null, property);
    }

    public static void setTableCellEditorByFormattedTextField(KDTable tblMain, String property, int precision) throws Exception {
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(precision);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
    }

    public static void setTableCellEditorByFormattedTextField(KDTable tblMain, String property, int precision, boolean isVerifyInput) throws Exception {
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        if (isVerifyInput) {
            formattedTextField.setDataVerifierType(12);
        }
        formattedTextField.setPrecision(precision);
        formattedTextField.setMinimumValue((Comparable)PerfUtils.ZERO);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
    }

    public static void setTableCellEditorByFormattedTextFieldWithNegative(KDTable tblMain, String property, int precision, boolean isVerifyInput) throws Exception {
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        if (isVerifyInput) {
            // empty if block
        }
        formattedTextField.setPrecision(precision);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
    }

    public static void setTableCellEditorByFormattedTextField(KDTable tblMain, KDFormattedTextField formattedTextField, String property, int precision) throws Exception {
        formattedTextField.setDataType(1);
        formattedTextField.setPrecision(precision);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
    }

    public static void setTableCellEditorByFormattedTextField(KDTable tblMain, String property) throws Exception {
        KDFormattedTextField formattedTextField = new KDFormattedTextField();
        formattedTextField.setDataType(1);
        formattedTextField.setRoundingMode(4);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)formattedTextField));
    }

    public static void setTableNumberFormat(KDTable tblMain, String columnKey, int precision) {
        String numberFormat = PFUtils.getNumberFormat(precision);
        StyleAttributes styleAttributes = tblMain.getColumn(columnKey).getStyleAttributes();
        styleAttributes.setNumberFormat(numberFormat);
    }

    public static String getNumberFormat(int precision) {
        StringBuffer sb = new StringBuffer("0");
        for (int i = 0; i < precision; ++i) {
            if (i == 0) {
                sb.append(".");
            }
            sb.append("0");
        }
        return sb.toString();
    }

    public static PositionInfo getPositionReferToPerson(PersonInfo person) throws Exception {
        if (person == null || person.getId() == null) {
            return null;
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)person.getId().toString()));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("position.adminOrgUnit.name"));
        SorterItemInfo sorterItem = new SorterItemInfo("isPrimary");
        sorterItem.setSortType(SortType.DESCEND);
        viewInfo.getSorter().add(sorterItem);
        IPositionMember iPositionMember = PositionMemberFactory.getRemoteInstance();
        PositionMemberCollection coll = iPositionMember.getPositionMemberCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            return coll.get(0).getPosition();
        }
        return null;
    }

    public static void sortCollection(AbstractObjectCollection coll, String[] strArray) {
        PFUtils.sortCollection(coll, strArray, true);
    }

    public static void sortCollection(AbstractObjectCollection coll, String[] strArray, boolean isASC) {
        VOComparator comp = new VOComparator(strArray, isASC);
        Object[] infoArray = coll.toArray();
        Arrays.sort(infoArray, comp);
        coll.clear();
        for (int i = 0; i < infoArray.length; ++i) {
            coll.addObject((IObjectValue)infoArray[i]);
        }
    }

    public static FilterInfo getCUFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentCtrlUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    public static FilterInfo getHRFilter() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentHRUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        return filter;
    }

    public static IRow[] getSelectedFullRows(KDTable table) {
        if (table.getSelectManager().size() == 0) {
            return null;
        }
        int count = KDTableUtil.getSelectedRowCount((KDTable)table);
        IRow[] rows = new IRow[count];
        int[] rowsIndex = KDTableUtil.getSelectedRows((KDTable)table);
        for (int i = 0; i < rowsIndex.length; ++i) {
            rows[i] = table.getRow(rowsIndex[i]);
        }
        return rows;
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof Object[]) {
            Object[] objs = (Object[])obj;
            for (int i = 0; i < objs.length; ++i) {
                Object o = objs[i];
                if (o != null) continue;
                return true;
            }
        }
        return false;
    }

    public static void clearMultiLangAreaValue(KDMultiLangBox mlb) {
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo defaultLang = null;
        while (iter.hasNext()) {
            LanguageInfo currentLang = (LanguageInfo)iter.next();
            mlb.addItem(currentLang, null);
            if (!LocaleUtils.getDefaultLocale().equals(currentLang.getLocale())) continue;
            defaultLang = currentLang;
        }
        if (defaultLang != null) {
            mlb.setSelectedLanguage(defaultLang);
        }
    }

    public static void clearObjectMultiFieldValue(IObjectValue data, String propertyName) {
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo defaultLang = null;
        while (iter.hasNext()) {
            LanguageInfo currentLang = (LanguageInfo)iter.next();
            data.put(propertyName, null, currentLang.getLocale());
            if (!LocaleUtils.getDefaultLocale().equals(currentLang.getLocale())) continue;
            defaultLang = currentLang;
        }
    }

    public static FilterItemInfo getAdminRangeFilterItemInfo(String queryColumn) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        FilterItemInfo item = new FilterItemInfo(queryColumn, (Object)sql.toString(), CompareType.INNER);
        return item;
    }

    public static FilterInfo getHRAndAdminRangeFilterInfo(String hrColumnName, String orgUnitColumnName) {
        String userID = SysContext.getSysContext().getCurrentUserInfo().getId().toString();
        String hrOrgUnitID = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT FFromUnitID FROM T_ORG_UnitRelation WHERE FToUnitID = ");
        sql.append("'");
        sql.append(hrOrgUnitID);
        sql.append("'");
        sql.append(" AND ");
        sql.append(" FTypeRelationID = ");
        sql.append("'00000000-0000-0000-0000-0000000000100FE9F8B5'");
        sql.append(" AND ");
        sql.append("FFromUnitID IN (");
        sql.append("SELECT FOrgID FROM T_PM_OrgRange WHERE FUserID = ");
        sql.append("'");
        sql.append(userID);
        sql.append("'");
        sql.append(" AND ");
        sql.append("FType = ");
        sql.append(20);
        sql.append(")");
        FilterInfo filter = new FilterInfo();
        FilterItemInfo item = new FilterItemInfo(orgUnitColumnName, (Object)sql.toString(), CompareType.INNER);
        filter.getFilterItems().add(item);
        item = new FilterItemInfo(hrColumnName, (Object)hrOrgUnitID);
        filter.getFilterItems().add(item);
        return filter;
    }

    public static boolean getParamValue() throws Exception {
        String[] truth = new String[]{"true", "yes", "1", "sure", "Y", "confirm", EASResource.getString((String)"com.kingdee.eas.fi.rpt.RPTAutoGenerateResource", (String)"280_RptUtil")};
        String param = ParamManager.getParamValue(null, null, (String)"hr_perf_001");
        for (int i = 0; i < truth.length; ++i) {
            if (!truth[i].equalsIgnoreCase(param)) continue;
            return true;
        }
        return false;
    }

    public static boolean getParamValue(String id) throws EASBizException, BOSException {
        String hrOrgId = null;
        String paramValue = null;
        if (SysContext.getSysContext().getCurrentHRUnit() == null) {
            return false;
        }
        hrOrgId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        paramValue = ParamManager.getParamValue(null, (IObjectPK)new ObjectUuidPK(hrOrgId), (String)id);
        return TypeConversionUtils.objToBoolean((Object)paramValue);
    }

    public static HierarchyCollection getHierarchyCollection() throws Exception {
        IHierarchy iHierarchy = HierarchyFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        SorterItemInfo sortInfo = new SorterItemInfo("isDefault");
        sortInfo.setSortType(SortType.DESCEND);
        evi.getSorter().add(sortInfo);
        return iHierarchy.getHierarchyCollection(evi);
    }

    public static PrecisionMaintainInfo getPrecisionMaintainInfo(EvaluSolutionInfo evaluSolutionInfo) throws Exception {
        if (evaluSolutionInfo != null && evaluSolutionInfo.getId() != null) {
            return PFUtils.getPrecisionMaintainInfo(evaluSolutionInfo.getId().toString());
        }
        return null;
    }

    public static PrecisionMaintainInfo getPrecisionMaintainInfo(String evaluSolutionID) throws Exception {
        PrecisionMaintainInfo info = null;
        if (evaluSolutionID != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)evaluSolutionID, CompareType.EQUALS));
            view.setFilter(filterInfo);
            PrecisionMaintainCollection col = PrecisionMaintainFactory.getRemoteInstance().getPrecisionMaintainCollection(view);
            if (col != null && col.size() > 0) {
                info = col.get(0);
            }
        }
        return info;
    }

    public static PrecisionMaintainInfo getPrecisionMaintainInfo(String evaluObjectID, int type) throws Exception {
        PrecisionMaintainInfo info = null;
        if (evaluObjectID != null) {
            ObjectUuidPK pk = new ObjectUuidPK(evaluObjectID);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("evaluSolution.id"));
            EvaluObjectInfo evaluObjectInfo = EvaluObjectFactory.getRemoteInstance().getEvaluObjectInfo((IObjectPK)pk, selector);
            if (evaluObjectInfo != null && evaluObjectInfo.getEvaluSolution() != null) {
                return PFUtils.getPrecisionMaintainInfo(evaluObjectInfo.getEvaluSolution());
            }
        }
        return info;
    }

    public static PrecisionMaintainCollection getPrecisionMaintainCollection(Set ids) throws Exception {
        PrecisionMaintainCollection coll = null;
        if (ids.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)ids, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            coll = PrecisionMaintainFactory.getRemoteInstance().getPrecisionMaintainCollection(view);
        }
        return coll;
    }

    public static void setTableNumberFormat(IRow row, String columnKey, int precision) {
        String numberFormat = PFUtils.getNumberFormat(precision);
        StyleAttributes styleAttributes = row.getCell(columnKey).getStyleAttributes();
        styleAttributes.setNumberFormat(numberFormat);
    }

    public static void setTableCellNumberForMat(KDTable table, String columnKey, String evaluSolutionIdColumnKey) {
        String[] columnKeys = new String[]{columnKey};
        PFUtils.setTableCellNumberFormat(table, columnKeys, evaluSolutionIdColumnKey);
    }

    public static void setTableCellNumberFormat(KDTable table, String[] columnKeys, String evaluSolutionIdColumnKey) {
        HashMap ESIdAndTableRelation = new HashMap();
        Set evaluSolutionIdSets = PFUtils.getEvaluSolutionIds(table, evaluSolutionIdColumnKey, ESIdAndTableRelation);
        PrecisionMaintainCollection PMColl = null;
        PrecisionMaintainInfo PMInfo = null;
        HashSet<Integer> isUsedRowIndex = new HashSet<Integer>();
        IRow row = null;
        try {
            PMColl = PFUtils.getPrecisionMaintainCollection(evaluSolutionIdSets);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        if (PMColl != null && PMColl.size() > 0) {
            String evaluSolutionId = null;
            Set rowIndexs = null;
            int size = PMColl.size();
            for (int i = 0; i < size; ++i) {
                PMInfo = PMColl.get(i);
                evaluSolutionId = PMInfo.getEvaluSolution().getId().toString();
                if (ESIdAndTableRelation == null || ESIdAndTableRelation.isEmpty() || ESIdAndTableRelation.get(evaluSolutionId) == null || (rowIndexs = (Set)ESIdAndTableRelation.get(evaluSolutionId)) == null || rowIndexs.isEmpty()) continue;
                Iterator it = rowIndexs.iterator();
                while (it.hasNext()) {
                    int rowIndex = (Integer)it.next();
                    row = table.getRow(rowIndex);
                    if (columnKeys != null && columnKeys.length > 0) {
                        int len = columnKeys.length;
                        for (int k = 0; k < len; ++k) {
                            PFUtils.setTableNumberFormat(row, columnKeys[k], PMInfo.getTotalPrecision());
                        }
                    }
                    isUsedRowIndex.add(new Integer(rowIndex));
                }
            }
        }
        int size = table.getRowCount();
        for (int i = 0; i < size; ++i) {
            if (isUsedRowIndex.contains(new Integer(i))) continue;
            row = table.getRow(i);
            if (columnKeys == null || columnKeys.length <= 0) continue;
            int len = columnKeys.length;
            for (int k = 0; k < len; ++k) {
                PFUtils.setTableNumberFormat(row, columnKeys[k], 2);
            }
        }
    }

    public static Set getEvaluSolutionIds(KDTable table, String evaluSolutionIdColumnKey, Map ESIdAndTableRelation) {
        HashSet<String> ids = new HashSet<String>();
        String evaluSolutionId = null;
        ESIdAndTableRelation.clear();
        int count = table.getRowCount();
        for (int i = 0; i < count; ++i) {
            if (table.getRow(i).getCell(evaluSolutionIdColumnKey) == null || table.getRow(i).getCell(evaluSolutionIdColumnKey).getValue() == null) continue;
            evaluSolutionId = table.getRow(i).getCell(evaluSolutionIdColumnKey).getValue().toString();
            ids.add(evaluSolutionId);
            if (ESIdAndTableRelation.containsKey(evaluSolutionId)) {
                if (ESIdAndTableRelation.get(evaluSolutionId) == null) continue;
                ((Set)ESIdAndTableRelation.get(evaluSolutionId)).add(new Integer(i));
                continue;
            }
            HashSet<Integer> rows = new HashSet<Integer>();
            rows.add(new Integer(i));
            ESIdAndTableRelation.put(evaluSolutionId, rows);
        }
        return ids;
    }

    public static void setDataPrecision(EvaluSolutionInfo evaluSolutionInfo, KDFormattedTextField txt, int type) throws Exception {
        if (evaluSolutionInfo != null && evaluSolutionInfo.getId() != null) {
            PFUtils.setDataPrecision(evaluSolutionInfo.getId().toString(), txt, type);
        }
    }

    public static void setDataPrecision(String evaluSolutionId, KDFormattedTextField txt, int type) throws Exception {
        PrecisionMaintainInfo pmInfo = PFUtils.getPrecisionMaintainInfo(evaluSolutionId);
        if (pmInfo != null) {
            switch (type) {
                case 1: {
                    PFUtils.setPrecision(txt, pmInfo.getIndexGradePrecision(), pmInfo.getIndexGradePrecisionType().getValue());
                    break;
                }
                case 2: {
                    PFUtils.setPrecision(txt, pmInfo.getNodeScorePrecision(), pmInfo.getNodeScorePrecisionType().getValue());
                    break;
                }
                case 3: {
                    PFUtils.setPrecision(txt, pmInfo.getTotalPrecision(), pmInfo.getTotalPrecisionType().getValue());
                }
            }
        } else {
            PFUtils.setPrecision(txt, 2, 10);
        }
    }

    public static void setPrecision(KDFormattedTextField txt, int precision, int precisionType) {
        txt.setPrecision(precision);
        txt.setRemoveingZeroInDispaly(false);
        txt.setRemoveingZeroInEdit(false);
        switch (precisionType) {
            case 10: {
                txt.setRoundingMode(4);
                break;
            }
            case 20: {
                txt.setRoundingMode(0);
                break;
            }
            case 30: {
                txt.setRoundingMode(1);
            }
        }
    }

    public static void setTableColumnPrecision(KDTable table, String evaluSolutionIdColumnKey, String columnKey, int type) throws Exception {
        String evaluSolutionId = PFUtils.getEvaluSolutionId(table, evaluSolutionIdColumnKey);
        PrecisionMaintainInfo PMInfo = PFUtils.getPrecisionMaintainInfo(evaluSolutionId);
        if (PMInfo != null) {
            switch (type) {
                case 1: {
                    PFUtils.setTableNumberFormat(table, columnKey, PMInfo.getIndexGradePrecision());
                    break;
                }
                case 2: {
                    PFUtils.setTableNumberFormat(table, columnKey, PMInfo.getNodeScorePrecision());
                    break;
                }
                case 3: {
                    PFUtils.setTableNumberFormat(table, columnKey, PMInfo.getTotalPrecision());
                }
            }
        } else {
            PFUtils.setTableNumberFormat(table, columnKey, 2);
        }
    }

    public static String getEvaluSolutionId(KDTable table, String columnKey) {
        String evaluSolutionId = null;
        IRow row = null;
        if (table != null && table.getRowCount() > 0 && (row = table.getRow(0)).getCell(columnKey) != null && row.getCell(columnKey).getValue() != null) {
            evaluSolutionId = row.getCell(columnKey).getValue().toString();
        }
        return evaluSolutionId;
    }

    public static PrecisionMaintainInfo getDefaultPrecisionMaintainInfo() {
        PrecisionMaintainInfo pMaintainInfo = new PrecisionMaintainInfo();
        pMaintainInfo.setIndexGradePrecision(2);
        pMaintainInfo.setNodeScorePrecision(2);
        pMaintainInfo.setTotalPrecision(2);
        pMaintainInfo.setIndexGradePrecisionType(PrecisionTypeEnum.ROUND);
        pMaintainInfo.setNodeScorePrecisionType(PrecisionTypeEnum.ROUND);
        pMaintainInfo.setTotalPrecisionType(PrecisionTypeEnum.ROUND);
        return pMaintainInfo;
    }
}

