/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabelContainer;
import com.kingdee.bos.ctrl.swing.KDNumberTextField;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.workflow.monitor.client.WfMonitorUtils;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.perf.EvalWorkFlowFacadeFactory;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;

public class PFVerifyUtils {
    private static String path = "com.kingdee.eas.hr.perf.PerformanceResource";
    public static final BigDecimal ZERO = new BigDecimal("0.00");

    public static void verifyInput(CoreUIObject ui, String resourcePath, KDTable kdtEntries, IRow row, int i, String msg) {
        if (PFVerifyUtils.isEmpty(row.getCell(i).getValue())) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), i);
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, String key) {
        IRow row = null;
        for (int j = 0; j < kdtEntries.getRowCount(); ++j) {
            row = kdtEntries.getRow(j);
            PFVerifyUtils.verifyInput(ui, kdtEntries, row, key);
        }
    }

    public static void verifyInput(CoreUIObject ui, KDTable kdtEntries, IRow row, String key) {
        int colIndex = kdtEntries.getColumnIndex(key);
        if (PFVerifyUtils.isEmpty(row.getCell(key).getValue())) {
            kdtEntries.getEditManager().editCellAt(row.getRowIndex(), colIndex);
            String headValue = (String)kdtEntries.getHeadRow(0).getCell(key).getValue();
            String msg = headValue + " " + EASResource.getString((String)path, (String)"CanNotBeNull");
            msg = msg.replaceAll("#", " " + headValue + " ");
            MsgBox.showWarning((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDTextField txtNumber, String msg) {
        String txt = txtNumber.getText();
        if (txt == null || txt.trim().equals("")) {
            txtNumber.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath == null || msg == null ? PFVerifyUtils.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDTextField txtNumber) {
        PFVerifyUtils.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizMultiLangBox txtNumber, String msg) {
        Object txt = txtNumber.getSelectedItem();
        if (txt == null || txt.toString().trim().equals("")) {
            txtNumber.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath == null || msg == null ? PFVerifyUtils.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizMultiLangBox txtNumber) {
        PFVerifyUtils.verifyEmpty(ui, null, txtNumber, null);
    }

    private static String getMessage(Component component) {
        String text = PFVerifyUtils.getBoundLabelText(component);
        return text + EASResource.getString((String)path, (String)"CanNotBeNull");
    }

    public static void verifyEmpty(CoreUIObject ui, KDNumberTextField txtNumber) {
        PFVerifyUtils.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDNumberTextField txtNumber, String msg) {
        Number txt = txtNumber.getNumberValue();
        if (txt == null) {
            txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? PFVerifyUtils.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    private static String getBoundLabelText(Component component) {
        String text = "";
        if (component.getParent() instanceof KDLabelContainer) {
            text = ((KDLabelContainer)component.getParent()).getBoundLabelText();
        }
        return text;
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDBizPromptBox bizBox, String msg) {
        Object content = bizBox.getData();
        boolean empty = false;
        if (content == null) {
            empty = true;
        } else if (bizBox.isEnabledMultiSelection()) {
            Object[] objs = (Object[])content;
            boolean bl = empty = objs.length == 0 || objs[0] == null;
        }
        if (empty) {
            bizBox.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath == null || msg == null ? PFVerifyUtils.getMessage((Component)bizBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDBizPromptBox bizBox) {
        PFVerifyUtils.verifyEmpty(ui, null, bizBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDComboBox comboBox, String msg) {
        Object content = comboBox.getSelectedItem();
        if (content == null) {
            comboBox.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath == null || msg == null ? PFVerifyUtils.getMessage((Component)comboBox) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDComboBox comboBox) {
        PFVerifyUtils.verifyEmpty(ui, null, comboBox, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDDatePicker datePicker, String msg) {
        String content = datePicker.getText();
        if (content == null || content.equals("")) {
            datePicker.requestFocus(true);
            MsgBox.showInfo((Component)ui, (String)(resourcePath == null || msg == null ? PFVerifyUtils.getMessage((Component)datePicker) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDDatePicker datePicker) {
        PFVerifyUtils.verifyEmpty(ui, null, datePicker, null);
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, KDFormattedTextField txtNumber, String msg) {
        Number txt = txtNumber.getNumberValue();
        if (txt == null) {
            txtNumber.requestFocus(true);
            MsgBox.showWarning((Component)ui, (String)(resourcePath == null || msg == null ? PFVerifyUtils.getMessage((Component)txtNumber) : EASResource.getString((String)resourcePath, (String)msg)));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, KDFormattedTextField txtNumber) {
        PFVerifyUtils.verifyEmpty(ui, null, txtNumber, null);
    }

    public static void checkStringLength(Component ui, String resourcePath, IRow row, String colName, int length) {
        String name = (String)row.getCell(colName).getValue();
        if (name != null && name.length() > length) {
            MsgBox.showWarning((Component)ui, (String)(EASResource.getString((String)resourcePath, (String)"StringLengthGreaterthan") + length + ":" + "\n\n" + name));
            SysUtil.abort();
        }
    }

    public static void verifyEmpty(CoreUIObject ui, String resourcePath, Object value, String msg) {
        if (value == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyEmptyAndNoZero(CoreUIObject ui, String resourcePath, Object value, String msg) {
        if (value == null) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
        if (value instanceof BigDecimal && ((BigDecimal)value).equals(new BigDecimal("0"))) {
            MsgBox.showWarning((Component)ui, (String)EASResource.getString((String)resourcePath, (String)msg));
            SysUtil.abort();
        }
    }

    public static void verifyDateBigOrSmall(CoreUIObject ui, KDDatePicker pkStartDate, KDDatePicker pkEndDate) {
        Date smallDate;
        if (pkStartDate.getValue() == null || pkEndDate.getValue() == null) {
            return;
        }
        Date bigDate = DateTimeUtils.truncateDate((Date)((Date)pkEndDate.getValue()));
        if (!bigDate.after(smallDate = DateTimeUtils.truncateDate((Date)((Date)pkStartDate.getValue())))) {
            pkEndDate.requestFocus(true);
            String msg = PFVerifyUtils.getBoundLabelText((Component)pkEndDate) + EASResource.getString((String)path, (String)"BigThan") + PFVerifyUtils.getBoundLabelText((Component)pkStartDate) + EASResource.getString((String)path, (String)".");
            MsgBox.showInfo((Component)ui, (String)msg);
            SysUtil.abort();
        }
    }

    public static boolean isEmpty(Object o) {
        return o == null || o.toString().trim().length() == 0;
    }

    public static boolean objectIsNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return StringUtils.isEmpty((String)obj.toString());
        }
        return false;
    }

    public static String formatBigDecimal(BigDecimal value, int precicion) {
        if (PFVerifyUtils.objectIsNull(value)) {
            return "";
        }
        String str = ZERO.compareTo(value) == 0 ? "0.00000000000000000000000" : value.toString();
        if (str.lastIndexOf(".") == -1) {
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(str);
            strBuffer.append(".");
            for (int i = 0; i < precicion; ++i) {
                strBuffer.append("0");
            }
            return strBuffer.toString();
        }
        if (str.lastIndexOf(".") == str.length() - 2) {
            return str + "0";
        }
        int len = str.lastIndexOf(".") + 1 + precicion;
        return str.substring(0, len);
    }

    public static BigDecimal objToBigDecimal(Object obj) {
        if (PFVerifyUtils.objectIsNull(obj)) {
            return new BigDecimal("0.0");
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        try {
            return new BigDecimal(obj.toString().trim());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean bigDecimalBetween(BigDecimal value, BigDecimal from, BigDecimal to) {
        if (PFVerifyUtils.objectIsNull(value) || PFVerifyUtils.objectIsNull(from) || PFVerifyUtils.objectIsNull(to)) {
            return false;
        }
        BigDecimal zeroDecimal = new BigDecimal("0.0");
        return value.subtract(from).compareTo(zeroDecimal) >= 0 && to.subtract(value).compareTo(zeroDecimal) >= 0;
    }

    public static boolean isNumberString(String str) {
        if (PFVerifyUtils.objectIsNull(str)) {
            return false;
        }
        str = str.trim();
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static RankInfo getRankInfoInEvaluFlow(String solutionPeriodId, String evaluObjectId) throws Exception {
        if (solutionPeriodId == null || evaluObjectId == null) {
            return null;
        }
        return EvalWorkFlowFacadeFactory.getRemoteInstance().getNodeProcesserRankInfo(solutionPeriodId, evaluObjectId);
    }

    public static void makeMaskString(StringBuffer maskString, int index, String logicWord) {
        if (index == 0) {
            maskString.append("#" + index);
        } else {
            maskString.append(logicWord + "#" + index);
        }
    }

    public static HashSet getOrgRangeWithHROandAdminRange() throws Exception {
        AdminOrgUnitCollection adminColl = HROrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollectionWithOrgRangeFilter(SysContext.getSysContext().getCurrentHRUnit().getId().toString());
        HashSet<String> orgSet = new HashSet<String>();
        int n = adminColl.size();
        for (int i = 0; i < n; ++i) {
            orgSet.add(adminColl.get(i).getId().toString());
        }
        return orgSet;
    }

    public static void showWorkFlowDef(CoreUIObject ui, String procDefId) throws Exception {
        WfMonitorUtils.showWfDiagramDefine((Component)ui, (String)procDefId);
    }

    public static void verifyNumberBig(CoreUIObject ui, KDFormattedTextField firstNumber, KDFormattedTextField secondNumber) {
        Number first = firstNumber.getNumberValue();
        Number second = secondNumber.getNumberValue();
        if (first == null || second == null) {
            return;
        }
        if (second.doubleValue() > first.doubleValue()) {
            firstNumber.requestFocus();
            StringBuffer msg = new StringBuffer();
            msg.append(PFVerifyUtils.getBoundLabelText((Component)secondNumber));
            msg.append(" ");
            msg.append(EASResource.getString((String)path, (String)"BigThan"));
            msg.append(" ");
            msg.append(PFVerifyUtils.getBoundLabelText((Component)firstNumber));
            MsgBox.showInfo((Component)ui, (String)msg.toString());
            SysUtil.abort();
        }
    }
}

