/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.extendcontrols.KDBizMultiLangBox;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDatePicker;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextArea;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.HROrgUnitFactory;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.multiDetail.DetailPanel;
import com.kingdee.eas.hr.train.client.TrainHelper;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.enums.EnumUtils;
import com.kingdee.util.enums.IntEnum;
import com.kingdee.util.enums.StringEnum;
import java.awt.Color;
import java.awt.Component;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class PerfClientUtils {
    static Color disableColor = Color.decode("#F5F5E6");
    static Color requiredColor = Color.decode("#FCFBDF");
    static Color normalColor = Color.decode("#FFFFFF");
    static String AND = "AND";
    static String OR = "OR";
    static int PRECISION = 2;
    static Float maxPrecision = new Float("99999999.99");
    static Float minPrecision = new Float("0.00");
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final BigDecimal HUNDRED = new BigDecimal("100.00");
    public static final BigDecimal PERCENT = new BigDecimal("0.01");

    public static boolean objectIsNull(Object obj) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String) {
            return StringUtils.isEmpty((String)obj.toString());
        }
        return false;
    }

    public static String getResource(String RES, String message) {
        return EASResource.getString((String)RES, (String)message);
    }

    public static void showErrorMessage(String RES, String message, CoreUI uiObject) {
        MsgBox.showError((Component)uiObject, (String)PerfClientUtils.getResource(RES, message));
        uiObject.setCursorOfDefault();
        SysUtil.abort();
    }

    public static void showErrorMessage(String msg, CoreUI uiObject) {
        MsgBox.showError((Component)uiObject, (String)msg);
        uiObject.setCursorOfDefault();
        SysUtil.abort();
    }

    public static void showErrorMessage(String RES, String message, Object[] variables, CoreUI uiObject) {
        MsgBox.showError((Component)uiObject, (String)MessageFormat.format(PerfClientUtils.getResource(RES, message), variables));
        uiObject.setCursorOfDefault();
        SysUtil.abort();
    }

    public static void showMessage(String RES, String message, CoreUI uiObject) {
        MsgBox.showInfo((Component)uiObject, (String)PerfClientUtils.getResource(RES, message));
    }

    public static boolean showConfirmMessge(String RES, String message, CoreUI uiObject) {
        int result = MsgBox.showConfirm2((Component)uiObject, (String)PerfClientUtils.getResource(RES, message));
        if (result == 0) {
            return true;
        }
        if (result == 2) {
            return false;
        }
        return false;
    }

    public static String formatBigDecimal(BigDecimal value, int precicion) {
        if (PerfClientUtils.objectIsNull(value)) {
            return "";
        }
        String str = ZERO.compareTo(value) == 0 ? "0.00000000000000000000000" : value.toString();
        if (str.lastIndexOf(".") == -1) {
            StringBuffer strBuffer = new StringBuffer();
            strBuffer.append(str);
            strBuffer.append(".");
            for (int i = 0; i < precicion; ++i) {
                strBuffer.append("0");
            }
            return strBuffer.toString();
        }
        if (str.lastIndexOf(".") == str.length() - 2) {
            return str + "0";
        }
        int len = str.lastIndexOf(".") + 1 + precicion;
        return str.substring(0, len);
    }

    public static IRow getSelectedRow(KDTable tblMain) {
        KDTSelectBlock selectBlock = tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            IRow row = tblMain.getRow(rowIndex);
            return row;
        }
        return null;
    }

    public static int getSelectedRowIndex(KDTable tblMain) {
        KDTSelectBlock selectBlock = tblMain.getSelectManager().get();
        if (selectBlock != null) {
            return selectBlock.getTop();
        }
        return 0;
    }

    public static FilterInfo getCurrentHROFilter() {
        FilterInfo filter = new FilterInfo();
        if (SysContext.getSysContext().getCurrentHRUnit() == null) {
            return filter;
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    public static EntityViewInfo getCurrentHREntityViewInfo() {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(PerfClientUtils.getCurrentHROFilter());
        return viewInfo;
    }

    public static void checkValidHRO(CoreUI uiObject) {
        if (PerfClientUtils.objectIsNull(SysContext.getSysContext().getCurrentHRUnit())) {
            PerfClientUtils.showErrorMessage("com.kingdee.eas.hr.perf.PerfResource", "currentUserNoHRO", uiObject);
        }
    }

    public static void checkValidPerson(CoreUI uiObject) {
        if (PerfClientUtils.objectIsNull(SysContext.getSysContext().getCurrentUserInfo().getPerson())) {
            PerfClientUtils.showErrorMessage("com.kingdee.eas.hr.perf.PerfResource", "userNoPerson", uiObject);
        }
    }

    public static String getCurrentPersonID() {
        return SysContext.getSysContext().getCurrentUserInfo().getPerson().getId().toString();
    }

    public static String getCurrentHROID() {
        return SysContext.getSysContext().getCurrentHRUnit().getId().toString();
    }

    public static void setBimBuildEntryWorkButtonState(KDTable table, boolean state) {
        HashSet<String> set = new HashSet<String>();
        set.add("btnAddnewLine");
        set.add("btnInsertLine");
        set.add("btnRemoveLines");
        Component[] components = ((DetailPanel)table.getParent().getParent()).getComponents();
        int n = components.length;
        for (int i = 0; i < n; ++i) {
            if (!"controlPanel".equals(components[i].getName().toString()) || !(components[i] instanceof KDPanel)) continue;
            Component[] components2 = ((KDPanel)components[i]).getComponents();
            int m = components2.length;
            for (int j = 0; j < m; ++j) {
                if (!set.contains(components2[j].getName().toString()) || !(components2[j] instanceof KDWorkButton)) continue;
                ((KDWorkButton)components2[j]).setEnabled(state);
            }
        }
    }

    public static void addLine(KDTable table) {
        if (table == null) {
            return;
        }
        table.addRow();
    }

    public IRow insertLine(KDTable table) {
        if (table == null) {
            return null;
        }
        IRow row = null;
        if (table.getSelectManager().size() > 0) {
            int top = table.getSelectManager().get().getTop();
            row = PerfClientUtils.isTableColumnSelected(table) ? table.addRow() : table.addRow(top);
        } else {
            row = table.addRow();
        }
        return row;
    }

    public static void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0 || PerfClientUtils.isTableColumnSelected(table)) {
            return;
        }
        int[] selectRowsIndex = TrainHelper.getSelectedRows((KDTable)table);
        if (selectRowsIndex.length > 0) {
            int[] selectedColumnIndexs = TrainHelper.getSelectedColumns((KDTable)table);
            Arrays.sort(selectRowsIndex);
            for (int i = selectRowsIndex.length - 1; i >= 0; --i) {
                PerfClientUtils.removeRow(table, selectRowsIndex[i]);
            }
            if (table.getRowCount() > 0) {
                Arrays.sort(selectedColumnIndexs);
                int columnIndex = 0;
                if (selectedColumnIndexs.length > 0) {
                    columnIndex = selectedColumnIndexs[0];
                }
                table.getSelectManager().select(selectRowsIndex[0], columnIndex);
            }
        }
    }

    public static void removeRow(KDTable table, int rowIndex) {
        IObjectCollection collection;
        int index;
        Object detailData = table.getRow(rowIndex).getUserObject();
        table.removeRow(rowIndex);
        if (detailData != null && (index = PerfClientUtils.getCollectionIndex(collection = (IObjectCollection)table.getUserObject(), (IObjectValue)detailData)) >= 0 && collection.size() > index) {
            collection.removeObject(index);
        }
    }

    public static void removeRows(KDTable table) {
        for (int i = table.getRowCount() - 1; i >= 0; --i) {
            PerfClientUtils.removeRow(table, i);
        }
    }

    private static int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    private static boolean isTableColumnSelected(KDTable table) {
        KDTSelectBlock block;
        return table.getSelectManager().size() > 0 && ((block = table.getSelectManager().get()).getMode() == 4 || block.getMode() == 8);
    }

    public static String getStartDate2EndDateString(Date startDate, Date endDate, String seperate) {
        if (startDate == null || endDate == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(startDate);
        sb.append(seperate);
        sb.append(endDate);
        return sb.toString();
    }

    public static boolean isOrgResponser() throws Exception {
        AdminOrgUnitCollection adminColl = HROrgUnitFactory.getRemoteInstance().getAdminOrgUnitCollectionWithOrgRangeFilter(SysContext.getSysContext().getCurrentHRUnit().getId().toString());
        return adminColl.size() > 0;
    }

    public static void makeMaskString(StringBuffer maskString, int index, String logicWord) {
        if (index == 0) {
            maskString.append("#" + index);
        } else {
            maskString.append(logicWord + "#" + index);
        }
    }

    public static boolean objectArrayIsNull(Object obj) {
        if (PerfClientUtils.objectIsNull(obj)) {
            return true;
        }
        if (obj instanceof Object[] && ((Object[])obj).length == 0) {
            return true;
        }
        return obj instanceof Object[] && PerfClientUtils.objectIsNull(((Object[])obj)[0]);
    }

    public static HashSet getObjectArrayIds(Object obj) {
        HashSet<String> set = new HashSet<String>();
        Object[] objs = null;
        objs = obj instanceof Object[] ? (Object[])obj : new Object[]{obj};
        if (objs != null) {
            int n = objs.length;
            for (int i = 0; i < n; ++i) {
                set.add(((CoreBaseInfo)objs[i]).getId().toString());
            }
        }
        return set;
    }

    public static String getObjectID(Object obj) {
        return ((CoreBaseInfo)obj).getId().toString();
    }

    public static BigDecimal objToBigDecimal(Object obj) {
        if (PerfClientUtils.objectIsNull(obj)) {
            return new BigDecimal("0.0");
        }
        if (obj instanceof BigDecimal) {
            return (BigDecimal)obj;
        }
        try {
            return new BigDecimal(obj.toString().trim());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void setBigDecimalDisplayFormatter(KDFormattedTextField formattedTextField, int prec) {
        formattedTextField.setRemoveingZeroInDispaly(false);
        formattedTextField.setRemoveingZeroInEdit(false);
        formattedTextField.setPrecision(prec);
    }

    public static void setPercentageDisplayFormatter(KDFormattedTextField formattedTextField, int prec) {
        formattedTextField.setPrecision(prec);
        formattedTextField.setRemoveingZeroInDispaly(false);
        formattedTextField.setRemoveingZeroInEdit(false);
        formattedTextField.setPercentDisplay(true);
    }

    public static void setFormattedTextFieldMaxMinValue(KDFormattedTextField formattedTextField, Float min, Float max) {
        formattedTextField.setMaximumValue((Comparable)max);
        formattedTextField.setMinimumValue((Comparable)min);
    }

    public static void setFormattedTextFieldMaxMinValue(KDFormattedTextField formattedTextField) {
        PerfClientUtils.setFormattedTextFieldMaxMinValue(formattedTextField, minPrecision, maxPrecision);
    }

    public static String convertSpecialStringTo(String solutionPeriodName) {
        if (solutionPeriodName == null) {
            return null;
        }
        int last = solutionPeriodName.lastIndexOf("----");
        if (last == -1) {
            return solutionPeriodName;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(solutionPeriodName.substring(0, last));
        sb.append(EASResource.getString((String)"com.kingdee.eas.hr.perf.PerfWebResource", (String)"to"));
        sb.append(solutionPeriodName.substring(last + 2));
        return sb.toString();
    }

    public static void setComponentEnable(IKDTextComponent component, boolean flag) {
        int authority = component.getAccessAuthority();
        component.setAccessAuthority(0);
        component.setEnabled(flag);
        component.setAccessAuthority(authority);
    }

    public static void setTableCellEditorByF7Selector(KDTable tblMain, KDPromptSelector selector, String property) throws Exception {
        KDBizPromptBox promptBox = new KDBizPromptBox();
        promptBox.setEditable(true);
        promptBox.setEditFormat("$number$");
        promptBox.setDisplayFormat("$name$");
        promptBox.setCommitFormat("$number$");
        promptBox.setSelector(selector);
        promptBox.setEditable(false);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)promptBox));
    }

    public static void setTableCellEditorByTextArea(KDTable tblMain, String property) throws Exception {
        KDTextArea txtArea = new KDTextArea();
        txtArea.setMaxLength(255);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextArea)txtArea));
    }

    public static void setTableCellEditorByTextArea(KDTable tblMain, String property, int areaSize) throws Exception {
        KDTextArea txtArea = new KDTextArea();
        txtArea.setMaxLength(areaSize);
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JTextArea)txtArea));
    }

    public static void setEnumComboBoxSelected(KDComboBox comboBox, String id) {
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        int count = comboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            Object item = comboBox.getItemAt(i);
            String value = null;
            if (item == null) continue;
            if (item instanceof StringEnum) {
                value = ((StringEnum)item).getValue();
            } else if (item instanceof IntEnum) {
                value = String.valueOf(((IntEnum)item).getValue());
            } else if (item != null) {
                value = item.toString();
            }
            if (!id.equals(value)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    public static void setComboBoxSelected(KDComboBox comboBox, String id) {
        int count = comboBox.getItemCount();
        for (int i = 0; i < count; ++i) {
            Object item = comboBox.getItemAt(i);
            String value = null;
            if (item instanceof CoreBaseInfo) {
                value = ((CoreBaseInfo)item).getId().toString();
            } else if (item != null) {
                value = item.toString();
            }
            if (!id.equals(value)) continue;
            comboBox.setSelectedIndex(i);
            break;
        }
    }

    public static void setTableCellEditorByComboBox(KDTable tblMain, String property, String enumString) throws Exception {
        KDComboBox box = new KDComboBox();
        box.setVisible(true);
        box.addItems(EnumUtils.getEnumList((String)enumString).toArray());
        tblMain.getColumn(property).setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)box));
    }

    public static List getSelectedRows(KDTable table) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int[] selectRowsIndex = TrainHelper.getSelectedRows((KDTable)table);
        Arrays.sort(selectRowsIndex);
        for (int i = 0; i < selectRowsIndex.length; ++i) {
            if (list.contains(new Integer(selectRowsIndex[i]))) continue;
            list.add(new Integer(selectRowsIndex[i]));
        }
        return list;
    }

    public static void setCellPrmtEditor(KDTable table, String column, KDBizPromptBox prmt) {
        KDTDefaultCellEditor name_cellEditor = new KDTDefaultCellEditor((IKDEditor)prmt);
        table.getColumn(column).setEditor((ICellEditor)name_cellEditor);
    }

    public static void setCellTextEditor(KDTable table, String column, int minLength, int maxLength) {
        KDTextField textField = new KDTextField();
        textField.setMinLength(minLength);
        textField.setMaxLength(maxLength);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)textField);
        table.getColumn(column).setEditor((ICellEditor)cellEditor);
    }

    public static void setCellNumberEditor(KDTable table, String column, int dataType, int precision, int min, int max) {
        KDFormattedTextField field = new KDFormattedTextField();
        field.setDataType(dataType);
        field.setPrecision(precision);
        field.setMinimumValue((Comparable)new BigDecimal(min));
        field.setMaximumValue((Comparable)new BigDecimal(max));
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JTextField)field);
        table.getColumn(column).setEditor((ICellEditor)cellEditor);
    }

    public static void setCellComboBoxEditor(KDTable table, String column, Object[] items) {
        KDComboBox box = new KDComboBox();
        box.addItems(items);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JComboBox)box);
        table.getColumn(column).setEditor((ICellEditor)cellEditor);
    }

    public static void setCellDateEditor(KDTable table, String column, boolean editabl) {
        if (table == null || column == null) {
            return;
        }
        KDDatePicker datePicker = new KDDatePicker();
        datePicker.setEditable(true);
        datePicker.setVisible(true);
        datePicker.setDatePattern("yyyy-MM-dd");
        KDTDefaultCellEditor datePicker_CellEditor = new KDTDefaultCellEditor(datePicker);
        table.getColumn(column).setEditor((ICellEditor)datePicker_CellEditor);
    }

    public static void setCellQueryInfo(KDTable table, String column, String query) {
        KDBizPromptBox prmtPoliticalFace = new KDBizPromptBox();
        prmtPoliticalFace.setDisplayFormat("$name$");
        prmtPoliticalFace.setQueryInfo(query);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)prmtPoliticalFace);
        table.getColumn(column).setEditor((ICellEditor)cellEditor);
    }

    public static void setCellQueryInfo2(KDTable table, String column, String query, boolean editable) {
        KDBizPromptBox prmtPoliticalFace = new KDBizPromptBox();
        prmtPoliticalFace.setDisplayFormat("$name$");
        prmtPoliticalFace.setQueryInfo(query);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((IKDEditor)prmtPoliticalFace);
        table.getColumn(column).setEditor((ICellEditor)cellEditor);
        prmtPoliticalFace.setEditable(editable);
    }

    public static void setCellCheckBoxEditor(KDTable table, String column, boolean defaultSelected) {
        KDCheckBox checkBox = new KDCheckBox();
        checkBox.setSelected(defaultSelected);
        KDTDefaultCellEditor cellEditor = new KDTDefaultCellEditor((JCheckBox)checkBox);
        table.getColumn(column).setEditor((ICellEditor)cellEditor);
    }

    public static void setComboBoxSelected(KDTEditEvent e) {
        KDTable table = (KDTable)e.getSource();
        Component component = table.getEditManager().getEditor().getComponent();
        if (component != null && component instanceof KDComboBox) {
            int colIndex = e.getColIndex();
            int rowIndex = e.getRowIndex();
            PerfClientUtils.setComboBoxSelected((KDComboBox)component, table, rowIndex, colIndex);
        }
    }

    public static void setComboBoxSelected(KDComboBox comboBox, KDTable table, int rowIndex, int colIndex) {
        CoreBaseInfo info;
        IRow row = table.getRow(rowIndex);
        Object obj = row.getCell(colIndex).getValue();
        if (obj instanceof CoreBaseInfo && (info = (CoreBaseInfo)obj) != null && info.getId() != null) {
            PerfClientUtils.setComboBoxSelected(comboBox, info.getId().toString());
        }
    }

    public static void setMultiLangBoxSelectedLanguage(KDBizMultiLangBox multiLangBox) {
        List langList = KDBizMultiLangBox.getLanguageList();
        Iterator iter = langList.iterator();
        LanguageInfo defaultLang = null;
        while (iter.hasNext()) {
            LanguageInfo currentLang = (LanguageInfo)iter.next();
            if (!LocaleUtils.getDefaultLocale().equals(currentLang.getLocale())) continue;
            defaultLang = currentLang;
        }
        if (defaultLang != null) {
            multiLangBox.setSelectedLanguage(defaultLang);
        }
    }
}

