/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.swing.IKDTextComponent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.AlreadyBindProcessInstanceException;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.IPersonFacade;
import com.kingdee.eas.basedata.person.PersonFacadeFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.AssessPeriodFacadeFactory;
import com.kingdee.eas.hr.perf.AssessPeriodInfo;
import com.kingdee.eas.hr.perf.EvaluObjectFactory;
import com.kingdee.eas.hr.perf.EvaluObjectInfo;
import com.kingdee.eas.hr.perf.IAssessPeriodFacade;
import com.kingdee.eas.hr.perf.IEvaluObject;
import com.kingdee.eas.hr.perf.PerfSummaryFactory;
import com.kingdee.eas.hr.perf.PerfSummaryInfo;
import com.kingdee.eas.hr.perf.client.AbstractPerfSummaryEditUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class PerfSummaryEditUI
extends AbstractPerfSummaryEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PerfSummaryEditUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private PersonInfo person = SysContext.getSysContext().getCurrentUserInfo().getPerson();

    protected IObjectValue createNewData() {
        PerfSummaryInfo ret = new PerfSummaryInfo();
        ret.setPerson(this.person);
        ret.setAssessPeriod((AssessPeriodInfo)this.comboAssessPeriod.getSelectedItem());
        return ret;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PerfSummaryFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        if (this.getUIContext().get("CURRENT.VO") != null) {
            this.getUIContext().remove("CURRENT.VO");
        }
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.initWhenAddNew();
        } else {
            this.initWhenNotAddNew();
        }
        super.setQueryPreference(false);
        this.btnAttachment.setVisible(true);
        this.btnAttachment.setEnabled(true);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("assessPeriod.name"));
        return sic;
    }

    private void initWhenNotAddNew() throws Exception {
        this.person = this.editData.getPerson();
        this.initCommon();
        this.comboAssessPeriod.removeAllItems();
        this.comboAssessPeriod.addItem((Object)this.editData.getAssessPeriod());
        PerfClientUtils.setComponentEnable((IKDTextComponent)this.comboAssessPeriod, false);
    }

    private void initWhenAddNew() throws Exception {
        this.initCommon();
        HashMap map = this.getUnSummaryedAssessPeriod();
        if (map.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noAssessUnSum"));
            SysUtil.abort();
        } else {
            this.initAssessPeriod(map);
        }
    }

    private void initCommon() throws Exception {
        this.txtPersonNumber.setText(this.person.getNumber());
        PositionInfo position = PFUtils.getPositionReferToPerson(this.person);
        if (position != null) {
            this.txtPersonPosition.setText(position.getName());
            this.txtOrgUnit.setText(position.getAdminOrgUnit().getName());
        } else {
            this.txtPersonPosition.setText(null);
            this.txtOrgUnit.setText(null);
        }
        this.prmptEvaluPerson.setValue((Object)this.person);
        IPersonFacade facade = PersonFacadeFactory.getRemoteInstance();
        PersonInfo leader = facade.getSupervisor(BOSUuid.read((String)"00000000-0000-0000-0000-000000000001396FCAD0"), this.person.getId()).get(0);
        if (leader != null) {
            this.txtLeader.setText(leader.getName());
            position = PFUtils.getPositionReferToPerson(leader);
            if (position != null) {
                this.txtLeaderPosition.setText(position.getName());
            } else {
                this.txtLeaderPosition.setText(null);
            }
        }
    }

    protected HashSet getEvaluSolutionByObjectID(String objectID) throws Exception {
        IEvaluObject ieo = EvaluObjectFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("objectID", (Object)objectID, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaluSolution.id"));
        sic.add(new SelectorItemInfo("objectID"));
        CoreBaseCollection eoColl = ieo.getCollection(viewInfo);
        HashSet<String> set = null;
        if (eoColl != null && eoColl.size() > 0) {
            set = new HashSet<String>();
            int n = eoColl.size();
            for (int i = 0; i < n; ++i) {
                set.add(((EvaluObjectInfo)eoColl.get(i)).getEvaluSolution().getId().toString());
            }
        }
        return set;
    }

    private void initAssessPeriod(HashMap map) {
        this.comboAssessPeriod.removeAllItems();
        if (map.size() > 0) {
            AssessPeriodInfo info = null;
            Object key = null;
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                info = new AssessPeriodInfo();
                key = iter.next();
                info.setId(BOSUuid.read((String)key.toString()));
                info.setName((String)map.get(key));
                this.comboAssessPeriod.addItem((Object)info);
            }
            this.comboAssessPeriod.setSelectedIndex(0);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.verify(e);
        IObjectPK pk = null;
        try {
            pk = this.runSubmit();
        }
        catch (AlreadyBindProcessInstanceException wfExceptoin) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_BindWfInstance"));
            return;
        }
        this.editData.setId(BOSUuid.read((String)pk.toString()));
        CacheServiceFactory.getInstance().discardType(this.editData.getBOSType());
        this.showSubmitSuccess();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            this.idList.add(this.idList.getCurrentIndex() + 1, pk.toString());
            this.setOprtState(OprtState.EDIT);
            PerfClientUtils.setComponentEnable((IKDTextComponent)this.comboAssessPeriod, false);
        }
        this.setDataObject(this.getValue(pk));
        this.loadFields();
        this.setSave(true);
    }

    private HashMap getUnSummaryedAssessPeriod() throws Exception {
        IAssessPeriodFacade facade = AssessPeriodFacadeFactory.getRemoteInstance();
        HashMap map = facade.getUnSummaryedAssessPeriods(this.person.getId().toString());
        return map;
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
    }

    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"perfSummaryAttachment"));
        } else {
            super.actionAttachment_actionPerformed(e);
        }
    }

    public boolean checkBeforeWindowClosing() {
        if (OprtState.ADDNEW.equals(this.getOprtState()) && StringUtils.isEmpty((String)this.txtContent.getText())) {
            return true;
        }
        return super.checkBeforeWindowClosing();
    }

    protected void initUserConfig() {
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

