/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.KindEnum;
import com.kingdee.eas.hr.perf.PerformLibException;
import com.kingdee.eas.hr.perf.PerformTargetItemFactory;
import com.kingdee.eas.hr.perf.PerformTargetItemInfo;
import com.kingdee.eas.hr.perf.PerformTargetTypeInfo;
import com.kingdee.eas.hr.perf.PrecisionTypeEnum;
import com.kingdee.eas.hr.perf.ReportFrequencyEnum;
import com.kingdee.eas.hr.perf.client.AbstractPerformTargetItemEditUI;
import com.kingdee.eas.hr.perf.client.FormulaPromptBox;
import com.kingdee.eas.hr.train.client.TrainVerifyUtils;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import org.apache.log4j.Logger;

public class PerformTargetItemEditUI
extends AbstractPerformTargetItemEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PerformTargetItemEditUI.class);
    private boolean isIntermit = false;
    private boolean isModifiable = false;

    public void onLoad() throws Exception {
        super.onLoad();
        this.txtStandardValue.setPrecision(5);
        this.txtChallengeValue.setPrecision(5);
        this.txtThresholdValue.setPrecision(5);
        this.txtReservedField2.setPrecision(2);
        ((SpinnerNumberModel)this.txtMaxGrade.getModel()).setMaximum(new Integer(4));
        ((SpinnerNumberModel)this.txtMaxGrade.getModel()).setMinimum(new Integer(0));
        FormulaPromptBox formulaF7 = new FormulaPromptBox((IUIObject)this);
        formulaF7.setFormulaType(2);
        this.prmtCalFormula.setSelector((KDPromptSelector)formulaF7);
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.comboKind.addItems(KindEnum.getEnumList().toArray());
        this.comboPrecisionType.addItems(PrecisionTypeEnum.getEnumList().toArray());
        this.comboReportFrequency.addItems(ReportFrequencyEnum.getEnumList().toArray());
    }

    @Override
    protected IObjectValue createNewData() {
        PerformTargetItemInfo ret = new PerformTargetItemInfo();
        ret.setType(this.getTypeInfo());
        ret.setKind(KindEnum.QUALITATIVE);
        ret.setPrecisionType(PrecisionTypeEnum.ROUND);
        ret.setDataPrecision(2);
        ret.setCreator(SysContext.getSysContext().getCurrentUserInfo());
        ret.setCU(SysContext.getSysContext().getCurrentCtrlUnit());
        return ret;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return PerformTargetItemFactory.getRemoteInstance();
    }

    private PerformTargetTypeInfo getTypeInfo() {
        Object parentNode = this.getUIContext().get("ParentNode");
        if (parentNode == null) {
            return null;
        }
        return (PerformTargetTypeInfo)parentNode;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        TrainVerifyUtils.verifyEmpty((CoreUIObject)this, (KDTextField)this.txtNumber);
        if (StringUtils.isEmpty((String)this.txtContent.getText())) {
            this.txtContent.requestFocus();
            throw new PerformLibException(PerformLibException.NULL_NAME);
        }
        if (this.comboKind.getSelectedItem() == null) {
            this.comboKind.requestFocus();
            throw new PerformLibException(PerformLibException.NULL_KIND);
        }
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        this.getUIContext().put("ParentNode", this.editData.getType());
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.txtNumber.setEditable(this.isModifiable);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("type.id"));
        return sic;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    protected void comboKind_actionPerformed(ActionEvent e) throws Exception {
        boolean flag = KindEnum.QUANTITATIVE2.equals((Object)((KindEnum)((Object)this.comboKind.getSelectedItem())));
        this.contThresholdValue2.setVisible(flag);
        this.contStandardValue2.setVisible(flag);
        this.contChallengeValue2.setVisible(flag);
        this.contReservedNumberField.setVisible(flag);
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (KindEnum.QUANTITATIVE2.equals((Object)((KindEnum)((Object)this.comboKind.getSelectedItem())))) {
            BigDecimal value;
            BigDecimal multiplicand = new BigDecimal("100.00");
            if (this.editData.getThresholdValue() != null) {
                value = this.editData.getThresholdValue().multiply(multiplicand);
                this.txtThresholdValue.setValue((Object)value);
            }
            if (this.editData.getStandardValue() != null) {
                value = this.editData.getStandardValue().multiply(multiplicand);
                this.txtStandardValue.setValue((Object)value);
            }
            if (this.editData.getChallengeValue() != null) {
                value = this.editData.getChallengeValue().multiply(multiplicand);
                this.txtChallengeValue.setValue((Object)value);
            }
            if (this.editData.getReservedField2() != null) {
                value = this.editData.getReservedField2().multiply(multiplicand);
                this.txtReservedField2.setValue((Object)value);
            }
        }
    }

    @Override
    public void storeFields() {
        super.storeFields();
        int dataPrecision = Integer.valueOf(this.txtMaxGrade.getValue().toString());
        PrecisionTypeEnum precisionType = (PrecisionTypeEnum)((Object)this.comboPrecisionType.getSelectedItem());
        if (precisionType == null) {
            precisionType = PrecisionTypeEnum.ROUND;
            this.editData.setPrecisionType(precisionType);
        }
        if (PrecisionTypeEnum.ROUND.equals((Object)precisionType)) {
            if (KindEnum.QUANTITATIVE2.equals((Object)((KindEnum)((Object)this.comboKind.getSelectedItem())))) {
                BigDecimal value;
                BigDecimal multiplicand = new BigDecimal("0.01");
                if (this.editData.getThresholdValue() != null) {
                    value = this.editData.getThresholdValue().setScale(dataPrecision, 4).multiply(multiplicand);
                    this.editData.setThresholdValue(value);
                }
                if (this.editData.getStandardValue() != null) {
                    value = this.editData.getStandardValue().setScale(dataPrecision, 4).multiply(multiplicand);
                    this.editData.setStandardValue(value);
                }
                if (this.editData.getChallengeValue() != null) {
                    value = this.editData.getChallengeValue().setScale(dataPrecision, 4).multiply(multiplicand);
                    this.editData.setChallengeValue(value);
                }
                if (this.editData.getReservedField2() != null) {
                    value = this.editData.getReservedField2().setScale(dataPrecision, 4).multiply(multiplicand);
                    this.editData.setReservedField2(value);
                }
            } else {
                BigDecimal value;
                if (this.editData.getThresholdValue() != null) {
                    value = this.editData.getThresholdValue();
                    value = value.setScale(dataPrecision, 4);
                    this.editData.setThresholdValue(value);
                }
                if (this.editData.getStandardValue() != null) {
                    value = this.editData.getStandardValue();
                    value = value.setScale(dataPrecision, 4);
                    this.editData.setStandardValue(value);
                }
                if (this.editData.getChallengeValue() != null) {
                    value = this.editData.getChallengeValue();
                    value = value.setScale(dataPrecision, 4);
                    this.editData.setChallengeValue(value);
                }
                if (this.editData.getReservedField2() != null) {
                    value = this.editData.getReservedField2();
                    value = value.setScale(dataPrecision, 4);
                    this.editData.setReservedField2(value);
                }
            }
        } else if (PrecisionTypeEnum.TRUNCATE.equals((Object)precisionType)) {
            if (KindEnum.QUANTITATIVE2.equals((Object)((KindEnum)((Object)this.comboKind.getSelectedItem())))) {
                BigDecimal value;
                BigDecimal multiplicand = new BigDecimal("0.01");
                if (this.editData.getThresholdValue() != null) {
                    value = this.editData.getThresholdValue().setScale(dataPrecision, 1).multiply(multiplicand);
                    this.editData.setThresholdValue(value);
                }
                if (this.editData.getStandardValue() != null) {
                    value = this.editData.getStandardValue().setScale(dataPrecision, 1).multiply(multiplicand);
                    this.editData.setStandardValue(value);
                }
                if (this.editData.getChallengeValue() != null) {
                    value = this.editData.getChallengeValue().setScale(dataPrecision, 1).multiply(multiplicand);
                    this.editData.setChallengeValue(value);
                }
                if (this.editData.getReservedField2() != null) {
                    value = this.editData.getReservedField2().setScale(dataPrecision, 1).multiply(multiplicand);
                    this.editData.setReservedField2(value);
                }
            } else {
                BigDecimal value;
                if (this.editData.getThresholdValue() != null) {
                    value = this.editData.getThresholdValue();
                    value = value.setScale(dataPrecision, 1);
                    this.editData.setThresholdValue(value);
                }
                if (this.editData.getStandardValue() != null) {
                    value = this.editData.getStandardValue();
                    value = value.setScale(dataPrecision, 1);
                    this.editData.setStandardValue(value);
                }
                if (this.editData.getChallengeValue() != null) {
                    value = this.editData.getChallengeValue();
                    value = value.setScale(dataPrecision, 1);
                    this.editData.setChallengeValue(value);
                }
                if (this.editData.getReservedField2() != null) {
                    value = this.editData.getReservedField2();
                    value = value.setScale(dataPrecision, 1);
                    this.editData.setReservedField2(value);
                }
            }
        } else if (KindEnum.QUANTITATIVE2.equals((Object)((KindEnum)((Object)this.comboKind.getSelectedItem())))) {
            BigDecimal value;
            BigDecimal multiplicand = new BigDecimal("0.01");
            if (this.editData.getThresholdValue() != null) {
                value = this.editData.getThresholdValue().setScale(dataPrecision, 0).multiply(multiplicand);
                this.editData.setThresholdValue(value);
            }
            if (this.editData.getStandardValue() != null) {
                value = this.editData.getStandardValue().setScale(dataPrecision, 0).multiply(multiplicand);
                this.editData.setStandardValue(value);
            }
            if (this.editData.getChallengeValue() != null) {
                value = this.editData.getChallengeValue().setScale(dataPrecision, 0).multiply(multiplicand);
                this.editData.setChallengeValue(value);
            }
            if (this.editData.getReservedField2() != null) {
                value = this.editData.getReservedField2().setScale(dataPrecision, 0).multiply(multiplicand);
                this.editData.setReservedField2(value);
            }
        } else {
            BigDecimal value;
            if (this.editData.getThresholdValue() != null) {
                value = this.editData.getThresholdValue();
                value = value.setScale(dataPrecision, 0);
                this.editData.setThresholdValue(value);
            }
            if (this.editData.getStandardValue() != null) {
                value = this.editData.getStandardValue();
                value = value.setScale(dataPrecision, 0);
                this.editData.setStandardValue(value);
            }
            if (this.editData.getChallengeValue() != null) {
                value = this.editData.getChallengeValue();
                value = value.setScale(dataPrecision, 0);
                this.editData.setChallengeValue(value);
            }
            if (this.editData.getReservedField2() != null) {
                value = this.editData.getReservedField2();
                value = value.setScale(dataPrecision, 0);
                this.editData.setReservedField2(value);
            }
        }
    }

    @Override
    protected void setAutoNumberByOrg(String orgType) {
        super.setAutoNumberByOrg(orgType);
        String orgUnitId = SysContext.getSysContext().getCurrentHRUnit().getId().toString();
        try {
            ICodingRuleManager codingRuleManager = CodingRuleManagerFactory.getRemoteInstance();
            boolean result = codingRuleManager.isExist((IObjectValue)this.editData, orgUnitId);
            if (result) {
                this.isModifiable = codingRuleManager.isModifiable((IObjectValue)this.editData, orgUnitId);
                this.txtNumber.setEnabled(this.isModifiable);
                this.txtNumber.setEditable(this.isModifiable);
                if (OprtState.ADDNEW.equals(this.getOprtState())) {
                    this.isIntermit = codingRuleManager.isUseIntermitNumber((IObjectValue)this.editData, orgUnitId);
                    if (this.isIntermit) {
                        this.txtNumber.setEnabled(false);
                        this.txtNumber.setEditable(false);
                    }
                }
                if (OprtState.VIEW.equals(this.getOprtState())) {
                    this.txtNumber.setEnabled(false);
                    this.txtNumber.setEditable(false);
                }
            }
        }
        catch (BOSException e) {
            ExceptionHandler.handle((Throwable)e);
        }
        catch (EASBizException e1) {
            ExceptionHandler.handle((Throwable)e1);
        }
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        return super.getValue(pk);
    }

    public void txtMaxGrade_stateChanged(ChangeEvent e) {
    }
}

