/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.EvaluGroupTargetTypeFactory;
import com.kingdee.eas.hr.perf.EvaluTargetFactory;
import com.kingdee.eas.hr.perf.IEvaluGroupTargetType;
import com.kingdee.eas.hr.perf.IEvaluTarget;
import com.kingdee.eas.hr.perf.PerformLibException;
import com.kingdee.eas.hr.perf.PerformTargetItemFactory;
import com.kingdee.eas.hr.perf.PerformTargetTypeFactory;
import com.kingdee.eas.hr.perf.PerformTargetTypeInfo;
import com.kingdee.eas.hr.perf.client.AbstractPerformTargetTypeEditUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class PerformTargetTypeEditUI
extends AbstractPerformTargetTypeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PerformTargetTypeEditUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";

    protected IObjectValue createNewData() {
        PerformTargetTypeInfo ret = new PerformTargetTypeInfo();
        ret.setParent(this.getParentType());
        ret.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return ret;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return PerformTargetTypeFactory.getRemoteInstance();
    }

    private PerformTargetTypeInfo getParentType() {
        Object obj = this.getUIContext().get("ParentNode");
        if (obj == null) {
            return null;
        }
        return (PerformTargetTypeInfo)obj;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
            throw new PerformLibException(PerformLibException.NULL_NUMBER);
        }
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.editData, (String)"name");
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.txtName.requestFocus();
            throw new PerformLibException(PerformLibException.NULL_NAME);
        }
    }

    private boolean isTargetTypeRefered() throws Exception {
        String longNumber = this.editData.getLongNumber();
        if (this.editData == null || longNumber == null) {
            return false;
        }
        FilterInfo targetFilter = new FilterInfo();
        targetFilter.getFilterItems().add(new FilterItemInfo("type.longNumber", (Object)(longNumber + "%"), CompareType.LIKE));
        targetFilter.getFilterItems().add(new FilterItemInfo("type.hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        FilterInfo groupFilter = new FilterInfo();
        groupFilter.getFilterItems().add(new FilterItemInfo("performTargetType.longNumber", (Object)(longNumber + "%"), CompareType.LIKE));
        groupFilter.getFilterItems().add(new FilterItemInfo("performTargetType.hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        IEvaluTarget iEvaluTarget = EvaluTargetFactory.getRemoteInstance();
        IEvaluGroupTargetType iEvaluGroupTargetType = EvaluGroupTargetTypeFactory.getRemoteInstance();
        return iEvaluTarget.exists(targetFilter) || iEvaluGroupTargetType.exists(groupFilter);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("longNumber"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        return sic;
    }

    @Override
    public void loadFields() {
        super.loadFields();
        try {
            if (OprtState.VIEW.equals(this.getOprtState()) || this.isTargetTypeRefered()) {
                this.setUIEnabled(false);
            } else {
                this.setUIEnabled(true);
            }
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
    }

    private void setUIEnabled(boolean status) {
        this.txtNumber.setEnabled(status);
        this.txtName.setEnabled(status);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isTargetTypeRefered()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"targetTypeReferedEditNotAllow"));
            return;
        }
        this.setUIEnabled(true);
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.isTargetTypeRefered()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"targetTypeReferedDelNotAllow"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    private boolean haveItems() throws Exception {
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(this.getTypeFilter());
        int count = PerformTargetItemFactory.getRemoteInstance().getCollection(viewInfo).size();
        return count > 0;
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.haveItems()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"cantNotAddSubType"));
            return;
        }
        super.actionAddNew_actionPerformed(e);
    }

    private FilterInfo getTypeFilter() {
        PerformTargetTypeInfo info = this.getParentType();
        FilterInfo filter = new FilterInfo();
        if (info != null) {
            filter.getFilterItems().add(new FilterItemInfo("type", (Object)info.getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("type", null, CompareType.EQUALS));
        }
        return filter;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

