/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.KDTableHelper;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.util.CtrlSwingUtilities;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.hr.perf.IPerformTargetItem;
import com.kingdee.eas.hr.perf.PerformTargetItemFactory;
import com.kingdee.eas.hr.perf.client.AbstractPerformanceTargetF7ListUI;
import com.kingdee.eas.hr.perf.client.KDTableUtil;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PerformItemHelper;
import com.kingdee.eas.hr.perf.client.PerformanceTreeDetailBaseF7UI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class PerformanceTargetF7ListUI
extends AbstractPerformanceTargetF7ListUI {
    private static final Logger logger = CoreUIObject.getLogger(PerformanceTargetF7ListUI.class);
    private HashSet selectedIDset = new HashSet();
    public static final String INIT_FILTER = "INIT_FILTER";
    public static final String INIT_ITEM_FILTER = "INIT_ITEM_FILTER";
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private boolean opState = true;

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        JButton btnAddSelect = this.kctSelected.add((Action)((Object)this.actionAddSelect));
        btnAddSelect.setText(EASResource.getString((String)RES, (String)"addSelect"));
        JButton btnAddAllSelect = this.kctSelected.add((Action)((Object)this.actionAddAllSelect));
        btnAddAllSelect.setText(EASResource.getString((String)RES, (String)"addAllSelect"));
        JButton btnRemoveSelect = this.kctSelected.add((Action)((Object)this.actionRemoveSelect));
        btnRemoveSelect.setText(EASResource.getString((String)RES, (String)"removeSelect"));
        JButton btnRemoveAllSelect = this.kctSelected.add((Action)((Object)this.actionRemoveAllSelect));
        btnRemoveAllSelect.setText(EASResource.getString((String)RES, (String)"removeAllSelect"));
        this.treeView.setShowButton(false);
        this.treeView.setShowControlPanel(false);
        this.tblSelected.checkParsed();
        this.tblMain.checkParsed();
        if (this.tblSelected.getColumn("type") != null) {
            this.setRenderForSelectedType();
        }
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblSelected.getStyleAttributes().setWrapText(true);
        this.menuBar.setVisible(false);
        this.actionQuery.setVisible(true);
        this.btnQuery.setEnabled(true);
        this.actionAddNew.setVisible(false);
        this.actionView.setVisible(false);
        this.actionEdit.setVisible(false);
        this.actionRemove.setVisible(false);
        this.actionRefresh.setVisible(false);
        this.btnFastQuery.setEnabled(true);
        this.txtValue.setText("");
        CtrlSwingUtilities.removeManagingFocusForwardTraversalKeys((JComponent)this.txtValue, (KeyStroke)KeyStroke.getKeyStroke(10, 0));
        this.txtValue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PerformanceTargetF7ListUI.this.btnFastQuery_actionPerformed(e);
                }
                catch (Exception e1) {
                    PerformanceTargetF7ListUI.this.handUIException(e1);
                    logger.info((Object)e1.getMessage(), (Throwable)e1);
                }
            }
        });
    }

    @Override
    public void actionAddAllSelect_actionPerformed(ActionEvent e) throws Exception {
        IRow row = null;
        for (int i = this.tblMain.getRowCount() - 1; i >= 0; --i) {
            row = this.tblMain.getRow(i);
            if (row == null || this.selectedIDset.contains(row.getCell("id").getValue().toString())) continue;
            this.tblSelected.addRow(this.tblSelected.getRowCount(), row);
            this.selectedIDset.add(row.getCell("id").getValue().toString());
        }
        this.execQuery();
        this.autoFitHeight();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.autoFitHeight();
    }

    private void autoFitHeight() {
        int rowIndex;
        int k = this.tblMain.getRowCount();
        for (rowIndex = 0; rowIndex < k; ++rowIndex) {
            KDTableHelper.autoFitRowHeight((KDTable)this.tblMain, (int)rowIndex, (int)0);
        }
        k = this.tblSelected.getRowCount();
        for (rowIndex = 0; rowIndex < k; ++rowIndex) {
            KDTableHelper.autoFitRowHeight((KDTable)this.tblSelected, (int)rowIndex, (int)0);
        }
    }

    @Override
    public void actionAddSelect_actionPerformed(ActionEvent e) throws Exception {
        int[] selected = KDTableUtil.getSelectedRows(this.tblMain);
        if (selected.length == 0 || selected[0] == -1) {
            return;
        }
        IRow row = null;
        Arrays.sort(selected);
        for (int i = selected.length - 1; i >= 0; --i) {
            row = this.tblMain.getRow(selected[i]);
            if (this.selectedIDset.contains(row.getCell("id").getValue().toString())) continue;
            this.tblSelected.addRow(this.tblSelected.getRowCount(), row);
            this.selectedIDset.add(row.getCell("id").getValue().toString());
        }
        this.execQuery();
        this.autoFitHeight();
    }

    @Override
    public void actionRemoveAllSelect_actionPerformed(ActionEvent e) throws Exception {
        this.selectedIDset.clear();
        this.tblSelected.removeRows();
        this.execQuery();
        this.autoFitHeight();
    }

    @Override
    public void actionRemoveSelect_actionPerformed(ActionEvent e) throws Exception {
        int[] selected = KDTableUtil.getSelectedRows(this.tblSelected);
        if (selected.length == 0 || selected[0] == -1) {
            return;
        }
        IRow row = null;
        Arrays.sort(selected);
        for (int i = selected.length - 1; i >= 0; --i) {
            row = this.tblSelected.removeRow(selected[i]);
            this.selectedIDset.remove(row.getCell("id").getValue().toString());
        }
        this.execQuery();
        this.autoFitHeight();
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        IRow row = null;
        for (int i = this.tblMain.getRowCount() - 1; i >= 0; --i) {
            String id;
            row = this.tblMain.getRow(i);
            if (row == null || row.getCell("id") == null || row.getCell("id").getValue() == null || row.getCell("id").getValue().toString() == null || !this.selectedIDset.contains(id = row.getCell("id").getValue().toString())) continue;
            this.tblMain.removeRow(i);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() == 1) {
            this.actionAddSelect_actionPerformed(null);
        }
    }

    @Override
    protected void tblSelected_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() == 2 && e.getType() == 1) {
            this.actionRemoveSelect_actionPerformed(null);
        }
    }

    public Object[] getSelectedUserObject() {
        if (this.selectedIDset.size() == 0) {
            return null;
        }
        Object[] data = new Object[this.selectedIDset.size()];
        try {
            ObjectUuidPK pk = null;
            IPerformTargetItem iTargetItem = PerformTargetItemFactory.getRemoteInstance();
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("formula.id"));
            sic.add(new SelectorItemInfo("formula.name"));
            sic.add(new SelectorItemInfo("type.name"));
            sic.add(new SelectorItemInfo("type.longNumber"));
            sic.add(new SelectorItemInfo("type.displayName"));
            sic.add(new SelectorItemInfo("type.parent.id"));
            sic.add(new SelectorItemInfo("type.parent.name"));
            sic.add(new SelectorItemInfo("type.parent.number"));
            sic.add(new SelectorItemInfo("type.number"));
            int i = 0;
            Iterator iter = this.selectedIDset.iterator();
            while (iter.hasNext()) {
                pk = new ObjectUuidPK((String)iter.next());
                data[i] = iTargetItem.getValue((IObjectPK)pk, sic);
                ++i;
            }
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        return data;
    }

    @Override
    protected FilterInfo getDefaultFilterForTree() {
        FilterInfo filter = super.getDefaultFilterForTree();
        Object obj = this.getUIContext().get(INIT_FILTER);
        if (obj != null && obj instanceof FilterInfo) {
            try {
                filter.mergeFilter((FilterInfo)obj, "AND");
            }
            catch (BOSException ex) {
                super.handleException((Exception)((Object)ex));
            }
        }
        return filter;
    }

    @Override
    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo fi = new FilterInfo();
        fi.getFilterItems().add(new FilterItemInfo("enable", (Object)Boolean.TRUE));
        return fi;
    }

    protected FilterInfo getTreeFilter() {
        Object obj = this.getUIContext().get(INIT_ITEM_FILTER);
        if (obj != null && obj instanceof FilterInfo) {
            return (FilterInfo)obj;
        }
        return null;
    }

    @Override
    public void actionCancelOP_actionPerformed(ActionEvent e) throws Exception {
        this.setOpState(true);
        super.actionExitCurrent_actionPerformed(null);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (this.tblSelected.getRowCount() <= 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.PERFAutoGenerateResource", (String)"82_PerformanceTargetF7ListUI"));
            return;
        }
        this.setOpState(false);
        super.actionExitCurrent_actionPerformed(null);
    }

    public boolean getOpState() {
        return this.opState;
    }

    public void setOpState(boolean state) {
        this.opState = state;
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("content"));
        sic.add(new SelectorItemInfo("standard"));
        sic.add(new SelectorItemInfo("isReferenced"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("kind"));
        sic.add(new SelectorItemInfo("thresholdValue"));
        sic.add(new SelectorItemInfo("standardValue"));
        sic.add(new SelectorItemInfo("challengeValue"));
        sic.add(new SelectorItemInfo("unit"));
        sic.add(new SelectorItemInfo("reportFrequency"));
        sic.add(new SelectorItemInfo("type.id"));
        sic.add(new SelectorItemInfo("type.longNumber"));
        return sic;
    }

    private void setRenderForSelectedType() throws Exception {
        this.tblSelected.getColumn("type").setRenderer(new IBasicRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                if (PerformanceTargetF7ListUI.this.typeMap.size() == 0) {
                    PerformanceTargetF7ListUI.this.getPath();
                }
                try {
                    if (object == null) {
                        return;
                    }
                    ObjectUuidPK typePK = new ObjectUuidPK(object.toString());
                    Object obj = PerformanceTargetF7ListUI.this.typeMap.get(typePK.toString());
                    if (obj != null) {
                        object = obj;
                    }
                    PerformanceTreeDetailBaseF7UI.render.draw(graphics, clip, object.toString(), cellStyle);
                }
                catch (Exception ex) {
                    PerformanceTargetF7ListUI.this.handleException(ex);
                }
            }
        });
    }

    @Override
    protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {
        super.treeMain_valueChanged(e);
        this.autoFitHeight();
    }

    protected void initPopmenu() {
    }

    @Override
    public void btnFastQuery_actionPerformed(ActionEvent e) throws Exception {
        FilterInfo filterInfo = this.getFastQueryFilterInfo();
        EntityViewInfo evi = new EntityViewInfo();
        if (filterInfo == null) {
            filterInfo = new FilterInfo();
        }
        evi.setFilter(filterInfo);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("type.hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        filterInfo.mergeFilter(filter, "and");
        Object obj = this.getUIContext().get(INIT_ITEM_FILTER);
        if (obj != null && obj instanceof FilterInfo) {
            FilterInfo fi = (FilterInfo)obj;
            filterInfo.mergeFilter(fi, "and");
        }
        this.mainQuery = evi;
        this.execQuery();
        this.autoFitHeight();
    }

    private FilterInfo getFastQueryFilterInfo() {
        if (StringUtils.isEmpty((String)this.txtValue.getText().trim())) {
            return null;
        }
        FilterInfo filterInfo = new FilterInfo();
        if (this.cboKey.getSelectedIndex() == 0 && !StringUtils.isEmpty((String)this.txtValue.getText().trim())) {
            if (this.chkLike.isSelected()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("content", (Object)("%" + this.txtValue.getText().trim() + "%"), CompareType.LIKE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("content", (Object)this.txtValue.getText().trim(), CompareType.LIKE));
            }
        } else if (this.cboKey.getSelectedIndex() == 1 && !StringUtils.isEmpty((String)this.txtValue.getText().trim())) {
            if (this.chkLike.isSelected()) {
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)("%" + this.txtValue.getText().trim() + "%"), CompareType.LIKE));
            } else {
                filterInfo.getFilterItems().add(new FilterItemInfo("number", (Object)this.txtValue.getText().trim()));
            }
        }
        filterInfo.getFilterItems().add(new FilterItemInfo("enable", (Object)Boolean.TRUE));
        return filterInfo;
    }

    @Override
    protected void initWorkButton() {
        super.initWorkButton();
        this.txtValue.setFilterType(-1);
    }

    public void setPerformanceTargetPrecision() {
        int count = this.tblMain.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.tblMain.getRow(i);
            String dataPrecision = row.getCell("dataPrecision").getValue().toString();
            if (row.getCell("kind").getValue() != null) {
                if (22 == ((BizEnumValueDTO)row.getCell("kind").getValue()).getInt()) {
                    String[] columnName = new String[]{"thresholdValue", "standardValue", "challengeValue"};
                    if ("0".equals(dataPrecision)) {
                        PerformItemHelper.setFormatString(row, columnName, "0");
                        continue;
                    }
                    String precision = PFUtils.getNumberFormat(Integer.parseInt(dataPrecision));
                    PerformItemHelper.setFormatString(row, columnName, precision);
                    continue;
                }
                if ("0".equals(dataPrecision)) {
                    row.getCell("thresholdValue").getStyleAttributes().setNumberFormat("0");
                    row.getCell("standardValue").getStyleAttributes().setNumberFormat("0");
                    row.getCell("challengeValue").getStyleAttributes().setNumberFormat("0");
                    continue;
                }
                String precision = PFUtils.getNumberFormat(Integer.parseInt(dataPrecision));
                row.getCell("thresholdValue").getStyleAttributes().setNumberFormat(precision);
                row.getCell("standardValue").getStyleAttributes().setNumberFormat(precision);
                row.getCell("challengeValue").getStyleAttributes().setNumberFormat(precision);
                continue;
            }
            row.getCell("thresholdValue").getStyleAttributes().setNumberFormat("0");
            row.getCell("standardValue").getStyleAttributes().setNumberFormat("0");
            row.getCell("challengeValue").getStyleAttributes().setNumberFormat("0");
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        super.refresh(e);
    }

    public void onGetRowSet(IRowSet rowSet) {
        super.onGetRowSet(rowSet);
        try {
            rowSet.beforeFirst();
            Object value = null;
            while (rowSet.next()) {
                try {
                    DecimalFormat df;
                    String precision;
                    BizEnumValueDTO dt = (BizEnumValueDTO)rowSet.getObject("kind");
                    if (dt == null) continue;
                    if (22 == dt.getInt()) {
                        float valueTmp;
                        String value1;
                        int dataPrecision = rowSet.getInt("dataPrecision");
                        precision = PFUtils.getNumberFormat(dataPrecision) + "%";
                        df = new DecimalFormat(precision);
                        value = rowSet.getObject("thresholdValue");
                        if (value != null && value instanceof BigDecimal) {
                            rowSet.updateObject("thresholdValue", (Object)df.format(value));
                        } else if (value != null && value instanceof String && !(value1 = value.toString()).contains("%")) {
                            valueTmp = Float.valueOf(value1).floatValue();
                            rowSet.updateObject("thresholdValue", (Object)df.format(valueTmp));
                        }
                        value = rowSet.getObject("standardValue");
                        if (value != null && value instanceof BigDecimal) {
                            rowSet.updateObject("standardValue", (Object)df.format(value));
                        } else if (value != null && value instanceof String && !(value1 = value.toString()).contains("%")) {
                            valueTmp = Float.valueOf(value1).floatValue();
                            rowSet.updateObject("standardValue", (Object)df.format(valueTmp));
                        }
                        value = rowSet.getObject("challengeValue");
                        if (value != null && value instanceof BigDecimal) {
                            rowSet.updateObject("challengeValue", (Object)df.format(value));
                            continue;
                        }
                        if (value == null || !(value instanceof String) || (value1 = value.toString()).contains("%")) continue;
                        valueTmp = Float.valueOf(value1).floatValue();
                        rowSet.updateObject("challengeValue", (Object)df.format(valueTmp));
                        continue;
                    }
                    if (21 == dt.getInt()) {
                        int dataPrecision = rowSet.getInt("dataPrecision");
                        precision = null;
                        precision = dataPrecision == 0 ? "0" : PFUtils.getNumberFormat(dataPrecision);
                        df = new DecimalFormat(precision);
                        value = rowSet.getBigDecimal("thresholdValue");
                        if (value != null) {
                            rowSet.updateObject("thresholdValue", (Object)df.format(value));
                        }
                        if ((value = rowSet.getBigDecimal("standardValue")) != null) {
                            rowSet.updateObject("standardValue", (Object)df.format(value));
                        }
                        if ((value = rowSet.getBigDecimal("challengeValue")) == null) continue;
                        rowSet.updateObject("challengeValue", (Object)df.format(value));
                        continue;
                    }
                    DecimalFormat df2 = new DecimalFormat("0.00");
                    value = rowSet.getBigDecimal("thresholdValue");
                    if (value != null) {
                        rowSet.updateObject("thresholdValue", (Object)df2.format(value));
                    }
                    if ((value = rowSet.getBigDecimal("standardValue")) != null) {
                        rowSet.updateObject("standardValue", (Object)df2.format(value));
                    }
                    if ((value = rowSet.getBigDecimal("challengeValue")) == null) continue;
                    rowSet.updateObject("challengeValue", (Object)df2.format(value));
                }
                catch (Exception ex) {
                    ExceptionHandler.handle((Throwable)ex);
                }
            }
            rowSet.beforeFirst();
        }
        catch (SQLException ex) {
            super.handUIException((Throwable)ex);
        }
    }
}

