/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.EvalWFObjectsCollection;
import com.kingdee.eas.hr.perf.EvalWFObjectsFactory;
import com.kingdee.eas.hr.perf.EvaluDetailCollection;
import com.kingdee.eas.hr.perf.EvaluNodeCollection;
import com.kingdee.eas.hr.perf.EvaluNodeFactory;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.INodeProcesser;
import com.kingdee.eas.hr.perf.NodeProcesserCollection;
import com.kingdee.eas.hr.perf.NodeProcesserFactory;
import com.kingdee.eas.hr.perf.NodeProcesserInfo;
import com.kingdee.eas.hr.perf.NodeProcesserUtils;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodStatusEnum;
import com.kingdee.eas.hr.perf.TargetEvaluStoreInfo;
import com.kingdee.eas.hr.perf.TargetScoreComputeFacadeFactory;
import com.kingdee.eas.hr.perf.client.AbstractPersonalEvaluResultEditUI;
import com.kingdee.eas.hr.perf.client.IProgTask;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.ProgDialog;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PersonalEvaluResultEditUI
extends AbstractPersonalEvaluResultEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonalEvaluResultEditUI.class);
    private HashMap datas = new HashMap();
    private HashMap datasMirror = new HashMap();
    private static String path = "com.kingdee.eas.hr.perf.client.PerfResource";

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() != 2) {
            super.tblMain_tableClicked(e);
        }
    }

    @Override
    protected EvaluSolutionTypeEnum getEvaluResultType() {
        return EvaluSolutionTypeEnum.PERSON;
    }

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EvaluResultFactory.getRemoteInstance();
    }

    @Override
    protected String getEditUIName() {
        return null;
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        PerfClientUtils.checkValidHRO((CoreUI)this);
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.btnExport.setIcon(EASResource.getIcon((String)"imgTbtn_output"));
    }

    @Override
    public void actionView_actionPerformed(ActionEvent e) throws Exception {
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    public void actionImportData_actionPerformed(ActionEvent e) throws Exception {
        if (this.spID == null || "".endsWith(this.spID)) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"selectImportSP"));
            return;
        }
        SolutionPeriodInfo spInfo = SolutionPeriodFactory.getRemoteInstance().getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(this.spID));
        if (SolutionPeriodStatusEnum.END_EVALU.equals((Object)spInfo.getStatus())) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)path, (String)"evaluReslutSolutionEnd"));
            return;
        }
        ArrayList<DatataskParameter> arrayList = new ArrayList<DatataskParameter>();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.hr.perf.PersonalEvaluResult";
        param.alias = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"personalEvaluResult");
        if (this.spID != null && this.solutionID != null) {
            param.putContextParam((Object)"spID", (Object)this.spID);
            param.putContextParam((Object)"solutionID", (Object)this.solutionID);
        }
        if (this.rankGroupID != null) {
            param.putContextParam((Object)"rankGroupID", (Object)this.rankGroupID);
        }
        arrayList.add(param);
        DatataskCaller task = new DatataskCaller();
        if (SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof KDFrame) {
            task.setParentComponent((Component)((Object)this));
            task.invoke(arrayList, 0);
        }
        ActionEvent evt = new ActionEvent(this.btnRefresh, 0, "Double Clicked");
        ItemAction actView = this.getActionFromActionEvent(evt);
        actView.actionPerformed(evt);
    }

    public void actionExportData_actionPerformed(ActionEvent e) throws Exception {
        SolutionPeriodInfo sp = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        if (sp != null) {
            this.spID = sp.getId().toString();
            this.solutionID = sp.getEvaluSolution().getId().toString();
            SolutionPeriodInfo spInfo = SolutionPeriodFactory.getRemoteInstance().getSolutionPeriodInfo((IObjectPK)new ObjectUuidPK(this.spID));
            if (SolutionPeriodStatusEnum.END_EVALU.equals((Object)spInfo.getStatus())) {
                MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)path, (String)"evaluReslutSolutionEnd"));
                return;
            }
        } else {
            return;
        }
        this.rankGroupID = sp.getEvaluSolution().getRankGroup().getId().toString();
        DatataskParameter param = new DatataskParameter();
        param.solutionName = "eas.hr.perf.PersonalEvaluResult";
        param.alias = EASResource.getString((String)"com.kingdee.eas.hr.perf.client.PerfResource", (String)"personalEvaluResult");
        param.datataskMode = 1;
        MetaDataPK pk = new MetaDataPK("com.kingdee.eas.hr.perf.app", "PersonalEvaluResultQuery");
        param.putContextParam((Object)"mainQueryPK", (Object)pk);
        param.putContextParam((Object)"solutionID2", (Object)this.solutionID);
        FilterInfo filter = new FilterInfo();
        EntityViewInfo viewInfo = new EntityViewInfo();
        filter.getFilterItems().add(new FilterItemInfo("solutionPeriod.id", (Object)this.spID));
        viewInfo.setFilter(filter);
        param.putContextParam((Object)"mainQuery", (Object)viewInfo);
        ArrayList<DatataskParameter> array = new ArrayList<DatataskParameter>();
        array.add(param);
        DatataskCaller dc = new DatataskCaller();
        if (SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof KDFrame) {
            dc.setParentComponent((Component)((Object)this));
        }
        dc.invoke(array, 1);
    }

    @Override
    protected void actionCalculateEvaluScore_actionPerformed(ActionEvent e) throws Exception {
        IProgTask prog = new IProgTask(){

            @Override
            public Object exec() throws Exception {
                PersonalEvaluResultEditUI.this.executeCompute();
                return "";
            }

            @Override
            public void afterExec(Object result) throws Exception {
            }
        };
        ProgDialog dialog = null;
        Window win = SwingUtilities.getWindowAncestor((Component)((Object)this));
        if (win instanceof Frame) {
            dialog = new ProgDialog((Frame)win);
        } else if (win instanceof Dialog) {
            dialog = new ProgDialog((Dialog)win);
        }
        dialog.setLongTimeTask(prog);
        dialog.show();
    }

    @Override
    public boolean isPrepareActionNodeProcess() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionAddNew() {
        return true;
    }

    public boolean isPrepareActionEdit() {
        return true;
    }

    @Override
    public boolean isPrepareActionQuery() {
        return true;
    }

    @Override
    public boolean isPrepareActionRefresh() {
        return true;
    }

    @Override
    public boolean isPrepareActionView() {
        return true;
    }

    private void executeCompute() throws Exception {
        Map nodesMap = new HashMap();
        SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)this.comboSolutionPeriod.getSelectedItem();
        if (solutionPeriodInfo == null || solutionPeriodInfo.getId() == null) {
            return;
        }
        String solutionPeriodID = solutionPeriodInfo.getId().toString();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("deduction"));
        sic.add(new SelectorItemInfo("evaluRule.ruleMode"));
        sic.add(new SelectorItemInfo("evaluRule.EvaluRuleToolClassName"));
        sic.add(new SelectorItemInfo("targetGradeModeLink.maxGrade"));
        sic.add(new SelectorItemInfo("deduction"));
        EvaluSolutionInfo evaluSolutionInfo = EvaluSolutionFactory.getRemoteInstance().getEvaluSolutionInfo((IObjectPK)new ObjectUuidPK(solutionPeriodInfo.getEvaluSolution().getId().toString()), sic);
        INodeProcesser iNodeProcesser = NodeProcesserFactory.getRemoteInstance();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("nodeScore"));
        selector.add(new SelectorItemInfo("evaluDetails.targetScore"));
        IRow row = null;
        String evaluObjectID = null;
        NodeProcesserInfo nodeProcesserInfo = null;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            row = this.tblMain.getRow(i);
            evaluObjectID = (String)row.getCell("evaluObject.id").getValue();
            TargetScoreComputeFacadeFactory.getRemoteInstance().updateTargetRealValue(solutionPeriodID, evaluObjectID);
            TargetScoreComputeFacadeFactory.getRemoteInstance().computeTargetScore(solutionPeriodID, evaluObjectID);
            nodesMap = this.getAllNodes(solutionPeriodID, evaluObjectID);
            Iterator iter = nodesMap.keySet().iterator();
            NodeProcesserCollection coll = new NodeProcesserCollection();
            while (iter.hasNext()) {
                nodeProcesserInfo = (NodeProcesserInfo)nodesMap.get(iter.next());
                coll.add(nodeProcesserInfo);
            }
            if (coll != null && coll.size() > 0) {
                int len = coll.size();
                for (int j = 0; j < len; ++j) {
                    nodeProcesserInfo = coll.get(j);
                    EvaluDetailCollection details = nodeProcesserInfo.getEvaluDetails();
                    for (int k = 0; k < details.size(); ++k) {
                        if (details.get(k).getTargetEvaluStore().getEvaluTarget().getFormula() == null) continue;
                        BigDecimal targetScore = details.get(k).getTargetEvaluStore().getFormulaScore();
                        details.get(k).setTargetScore(targetScore);
                    }
                    nodeProcesserInfo.setNodeScore(NodeProcesserUtils.computeScore(details, evaluSolutionInfo));
                    iNodeProcesser.save((CoreBaseInfo)nodeProcesserInfo);
                }
            }
            iNodeProcesser.countTotalTargetEvaluScore(solutionPeriodID, evaluObjectID);
        }
        this.retrieveData();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)path, (String)"compute_success"));
    }

    private Map getAllNodes(Object solutionPeriodID, Object evaluObjectID) throws Exception {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.solutionPeriod", (Object)solutionPeriodID.toString()));
        filter.getFilterItems().add(new FilterItemInfo("evaluResult.evaluObject.id", (Object)evaluObjectID.toString()));
        EntityViewInfo viewInfo = new EntityViewInfo();
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("evaluNode.*"));
        sic.add(new SelectorItemInfo("evaluNode.nodes.*"));
        sic.add(new SelectorItemInfo("evaluNode.evalWorkFlow.id"));
        sic.add(new SelectorItemInfo("evaluNode.evalWorkFlow.wfLevels"));
        sic.add(new SelectorItemInfo("evaluDetails.*"));
        sic.add(new SelectorItemInfo("evaluDetails.id"));
        sic.add(new SelectorItemInfo("evaluDetails.rank.*"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.*"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.formulaRank.id"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.formulaRank.name"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.creator.person.id"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.creator.person.name"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.evaluTarget.*"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.evaluTarget.formula.id"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.evaluTarget.formula.name"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.evaluTarget.type.id"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.evaluTarget.type.name"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.evaluTarget.type.number"));
        sic.add(new SelectorItemInfo("evaluDetails.targetEvaluStore.evaluTarget.type.firstTypeWeight"));
        sic.add(new SelectorItemInfo("evaluer.id"));
        sic.add(new SelectorItemInfo("evaluer.name"));
        sic.add(new SelectorItemInfo("rank.*"));
        SorterItemCollection sorter = viewInfo.getSorter();
        sorter.add(new SorterItemInfo("evaluDetails.targetEvaluStore.evaluTarget.seqNumber"));
        sorter.add(new SorterItemInfo("evaluDetails.targetEvaluStore.evaluTarget.type.number"));
        sorter.add(new SorterItemInfo("evaluDetails.targetEvaluStore.evaluTarget.number"));
        NodeProcesserCollection coll = NodeProcesserFactory.getRemoteInstance().getNodeProcesserCollection(viewInfo);
        NodeProcesserInfo info = null;
        HashSet<String> personIds = new HashSet<String>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            this.datas.put("" + info.getEvaluNode().getSeqNumber(), info);
            this.datasMirror.put("" + info.getEvaluNode().getSeqNumber(), info.clone());
            EvaluDetailCollection edColl = info.getEvaluDetails();
            if (edColl == null || edColl.size() <= 0) continue;
            int n = edColl.size();
            for (int m = 0; m < n; ++m) {
                TargetEvaluStoreInfo tesInfo = edColl.get(m).getTargetEvaluStore();
                if (tesInfo == null || tesInfo.getCreator() == null || tesInfo.getCreator().getPerson() == null) continue;
                personIds.add(tesInfo.getCreator().getPerson().getId().toString());
            }
        }
        if (size == 0) {
            filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("evaluObject", (Object)evaluObjectID.toString()));
            filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.solutionPeriod.id", (Object)solutionPeriodID.toString()));
            viewInfo = new EntityViewInfo();
            viewInfo.setFilter(filter);
            sic = viewInfo.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("evalWorkFlow.id"));
            EvalWFObjectsCollection objColl = EvalWFObjectsFactory.getRemoteInstance().getEvalWFObjectsCollection(viewInfo);
            if (objColl.size() > 0) {
                String id = objColl.get(0).getEvalWorkFlow().getId().toString();
                filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("evalWorkFlow.id", (Object)id));
                viewInfo = new EntityViewInfo();
                viewInfo.setFilter(filter);
                sic = viewInfo.getSelector();
                sic.add(new SelectorItemInfo("id"));
                sic.add(new SelectorItemInfo("seqNumber"));
                EvaluNodeCollection nodeColl = EvaluNodeFactory.getRemoteInstance().getEvaluNodeCollection(viewInfo);
                if (nodeColl != null && nodeColl.size() > 0) {
                    String[] nodeSeqs = new String[nodeColl.size()];
                    int n = nodeColl.size();
                    for (int i = 0; i < n; ++i) {
                        nodeSeqs[i] = "" + nodeColl.get(i).getSeqNumber();
                    }
                    Map map = NodeProcesserFactory.getRemoteInstance().getNodeProcesserInfoOfTheNode(nodeSeqs, evaluObjectID.toString(), solutionPeriodID.toString());
                    Object key2 = null;
                    for (Object key2 : map.keySet()) {
                        info = (NodeProcesserInfo)map.get(key2);
                        this.datas.put(key2, info);
                        this.datasMirror.put(key2, info.clone());
                    }
                }
            }
        }
        return this.datas;
    }
}

