/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDFrame;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.BizEnumValueDTO;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.basedata.org.HROrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.UtilRequest;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.hr.perf.AchieveStatisticsPeriodInfo;
import com.kingdee.eas.hr.perf.AuditStatusEnum;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.EvaluSolutionTypeEnum;
import com.kingdee.eas.hr.perf.IPerfSummary;
import com.kingdee.eas.hr.perf.PerfSummaryFactory;
import com.kingdee.eas.hr.perf.PerfSummaryInfo;
import com.kingdee.eas.hr.perf.PersonKeyEventCollection;
import com.kingdee.eas.hr.perf.PersonKeyEventFactory;
import com.kingdee.eas.hr.perf.PersonKeyEventInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.client.AbstractPersonalEvaluResultListUI;
import com.kingdee.eas.hr.perf.client.EvaluResultAuditSumBillListUI;
import com.kingdee.eas.hr.perf.client.EvaluResultAuditSumBillUI;
import com.kingdee.eas.hr.perf.client.EvaluResultPersonModifyEditUI;
import com.kingdee.eas.hr.perf.client.HistoryKeyEventUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.eas.hr.perf.client.PerfClientUtils;
import com.kingdee.eas.hr.perf.client.PerfSummaryEditUI;
import com.kingdee.eas.tools.datatask.DatataskParameter;
import com.kingdee.eas.tools.datatask.client.DatataskCaller;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class PersonalEvaluResultListUI
extends AbstractPersonalEvaluResultListUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonalEvaluResultListUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private static final String solutionName = "eas.hr.perf.PersonalEvaluResultRanking";
    private int isInfo = 0;

    @Override
    protected ICoreBase getBizInterface() throws Exception {
        return EvaluResultFactory.getRemoteInstance();
    }

    @Override
    protected String getEditUIName() {
        return EvaluResultPersonModifyEditUI.class.getName();
    }

    @Override
    public void actionPerfSummary_actionPerformed(ActionEvent e) throws Exception {
        String id = this.getSelectedPerfSummaryID();
        if (id == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"perfSummaryView"));
            return;
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(PerfSummaryEditUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    protected String getSelectedPerfSummaryID() throws Exception {
        KDTSelectBlock selectBlock = this.tblMain.getSelectManager().get();
        if (selectBlock != null) {
            int rowIndex = selectBlock.getTop();
            String id = null;
            IRow row = this.tblMain.getRow(rowIndex);
            if (row == null) {
                return null;
            }
            ICell cell = row.getCell("AssessPeriod.id");
            ICell objectCell = row.getCell("evaluObject.objectID");
            if (cell == null) {
                MsgBox.showError((String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Error_KeyField_Fail"));
                SysUtil.abort();
            }
            if (cell.getValue() != null && objectCell.getValue() != null) {
                String assessID = cell.getValue().toString();
                String objectID = objectCell.getValue().toString();
                IPerfSummary iPerfSummary = PerfSummaryFactory.getRemoteInstance();
                PerfSummaryInfo perfSummaryInfo = null;
                CoreBaseCollection psColl = null;
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("assessPeriod.id", (Object)assessID, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)objectID, CompareType.EQUALS));
                viewInfo.setFilter(filter);
                psColl = iPerfSummary.getCollection(viewInfo);
                if (psColl != null && psColl.size() > 0) {
                    perfSummaryInfo = (PerfSummaryInfo)psColl.get(0);
                    id = perfSummaryInfo.getId().toString();
                }
            }
            return id;
        }
        return null;
    }

    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception {
        super.actionRefresh_actionPerformed(e);
        this.getStatus();
        this.getStatusInfo();
    }

    private boolean confirmRestartFlow(int isInfo) {
        if (isInfo == 0) {
            return MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"reviewData")));
        }
        return true;
    }

    @Override
    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        SolutionPeriodInfo info = (SolutionPeriodInfo)this.prmptSolutionPeriod.getValue();
        if (info == null || info.getId() == null) {
            MsgBox.showError((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"selectPersonalImportSP"));
            return;
        }
        if (this.confirmRestartFlow(this.isInfo)) {
            String spID = info.getId().toString();
            String solutionID = info.getEvaluSolution().getId().toString();
            ArrayList<DatataskParameter> importParam = new ArrayList<DatataskParameter>();
            DatataskParameter param = new DatataskParameter();
            param.solutionName = solutionName;
            param.alias = this.getUITitle();
            boolean isCanceld = false;
            if (info.getId() != null && info.getEvaluSolution().getId() != null) {
                param.putContextParam((Object)"spID", (Object)spID);
                param.putContextParam((Object)"solutionID", (Object)solutionID);
            }
            importParam.add(param);
            DatataskCaller task = new DatataskCaller();
            if (SwingUtilities.getWindowAncestor((Component)((Object)this)) instanceof KDFrame) {
                task.setParentComponent((Component)((Object)this));
                task.invoke(importParam, 0);
            }
        }
    }

    private void getStatus() {
        boolean isFlag = false;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            BizEnumValueDTO inte = (BizEnumValueDTO)this.tblMain.getRow(i).getCell("auditStatus").getValue();
            if (inte == null || inte.toString().endsWith(AuditStatusEnum.AUDITING.toString()) || inte.toString().endsWith(AuditStatusEnum.PASS.toString())) continue;
            isFlag = true;
            break;
        }
        if (!isFlag) {
            this.btnImport.setEnabled(false);
            this.menuItemImport.setEnabled(false);
        } else {
            this.btnImport.setEnabled(true);
            this.menuItemImport.setEnabled(true);
        }
    }

    private void getStatusInfo() {
        boolean isFlag = false;
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            BizEnumValueDTO inte = (BizEnumValueDTO)this.tblMain.getRow(i).getCell("auditStatus").getValue();
            if (inte != null) {
                if (!inte.toString().endsWith(AuditStatusEnum.AUDITING.toString()) && !inte.toString().endsWith(AuditStatusEnum.PASS.toString())) continue;
                isFlag = true;
                break;
            }
            isFlag = true;
            break;
        }
        this.isInfo = !isFlag ? 1 : 0;
    }

    @Override
    public void actionAntiAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAntiAudit_actionPerformed(e);
        ActionEvent evt = new ActionEvent(this.btnRefresh, 0, "Double Clicked");
        ItemAction actView = this.getActionFromActionEvent(evt);
        actView.actionPerformed(evt);
    }

    @Override
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception {
        super.actionAudit_actionPerformed(e);
        ActionEvent evt = new ActionEvent(this.btnRefresh, 0, "Double Clicked");
        ItemAction actView = this.getActionFromActionEvent(evt);
        actView.actionPerformed(evt);
    }

    private boolean isShow() throws Exception {
        return PFUtils.getParamValue("hr_perf_003");
    }

    private void initUI() throws Exception {
        boolean isShow = this.isShow();
        this.actionShow.setVisible(isShow);
        this.tblMain.getColumn("isShow").getStyleAttributes().setHided(!isShow);
        this.tblMain.getColumn("shower.name").getStyleAttributes().setHided(!isShow);
        this.tblMain.getColumn("showDate").getStyleAttributes().setHided(!isShow);
        this.btnKeyEventHistory.setEnabled(false);
        this.btnCalKeyEventScore.setEnabled(false);
        this.btnImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuItemImport.setIcon(EASResource.getIcon((String)"imgTbtn_input"));
        this.menuItemImport.setEnabled(true);
        this.btnImport.setEnabled(true);
    }

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        PerfClientUtils.checkValidHRO((CoreUI)this);
        PerfClientUtils.checkValidPerson((CoreUI)this);
        this.tblMain.getColumn("cmpPeriod.name").getStyleAttributes().setHided(true);
        this.btnVerdictAllCmpPeriod.setVisible(false);
        this.btnVerdictAllCmpPeriod.setEnabled(false);
        this.tblMain.getColumn("modifyCause").getStyleAttributes().setWrapText(true);
        this.initUI();
        EntityViewInfo view = null;
        HROrgUnitInfo hrOrg = SysContext.getSysContext().getCurrentHRUnit();
        if (hrOrg != null) {
            view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)hrOrg.getId().toString()));
            view.setFilter(filter);
        }
        this.prmptSolutionPeriod.setEntityViewInfo(view);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.ACHIEVEMENT_MANAGEMENT;
    }

    @Override
    protected Map getResourceMap() {
        HashMap<String, String> resourceMap = new HashMap<String, String>();
        resourceMap.put("resultIsLittle", EASResource.getString((String)RES, (String)"personalResultIsLittle"));
        return resourceMap;
    }

    @Override
    protected EvaluSolutionTypeEnum getSolutionType() {
        return EvaluSolutionTypeEnum.PERSON;
    }

    @Override
    public IUIActionPostman prepareInit() {
        PerfClientUtils.checkValidPerson((CoreUI)this);
        PerfClientUtils.checkValidHRO((CoreUI)this);
        return super.prepareInit();
    }

    @Override
    public boolean isPrepareActionConvert() {
        return true;
    }

    @Override
    public boolean isPrepareActionEdit() {
        return true;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    @Override
    public boolean isPrepareActionViewNodeProcess() {
        return true;
    }

    @Override
    public boolean isPrepareActionQuery() {
        return true;
    }

    @Override
    protected int getNDType() {
        return 0;
    }

    @Override
    protected void prmptSolutionPeriod_dataChanged(DataChangeEvent e) throws Exception {
        super.prmptSolutionPeriod_dataChanged(e);
        SolutionPeriodInfo info = (SolutionPeriodInfo)this.prmptSolutionPeriod.getValue();
        this.btnKeyEventHistory.setEnabled(info != null && info.getEvaluSolution().isKeyEvent());
        this.btnCalKeyEventScore.setEnabled(info != null && info.getEvaluSolution().isKeyEvent());
        boolean workFlow = info != null && info.getEvaluSolution().isWorkflow();
        this.actionSubmit.setEnabled(workFlow);
        this.actionAudit.setEnabled(!workFlow);
        this.actionAntiAudit.setEnabled(!workFlow);
        ActionEvent evt = new ActionEvent(this.btnRefresh, 0, "Double Clicked");
        ItemAction actView = this.getActionFromActionEvent(evt);
        actView.actionPerformed(evt);
    }

    @Override
    public void actionKeyEventHistory_actionPerformed(ActionEvent e) throws Exception {
        PFUtils.checkSelected((Component)((Object)this), this.tblMain);
        int[] index = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = this.tblMain.getRow(index[0]);
        String id = (String)row.getCell("id").getValue();
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"ID", (Object)id);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(HistoryKeyEventUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
    }

    @Override
    public void actionCalKeyEventScore_actionPerformed(ActionEvent e) throws Exception {
        SolutionPeriodInfo solutionPeriodInfo = (SolutionPeriodInfo)this.prmptSolutionPeriod.getValue();
        AchieveStatisticsPeriodInfo keyEventPeriod = solutionPeriodInfo.getKeyEventPeriod();
        if (keyEventPeriod == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"notDate"));
            return;
        }
        Date startTime = keyEventPeriod.getStartDate();
        Date endTime = keyEventPeriod.getEndDate();
        IRow row = null;
        HashMap<String, String> personResult = new HashMap<String, String>();
        String personId = null;
        String evaluResultId = null;
        boolean isAudit = false;
        int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        int count = rows.length;
        for (int j = 0; j < count; ++j) {
            row = this.tblMain.getRow(rows[j]);
            personId = row.getCell("Person.id").getValue().toString();
            evaluResultId = row.getCell("id").getValue().toString();
            isAudit = (Boolean)row.getCell("isApproved").getValue();
            if (isAudit) continue;
            personResult.put(personId, evaluResultId);
        }
        HashSet personIdSet = new HashSet();
        personIdSet.addAll(personResult.keySet());
        if (personIdSet.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"auditedNotkey"));
            SysUtil.abort();
        }
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("eventStartDate", (Object)startTime, CompareType.GREATER_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("eventEndDate", (Object)endTime, CompareType.LESS_EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("person", personIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        viewInfo.getSelector().add(new SelectorItemInfo("person.id"));
        viewInfo.getSelector().add(new SelectorItemInfo("grade"));
        PersonKeyEventCollection coll = PersonKeyEventFactory.getRemoteInstance().getPersonKeyEventCollection(viewInfo);
        if (coll == null || coll.size() == 0) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noKeyEvent"));
            SysUtil.abort();
        }
        PersonKeyEventInfo info = null;
        HashMap mapcoll = new HashMap();
        HashMap<String, Object> entry = null;
        HashSet<String> keyEventSet = null;
        BigDecimal sumScore = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            personId = info.getPerson().getId().toString();
            entry = (HashMap<String, Object>)mapcoll.get(personId);
            if (entry == null) {
                entry = new HashMap<String, Object>();
                mapcoll.put(personId, entry);
            }
            if ((sumScore = (BigDecimal)entry.get("sumScore")) == null) {
                sumScore = new BigDecimal("0.00000000");
            }
            if (info.getGrade() != null) {
                sumScore = sumScore.add(info.getGrade());
            }
            entry.put("sumScore", sumScore);
            keyEventSet = (HashSet<String>)entry.get("keyEvent");
            if (keyEventSet == null) {
                keyEventSet = new HashSet<String>();
                entry.put("keyEvent", keyEventSet);
            }
            keyEventSet.add(info.getId().toString());
            evaluResultId = (String)entry.get("evaluResult");
            if (evaluResultId != null) continue;
            evaluResultId = (String)personResult.get(personId);
            entry.put("evaluResult", evaluResultId);
        }
        if (mapcoll.size() > 0) {
            this.handleSumScorePrecesion(mapcoll);
            EvaluResultFactory.getRemoteInstance().updateKeyEventScore(mapcoll, 0);
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"keyScoreAssers"));
            this.refreshList();
        }
    }

    @Override
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        super.actionSubmit_actionPerformed(e);
        this.checkSelected();
        int[] selectedRows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
        IRow row = null;
        ArrayList<Object> selectedIds = new ArrayList<Object>();
        for (int i = 0; i < selectedRows.length; ++i) {
            int value;
            row = this.tblMain.getRow(selectedRows[i]);
            if (row.getCell("auditStatus").getValue() != null && 20 == (value = ((BizEnumValueDTO)row.getCell("auditStatus").getValue()).getInt())) continue;
            selectedIds.add(row.getCell("id").getValue());
        }
        UIContext uiContext = new UIContext((Object)this);
        uiContext.put((Object)"evaluResultIds", selectedIds);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)this.getEditUIModal()).create(EvaluResultAuditSumBillUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (uiWindow != null && this.isDoRefresh(uiWindow)) {
            if (UtilRequest.isPrepare((String)"ActionRefresh", (CoreUIObject)this)) {
                this.prepareRefresh(null).callHandler();
            }
            this.refresh(e);
            this.setPreSelecteRow();
        }
    }

    @Override
    public void actionAuditBill_actionPerformed(ActionEvent e) throws Exception {
        super.actionAuditBill_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UINewFrameFactory").create(EvaluResultAuditSumBillListUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
    }

    @Override
    protected String getEditUIModal() {
        return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
    }

    protected void getRowSetBeforeFillTable(IRowSet rowSet) {
        super.getRowSetBeforeFillTable(rowSet);
        PFUtils.setTableNumberFormat(this.tblMain, "evaluateSum", 5);
        PFUtils.setTableNumberFormat(this.tblMain, "targetEvaluScore", 5);
        PFUtils.setTableNumberFormat(this.tblMain, "modifiedScore", 5);
    }

    protected void afterTableFillData(KDTDataRequestEvent e) {
        super.afterTableFillData(e);
        this.initPrecision();
    }

    private void initPrecision() {
        try {
            PFUtils.setTableColumnPrecision(this.tblMain, "EvaluSolution.id", "evaluateSum", 3);
            PFUtils.setTableColumnPrecision(this.tblMain, "EvaluSolution.id", "targetEvaluScore", 3);
            PFUtils.setTableColumnPrecision(this.tblMain, "EvaluSolution.id", "modifiedScore", 3);
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        SolutionPeriodInfo info = (SolutionPeriodInfo)this.prmptSolutionPeriod.getValue();
        if (info != null) {
            this.txtGradeModeName.setText(info.getEvaluSolution().getGradeMode().getName());
            if (info.getEvaluSolution().isWorkflow()) {
                this.actionAudit.setEnabled(false);
                this.actionAntiAudit.setEnabled(false);
            } else {
                int[] rows = KDTableUtil.getSelectedRows((KDTable)this.tblMain);
                if (rows.length > 0) {
                    IRow row = this.tblMain.getRow(rows[0]);
                    if (row.getCell("auditStatus").getValue() != null) {
                        if (AuditStatusEnum.UNAUDITED.getAlias().equals(row.getCell("auditStatus").getValue().toString())) {
                            this.actionAudit.setEnabled(true);
                            this.actionAntiAudit.setEnabled(false);
                        } else {
                            this.actionAudit.setEnabled(false);
                            this.actionAntiAudit.setEnabled(true);
                        }
                    } else {
                        this.actionAudit.setEnabled(true);
                        this.actionAntiAudit.setEnabled(false);
                    }
                }
            }
        }
        super.tblMain_tableClicked(e);
    }
}

