/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.PositionInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.hr.perf.EvalWFObjectsInfo;
import com.kingdee.eas.hr.perf.client.AbstractPersonalTargetEvaluStoreEditUI;
import com.kingdee.eas.hr.perf.client.PFUtils;
import com.kingdee.jdbc.rowset.IRowSet;
import java.awt.Color;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PersonalTargetEvaluStoreEditUI
extends AbstractPersonalTargetEvaluStoreEditUI {
    private static final Logger logger = CoreUIObject.getLogger(PersonalTargetEvaluStoreEditUI.class);

    @Override
    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("kind").setRequired(true);
        this.tblMain.getColumn("weight").setRequired(true);
        this.tblMain.getColumn("content").setRequired(true);
        this.tblMain.getColumn("number").getStyleAttributes().setBackground(Color.WHITE);
    }

    @Override
    protected void initBaseInfo() throws Exception {
        IRowSet rowSet = this.getBaseInfo();
        if (rowSet != null && rowSet.size() > 0) {
            try {
                while (rowSet.next()) {
                    String evaluObject = rowSet.getString("person.name");
                    this.txtEvaluObject.setText(evaluObject);
                    String position = rowSet.getString("position.name");
                    this.txtPositionOrResponser.setText(position);
                    String evaluSolution = rowSet.getString("evaluSolution.name");
                    this.txtEvaluSolution.setText(evaluSolution);
                    String assessPeriod = rowSet.getString("assessPeriod.name");
                    this.txtAccessPeriod.setText(assessPeriod);
                }
            }
            catch (SQLException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                throw new BOSException(e.getMessage(), (Throwable)e);
            }
        } else {
            Object obj = this.getUIContext().get("PF_EvaluObject");
            String evaluObject = obj.toString();
            this.txtEvaluObject.setText(evaluObject);
            EvalWFObjectsInfo objs = (EvalWFObjectsInfo)obj;
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)objs.getEvaluObject().getObjectID()));
            PositionInfo positionInfo = PFUtils.getPositionReferToPerson(person);
            if (positionInfo != null) {
                this.txtPositionOrResponser.setText(positionInfo.getName());
            } else {
                this.txtPositionOrResponser.setText(null);
            }
            String evaluSolution = this.getUIContext().get("PF_EvaluSolution").toString();
            this.txtEvaluSolution.setText(evaluSolution);
            String assessPeriod = this.getUIContext().get("PF_AssessPeriod").toString();
            this.txtAccessPeriod.setText(assessPeriod);
        }
    }

    @Override
    protected String getEvaluStoreType() {
        return "person";
    }

    @Override
    protected String getCurrentEvaluObjectId() {
        EvalWFObjectsInfo info = (EvalWFObjectsInfo)this.getUIContext().get("PF_EvaluObject");
        String objcetID = info.getEvaluObject().getObjectID();
        return objcetID;
    }
}

