/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.base.BaseException;
import com.kingdee.eas.hr.emp.client.EmployeeMultiF7PromptBox;
import com.kingdee.eas.hr.perf.IMailPerson;
import com.kingdee.eas.hr.perf.IWorkPlan;
import com.kingdee.eas.hr.perf.MailPersonFactory;
import com.kingdee.eas.hr.perf.MailPersonInfo;
import com.kingdee.eas.hr.perf.WorkPlanFactory;
import com.kingdee.eas.hr.perf.client.AbstractPlanSendMailListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class PlanSendMailListUI
extends AbstractPlanSendMailListUI {
    private static final Logger logger = CoreUIObject.getLogger(PlanSendMailListUI.class);
    private String resClass = "com.kingdee.eas.hr.perf.client.PlanFreqTypeResource.";
    private PersonInfo curPerson = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnAddSendAddress.setIcon(EASResource.getIcon((String)"imgTbtn_recieversetting"));
        this.btnDelSendAddress.setIcon(EASResource.getIcon((String)"imgTbtn_logoutuser"));
        this.btnSendMail.setIcon(EASResource.getIcon((String)"imgTbtn_messagetopicedit"));
    }

    public void onLoad() throws Exception {
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        this.curPerson = userInfo.getPerson();
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.removeRows();
    }

    @Override
    public void actionSendMail_actionPerformed(ActionEvent e) throws Exception {
        super.actionSendMail_actionPerformed(e);
        if (this.tblMain.getRowCount() > 0) {
            StringBuffer to = new StringBuffer();
            int size = this.tblMain.getRowCount();
            for (int i = 0; i < size; ++i) {
                if (i != 0) {
                    to.append(",");
                }
                to.append(this.tblMain.getRow(i).getCell("email").getValue());
            }
            try {
                IWorkPlan iWP = WorkPlanFactory.getRemoteInstance();
                iWP.sendMail(this.curPerson.getId().toString(), to.toString(), (Map)this.getUIContext().get("PARAM"));
            }
            catch (Exception err) {
                String message = EASResource.getString((String)(this.resClass + "SENDMAIL_FAIL"));
                if (err.getCause() == null || err.getCause() instanceof BaseException) {
                    MsgBox.showDetailAndOK((Component)((Object)this), (String)message, (String)err.getMessage(), (int)0);
                } else {
                    ExceptionHandler.handle((Component)((Object)this), (String)message, (Throwable)err);
                }
                SysUtil.abort();
            }
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)(this.resClass + "SENDMAIL_SUCCESS")));
        }
    }

    @Override
    public void addSendAddress_actionPerformed(ActionEvent e) throws Exception {
        super.addSendAddress_actionPerformed(e);
        EmployeeMultiF7PromptBox pmt = new EmployeeMultiF7PromptBox((IUIObject)this);
        pmt.setModal(true);
        pmt.setIsSingleSelect(false);
        pmt.show();
        Object row = null;
        if (!pmt.isCanceled()) {
            Object[] obj = (Object[])pmt.getData();
            PersonInfo pInfo = null;
            IMailPerson iMP = MailPersonFactory.getRemoteInstance();
            MailPersonInfo mpInfo = null;
            Object[] param = new Object[1];
            int size = obj.length;
            for (int i = 0; i < size; ++i) {
                pInfo = (PersonInfo)obj[i];
                if (pInfo.getEmail() == null || StringUtils.isEmpty((String)pInfo.getEmail()) || pInfo.getEmail().indexOf("@") < 0) {
                    param[0] = pInfo.getName();
                }
                mpInfo = new MailPersonInfo();
                mpInfo.setPerson(this.curPerson);
                mpInfo.setToPerson(pInfo);
                iMP.addnew(mpInfo);
            }
        }
        this.refresh(null);
    }

    @Override
    public void delSendAddress_actionPerformed(ActionEvent e) throws Exception {
        int num = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (num == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        if (MsgBox.isYes((int)MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Confirm_Delete")))) {
            IMailPerson iMP = MailPersonFactory.getRemoteInstance();
            String id = this.tblMain.getRow(num).getCell("id").getValue().toString();
            String oql = "where person='" + this.curPerson.getId() + "' and toPerson='" + id + "'";
            if (!iMP.exists(oql)) {
                return;
            }
            MailPersonInfo info = iMP.getMailPersonInfo(oql);
            iMP.delete((IObjectPK)new ObjectUuidPK(info.getId()));
            this.refresh(null);
        }
    }

    protected String getEditUIName() {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return null;
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
    }

    protected FilterInfo getDefaultFilterForQuery() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("Person2.id", (Object)this.curPerson.getId().toString()));
        return filter;
    }
}

