/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.hr.perf.IPlanWriter;
import com.kingdee.eas.hr.perf.PlanWriterFactory;
import com.kingdee.eas.hr.perf.client.AbstractPlanWriteListUI;
import com.kingdee.eas.hr.perf.client.PlanWriteSetListUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PlanWriteListUI
extends AbstractPlanWriteListUI {
    private static final Logger logger = CoreUIObject.getLogger(PlanWriteListUI.class);
    private String resClass = "com.kingdee.eas.hr.perf.client.PlanFreqTypeResource.";
    private String default_label = EASResource.getString((String)(this.resClass + "DEFAULT_LABEL"));

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnSetPlanWriter.setIcon(EASResource.getIcon((String)"imgTbtn_distribute"));
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.checkParsed();
        this.tblMain.getSelectManager().setSelectMode(2);
        this.tblMain.getStyleAttributes().setLocked(true);
        this.tblMain.getStyleAttributes().setWrapText(true);
        this.tblMain.getColumn("planWriter").getStyleAttributes().setVerticalAlign(Styles.VerticalAlignment.TOP);
        this.loadTableData();
        if (this.tblMain.getRowCount() > 0) {
            this.tblMain.getSelectManager().select(0, 0);
        }
    }

    private void loadTableData() throws Exception {
        List empLists = null;
        this.tblMain.removeRows();
        UserInfo userInfo = SysContext.getSysContext().getCurrentUserInfo();
        PersonInfo curPerson = userInfo.getPerson();
        if (curPerson == null) {
            return;
        }
        IPlanWriter iPW = PlanWriterFactory.getRemoteInstance();
        empLists = iPW.getPlanWriterList(curPerson.getId().toString());
        if (empLists == null) {
            return;
        }
        IRow row = null;
        PersonInfo pInfo = null;
        String writer = null;
        int size = empLists.size();
        for (int i = 0; i < size; ++i) {
            pInfo = (PersonInfo)empLists.get(i);
            if (pInfo.getId().toString().equals(curPerson.getId().toString()) || this.checkExistRow(pInfo.getId().toString())) continue;
            row = this.tblMain.addRow();
            row.setHeight(50);
            row.setUserObject((Object)pInfo);
            row.getCell("id").setValue((Object)pInfo.getId());
            row.getCell("number").setValue((Object)pInfo.getNumber());
            row.getCell("name").setValue((Object)pInfo.getName());
            row.getCell("position").setValue(pInfo.get("POSITION"));
            writer = pInfo.get("PLAN_WRITER").toString();
            writer = writer.replaceAll("!#!", this.default_label);
            row.getCell("planWriter").setValue((Object)writer);
        }
    }

    private boolean checkExistRow(String pId) {
        int size = this.tblMain.getRowCount();
        String id = null;
        for (int i = 0; i < size; ++i) {
            id = this.tblMain.getRow(i).getCell("id").getValue().toString();
            if (!id.equals(pId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionSetPlanWriter_actionPerformed(ActionEvent e) throws Exception {
        super.actionSetPlanWriter_actionPerformed(e);
        int num = KDTableUtil.getSelectedRow((KDTable)this.tblMain);
        if (num == -1) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_MustSelected"));
            SysUtil.abort();
        }
        UIContext uiContext = new UIContext(this.getUIContext().get("OwnerWindow"));
        uiContext.put("PERSON", this.tblMain.getRow(num).getUserObject());
        IUIFactory uiFactory = null;
        uiFactory = UIFactory.createUIFactory((String)"com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
        IUIWindow uiWindow = uiFactory.create(PlanWriteSetListUI.class.getName(), (Map)uiContext);
        uiWindow.show();
        this.loadTableData();
    }
}

