/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.hr.perf.EvaluSolutionInfo;
import com.kingdee.eas.hr.perf.PrecisionMaintainCollection;
import com.kingdee.eas.hr.perf.PrecisionMaintainFactory;
import com.kingdee.eas.hr.perf.PrecisionMaintainInfo;
import com.kingdee.eas.hr.perf.PrecisionTypeEnum;
import com.kingdee.eas.hr.perf.client.AbstractPrecisionMaintainUI;
import java.awt.event.ActionEvent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import org.apache.log4j.Logger;

public class PrecisionMaintainUI
extends AbstractPrecisionMaintainUI {
    private static final Logger logger = CoreUIObject.getLogger(PrecisionMaintainUI.class);
    private String evaluSolutionId;
    private String OprtState = null;
    private PrecisionMaintainInfo editInfo = null;
    private String isRank = null;

    public void onLoad() throws Exception {
        super.onLoad();
        this.evaluSolutionId = (String)this.getUIContext().get("evaluSolutionId");
        if (this.getUIContext().get("OprtState") != null) {
            this.OprtState = (String)this.getUIContext().get("OprtState");
        }
        if (this.getUIContext().get("isRank") != null) {
            this.isRank = (String)this.getUIContext().get("isRank");
        }
        this.loadData();
        this.initButtonState();
    }

    private void initButtonState() {
        if (this.isRank != null) {
            this.spinIndexGradePrecision.setEnabled(false);
            this.indexGradePrecisionTypeComboBox.setEnabled(false);
            this.spinNodeScorePrecision.setEnabled(false);
            this.nodeScorePrecisionTypeComboBox.setEnabled(false);
        }
        if ("VIEW".equals(this.OprtState)) {
            if (this.isRank == null) {
                this.spinIndexGradePrecision.setAccessAuthority(1);
                this.indexGradePrecisionTypeComboBox.setAccessAuthority(1);
                this.spinNodeScorePrecision.setAccessAuthority(1);
                this.nodeScorePrecisionTypeComboBox.setAccessAuthority(1);
            }
            this.spinTotalPrecision.setAccessAuthority(1);
            this.totalPrecisionTypeComboBox.setAccessAuthority(1);
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.spinIndexGradePrecision.setModel((SpinnerModel)new SpinnerNumberModel(2, 0, 4, 1));
        this.spinNodeScorePrecision.setModel((SpinnerModel)new SpinnerNumberModel(2, 0, 4, 1));
        this.spinTotalPrecision.setModel((SpinnerModel)new SpinnerNumberModel(2, 0, 4, 1));
    }

    private void loadData() throws Exception {
        if (this.evaluSolutionId == null) {
            return;
        }
        this.editInfo = this.getPrecisionMaintainInfo();
        if (this.editInfo == null) {
            this.editInfo = this.createPrecisionMaintainInfo();
        } else {
            this.fillSpinnerAndComboBox(this.editInfo);
        }
    }

    private PrecisionMaintainInfo getPrecisionMaintainInfo() throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        PrecisionMaintainInfo info = null;
        if (this.evaluSolutionId != null) {
            filterInfo.getFilterItems().add(new FilterItemInfo("evaluSolution.id", (Object)this.evaluSolutionId, CompareType.EQUALS));
            view.setFilter(filterInfo);
            PrecisionMaintainCollection col = PrecisionMaintainFactory.getRemoteInstance().getPrecisionMaintainCollection(view);
            if (col != null && col.size() > 0) {
                info = col.get(0);
            }
        }
        return info;
    }

    private PrecisionMaintainInfo createPrecisionMaintainInfo() {
        PrecisionMaintainInfo info = new PrecisionMaintainInfo();
        return info;
    }

    private void fillSpinnerAndComboBox(PrecisionMaintainInfo info) {
        if (info != null) {
            this.spinIndexGradePrecision.setValue((Object)new Integer(info.getIndexGradePrecision()));
            this.indexGradePrecisionTypeComboBox.setSelectedItem((Object)info.getIndexGradePrecisionType());
            this.spinNodeScorePrecision.setValue((Object)new Integer(info.getNodeScorePrecision()));
            this.nodeScorePrecisionTypeComboBox.setSelectedItem((Object)info.getNodeScorePrecisionType());
            this.spinTotalPrecision.setValue((Object)new Integer(info.getTotalPrecision()));
            this.totalPrecisionTypeComboBox.setSelectedItem((Object)info.getTotalPrecisionType());
        }
    }

    @Override
    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    @Override
    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        if (!"VIEW".equals(this.OprtState)) {
            this.storeField();
            PrecisionMaintainFactory.getRemoteInstance().submit(this.editInfo);
        }
        this.getUIWindow().close();
    }

    private void storeField() {
        if (this.editInfo.getEvaluSolution() == null) {
            EvaluSolutionInfo evaluSolutionInfo = new EvaluSolutionInfo();
            evaluSolutionInfo.setId(BOSUuid.read((String)this.evaluSolutionId));
            this.editInfo.setEvaluSolution(evaluSolutionInfo);
        }
        this.editInfo.setIndexGradePrecision(this.spinIndexGradePrecision.getIntegerVlaue());
        this.editInfo.setIndexGradePrecisionType((PrecisionTypeEnum)((Object)this.indexGradePrecisionTypeComboBox.getSelectedItem()));
        this.editInfo.setNodeScorePrecision(this.spinNodeScorePrecision.getIntegerVlaue());
        this.editInfo.setNodeScorePrecisionType((PrecisionTypeEnum)((Object)this.nodeScorePrecisionTypeComboBox.getSelectedItem()));
        this.editInfo.setTotalPrecision(this.spinTotalPrecision.getIntegerVlaue());
        this.editInfo.setTotalPrecisionType((PrecisionTypeEnum)((Object)this.totalPrecisionTypeComboBox.getSelectedItem()));
    }
}

