/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTEditManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.EvaluResultFactory;
import com.kingdee.eas.hr.perf.IEvaluResult;
import com.kingdee.eas.hr.perf.IRank;
import com.kingdee.eas.hr.perf.IRankGroup;
import com.kingdee.eas.hr.perf.RankConvertRuleDetailCollection;
import com.kingdee.eas.hr.perf.RankConvertRuleDetailInfo;
import com.kingdee.eas.hr.perf.RankConvertRuleFactory;
import com.kingdee.eas.hr.perf.RankConvertRuleInfo;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankGroupCollection;
import com.kingdee.eas.hr.perf.RankGroupFactory;
import com.kingdee.eas.hr.perf.RankGroupInfo;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.client.AbstractRankConvertRuleEditUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class RankConvertRuleEditUI
extends AbstractRankConvertRuleEditUI {
    private static final Logger logger = CoreUIObject.getLogger(RankConvertRuleEditUI.class);
    private static final String USER = "user";
    private static final String MACHINE = "machine";
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private int selectedIndex = -1;
    private final KDComboBox comboLessSign = new KDComboBox();
    private final KDComboBox comboBoth = new KDComboBox();
    private BigDecimal minGrade = null;
    private BigDecimal maxGrade = null;
    protected static final Color YELLOW = new Color(16579551);
    protected static final Color GRAY = new Color(0xE8E8E3);

    public void onLoad() throws Exception {
        this.kdtEntries.checkParsed();
        super.onLoad();
        this.initUI();
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            RankGroupInfo info = this.editData.getRankGroup();
            Object obj = null;
            RankGroupInfo item = null;
            this.comboRankGroup.setActionCommand(MACHINE);
            for (int i = 0; i < this.comboRankGroup.getItemCount(); ++i) {
                obj = this.comboRankGroup.getItemAt(i);
                if (obj != null) {
                    item = (RankGroupInfo)obj;
                }
                if (!info.getId().equals((Object)item.getId())) continue;
                this.comboRankGroup.setSelectedIndex(i);
                this.maxGrade = item.getGradeMode().getMaxGrade();
                this.minGrade = item.getGradeMode().getMinGrade();
                break;
            }
            this.comboRankGroup.setActionCommand(USER);
            this.sortBySerial();
            this.lockMaxAndMin();
        }
        this.comboBoth.addItem((Object)"<");
        this.comboBoth.addItem((Object)"\u2264");
        if (OprtState.VIEW.equals(this.oprtState)) {
            this.kdtEntries.getStyleAttributes().setLocked(true);
        }
        this.kdtEntries.getColumn("rank").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("rank").getStyleAttributes().setBackground(GRAY);
        this.kdtEntries.getColumn("maxScoreCondition").getStyleAttributes().setBackground(YELLOW);
        this.kdtEntries.getColumn("minScoreCondition").getStyleAttributes().setBackground(YELLOW);
        if (this.kdtEntries.getRowCount() > 0) {
            this.kdtEntries.getRow(this.kdtEntries.getRowCount() - 1).getCell("minScoreCondition").getStyleAttributes().setBackground(GRAY);
            this.kdtEntries.getRow(this.kdtEntries.getRowCount() - 1).getCell("minScoreCondition").getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(0).getCell("maxScoreCondition").getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(0).getCell("maxScoreCondition").getStyleAttributes().setBackground(GRAY);
        }
        this.comboRankGroup.setEditable(false);
    }

    private void initUI() throws Exception {
        this.comboRankGroup.setEditable(false);
        IRankGroup iRankGroup = RankGroupFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        SorterItemCollection sorter = viewInfo.getSorter();
        SorterItemInfo item = new SorterItemInfo("createTime");
        item.setSortType(SortType.DESCEND);
        sorter.add(item);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("gradeMode.name"));
        sic.add(new SelectorItemInfo("gradeMode.minGrade"));
        sic.add(new SelectorItemInfo("gradeMode.maxGrade"));
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
        viewInfo.setFilter(filterInfo);
        RankGroupCollection groupCollection = iRankGroup.getRankGroupCollection(viewInfo);
        if (groupCollection == null || groupCollection.size() == 0) {
            return;
        }
        this.comboRankGroup.setActionCommand(MACHINE);
        this.comboRankGroup.addItems(groupCollection.toArray());
        this.comboRankGroup.setSelectedItem(null);
        this.comboRankGroup.setActionCommand(USER);
        KDFormattedTextField kdfTextField1 = new KDFormattedTextField();
        kdfTextField1.setDataType(1);
        kdfTextField1.setPrecision(2);
        kdfTextField1.setRemoveingZeroInDispaly(false);
        kdfTextField1.setRemoveingZeroInEdit(false);
        KDFormattedTextField kdfTextField2 = new KDFormattedTextField();
        kdfTextField2.setDataType(1);
        kdfTextField2.setPrecision(2);
        kdfTextField2.setRemoveingZeroInDispaly(false);
        kdfTextField2.setRemoveingZeroInEdit(false);
        this.kdtEntries.getColumn("minScore").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)kdfTextField1));
        this.kdtEntries.getColumn("maxScore").setEditor((ICellEditor)new KDTDefaultCellEditor((JTextField)kdfTextField2));
        KDComboBox comboBox1 = new KDComboBox();
        comboBox1.addItem((Object)"<");
        comboBox1.addItem((Object)"\u2264");
        this.kdtEntries.getColumn("minScoreCondition").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBox1));
        KDComboBox comboBox2 = new KDComboBox();
        comboBox2.addItem((Object)"<");
        comboBox2.addItem((Object)"\u2264");
        this.kdtEntries.getColumn("maxScoreCondition").setEditor((ICellEditor)new KDTDefaultCellEditor((JComboBox)comboBox2));
    }

    protected RankConvertRuleDetailInfo createNewDetailData(KDTable table) {
        RankConvertRuleDetailInfo ret = new RankConvertRuleDetailInfo();
        return ret;
    }

    protected KDTable getDetailTable() {
        return this.kdtEntries;
    }

    protected IObjectValue createNewData() {
        RankConvertRuleInfo ret = new RankConvertRuleInfo();
        ret.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return ret;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RankConvertRuleFactory.getRemoteInstance();
    }

    protected void loadLineFields(KDTable table, IRow row, IObjectValue obj) {
        this.dataBinder.loadLineFields(table, row, obj);
    }

    protected void addLine(KDTable table, RankInfo info) {
        RankConvertRuleDetailInfo detailData = this.createNewDetailData(table);
        detailData.setRank(info);
        IRow row = table.addRow();
        this.loadLineFields(table, row, (IObjectValue)detailData);
    }

    protected void removeLines() {
        if (this.kdtEntries.getRowCount() == 0) {
            return;
        }
        IObjectCollection collection = (IObjectCollection)this.kdtEntries.getUserObject();
        for (int i = this.kdtEntries.getRowCount() - 1; i >= 0; --i) {
            IObjectValue detailData = (IObjectValue)this.kdtEntries.getRow(i).getUserObject();
            collection.removeObject(detailData);
            this.kdtEntries.removeRow(i);
        }
    }

    @Override
    protected void comboRankGroup_actionPerformed(ActionEvent e) throws Exception {
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            return;
        }
        if (MACHINE.equals(e.getActionCommand())) {
            return;
        }
        Object obj = this.comboRankGroup.getSelectedItem();
        if (obj == null || !(obj instanceof RankGroupInfo)) {
            return;
        }
        if (this.kdtEntries.getRowCount() > 0) {
            int choice = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"changeRankGroup"));
            if (choice == 0) {
                this.removeLines();
            } else {
                this.comboRankGroup.setActionCommand(MACHINE);
                this.comboRankGroup.setSelectedIndex(this.selectedIndex);
                this.comboRankGroup.setActionCommand(USER);
                return;
            }
        }
        RankGroupInfo info = (RankGroupInfo)obj;
        this.maxGrade = info.getGradeMode().getMaxGrade();
        this.minGrade = info.getGradeMode().getMinGrade();
        this.prmtGradeMode.setValue((Object)info.getGradeMode());
        IRank iRank = RankFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)info.getId().toString(), CompareType.EQUALS));
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        viewInfo.setFilter(filter);
        SorterItemCollection sorterColl = viewInfo.getSorter();
        SorterItemInfo item = new SorterItemInfo("serial");
        item.setSortType(SortType.ASCEND);
        sorterColl.add(item);
        CoreBaseCollection coll = iRank.getCollection(viewInfo);
        RankInfo rank = null;
        if (coll != null && coll.size() > 0) {
            int n = coll.size();
            for (int i = 0; i < n; ++i) {
                rank = (RankInfo)coll.get(i);
                this.addLine(this.kdtEntries, rank);
            }
            ICell cell = this.kdtEntries.getRow(0).getCell("maxScore");
            cell.setValue((Object)info.getGradeMode().getMaxGrade());
            cell.getStyleAttributes().setLocked(true);
            cell.getStyleAttributes().setBackground(GRAY);
            cell = this.kdtEntries.getRow(0).getCell("maxScoreCondition");
            cell.setValue((Object)"\u2264");
            cell.getStyleAttributes().setLocked(true);
            cell.getStyleAttributes().setBackground(GRAY);
            cell = this.kdtEntries.getRow(this.kdtEntries.getRowCount() - 1).getCell("minScore");
            cell.setValue((Object)info.getGradeMode().getMinGrade());
            cell.getStyleAttributes().setLocked(true);
            cell.getStyleAttributes().setBackground(GRAY);
            cell = this.kdtEntries.getRow(this.kdtEntries.getRowCount() - 1).getCell("minScoreCondition");
            cell.setValue((Object)"\u2264");
            cell.getStyleAttributes().setLocked(true);
            cell.getStyleAttributes().setBackground(GRAY);
        }
        this.selectedIndex = this.comboRankGroup.getSelectedIndex();
    }

    public static KDFormattedTextField getScoreEditor() {
        KDFormattedTextField kdfTextField = new KDFormattedTextField();
        kdfTextField.setDataType(1);
        kdfTextField.setPrecision(2);
        kdfTextField.setRemoveingZeroInDispaly(false);
        kdfTextField.setRemoveingZeroInEdit(false);
        return kdfTextField;
    }

    @Override
    protected void kdtEntries_editStopped(KDTEditEvent e) throws Exception {
        int row = e.getRowIndex();
        int col = e.getColIndex();
        ICell cell = null;
        int rowCount = this.kdtEntries.getRowCount();
        Object value = null;
        String op = null;
        BigDecimal score = null;
        BigDecimal tempScore = null;
        Object temp = null;
        KDTEditManager kds = this.kdtEntries.getEditManager();
        if (col == this.kdtEntries.getColumnIndex("minScoreCondition")) {
            if (row < rowCount - 1) {
                value = this.kdtEntries.getRow(row).getCell(col).getValue();
                if (value == null) {
                    e.setCancel(true);
                    return;
                }
                op = (String)value;
                cell = this.kdtEntries.getRow(row + 1).getCell("maxScoreCondition");
                if (op.equals("\u2264")) {
                    cell.setValue((Object)"<");
                } else {
                    cell.setValue((Object)"\u2264");
                }
            }
        } else if (col == this.kdtEntries.getColumnIndex("minScore")) {
            if (row < rowCount - 1) {
                value = this.kdtEntries.getRow(row).getCell(col).getValue();
                if (value == null) {
                    e.setCancel(true);
                    return;
                }
                score = (BigDecimal)value;
                if (score.compareTo(this.maxGrade) > 0) {
                    kds.editCellAt(row, col, true);
                    MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"tooLarger"));
                    e.setCancel(true);
                    return;
                }
                if (score.compareTo(this.minGrade) < 0) {
                    kds.editCellAt(row, col, true);
                    MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"tooLess"));
                    e.setCancel(true);
                    return;
                }
                temp = this.kdtEntries.getRow(row).getCell("maxScore").getValue();
                if (temp != null && score.compareTo(tempScore = (BigDecimal)temp) > 0) {
                    kds.editCellAt(row, col, true);
                    MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"minLargeThanMax"));
                    e.setCancel(true);
                    return;
                }
                this.kdtEntries.getRow(row + 1).getCell("maxScore").setValue(value);
            }
        } else if (col == this.kdtEntries.getColumnIndex("maxScore")) {
            if (row > 0) {
                value = this.kdtEntries.getRow(row).getCell(col).getValue();
                if (value == null) {
                    e.setCancel(true);
                    return;
                }
                score = (BigDecimal)value;
                if (score.compareTo(this.maxGrade) > 0) {
                    kds.editCellAt(row, col, true);
                    MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"tooLarger"));
                    e.setCancel(true);
                    return;
                }
                if (score.compareTo(this.minGrade) < 0) {
                    kds.editCellAt(row, col, true);
                    MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"tooLess"));
                    e.setCancel(true);
                    return;
                }
                temp = this.kdtEntries.getRow(row).getCell("minScore").getValue();
                if (temp != null && score.compareTo(tempScore = (BigDecimal)temp) < 0) {
                    kds.editCellAt(row, col, true);
                    MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"maxLessThanMin"));
                    e.setCancel(true);
                    return;
                }
                this.kdtEntries.getRow(row - 1).getCell("minScore").setValue(value);
            }
        } else if (col == this.kdtEntries.getColumnIndex("maxScoreCondition") && row > 0) {
            value = this.kdtEntries.getRow(row).getCell(col).getValue();
            if (value == null) {
                e.setCancel(true);
                return;
            }
            op = (String)value;
            cell = this.kdtEntries.getRow(row - 1).getCell("minScoreCondition");
            if (op.equals("\u2264")) {
                cell.setValue((Object)"<");
            } else {
                cell.setValue((Object)"\u2264");
            }
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        Object obj;
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"numberNotAllowNull"));
            SysUtil.abort();
        }
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.editData, (String)"name");
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.txtName.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"nameNotAllowNull"));
            SysUtil.abort();
        }
        if ((obj = this.comboRankGroup.getSelectedItem()) == null || !(obj instanceof RankGroupInfo)) {
            this.comboRankGroup.requestFocus();
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"rankGroupNutNull"));
            SysUtil.abort();
        }
        IRow row = null;
        Object cell = null;
        int colIndex = 0;
        KDTEditManager kds = this.kdtEntries.getEditManager();
        BigDecimal minScore = null;
        BigDecimal maxScore = null;
        for (int i = 0; i < this.kdtEntries.getRowCount(); ++i) {
            row = this.kdtEntries.getRow(i);
            if (row.getCell(colIndex = row.getCell("minScore").getColumnIndex()).getValue() == null) {
                kds.editCellAt(i, colIndex, true);
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"minScoreNull"));
                SysUtil.abort();
            }
            if (row.getCell(colIndex = row.getCell("minScoreCondition").getColumnIndex()).getValue() == null) {
                kds.editCellAt(i, colIndex, true);
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"logicOperator"));
                SysUtil.abort();
            }
            if (row.getCell(colIndex = row.getCell("maxScoreCondition").getColumnIndex()).getValue() == null) {
                kds.editCellAt(i, colIndex, true);
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"logicOperator"));
                SysUtil.abort();
            }
            if (row.getCell(colIndex = row.getCell("maxScore").getColumnIndex()).getValue() == null) {
                kds.editCellAt(i, colIndex, true);
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"maxScoreNull"));
                SysUtil.abort();
            }
            minScore = (BigDecimal)row.getCell("minScore").getValue();
            maxScore = (BigDecimal)row.getCell("maxScore").getValue();
            if (maxScore.compareTo(minScore) > 0) continue;
            colIndex = row.getCell("maxScore").getColumnIndex();
            kds.editCellAt(i, colIndex, true);
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"minLessThanMax"));
            SysUtil.abort();
        }
        int minColIndex = this.kdtEntries.getColumnIndex("minScore");
        int maxColIndex = this.kdtEntries.getColumnIndex("maxScore");
        BigDecimal nextScore = null;
        BigDecimal nowScore = null;
        for (int i = 0; i < this.kdtEntries.getRowCount() - 2; ++i) {
            nowScore = (BigDecimal)this.kdtEntries.getCell(i, minColIndex).getValue();
            if (nowScore.compareTo(nextScore = (BigDecimal)this.kdtEntries.getCell(i + 1, minColIndex).getValue()) <= 0) {
                kds.editCellAt(i, minColIndex, true);
                MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"minScoreIllegal"));
                SysUtil.abort();
            }
            if ((nowScore = (BigDecimal)this.kdtEntries.getCell(i, maxColIndex).getValue()).compareTo(nextScore = (BigDecimal)this.kdtEntries.getCell(i + 1, maxColIndex).getValue()) > 0) continue;
            kds.editCellAt(i, minColIndex, true);
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"maxScoreIllegal"));
            SysUtil.abort();
        }
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("rankGroup.name"));
        sic.add(new SelectorItemInfo("rankGroup.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        return sic;
    }

    private void sortBySerial() {
        TreeMap<Integer, IRow> map = new TreeMap<Integer, IRow>(new Comparator(){

            public int compare(Object o1, Object o2) {
                Integer num1 = (Integer)o1;
                Integer num2 = (Integer)o2;
                return num1.compareTo(num2);
            }
        });
        Integer key = null;
        int n = this.kdtEntries.getRowCount();
        for (int i = 0; i < n; ++i) {
            key = (Integer)this.kdtEntries.getRow(i).getCell("rank.serial").getValue();
            map.put(key, this.kdtEntries.getRow(i));
        }
        this.kdtEntries.removeRows();
        IRow row = null;
        int i = 0;
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            row = (IRow)map.get(iter.next());
            this.kdtEntries.addRow(i, row);
            ++i;
        }
    }

    private void lockMaxAndMin() {
        if (this.kdtEntries.getRowCount() > 0) {
            this.kdtEntries.getRow(0).getCell("maxScore").getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(0).getCell("maxScore").getStyleAttributes().setBackground(GRAY);
            this.kdtEntries.getRow(this.kdtEntries.getRowCount() - 1).getCell("minScore").getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(this.kdtEntries.getRowCount() - 1).getCell("minScore").getStyleAttributes().setBackground(GRAY);
            this.kdtEntries.getRow(this.kdtEntries.getRowCount() - 1).getCell("minScoreCondition").getStyleAttributes().setBackground(GRAY);
            this.kdtEntries.getRow(this.kdtEntries.getRowCount() - 1).getCell("minScoreCondition").getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(0).getCell("maxScoreCondition").getStyleAttributes().setLocked(true);
            this.kdtEntries.getRow(0).getCell("maxScoreCondition").getStyleAttributes().setBackground(GRAY);
        }
    }

    public void actionFirst_actionPerformed(ActionEvent e) throws Exception {
        super.actionFirst_actionPerformed(e);
        this.sortBySerial();
        this.lockMaxAndMin();
    }

    public void actionLast_actionPerformed(ActionEvent e) throws Exception {
        super.actionLast_actionPerformed(e);
        this.sortBySerial();
        this.lockMaxAndMin();
    }

    public void actionNext_actionPerformed(ActionEvent e) throws Exception {
        super.actionNext_actionPerformed(e);
        this.sortBySerial();
        this.lockMaxAndMin();
    }

    public void actionPre_actionPerformed(ActionEvent e) throws Exception {
        super.actionPre_actionPerformed(e);
        this.sortBySerial();
        this.lockMaxAndMin();
    }

    private boolean isRefered() throws Exception {
        BOSUuid id = this.editData.getId();
        if (id == null) {
            return false;
        }
        IEvaluResult iEvaluResult = EvaluResultFactory.getRemoteInstance();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("rankConvertRule.id", (Object)id.toString(), CompareType.EQUALS));
        return iEvaluResult.exists(filter);
    }

    private void setUIEnabled(boolean status) {
        this.txtNumber.setEditable(status);
        this.txtName.setEditable(status);
        this.comboRankGroup.setEnabled(status);
        int n = this.kdtEntries.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.kdtEntries.getColumn(i).getStyleAttributes().setLocked(!status);
        }
        this.txtRemark.setEditable(status);
        this.btnSubmit.setEnabled(status);
    }

    @Override
    public void loadFields() {
        this.comboRankGroup.setActionCommand(MACHINE);
        super.loadFields();
        try {
            if (OprtState.VIEW.equals(this.getOprtState()) || this.isRefered()) {
                this.setUIEnabled(false);
            } else {
                this.setUIEnabled(true);
                if (this.kdtEntries.getRowCount() > 0) {
                    this.comboRankGroup.setEditable(false);
                }
            }
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            BOSUuid id = this.editData.getRankGroup().getId();
            RankGroupInfo info = null;
            for (int i = 0; i < this.comboRankGroup.getItemCount(); ++i) {
                info = (RankGroupInfo)this.comboRankGroup.getItemAt(i);
                if (!info.getId().equals((Object)id)) continue;
                this.comboRankGroup.setSelectedIndex(i);
                break;
            }
            this.comboRankGroup.setEnabled(false);
        } else {
            if (this.comboRankGroup.getItemCount() > 0) {
                this.comboRankGroup.setSelectedIndex(0);
            }
            this.comboRankGroup.setSelectedItem(null);
        }
        this.comboRankGroup.setActionCommand(USER);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isRefered()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"rankConvertRuleNotEdit"));
            return;
        }
        super.actionEdit_actionPerformed(e);
        this.setUIEnabled(true);
        this.lockMaxAndMin();
        this.comboRankGroup.setEnabled(false);
    }

    protected void unLockUI() {
        this.comboRankGroup.setActionCommand(MACHINE);
        super.unLockUI();
        this.comboRankGroup.setActionCommand(USER);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.isRefered()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"rankConvertRuleNotRemove"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    protected IObjectValue getValue(IObjectPK pk) throws Exception {
        RankConvertRuleInfo rcrInfo = (RankConvertRuleInfo)this.getBizInterface().getValue(pk, this.getMergedSelector());
        RankConvertRuleDetailCollection rcrColl = rcrInfo.getEntries();
        RankConvertRuleDetailCollection sortedColl = new RankConvertRuleDetailCollection();
        int[] array = new int[rcrColl.size()];
        for (int i = 0; i < rcrColl.size(); ++i) {
            array[i] = rcrColl.get(i).getRank().getSerial();
        }
        Arrays.sort(array);
        for (int j = 0; j < array.length; ++j) {
            for (int k = 0; k < array.length; ++k) {
                if (rcrColl.get(k).getRank().getSerial() != array[j]) continue;
                sortedColl.add(rcrColl.get(k));
            }
        }
        rcrInfo.put("entries", (Object)sortedColl);
        return rcrInfo;
    }
}

