/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.IRankConvertRule;
import com.kingdee.eas.hr.perf.ISolutionPeriod;
import com.kingdee.eas.hr.perf.RankConvertRuleCollection;
import com.kingdee.eas.hr.perf.RankConvertRuleFactory;
import com.kingdee.eas.hr.perf.RankConvertRuleInfo;
import com.kingdee.eas.hr.perf.RankGroupInfo;
import com.kingdee.eas.hr.perf.SolutionPeriodFactory;
import com.kingdee.eas.hr.perf.SolutionPeriodInfo;
import com.kingdee.eas.hr.perf.SumSolutionFactory;
import com.kingdee.eas.hr.perf.SumSolutionInfo;
import com.kingdee.eas.hr.perf.client.AbstractRankConvertStartUI;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import org.apache.log4j.Logger;

public class RankConvertStartUI
extends AbstractRankConvertStartUI {
    private static final Logger logger = CoreUIObject.getLogger(RankConvertStartUI.class);
    public static final String SOLUTION_PERIOD = "sp";
    private boolean canceled = true;
    private int scoreType = 0;
    public static final int TOTALSCORE = 0;
    public static final int MODIFYSCORE = 1;
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private void initUI() throws Exception {
        String id = (String)this.getUIContext().get(SOLUTION_PERIOD);
        if (StringUtils.isEmpty((String)id)) {
            return;
        }
        GradeModeInfo gradeMode = null;
        RankGroupInfo rankGroup = null;
        SelectorItemCollection selector = null;
        if (this.getUIContext().get("isSum") == null) {
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("evaluSolution.id"));
            selector.add(new SelectorItemInfo("evaluSolution.gradeMode.id"));
            selector.add(new SelectorItemInfo("evaluSolution.gradeMode.name"));
            selector.add(new SelectorItemInfo("evaluSolution.rankGroup.id"));
            ISolutionPeriod isp = SolutionPeriodFactory.getRemoteInstance();
            SolutionPeriodInfo solutionPeriod = (SolutionPeriodInfo)isp.getValue((IObjectPK)new ObjectUuidPK(id), selector);
            gradeMode = solutionPeriod.getEvaluSolution().getGradeMode();
            rankGroup = solutionPeriod.getEvaluSolution().getRankGroup();
        } else {
            selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("id"));
            selector.add(new SelectorItemInfo("gradeMode.id"));
            selector.add(new SelectorItemInfo("gradeMode.name"));
            selector.add(new SelectorItemInfo("rankGroup.id"));
            SumSolutionInfo solutionInfo = SumSolutionFactory.getRemoteInstance().getSumSolutionInfo((IObjectPK)new ObjectUuidPK(id), selector);
            gradeMode = solutionInfo.getGradeMode();
            rankGroup = solutionInfo.getRankGroup();
        }
        this.txtGradeMode.setText(gradeMode.getName());
        IRankConvertRule iRankConvertRule = RankConvertRuleFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("gradeMode.id", (Object)gradeMode.getId().toString(), CompareType.EQUALS));
        if (rankGroup != null) {
            filter.getFilterItems().add(new FilterItemInfo("rankGroup.id", (Object)rankGroup.getId().toString(), CompareType.EQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("rankGroup.id", null, CompareType.EQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId().toString()));
        viewInfo.setFilter(filter);
        SelectorItemCollection sic = viewInfo.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        RankConvertRuleCollection coll = iRankConvertRule.getRankConvertRuleCollection(viewInfo);
        if (coll != null && coll.size() > 0) {
            this.comboConvertRule.addItems(coll.toArray());
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"noRuleDetail"));
            SysUtil.abort();
        }
    }

    @Override
    public void actionCancelMe_actionPerformed(ActionEvent e) throws Exception {
        this.actionExitCurrent_actionPerformed(null);
    }

    @Override
    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.canceled = false;
        this.scoreType = this.comboConvertObject.getSelectedIndex();
        this.actionExitCurrent_actionPerformed(null);
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public int getScoreType() {
        return this.scoreType;
    }

    public RankConvertRuleInfo getSelectedRule() {
        return (RankConvertRuleInfo)this.comboConvertRule.getSelectedItem();
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        RequestContext req = new RequestContext();
        req.put("isSum", this.getUIContext().get("isSum"));
        String id = (String)this.getUIContext().get(SOLUTION_PERIOD);
        req.put("solutionid", (Object)id);
        postman.setRequestContext((Serializable)req);
        return postman;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }

    protected void handlePermissionForItemAction(ItemAction action) {
    }

    protected void initUserConfig() {
    }
}

