/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.PerformUtil;
import com.kingdee.eas.hr.perf.RankException;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankGroupFactory;
import com.kingdee.eas.hr.perf.RankGroupInfo;
import com.kingdee.eas.hr.perf.RankInfo;
import com.kingdee.eas.hr.perf.client.AbstractRankEditUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.math.BigDecimal;
import org.apache.log4j.Logger;

public class RankEditUI
extends AbstractRankEditUI {
    private static final Logger logger = CoreUIObject.getLogger(RankEditUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private GradeModeInfo gradeMode = null;
    private RankGroupInfo rankGroup = null;
    private boolean isUsed = false;
    private static final int MAX_LEN = 255;

    protected IObjectValue createNewData() {
        RankInfo ret = new RankInfo();
        if (this.rankGroup == null) {
            try {
                this.initGroupInfo();
            }
            catch (Exception ex) {
                super.handleException(ex);
            }
        }
        ret.setGroup(this.rankGroup);
        return ret;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RankFactory.getRemoteInstance();
    }

    private void initGroupInfo() throws Exception {
        this.rankGroup = (RankGroupInfo)this.getUIContext().get("ParentNode");
        if (this.rankGroup == null) {
            this.rankGroup = this.editData.getGroup();
        }
        this.gradeMode = this.rankGroup.getGradeMode();
        this.isUsed = this.isGroupUsed(this.rankGroup.getId().toString());
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.editData, (String)"name");
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        BigDecimal score = PerformUtil.toBigDecimal(this.txtGrade.getNumberValue());
        if (score == null) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"gradeNotAllowNull"));
            this.txtGrade.requestFocus();
            SysUtil.abort();
        }
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)this.editData.getGroup().getId().toString()));
        if (this.editData.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
        } else {
            filter.getFilterItems().add(new FilterItemInfo("id", null, CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("grade", (Object)score));
        if (RankFactory.getRemoteInstance().exists(filter)) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"dupGrade"));
            this.txtGrade.requestFocus();
            SysUtil.abort();
        }
        BigDecimal minGrade = this.gradeMode.getMinGrade();
        BigDecimal maxGrade = this.gradeMode.getMaxGrade();
        if (score.compareTo(minGrade) < 0 || score.compareTo(maxGrade) > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(EASResource.getString((String)RES, (String)"scoreInput"));
            sb.append(PFVerifyUtils.formatBigDecimal(minGrade, 2));
            sb.append("~");
            sb.append(PFVerifyUtils.formatBigDecimal(maxGrade, 2));
            sb.append(EASResource.getString((String)RES, (String)"scope"));
            MsgBox.showInfo((String)sb.toString());
            this.txtGrade.requestFocus();
            SysUtil.abort();
        }
        if (this.txtDescription.getText().trim().length() > 255) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"txtDescriptionTooLong"));
            this.txtDescription.requestFocus();
            return;
        }
        super.beforeStoreFields(e);
    }

    private void initUI() throws Exception {
        this.initGroupInfo();
        if (this.isUsed) {
            this.btnEdit.setEnabled(false);
            this.btnAddNew.setEnabled(false);
        }
        this.txtGrade.setRemoveingZeroInDispaly(false);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initUI();
    }

    private boolean isGroupUsed(String groupID) throws Exception {
        if (OprtState.ADDNEW.equals(this.getOprtState()) && (this.editData == null || this.editData.getId() == null)) {
            return false;
        }
        return RankGroupFactory.getRemoteInstance().isRefByOther(groupID);
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        if (this.isUsed) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"rankGroupUsedAddNew"));
            return;
        }
        super.actionAddNew_actionPerformed(e);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.isUsed) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"rankGroupUsedEdit"));
            return;
        }
        super.actionEdit_actionPerformed(e);
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.isUsed) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"rankGroupUsedRemove"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("group.id"));
        sic.add(new SelectorItemInfo("group.gradeMode.id"));
        sic.add(new SelectorItemInfo("group.gradeMode.maxGrade"));
        sic.add(new SelectorItemInfo("group.gradeMode.minGrade"));
        return sic;
    }

    protected void handleException(Exception err) {
        if (err instanceof RankException) {
            RankException ex = (RankException)((Object)err);
            if (ex.getSubCode().equals(RankException.NUMBER_NOT_ALLOW_DUP)) {
                this.txtNumber.requestFocus();
            } else if (ex.getSubCode().equals(RankException.NAME_NOT_ALLOW_DUP)) {
                this.txtName.requestFocus();
            }
        }
        super.handleException(err);
    }

    protected void initUserConfig() {
    }

    @Override
    public IUIActionPostman prepareInit() {
        IUIActionPostman postman = super.prepareInit();
        RequestContext req = new RequestContext();
        this.rankGroup = (RankGroupInfo)this.getUIContext().get("ParentNode");
        req.put("rankGroup", (Object)this.rankGroup);
        postman.setRequestContext((Serializable)req);
        return postman;
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

