/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.perf.client;

import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.perf.GradeModeCollection;
import com.kingdee.eas.hr.perf.GradeModeEnum;
import com.kingdee.eas.hr.perf.GradeModeFactory;
import com.kingdee.eas.hr.perf.GradeModeInfo;
import com.kingdee.eas.hr.perf.IGradeMode;
import com.kingdee.eas.hr.perf.RankFactory;
import com.kingdee.eas.hr.perf.RankGroupEnum;
import com.kingdee.eas.hr.perf.RankGroupFactory;
import com.kingdee.eas.hr.perf.RankGroupInfo;
import com.kingdee.eas.hr.perf.client.AbstractRankGroupEditUI;
import com.kingdee.eas.hr.perf.client.PFVerifyUtils;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class RankGroupEditUI
extends AbstractRankGroupEditUI {
    private static final Logger logger = CoreUIObject.getLogger(RankGroupEditUI.class);
    private static final String RES = "com.kingdee.eas.hr.perf.client.PerfResource";
    private static final int MAX_LEN = 255;
    private GradeModeInfo defaultGradeModeInfo = null;

    protected IObjectValue createNewData() {
        RankGroupInfo ret = new RankGroupInfo();
        ret.setIsDefault(RankGroupEnum.NO);
        ret.setHrOrgUnit(SysContext.getSysContext().getCurrentHRUnit());
        return ret;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RankGroupFactory.getRemoteInstance();
    }

    public void onLoad() throws Exception {
        this.initComboGradeMode();
        super.onLoad();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            GradeModeInfo gradeModeInfo = null;
            int n = this.comboGradeMode.getItemCount();
            for (int i = 0; i < n; ++i) {
                gradeModeInfo = (GradeModeInfo)this.comboGradeMode.getItemAt(i);
                if (!gradeModeInfo.getIsDefault().equals((Object)GradeModeEnum.YES)) continue;
                this.defaultGradeModeInfo = gradeModeInfo;
                this.comboGradeMode.setSelectedIndex(i);
                break;
            }
        }
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtNumber);
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.editData, (String)"name");
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.txtName);
        PFVerifyUtils.verifyEmpty((CoreUIObject)this, this.comboGradeMode);
        if (this.txtDescription.getText().trim().length() > 255) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"txtDescriptionTooLong"));
            this.txtDescription.requestFocus();
            SysUtil.abort();
        }
        if (this.comboDefault.getSelectedItem().equals((Object)RankGroupEnum.YES)) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("isDefault", (Object)new Integer(0)));
            filter.getFilterItems().add(new FilterItemInfo("gradeMode", (Object)((GradeModeInfo)this.comboGradeMode.getSelectedItem()).getId().toString()));
            if (this.editData != null && this.editData.getId() != null) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)this.editData.getId().toString(), CompareType.NOTEQUALS));
            }
            FilterInfo newFilterInfo = new FilterInfo();
            newFilterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
            filter.mergeFilter(newFilterInfo, "and");
            if (this.getBizInterface().exists(filter) && MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"existDefaultRankGroup")) == 2) {
                this.comboDefault.requestFocus();
                SysUtil.abort();
            }
        }
        super.beforeStoreFields(e);
    }

    private void initComboGradeMode() throws Exception {
        IGradeMode iGradeMode = GradeModeFactory.getRemoteInstance();
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("hrOrgUnit.id", (Object)SysContext.getSysContext().getCurrentHRUnit().getId()));
        viewInfo.setFilter(filterInfo);
        viewInfo.getSelector().add(new SelectorItemInfo("id"));
        viewInfo.getSelector().add(new SelectorItemInfo("name"));
        viewInfo.getSelector().add(new SelectorItemInfo("isDefault"));
        GradeModeCollection collection = iGradeMode.getGradeModeCollection(viewInfo);
        if (collection == null || collection.size() == 0) {
            return;
        }
        this.comboGradeMode.addItems(collection.toArray());
    }

    @Override
    public void loadFields() {
        super.loadFields();
        if (!OprtState.ADDNEW.equals(this.getOprtState())) {
            BOSUuid id = this.editData.getGradeMode().getId();
            GradeModeInfo info = null;
            for (int i = 0; i < this.comboGradeMode.getItemCount(); ++i) {
                info = (GradeModeInfo)this.comboGradeMode.getItemAt(i);
                if (!info.getId().equals((Object)id)) continue;
                this.comboGradeMode.setSelectedIndex(i);
                break;
            }
        }
        try {
            if (OprtState.VIEW.equals(this.getOprtState())) {
                this.setUIEnabled(false);
            } else if (this.isGroupUsed()) {
                this.txtNumber.setEnabled(false);
                this.txtName.setEnabled(false);
                this.comboGradeMode.setEnabled(false);
                this.btnEdit.setEnabled(true);
                this.btnSubmit.setEnabled(true);
                this.txtDescription.setEnabled(true);
                this.comboDefault.setEnabled(true);
            } else {
                this.setUIEnabled(true);
            }
            if (this.editData.getId() != null) {
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)this.editData.getId().toString()));
                if (RankFactory.getRemoteInstance().exists(filter)) {
                    this.comboGradeMode.setEnabled(false);
                }
            }
        }
        catch (Exception ex) {
            super.handleException(ex);
        }
    }

    private void setUIEnabled(boolean status) throws Exception {
        this.txtNumber.setEnabled(status);
        this.txtName.setEnabled(status);
        this.txtDescription.setEnabled(status);
        this.comboGradeMode.setEnabled(status);
        this.comboDefault.setEnabled(status);
        this.btnSubmit.setEnabled(status);
        if (this.editData.getId() != null) {
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("group.id", (Object)this.editData.getId().toString()));
            if (RankFactory.getRemoteInstance().exists(filter)) {
                this.comboGradeMode.setEnabled(false);
            }
        }
    }

    private boolean isGroupUsed() throws Exception {
        if (this.editData.getId() == null) {
            return false;
        }
        return RankGroupFactory.getRemoteInstance().isRefByOther(this.editData.getId().toString());
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.isGroupUsed()) {
            this.txtNumber.setEnabled(false);
            this.txtName.setEnabled(false);
            this.comboGradeMode.setEnabled(false);
            this.btnEdit.setEnabled(true);
            this.btnSubmit.setEnabled(true);
            this.txtDescription.setEnabled(true);
            this.comboDefault.setEnabled(true);
        }
        if (this.editData != null && this.editData.getId() != null) {
            this.actionRemove.setEnabled(true);
        } else {
            this.actionRemove.setEnabled(false);
        }
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        if (this.isGroupUsed()) {
            MsgBox.showInfo((String)EASResource.getString((String)RES, (String)"rankGroupUsedEdit"));
            return;
        }
        super.actionRemove_actionPerformed(e);
    }

    public boolean isModify() {
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            if (this.comboGradeMode.getSelectedItem() != null && !this.comboGradeMode.getSelectedItem().equals(this.defaultGradeModeInfo)) {
                return true;
            }
            if (!RankGroupEnum.NO.equals(this.comboDefault.getSelectedItem())) {
                return true;
            }
            UIHelper.storeMultiLangFields((KDMultiLangBox)this.txtName, (IObjectValue)this.editData, (String)"name");
            if (StringUtils.isEmpty((String)this.txtNumber.getText()) && StringUtils.isEmpty((String)this.editData.getName()) && StringUtils.isEmpty((String)this.txtDescription.getText())) {
                return false;
            }
        }
        return super.isModify();
    }

    @Override
    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("gradeMode.id"));
        sic.add(new SelectorItemInfo("gradeMode.name"));
        return sic;
    }

    protected void initUserConfig() {
    }

    @Override
    public boolean isPrepareInit() {
        return true;
    }
}

